/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrItemPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContrItemPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Item Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CntrlPurContrItemPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CntrlPurContrItemPartner extends VdmEntity<CntrlPurContrItemPartner>
{

    /**
     * Selector for all available fields of CntrlPurContrItemPartner.
     *
     */
    public final static CntrlPurContrItemPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "CentralPurchaseContract" )
    @JsonProperty( "CentralPurchaseContract" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContract" )
    private String centralPurchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContract</b> field to query operations.
     *
     */
    public final static CntrlPurContrItemPartnerField<String> CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurContrItemPartnerField<String>("CentralPurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "CentralPurchaseContractItem" )
    @JsonProperty( "CentralPurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContractItem" )
    private String centralPurchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContractItem</b> field to query operations.
     *
     */
    public final static CntrlPurContrItemPartnerField<String> CENTRAL_PURCHASE_CONTRACT_ITEM =
        new CntrlPurContrItemPartnerField<String>("CentralPurchaseContractItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DistributionKey</b>
     * </p>
     *
     * @return Distribution Number of Central Purchasing Document
     */
    @Key
    @SerializedName( "DistributionKey" )
    @JsonProperty( "DistributionKey" )
    @Nullable
    @ODataField( odataName = "DistributionKey" )
    private String distributionKey;
    /**
     * Use with available fluent helpers to apply the <b>DistributionKey</b> field to query operations.
     *
     */
    public final static CntrlPurContrItemPartnerField<String> DISTRIBUTION_KEY =
        new CntrlPurContrItemPartnerField<String>("DistributionKey");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCounter</b>
     * </p>
     *
     * @return Partner counter
     */
    @Key
    @SerializedName( "PartnerCounter" )
    @JsonProperty( "PartnerCounter" )
    @Nullable
    @ODataField( odataName = "PartnerCounter" )
    private String partnerCounter;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCounter</b> field to query operations.
     *
     */
    public final static CntrlPurContrItemPartnerField<String> PARTNER_COUNTER =
        new CntrlPurContrItemPartnerField<String>("PartnerCounter");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static CntrlPurContrItemPartnerField<String> PARTNER_FUNCTION =
        new CntrlPurContrItemPartnerField<String>("PartnerFunction");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ExtPlantForPurg</b>
     * </p>
     *
     * @return Plant of External System
     */
    @SerializedName( "ExtPlantForPurg" )
    @JsonProperty( "ExtPlantForPurg" )
    @Nullable
    @ODataField( odataName = "ExtPlantForPurg" )
    private String extPlantForPurg;
    /**
     * Use with available fluent helpers to apply the <b>ExtPlantForPurg</b> field to query operations.
     *
     */
    public final static CntrlPurContrItemPartnerField<String> EXT_PLANT_FOR_PURG =
        new CntrlPurContrItemPartnerField<String>("ExtPlantForPurg");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Reference to other supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static CntrlPurContrItemPartnerField<String> SUPPLIER =
        new CntrlPurContrItemPartnerField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSubrange</b>
     * </p>
     *
     * @return Supplier Subrange
     */
    @SerializedName( "SupplierSubrange" )
    @JsonProperty( "SupplierSubrange" )
    @Nullable
    @ODataField( odataName = "SupplierSubrange" )
    private String supplierSubrange;
    /**
     * Use with available fluent helpers to apply the <b>SupplierSubrange</b> field to query operations.
     *
     */
    public final static CntrlPurContrItemPartnerField<String> SUPPLIER_SUBRANGE =
        new CntrlPurContrItemPartnerField<String>("SupplierSubrange");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return The purchasingOrganization contained in this entity.
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static CntrlPurContrItemPartnerField<String> PURCHASING_ORGANIZATION =
        new CntrlPurContrItemPartnerField<String>("PurchasingOrganization");

    @Nonnull
    @Override
    public Class<CntrlPurContrItemPartner> getType()
    {
        return CntrlPurContrItemPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @param centralPurchaseContract
     *            Purchasing Document Number
     */
    public void setCentralPurchaseContract( @Nullable final String centralPurchaseContract )
    {
        rememberChangedField("CentralPurchaseContract", this.centralPurchaseContract);
        this.centralPurchaseContract = centralPurchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContractItem</b>
     * </p>
     *
     * @param centralPurchaseContractItem
     *            Item Number of Purchasing Document
     */
    public void setCentralPurchaseContractItem( @Nullable final String centralPurchaseContractItem )
    {
        rememberChangedField("CentralPurchaseContractItem", this.centralPurchaseContractItem);
        this.centralPurchaseContractItem = centralPurchaseContractItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DistributionKey</b>
     * </p>
     *
     * @param distributionKey
     *            Distribution Number of Central Purchasing Document
     */
    public void setDistributionKey( @Nullable final String distributionKey )
    {
        rememberChangedField("DistributionKey", this.distributionKey);
        this.distributionKey = distributionKey;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCounter</b>
     * </p>
     *
     * @param partnerCounter
     *            Partner counter
     */
    public void setPartnerCounter( @Nullable final String partnerCounter )
    {
        rememberChangedField("PartnerCounter", this.partnerCounter);
        this.partnerCounter = partnerCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ExtPlantForPurg</b>
     * </p>
     *
     * @param extPlantForPurg
     *            Plant of External System
     */
    public void setExtPlantForPurg( @Nullable final String extPlantForPurg )
    {
        rememberChangedField("ExtPlantForPurg", this.extPlantForPurg);
        this.extPlantForPurg = extPlantForPurg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Reference to other supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSubrange</b>
     * </p>
     *
     * @param supplierSubrange
     *            Supplier Subrange
     */
    public void setSupplierSubrange( @Nullable final String supplierSubrange )
    {
        rememberChangedField("SupplierSubrange", this.supplierSubrange);
        this.supplierSubrange = supplierSubrange;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            The purchasingOrganization to set.
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CntrlPurContrItemPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CentralPurchaseContract", getCentralPurchaseContract());
        result.put("CentralPurchaseContractItem", getCentralPurchaseContractItem());
        result.put("DistributionKey", getDistributionKey());
        result.put("PartnerCounter", getPartnerCounter());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CentralPurchaseContract", getCentralPurchaseContract());
        values.put("CentralPurchaseContractItem", getCentralPurchaseContractItem());
        values.put("DistributionKey", getDistributionKey());
        values.put("PartnerCounter", getPartnerCounter());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("ExtPlantForPurg", getExtPlantForPurg());
        values.put("Supplier", getSupplier());
        values.put("SupplierSubrange", getSupplierSubrange());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CentralPurchaseContract") ) {
                final Object value = values.remove("CentralPurchaseContract");
                if( (value == null) || (!value.equals(getCentralPurchaseContract())) ) {
                    setCentralPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("CentralPurchaseContractItem") ) {
                final Object value = values.remove("CentralPurchaseContractItem");
                if( (value == null) || (!value.equals(getCentralPurchaseContractItem())) ) {
                    setCentralPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("DistributionKey") ) {
                final Object value = values.remove("DistributionKey");
                if( (value == null) || (!value.equals(getDistributionKey())) ) {
                    setDistributionKey(((String) value));
                }
            }
            if( values.containsKey("PartnerCounter") ) {
                final Object value = values.remove("PartnerCounter");
                if( (value == null) || (!value.equals(getPartnerCounter())) ) {
                    setPartnerCounter(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("ExtPlantForPurg") ) {
                final Object value = values.remove("ExtPlantForPurg");
                if( (value == null) || (!value.equals(getExtPlantForPurg())) ) {
                    setExtPlantForPurg(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("SupplierSubrange") ) {
                final Object value = values.remove("SupplierSubrange");
                if( (value == null) || (!value.equals(getSupplierSubrange())) ) {
                    setSupplierSubrange(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CntrlPurContrItemPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CntrlPurContrItemPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CntrlPurContrItemPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CntrlPurContrItemPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

}
