/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrItmCmmdtyQtyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContrItmCmmdtyQtySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Item Commodity Quantity
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CntrlPurContrItmCmmdtyQtyType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CntrlPurContrItmCmmdtyQty extends VdmEntity<CntrlPurContrItmCmmdtyQty>
{

    /**
     * Selector for all available fields of CntrlPurContrItmCmmdtyQty.
     *
     */
    public final static CntrlPurContrItmCmmdtyQtySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "CentralPurchaseContract" )
    @JsonProperty( "CentralPurchaseContract" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContract" )
    private String centralPurchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContract</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCmmdtyQtyField<String> CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurContrItmCmmdtyQtyField<String>("CentralPurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "CentralPurchaseContractItem" )
    @JsonProperty( "CentralPurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContractItem" )
    private String centralPurchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContractItem</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCmmdtyQtyField<String> CENTRAL_PURCHASE_CONTRACT_ITEM =
        new CntrlPurContrItmCmmdtyQtyField<String>("CentralPurchaseContractItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocCmmdtyQtySqntlNumber</b>
     * </p>
     *
     * @return Commodity Qunatity Sequence Number in Purchasing Document
     */
    @Key
    @SerializedName( "PurgDocCmmdtyQtySqntlNumber" )
    @JsonProperty( "PurgDocCmmdtyQtySqntlNumber" )
    @Nullable
    @ODataField( odataName = "PurgDocCmmdtyQtySqntlNumber" )
    private String purgDocCmmdtyQtySqntlNumber;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocCmmdtyQtySqntlNumber</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCmmdtyQtyField<String> PURG_DOC_CMMDTY_QTY_SQNTL_NUMBER =
        new CntrlPurContrItmCmmdtyQtyField<String>("PurgDocCmmdtyQtySqntlNumber");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Commodity</b>
     * </p>
     *
     * @return Commodity
     */
    @SerializedName( "Commodity" )
    @JsonProperty( "Commodity" )
    @Nullable
    @ODataField( odataName = "Commodity" )
    private String commodity;
    /**
     * Use with available fluent helpers to apply the <b>Commodity</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCmmdtyQtyField<String> COMMODITY =
        new CntrlPurContrItmCmmdtyQtyField<String>("Commodity");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocCmmdtyQtyValidToDate</b>
     * </p>
     *
     * @return End of Validity Period
     */
    @SerializedName( "PurgDocCmmdtyQtyValidToDate" )
    @JsonProperty( "PurgDocCmmdtyQtyValidToDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PurgDocCmmdtyQtyValidToDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime purgDocCmmdtyQtyValidToDate;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocCmmdtyQtyValidToDate</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCmmdtyQtyField<LocalDateTime> PURG_DOC_CMMDTY_QTY_VALID_TO_DATE =
        new CntrlPurContrItmCmmdtyQtyField<LocalDateTime>("PurgDocCmmdtyQtyValidToDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocCmmdtyQtyValidFromDate</b>
     * </p>
     *
     * @return Start of Validity Period
     */
    @SerializedName( "PurgDocCmmdtyQtyValidFromDate" )
    @JsonProperty( "PurgDocCmmdtyQtyValidFromDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PurgDocCmmdtyQtyValidFromDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime purgDocCmmdtyQtyValidFromDate;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocCmmdtyQtyValidFromDate</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCmmdtyQtyField<LocalDateTime> PURG_DOC_CMMDTY_QTY_VALID_FROM_DATE =
        new CntrlPurContrItmCmmdtyQtyField<LocalDateTime>("PurgDocCmmdtyQtyValidFromDate");
    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CommodityQuantity</b>
     * </p>
     *
     * @return Commodity Quantity
     */
    @SerializedName( "CommodityQuantity" )
    @JsonProperty( "CommodityQuantity" )
    @Nullable
    @ODataField( odataName = "CommodityQuantity" )
    private BigDecimal commodityQuantity;
    /**
     * Use with available fluent helpers to apply the <b>CommodityQuantity</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCmmdtyQtyField<BigDecimal> COMMODITY_QUANTITY =
        new CntrlPurContrItmCmmdtyQtyField<BigDecimal>("CommodityQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CommodityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "CommodityUnit" )
    @JsonProperty( "CommodityUnit" )
    @Nullable
    @ODataField( odataName = "CommodityUnit" )
    private String commodityUnit;
    /**
     * Use with available fluent helpers to apply the <b>CommodityUnit</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCmmdtyQtyField<String> COMMODITY_UNIT =
        new CntrlPurContrItmCmmdtyQtyField<String>("CommodityUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocCmmdtyRefDocItmQty</b>
     * </p>
     *
     * @return Price unit
     */
    @SerializedName( "PurgDocCmmdtyRefDocItmQty" )
    @JsonProperty( "PurgDocCmmdtyRefDocItmQty" )
    @Nullable
    @ODataField( odataName = "PurgDocCmmdtyRefDocItmQty" )
    private BigDecimal purgDocCmmdtyRefDocItmQty;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocCmmdtyRefDocItmQty</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCmmdtyQtyField<BigDecimal> PURG_DOC_CMMDTY_REF_DOC_ITM_QTY =
        new CntrlPurContrItmCmmdtyQtyField<BigDecimal>("PurgDocCmmdtyRefDocItmQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "ItemQuantityUnit" )
    @JsonProperty( "ItemQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ItemQuantityUnit" )
    private String itemQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemQuantityUnit</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCmmdtyQtyField<String> ITEM_QUANTITY_UNIT =
        new CntrlPurContrItmCmmdtyQtyField<String>("ItemQuantityUnit");

    @Nonnull
    @Override
    public Class<CntrlPurContrItmCmmdtyQty> getType()
    {
        return CntrlPurContrItmCmmdtyQty.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @param centralPurchaseContract
     *            Purchasing Document Number
     */
    public void setCentralPurchaseContract( @Nullable final String centralPurchaseContract )
    {
        rememberChangedField("CentralPurchaseContract", this.centralPurchaseContract);
        this.centralPurchaseContract = centralPurchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContractItem</b>
     * </p>
     *
     * @param centralPurchaseContractItem
     *            Item Number of Purchasing Document
     */
    public void setCentralPurchaseContractItem( @Nullable final String centralPurchaseContractItem )
    {
        rememberChangedField("CentralPurchaseContractItem", this.centralPurchaseContractItem);
        this.centralPurchaseContractItem = centralPurchaseContractItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocCmmdtyQtySqntlNumber</b>
     * </p>
     *
     * @param purgDocCmmdtyQtySqntlNumber
     *            Commodity Qunatity Sequence Number in Purchasing Document
     */
    public void setPurgDocCmmdtyQtySqntlNumber( @Nullable final String purgDocCmmdtyQtySqntlNumber )
    {
        rememberChangedField("PurgDocCmmdtyQtySqntlNumber", this.purgDocCmmdtyQtySqntlNumber);
        this.purgDocCmmdtyQtySqntlNumber = purgDocCmmdtyQtySqntlNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Commodity</b>
     * </p>
     *
     * @param commodity
     *            Commodity
     */
    public void setCommodity( @Nullable final String commodity )
    {
        rememberChangedField("Commodity", this.commodity);
        this.commodity = commodity;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocCmmdtyQtyValidToDate</b>
     * </p>
     *
     * @param purgDocCmmdtyQtyValidToDate
     *            End of Validity Period
     */
    public void setPurgDocCmmdtyQtyValidToDate( @Nullable final LocalDateTime purgDocCmmdtyQtyValidToDate )
    {
        rememberChangedField("PurgDocCmmdtyQtyValidToDate", this.purgDocCmmdtyQtyValidToDate);
        this.purgDocCmmdtyQtyValidToDate = purgDocCmmdtyQtyValidToDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocCmmdtyQtyValidFromDate</b>
     * </p>
     *
     * @param purgDocCmmdtyQtyValidFromDate
     *            Start of Validity Period
     */
    public void setPurgDocCmmdtyQtyValidFromDate( @Nullable final LocalDateTime purgDocCmmdtyQtyValidFromDate )
    {
        rememberChangedField("PurgDocCmmdtyQtyValidFromDate", this.purgDocCmmdtyQtyValidFromDate);
        this.purgDocCmmdtyQtyValidFromDate = purgDocCmmdtyQtyValidFromDate;
    }

    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CommodityQuantity</b>
     * </p>
     *
     * @param commodityQuantity
     *            Commodity Quantity
     */
    public void setCommodityQuantity( @Nullable final BigDecimal commodityQuantity )
    {
        rememberChangedField("CommodityQuantity", this.commodityQuantity);
        this.commodityQuantity = commodityQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CommodityUnit</b>
     * </p>
     *
     * @param commodityUnit
     *            Purchase Order Unit of Measure
     */
    public void setCommodityUnit( @Nullable final String commodityUnit )
    {
        rememberChangedField("CommodityUnit", this.commodityUnit);
        this.commodityUnit = commodityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocCmmdtyRefDocItmQty</b>
     * </p>
     *
     * @param purgDocCmmdtyRefDocItmQty
     *            Price unit
     */
    public void setPurgDocCmmdtyRefDocItmQty( @Nullable final BigDecimal purgDocCmmdtyRefDocItmQty )
    {
        rememberChangedField("PurgDocCmmdtyRefDocItmQty", this.purgDocCmmdtyRefDocItmQty);
        this.purgDocCmmdtyRefDocItmQty = purgDocCmmdtyRefDocItmQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemQuantityUnit</b>
     * </p>
     *
     * @param itemQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setItemQuantityUnit( @Nullable final String itemQuantityUnit )
    {
        rememberChangedField("ItemQuantityUnit", this.itemQuantityUnit);
        this.itemQuantityUnit = itemQuantityUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CntrlPurContrItmCmmdtyQty";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CentralPurchaseContract", getCentralPurchaseContract());
        result.put("CentralPurchaseContractItem", getCentralPurchaseContractItem());
        result.put("PurgDocCmmdtyQtySqntlNumber", getPurgDocCmmdtyQtySqntlNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CentralPurchaseContract", getCentralPurchaseContract());
        values.put("CentralPurchaseContractItem", getCentralPurchaseContractItem());
        values.put("PurgDocCmmdtyQtySqntlNumber", getPurgDocCmmdtyQtySqntlNumber());
        values.put("Commodity", getCommodity());
        values.put("PurgDocCmmdtyQtyValidToDate", getPurgDocCmmdtyQtyValidToDate());
        values.put("PurgDocCmmdtyQtyValidFromDate", getPurgDocCmmdtyQtyValidFromDate());
        values.put("CommodityQuantity", getCommodityQuantity());
        values.put("CommodityUnit", getCommodityUnit());
        values.put("PurgDocCmmdtyRefDocItmQty", getPurgDocCmmdtyRefDocItmQty());
        values.put("ItemQuantityUnit", getItemQuantityUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CentralPurchaseContract") ) {
                final Object value = values.remove("CentralPurchaseContract");
                if( (value == null) || (!value.equals(getCentralPurchaseContract())) ) {
                    setCentralPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("CentralPurchaseContractItem") ) {
                final Object value = values.remove("CentralPurchaseContractItem");
                if( (value == null) || (!value.equals(getCentralPurchaseContractItem())) ) {
                    setCentralPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("PurgDocCmmdtyQtySqntlNumber") ) {
                final Object value = values.remove("PurgDocCmmdtyQtySqntlNumber");
                if( (value == null) || (!value.equals(getPurgDocCmmdtyQtySqntlNumber())) ) {
                    setPurgDocCmmdtyQtySqntlNumber(((String) value));
                }
            }
            if( values.containsKey("Commodity") ) {
                final Object value = values.remove("Commodity");
                if( (value == null) || (!value.equals(getCommodity())) ) {
                    setCommodity(((String) value));
                }
            }
            if( values.containsKey("PurgDocCmmdtyQtyValidToDate") ) {
                final Object value = values.remove("PurgDocCmmdtyQtyValidToDate");
                if( (value == null) || (!value.equals(getPurgDocCmmdtyQtyValidToDate())) ) {
                    setPurgDocCmmdtyQtyValidToDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PurgDocCmmdtyQtyValidFromDate") ) {
                final Object value = values.remove("PurgDocCmmdtyQtyValidFromDate");
                if( (value == null) || (!value.equals(getPurgDocCmmdtyQtyValidFromDate())) ) {
                    setPurgDocCmmdtyQtyValidFromDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CommodityQuantity") ) {
                final Object value = values.remove("CommodityQuantity");
                if( (value == null) || (!value.equals(getCommodityQuantity())) ) {
                    setCommodityQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("CommodityUnit") ) {
                final Object value = values.remove("CommodityUnit");
                if( (value == null) || (!value.equals(getCommodityUnit())) ) {
                    setCommodityUnit(((String) value));
                }
            }
            if( values.containsKey("PurgDocCmmdtyRefDocItmQty") ) {
                final Object value = values.remove("PurgDocCmmdtyRefDocItmQty");
                if( (value == null) || (!value.equals(getPurgDocCmmdtyRefDocItmQty())) ) {
                    setPurgDocCmmdtyRefDocItmQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemQuantityUnit") ) {
                final Object value = values.remove("ItemQuantityUnit");
                if( (value == null) || (!value.equals(getItemQuantityUnit())) ) {
                    setItemQuantityUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CntrlPurContrItmCmmdtyQtyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CntrlPurContrItmCmmdtyQtyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CntrlPurContrItmCmmdtyQtyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CntrlPurContrItmCmmdtyQtyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

}
