/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContrItmCmmdtyQtySelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty
 * CntrlPurContrItmCmmdtyQty} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class CntrlPurContrItmCmmdtyQtyByKeyFluentHelper
    extends
    FluentHelperByKey<CntrlPurContrItmCmmdtyQtyByKeyFluentHelper, CntrlPurContrItmCmmdtyQty, CntrlPurContrItmCmmdtyQtySelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty
     * CntrlPurContrItmCmmdtyQty} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CntrlPurContrItmCmmdtyQty}
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param centralPurchaseContractItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param purgDocCmmdtyQtySqntlNumber
     *            Commodity Qunatity Sequence Number in Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CntrlPurContrItmCmmdtyQty}
     */
    public CntrlPurContrItmCmmdtyQtyByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String centralPurchaseContract,
        final String centralPurchaseContractItem,
        final String purgDocCmmdtyQtySqntlNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("CentralPurchaseContract", centralPurchaseContract);
        this.key.put("CentralPurchaseContractItem", centralPurchaseContractItem);
        this.key.put("PurgDocCmmdtyQtySqntlNumber", purgDocCmmdtyQtySqntlNumber);
    }

    @Override
    @Nonnull
    protected Class<CntrlPurContrItmCmmdtyQty> getEntityClass()
    {
        return CntrlPurContrItmCmmdtyQty.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
