/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrItmCndnAmountField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrItmCndnAmountLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrItmCndnAmountOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContrItmCndnAmountSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Condition Amount
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CntrlPurContrItmCndnAmountType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CntrlPurContrItmCndnAmount extends VdmEntity<CntrlPurContrItmCndnAmount>
{

    /**
     * Selector for all available fields of CntrlPurContrItmCndnAmount.
     *
     */
    public final static CntrlPurContrItmCndnAmountSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "CentralPurchaseContract" )
    @JsonProperty( "CentralPurchaseContract" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContract" )
    private String centralPurchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContract</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurContrItmCndnAmountField<String>("CentralPurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "CentralPurchaseContractItem" )
    @JsonProperty( "CentralPurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContractItem" )
    private String centralPurchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContractItem</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CENTRAL_PURCHASE_CONTRACT_ITEM =
        new CntrlPurContrItmCndnAmountField<String>("CentralPurchaseContractItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @Key
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CONDITION_RECORD =
        new CntrlPurContrItmCndnAmountField<String>("ConditionRecord");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @return Validity end date of the condition record
     */
    @Key
    @SerializedName( "ConditionValidityEndDate" )
    @JsonProperty( "ConditionValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityEndDate</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<LocalDateTime> CONDITION_VALIDITY_END_DATE =
        new CntrlPurContrItmCndnAmountField<LocalDateTime>("ConditionValidityEndDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @return Sequential number of the condition
     */
    @Key
    @SerializedName( "ConditionSequentialNumber" )
    @JsonProperty( "ConditionSequentialNumber" )
    @Nullable
    @ODataField( odataName = "ConditionSequentialNumber" )
    private String conditionSequentialNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConditionSequentialNumber</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CONDITION_SEQUENTIAL_NUMBER =
        new CntrlPurContrItmCndnAmountField<String>("ConditionSequentialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CONDITION_TYPE =
        new CntrlPurContrItmCndnAmountField<String>("ConditionType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTextID</b>
     * </p>
     *
     * @return Number of texts
     */
    @SerializedName( "ConditionTextID" )
    @JsonProperty( "ConditionTextID" )
    @Nullable
    @ODataField( odataName = "ConditionTextID" )
    private String conditionTextID;
    /**
     * Use with available fluent helpers to apply the <b>ConditionTextID</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CONDITION_TEXT_ID =
        new CntrlPurContrItmCndnAmountField<String>("ConditionTextID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     *
     * @return Calculation Type for Condition
     */
    @SerializedName( "ConditionCalculationType" )
    @JsonProperty( "ConditionCalculationType" )
    @Nullable
    @ODataField( odataName = "ConditionCalculationType" )
    private String conditionCalculationType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCalculationType</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CONDITION_CALCULATION_TYPE =
        new CntrlPurContrItmCndnAmountField<String>("ConditionCalculationType");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @return Condition amount or percentage where no scale exists
     */
    @SerializedName( "ConditionRateValue" )
    @JsonProperty( "ConditionRateValue" )
    @Nullable
    @ODataField( odataName = "ConditionRateValue" )
    private BigDecimal conditionRateValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValue</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<BigDecimal> CONDITION_RATE_VALUE =
        new CntrlPurContrItmCndnAmountField<BigDecimal>("ConditionRateValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValueUnit</b>
     * </p>
     *
     * @return Condition Unit (Currency or Percentage)
     */
    @SerializedName( "ConditionRateValueUnit" )
    @JsonProperty( "ConditionRateValueUnit" )
    @Nullable
    @ODataField( odataName = "ConditionRateValueUnit" )
    private String conditionRateValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValueUnit</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CONDITION_RATE_VALUE_UNIT =
        new CntrlPurContrItmCndnAmountField<String>("ConditionRateValueUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "ConditionRateRatioUnit" )
    @JsonProperty( "ConditionRateRatioUnit" )
    @Nullable
    @ODataField( odataName = "ConditionRateRatioUnit" )
    private String conditionRateRatioUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateRatioUnit</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CONDITION_RATE_RATIO_UNIT =
        new CntrlPurContrItmCndnAmountField<String>("ConditionRateRatioUnit");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     *
     * @return Condition Ratio (in Percent or Per Mille)
     */
    @SerializedName( "ConditionRateRatio" )
    @JsonProperty( "ConditionRateRatio" )
    @Nullable
    @ODataField( odataName = "ConditionRateRatio" )
    private BigDecimal conditionRateRatio;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateRatio</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<BigDecimal> CONDITION_RATE_RATIO =
        new CntrlPurContrItmCndnAmountField<BigDecimal>("ConditionRateRatio");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @return Condition Unit (Currency or Percentage)
     */
    @SerializedName( "ConditionCurrency" )
    @JsonProperty( "ConditionCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionCurrency" )
    private String conditionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCurrency</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CONDITION_CURRENCY =
        new CntrlPurContrItmCndnAmountField<String>("ConditionCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionRateAmount" )
    @JsonProperty( "ConditionRateAmount" )
    @Nullable
    @ODataField( odataName = "ConditionRateAmount" )
    private BigDecimal conditionRateAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateAmount</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<BigDecimal> CONDITION_RATE_AMOUNT =
        new CntrlPurContrItmCndnAmountField<BigDecimal>("ConditionRateAmount");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @return Condition Pricing Unit
     */
    @SerializedName( "ConditionQuantity" )
    @JsonProperty( "ConditionQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionQuantity" )
    private BigDecimal conditionQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantity</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<BigDecimal> CONDITION_QUANTITY =
        new CntrlPurContrItmCndnAmountField<BigDecimal>("ConditionQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @return Condition Unit
     */
    @SerializedName( "ConditionQuantityUnit" )
    @JsonProperty( "ConditionQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionQuantityUnit" )
    private String conditionQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantityUnit</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CONDITION_QUANTITY_UNIT =
        new CntrlPurContrItmCndnAmountField<String>("ConditionQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyNmrtr</b>
     * </p>
     *
     * @return Numerator for converting condition units to base units
     */
    @SerializedName( "ConditionToBaseQtyNmrtr" )
    @JsonProperty( "ConditionToBaseQtyNmrtr" )
    @Nullable
    @ODataField( odataName = "ConditionToBaseQtyNmrtr" )
    private BigDecimal conditionToBaseQtyNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>ConditionToBaseQtyNmrtr</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<BigDecimal> CONDITION_TO_BASE_QTY_NMRTR =
        new CntrlPurContrItmCndnAmountField<BigDecimal>("ConditionToBaseQtyNmrtr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyDnmntr</b>
     * </p>
     *
     * @return Denominator for converting condition units to base units
     */
    @SerializedName( "ConditionToBaseQtyDnmntr" )
    @JsonProperty( "ConditionToBaseQtyDnmntr" )
    @Nullable
    @ODataField( odataName = "ConditionToBaseQtyDnmntr" )
    private BigDecimal conditionToBaseQtyDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>ConditionToBaseQtyDnmntr</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<BigDecimal> CONDITION_TO_BASE_QTY_DNMNTR =
        new CntrlPurContrItmCndnAmountField<BigDecimal>("ConditionToBaseQtyDnmntr");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> BASE_UNIT =
        new CntrlPurContrItmCndnAmountField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionLowerLimit</b>
     * </p>
     *
     * @return Lower limit of the condition rate/amount
     */
    @SerializedName( "ConditionLowerLimit" )
    @JsonProperty( "ConditionLowerLimit" )
    @Nullable
    @ODataField( odataName = "ConditionLowerLimit" )
    private BigDecimal conditionLowerLimit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionLowerLimit</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<BigDecimal> CONDITION_LOWER_LIMIT =
        new CntrlPurContrItmCndnAmountField<BigDecimal>("ConditionLowerLimit");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUpperLimit</b>
     * </p>
     *
     * @return Upper limit for the condition rate
     */
    @SerializedName( "ConditionUpperLimit" )
    @JsonProperty( "ConditionUpperLimit" )
    @Nullable
    @ODataField( odataName = "ConditionUpperLimit" )
    private BigDecimal conditionUpperLimit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionUpperLimit</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<BigDecimal> CONDITION_UPPER_LIMIT =
        new CntrlPurContrItmCndnAmountField<BigDecimal>("ConditionUpperLimit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAlternativeCurrency</b>
     * </p>
     *
     * @return Condition Currency (for Cumulation Fields)
     */
    @SerializedName( "ConditionAlternativeCurrency" )
    @JsonProperty( "ConditionAlternativeCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionAlternativeCurrency" )
    private String conditionAlternativeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionAlternativeCurrency</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CONDITION_ALTERNATIVE_CURRENCY =
        new CntrlPurContrItmCndnAmountField<String>("ConditionAlternativeCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionExclusion</b>
     * </p>
     *
     * @return Condition exclusion indicator
     */
    @SerializedName( "ConditionExclusion" )
    @JsonProperty( "ConditionExclusion" )
    @Nullable
    @ODataField( odataName = "ConditionExclusion" )
    private String conditionExclusion;
    /**
     * Use with available fluent helpers to apply the <b>ConditionExclusion</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CONDITION_EXCLUSION =
        new CntrlPurContrItmCndnAmountField<String>("ConditionExclusion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator for Condition Record
     */
    @SerializedName( "ConditionIsDeleted" )
    @JsonProperty( "ConditionIsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsDeleted" )
    private Boolean conditionIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsDeleted</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<Boolean> CONDITION_IS_DELETED =
        new CntrlPurContrItmCndnAmountField<Boolean>("ConditionIsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalValueDays</b>
     * </p>
     *
     * @return Additional Value Days
     */
    @SerializedName( "AdditionalValueDays" )
    @JsonProperty( "AdditionalValueDays" )
    @Nullable
    @ODataField( odataName = "AdditionalValueDays" )
    private String additionalValueDays;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalValueDays</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> ADDITIONAL_VALUE_DAYS =
        new CntrlPurContrItmCndnAmountField<String>("AdditionalValueDays");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FixedValueDate</b>
     * </p>
     *
     * @return Fixed Value Date
     */
    @SerializedName( "FixedValueDate" )
    @JsonProperty( "FixedValueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FixedValueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime fixedValueDate;
    /**
     * Use with available fluent helpers to apply the <b>FixedValueDate</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<LocalDateTime> FIXED_VALUE_DATE =
        new CntrlPurContrItmCndnAmountField<LocalDateTime>("FixedValueDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> PAYMENT_TERMS =
        new CntrlPurContrItmCndnAmountField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnMaxNumberOfSalesOrders</b>
     * </p>
     *
     * @return Maximum number of sales orders per condition record
     */
    @SerializedName( "CndnMaxNumberOfSalesOrders" )
    @JsonProperty( "CndnMaxNumberOfSalesOrders" )
    @Nullable
    @ODataField( odataName = "CndnMaxNumberOfSalesOrders" )
    private String cndnMaxNumberOfSalesOrders;
    /**
     * Use with available fluent helpers to apply the <b>CndnMaxNumberOfSalesOrders</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CNDN_MAX_NUMBER_OF_SALES_ORDERS =
        new CntrlPurContrItmCndnAmountField<String>("CndnMaxNumberOfSalesOrders");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumConditionBasisValue</b>
     * </p>
     *
     * @return Minimum condition base value
     */
    @SerializedName( "MinimumConditionBasisValue" )
    @JsonProperty( "MinimumConditionBasisValue" )
    @Nullable
    @ODataField( odataName = "MinimumConditionBasisValue" )
    private BigDecimal minimumConditionBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>MinimumConditionBasisValue</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<BigDecimal> MINIMUM_CONDITION_BASIS_VALUE =
        new CntrlPurContrItmCndnAmountField<BigDecimal>("MinimumConditionBasisValue");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumConditionBasisValue</b>
     * </p>
     *
     * @return Maximum condition base value
     */
    @SerializedName( "MaximumConditionBasisValue" )
    @JsonProperty( "MaximumConditionBasisValue" )
    @Nullable
    @ODataField( odataName = "MaximumConditionBasisValue" )
    private BigDecimal maximumConditionBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>MaximumConditionBasisValue</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<BigDecimal> MAXIMUM_CONDITION_BASIS_VALUE =
        new CntrlPurContrItmCndnAmountField<BigDecimal>("MaximumConditionBasisValue");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumConditionAmount</b>
     * </p>
     *
     * @return Maximum condition value
     */
    @SerializedName( "MaximumConditionAmount" )
    @JsonProperty( "MaximumConditionAmount" )
    @Nullable
    @ODataField( odataName = "MaximumConditionAmount" )
    private BigDecimal maximumConditionAmount;
    /**
     * Use with available fluent helpers to apply the <b>MaximumConditionAmount</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<BigDecimal> MAXIMUM_CONDITION_AMOUNT =
        new CntrlPurContrItmCndnAmountField<BigDecimal>("MaximumConditionAmount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionReleaseStatus</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "ConditionReleaseStatus" )
    @JsonProperty( "ConditionReleaseStatus" )
    @Nullable
    @ODataField( odataName = "ConditionReleaseStatus" )
    private String conditionReleaseStatus;
    /**
     * Use with available fluent helpers to apply the <b>ConditionReleaseStatus</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CONDITION_RELEASE_STATUS =
        new CntrlPurContrItmCndnAmountField<String>("ConditionReleaseStatus");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionChangeReason</b>
     * </p>
     *
     * @return Reason for Changing Condition Record
     */
    @SerializedName( "ConditionChangeReason" )
    @JsonProperty( "ConditionChangeReason" )
    @Nullable
    @ODataField( odataName = "ConditionChangeReason" )
    private String conditionChangeReason;
    /**
     * Use with available fluent helpers to apply the <b>ConditionChangeReason</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CONDITION_CHANGE_REASON =
        new CntrlPurContrItmCndnAmountField<String>("ConditionChangeReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CmmdtyPricingEngineIsEnabled</b>
     * </p>
     *
     * @return Condition Enabled for Commodity Pricing Engine (CPE)
     */
    @SerializedName( "CmmdtyPricingEngineIsEnabled" )
    @JsonProperty( "CmmdtyPricingEngineIsEnabled" )
    @Nullable
    @ODataField( odataName = "CmmdtyPricingEngineIsEnabled" )
    private String cmmdtyPricingEngineIsEnabled;
    /**
     * Use with available fluent helpers to apply the <b>CmmdtyPricingEngineIsEnabled</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> CMMDTY_PRICING_ENGINE_IS_ENABLED =
        new CntrlPurContrItmCndnAmountField<String>("CmmdtyPricingEngineIsEnabled");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @return Validity start date of the condition record
     */
    @SerializedName( "ConditionValidityStartDate" )
    @JsonProperty( "ConditionValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityStartDate</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<LocalDateTime> CONDITION_VALIDITY_START_DATE =
        new CntrlPurContrItmCndnAmountField<LocalDateTime>("ConditionValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPlantUniqueID</b>
     * </p>
     *
     * @return Plant Unique ID
     */
    @SerializedName( "ProcmtHubPlantUniqueID" )
    @JsonProperty( "ProcmtHubPlantUniqueID" )
    @Nullable
    @ODataField( odataName = "ProcmtHubPlantUniqueID" )
    private String procmtHubPlantUniqueID;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubPlantUniqueID</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> PROCMT_HUB_PLANT_UNIQUE_ID =
        new CntrlPurContrItmCndnAmountField<String>("ProcmtHubPlantUniqueID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @return Scale Type
     */
    @SerializedName( "PricingScaleType" )
    @JsonProperty( "PricingScaleType" )
    @Nullable
    @ODataField( odataName = "PricingScaleType" )
    private String pricingScaleType;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleType</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> PRICING_SCALE_TYPE =
        new CntrlPurContrItmCndnAmountField<String>("PricingScaleType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     *
     * @return Scale Base Type
     */
    @SerializedName( "PricingScaleBasis" )
    @JsonProperty( "PricingScaleBasis" )
    @Nullable
    @ODataField( odataName = "PricingScaleBasis" )
    private String pricingScaleBasis;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleBasis</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> PRICING_SCALE_BASIS =
        new CntrlPurContrItmCndnAmountField<String>("PricingScaleBasis");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleCheckingRule</b>
     * </p>
     *
     * @return Checking Rule for Scale Amounts
     */
    @SerializedName( "PricingScaleCheckingRule" )
    @JsonProperty( "PricingScaleCheckingRule" )
    @Nullable
    @ODataField( odataName = "PricingScaleCheckingRule" )
    private String pricingScaleCheckingRule;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleCheckingRule</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> PRICING_SCALE_CHECKING_RULE =
        new CntrlPurContrItmCndnAmountField<String>("PricingScaleCheckingRule");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleLine</b>
     * </p>
     *
     * @return Scale number for pricing
     */
    @SerializedName( "PricingScaleLine" )
    @JsonProperty( "PricingScaleLine" )
    @Nullable
    @ODataField( odataName = "PricingScaleLine" )
    private String pricingScaleLine;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleLine</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<String> PRICING_SCALE_LINE =
        new CntrlPurContrItmCndnAmountField<String>("PricingScaleLine");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionHasScales</b>
     * </p>
     *
     * @return Scales are maintained
     */
    @SerializedName( "ConditionHasScales" )
    @JsonProperty( "ConditionHasScales" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionHasScales" )
    private Boolean conditionHasScales;
    /**
     * Use with available fluent helpers to apply the <b>ConditionHasScales</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountField<Boolean> CONDITION_HAS_SCALES =
        new CntrlPurContrItmCndnAmountField<Boolean>("ConditionHasScales");
    /**
     * Navigation property <b>to_CentralPurchaseContract</b> for <b>CntrlPurContrItmCndnAmount</b> to single
     * <b>CentralPurchaseContract</b>.
     *
     */
    @SerializedName( "to_CentralPurchaseContract" )
    @JsonProperty( "to_CentralPurchaseContract" )
    @ODataField( odataName = "to_CentralPurchaseContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CentralPurchaseContract toCentralPurchaseContract;
    /**
     * Navigation property <b>to_CntrlPurContrItmCndnScales</b> for <b>CntrlPurContrItmCndnAmount</b> to multiple
     * <b>CntrlPurContrItmCndnScales</b>.
     *
     */
    @SerializedName( "to_CntrlPurContrItmCndnScales" )
    @JsonProperty( "to_CntrlPurContrItmCndnScales" )
    @ODataField( odataName = "to_CntrlPurContrItmCndnScales" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurContrItmCndnScales> toCntrlPurContrItmCndnScales;
    /**
     * Navigation property <b>to_CntrlPurContrItmCndnValdty</b> for <b>CntrlPurContrItmCndnAmount</b> to single
     * <b>CntrlPurContrItmCndnValdty</b>.
     *
     */
    @SerializedName( "to_CntrlPurContrItmCndnValdty" )
    @JsonProperty( "to_CntrlPurContrItmCndnValdty" )
    @ODataField( odataName = "to_CntrlPurContrItmCndnValdty" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CntrlPurContrItmCndnValdty toCntrlPurContrItmCndnValdty;
    /**
     * Use with available fluent helpers to apply the <b>to_CentralPurchaseContract</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountOneToOneLink<CentralPurchaseContract> TO_CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurContrItmCndnAmountOneToOneLink<CentralPurchaseContract>("to_CentralPurchaseContract");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlPurContrItmCndnScales</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountLink<CntrlPurContrItmCndnScales> TO_CNTRL_PUR_CONTR_ITM_CNDN_SCALES =
        new CntrlPurContrItmCndnAmountLink<CntrlPurContrItmCndnScales>("to_CntrlPurContrItmCndnScales");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlPurContrItmCndnValdty</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurContrItmCndnAmountOneToOneLink<CntrlPurContrItmCndnValdty> TO_CNTRL_PUR_CONTR_ITM_CNDN_VALDTY =
        new CntrlPurContrItmCndnAmountOneToOneLink<CntrlPurContrItmCndnValdty>("to_CntrlPurContrItmCndnValdty");

    @Nonnull
    @Override
    public Class<CntrlPurContrItmCndnAmount> getType()
    {
        return CntrlPurContrItmCndnAmount.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @param centralPurchaseContract
     *            Purchasing Document Number
     */
    public void setCentralPurchaseContract( @Nullable final String centralPurchaseContract )
    {
        rememberChangedField("CentralPurchaseContract", this.centralPurchaseContract);
        this.centralPurchaseContract = centralPurchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContractItem</b>
     * </p>
     *
     * @param centralPurchaseContractItem
     *            Item Number of Purchasing Document
     */
    public void setCentralPurchaseContractItem( @Nullable final String centralPurchaseContractItem )
    {
        rememberChangedField("CentralPurchaseContractItem", this.centralPurchaseContractItem);
        this.centralPurchaseContractItem = centralPurchaseContractItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     */
    public void setConditionValidityEndDate( @Nullable final LocalDateTime conditionValidityEndDate )
    {
        rememberChangedField("ConditionValidityEndDate", this.conditionValidityEndDate);
        this.conditionValidityEndDate = conditionValidityEndDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     */
    public void setConditionSequentialNumber( @Nullable final String conditionSequentialNumber )
    {
        rememberChangedField("ConditionSequentialNumber", this.conditionSequentialNumber);
        this.conditionSequentialNumber = conditionSequentialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTextID</b>
     * </p>
     *
     * @param conditionTextID
     *            Number of texts
     */
    public void setConditionTextID( @Nullable final String conditionTextID )
    {
        rememberChangedField("ConditionTextID", this.conditionTextID);
        this.conditionTextID = conditionTextID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     *
     * @param conditionCalculationType
     *            Calculation Type for Condition
     */
    public void setConditionCalculationType( @Nullable final String conditionCalculationType )
    {
        rememberChangedField("ConditionCalculationType", this.conditionCalculationType);
        this.conditionCalculationType = conditionCalculationType;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @param conditionRateValue
     *            Condition amount or percentage where no scale exists
     */
    public void setConditionRateValue( @Nullable final BigDecimal conditionRateValue )
    {
        rememberChangedField("ConditionRateValue", this.conditionRateValue);
        this.conditionRateValue = conditionRateValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValueUnit</b>
     * </p>
     *
     * @param conditionRateValueUnit
     *            Condition Unit (Currency or Percentage)
     */
    public void setConditionRateValueUnit( @Nullable final String conditionRateValueUnit )
    {
        rememberChangedField("ConditionRateValueUnit", this.conditionRateValueUnit);
        this.conditionRateValueUnit = conditionRateValueUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     *
     * @param conditionRateRatioUnit
     *            Unit of Measure
     */
    public void setConditionRateRatioUnit( @Nullable final String conditionRateRatioUnit )
    {
        rememberChangedField("ConditionRateRatioUnit", this.conditionRateRatioUnit);
        this.conditionRateRatioUnit = conditionRateRatioUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     *
     * @param conditionRateRatio
     *            Condition Ratio (in Percent or Per Mille)
     */
    public void setConditionRateRatio( @Nullable final BigDecimal conditionRateRatio )
    {
        rememberChangedField("ConditionRateRatio", this.conditionRateRatio);
        this.conditionRateRatio = conditionRateRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @param conditionCurrency
     *            Condition Unit (Currency or Percentage)
     */
    public void setConditionCurrency( @Nullable final String conditionCurrency )
    {
        rememberChangedField("ConditionCurrency", this.conditionCurrency);
        this.conditionCurrency = conditionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     *
     * @param conditionRateAmount
     *            Condition Amount or Percentage
     */
    public void setConditionRateAmount( @Nullable final BigDecimal conditionRateAmount )
    {
        rememberChangedField("ConditionRateAmount", this.conditionRateAmount);
        this.conditionRateAmount = conditionRateAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @param conditionQuantity
     *            Condition Pricing Unit
     */
    public void setConditionQuantity( @Nullable final BigDecimal conditionQuantity )
    {
        rememberChangedField("ConditionQuantity", this.conditionQuantity);
        this.conditionQuantity = conditionQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @param conditionQuantityUnit
     *            Condition Unit
     */
    public void setConditionQuantityUnit( @Nullable final String conditionQuantityUnit )
    {
        rememberChangedField("ConditionQuantityUnit", this.conditionQuantityUnit);
        this.conditionQuantityUnit = conditionQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyNmrtr</b>
     * </p>
     *
     * @param conditionToBaseQtyNmrtr
     *            Numerator for converting condition units to base units
     */
    public void setConditionToBaseQtyNmrtr( @Nullable final BigDecimal conditionToBaseQtyNmrtr )
    {
        rememberChangedField("ConditionToBaseQtyNmrtr", this.conditionToBaseQtyNmrtr);
        this.conditionToBaseQtyNmrtr = conditionToBaseQtyNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyDnmntr</b>
     * </p>
     *
     * @param conditionToBaseQtyDnmntr
     *            Denominator for converting condition units to base units
     */
    public void setConditionToBaseQtyDnmntr( @Nullable final BigDecimal conditionToBaseQtyDnmntr )
    {
        rememberChangedField("ConditionToBaseQtyDnmntr", this.conditionToBaseQtyDnmntr);
        this.conditionToBaseQtyDnmntr = conditionToBaseQtyDnmntr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionLowerLimit</b>
     * </p>
     *
     * @param conditionLowerLimit
     *            Lower limit of the condition rate/amount
     */
    public void setConditionLowerLimit( @Nullable final BigDecimal conditionLowerLimit )
    {
        rememberChangedField("ConditionLowerLimit", this.conditionLowerLimit);
        this.conditionLowerLimit = conditionLowerLimit;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUpperLimit</b>
     * </p>
     *
     * @param conditionUpperLimit
     *            Upper limit for the condition rate
     */
    public void setConditionUpperLimit( @Nullable final BigDecimal conditionUpperLimit )
    {
        rememberChangedField("ConditionUpperLimit", this.conditionUpperLimit);
        this.conditionUpperLimit = conditionUpperLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAlternativeCurrency</b>
     * </p>
     *
     * @param conditionAlternativeCurrency
     *            Condition Currency (for Cumulation Fields)
     */
    public void setConditionAlternativeCurrency( @Nullable final String conditionAlternativeCurrency )
    {
        rememberChangedField("ConditionAlternativeCurrency", this.conditionAlternativeCurrency);
        this.conditionAlternativeCurrency = conditionAlternativeCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionExclusion</b>
     * </p>
     *
     * @param conditionExclusion
     *            Condition exclusion indicator
     */
    public void setConditionExclusion( @Nullable final String conditionExclusion )
    {
        rememberChangedField("ConditionExclusion", this.conditionExclusion);
        this.conditionExclusion = conditionExclusion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsDeleted</b>
     * </p>
     *
     * @param conditionIsDeleted
     *            Deletion Indicator for Condition Record
     */
    public void setConditionIsDeleted( @Nullable final Boolean conditionIsDeleted )
    {
        rememberChangedField("ConditionIsDeleted", this.conditionIsDeleted);
        this.conditionIsDeleted = conditionIsDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalValueDays</b>
     * </p>
     *
     * @param additionalValueDays
     *            Additional Value Days
     */
    public void setAdditionalValueDays( @Nullable final String additionalValueDays )
    {
        rememberChangedField("AdditionalValueDays", this.additionalValueDays);
        this.additionalValueDays = additionalValueDays;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FixedValueDate</b>
     * </p>
     *
     * @param fixedValueDate
     *            Fixed Value Date
     */
    public void setFixedValueDate( @Nullable final LocalDateTime fixedValueDate )
    {
        rememberChangedField("FixedValueDate", this.fixedValueDate);
        this.fixedValueDate = fixedValueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnMaxNumberOfSalesOrders</b>
     * </p>
     *
     * @param cndnMaxNumberOfSalesOrders
     *            Maximum number of sales orders per condition record
     */
    public void setCndnMaxNumberOfSalesOrders( @Nullable final String cndnMaxNumberOfSalesOrders )
    {
        rememberChangedField("CndnMaxNumberOfSalesOrders", this.cndnMaxNumberOfSalesOrders);
        this.cndnMaxNumberOfSalesOrders = cndnMaxNumberOfSalesOrders;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumConditionBasisValue</b>
     * </p>
     *
     * @param minimumConditionBasisValue
     *            Minimum condition base value
     */
    public void setMinimumConditionBasisValue( @Nullable final BigDecimal minimumConditionBasisValue )
    {
        rememberChangedField("MinimumConditionBasisValue", this.minimumConditionBasisValue);
        this.minimumConditionBasisValue = minimumConditionBasisValue;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumConditionBasisValue</b>
     * </p>
     *
     * @param maximumConditionBasisValue
     *            Maximum condition base value
     */
    public void setMaximumConditionBasisValue( @Nullable final BigDecimal maximumConditionBasisValue )
    {
        rememberChangedField("MaximumConditionBasisValue", this.maximumConditionBasisValue);
        this.maximumConditionBasisValue = maximumConditionBasisValue;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumConditionAmount</b>
     * </p>
     *
     * @param maximumConditionAmount
     *            Maximum condition value
     */
    public void setMaximumConditionAmount( @Nullable final BigDecimal maximumConditionAmount )
    {
        rememberChangedField("MaximumConditionAmount", this.maximumConditionAmount);
        this.maximumConditionAmount = maximumConditionAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionReleaseStatus</b>
     * </p>
     *
     * @param conditionReleaseStatus
     *            Release Status
     */
    public void setConditionReleaseStatus( @Nullable final String conditionReleaseStatus )
    {
        rememberChangedField("ConditionReleaseStatus", this.conditionReleaseStatus);
        this.conditionReleaseStatus = conditionReleaseStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionChangeReason</b>
     * </p>
     *
     * @param conditionChangeReason
     *            Reason for Changing Condition Record
     */
    public void setConditionChangeReason( @Nullable final String conditionChangeReason )
    {
        rememberChangedField("ConditionChangeReason", this.conditionChangeReason);
        this.conditionChangeReason = conditionChangeReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CmmdtyPricingEngineIsEnabled</b>
     * </p>
     *
     * @param cmmdtyPricingEngineIsEnabled
     *            Condition Enabled for Commodity Pricing Engine (CPE)
     */
    public void setCmmdtyPricingEngineIsEnabled( @Nullable final String cmmdtyPricingEngineIsEnabled )
    {
        rememberChangedField("CmmdtyPricingEngineIsEnabled", this.cmmdtyPricingEngineIsEnabled);
        this.cmmdtyPricingEngineIsEnabled = cmmdtyPricingEngineIsEnabled;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @param conditionValidityStartDate
     *            Validity start date of the condition record
     */
    public void setConditionValidityStartDate( @Nullable final LocalDateTime conditionValidityStartDate )
    {
        rememberChangedField("ConditionValidityStartDate", this.conditionValidityStartDate);
        this.conditionValidityStartDate = conditionValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPlantUniqueID</b>
     * </p>
     *
     * @param procmtHubPlantUniqueID
     *            Plant Unique ID
     */
    public void setProcmtHubPlantUniqueID( @Nullable final String procmtHubPlantUniqueID )
    {
        rememberChangedField("ProcmtHubPlantUniqueID", this.procmtHubPlantUniqueID);
        this.procmtHubPlantUniqueID = procmtHubPlantUniqueID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @param pricingScaleType
     *            Scale Type
     */
    public void setPricingScaleType( @Nullable final String pricingScaleType )
    {
        rememberChangedField("PricingScaleType", this.pricingScaleType);
        this.pricingScaleType = pricingScaleType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     *
     * @param pricingScaleBasis
     *            Scale Base Type
     */
    public void setPricingScaleBasis( @Nullable final String pricingScaleBasis )
    {
        rememberChangedField("PricingScaleBasis", this.pricingScaleBasis);
        this.pricingScaleBasis = pricingScaleBasis;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleCheckingRule</b>
     * </p>
     *
     * @param pricingScaleCheckingRule
     *            Checking Rule for Scale Amounts
     */
    public void setPricingScaleCheckingRule( @Nullable final String pricingScaleCheckingRule )
    {
        rememberChangedField("PricingScaleCheckingRule", this.pricingScaleCheckingRule);
        this.pricingScaleCheckingRule = pricingScaleCheckingRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleLine</b>
     * </p>
     *
     * @param pricingScaleLine
     *            Scale number for pricing
     */
    public void setPricingScaleLine( @Nullable final String pricingScaleLine )
    {
        rememberChangedField("PricingScaleLine", this.pricingScaleLine);
        this.pricingScaleLine = pricingScaleLine;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionHasScales</b>
     * </p>
     *
     * @param conditionHasScales
     *            Scales are maintained
     */
    public void setConditionHasScales( @Nullable final Boolean conditionHasScales )
    {
        rememberChangedField("ConditionHasScales", this.conditionHasScales);
        this.conditionHasScales = conditionHasScales;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CntrlPurContrItmCndnAmount";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CentralPurchaseContract", getCentralPurchaseContract());
        result.put("CentralPurchaseContractItem", getCentralPurchaseContractItem());
        result.put("ConditionRecord", getConditionRecord());
        result.put("ConditionValidityEndDate", getConditionValidityEndDate());
        result.put("ConditionSequentialNumber", getConditionSequentialNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CentralPurchaseContract", getCentralPurchaseContract());
        values.put("CentralPurchaseContractItem", getCentralPurchaseContractItem());
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionValidityEndDate", getConditionValidityEndDate());
        values.put("ConditionSequentialNumber", getConditionSequentialNumber());
        values.put("ConditionType", getConditionType());
        values.put("ConditionTextID", getConditionTextID());
        values.put("ConditionCalculationType", getConditionCalculationType());
        values.put("ConditionRateValue", getConditionRateValue());
        values.put("ConditionRateValueUnit", getConditionRateValueUnit());
        values.put("ConditionRateRatioUnit", getConditionRateRatioUnit());
        values.put("ConditionRateRatio", getConditionRateRatio());
        values.put("ConditionCurrency", getConditionCurrency());
        values.put("ConditionRateAmount", getConditionRateAmount());
        values.put("ConditionQuantity", getConditionQuantity());
        values.put("ConditionQuantityUnit", getConditionQuantityUnit());
        values.put("ConditionToBaseQtyNmrtr", getConditionToBaseQtyNmrtr());
        values.put("ConditionToBaseQtyDnmntr", getConditionToBaseQtyDnmntr());
        values.put("BaseUnit", getBaseUnit());
        values.put("ConditionLowerLimit", getConditionLowerLimit());
        values.put("ConditionUpperLimit", getConditionUpperLimit());
        values.put("ConditionAlternativeCurrency", getConditionAlternativeCurrency());
        values.put("ConditionExclusion", getConditionExclusion());
        values.put("ConditionIsDeleted", getConditionIsDeleted());
        values.put("AdditionalValueDays", getAdditionalValueDays());
        values.put("FixedValueDate", getFixedValueDate());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("CndnMaxNumberOfSalesOrders", getCndnMaxNumberOfSalesOrders());
        values.put("MinimumConditionBasisValue", getMinimumConditionBasisValue());
        values.put("MaximumConditionBasisValue", getMaximumConditionBasisValue());
        values.put("MaximumConditionAmount", getMaximumConditionAmount());
        values.put("ConditionReleaseStatus", getConditionReleaseStatus());
        values.put("ConditionChangeReason", getConditionChangeReason());
        values.put("CmmdtyPricingEngineIsEnabled", getCmmdtyPricingEngineIsEnabled());
        values.put("ConditionValidityStartDate", getConditionValidityStartDate());
        values.put("ProcmtHubPlantUniqueID", getProcmtHubPlantUniqueID());
        values.put("PricingScaleType", getPricingScaleType());
        values.put("PricingScaleBasis", getPricingScaleBasis());
        values.put("PricingScaleCheckingRule", getPricingScaleCheckingRule());
        values.put("PricingScaleLine", getPricingScaleLine());
        values.put("ConditionHasScales", getConditionHasScales());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CentralPurchaseContract") ) {
                final Object value = values.remove("CentralPurchaseContract");
                if( (value == null) || (!value.equals(getCentralPurchaseContract())) ) {
                    setCentralPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("CentralPurchaseContractItem") ) {
                final Object value = values.remove("CentralPurchaseContractItem");
                if( (value == null) || (!value.equals(getCentralPurchaseContractItem())) ) {
                    setCentralPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionValidityEndDate") ) {
                final Object value = values.remove("ConditionValidityEndDate");
                if( (value == null) || (!value.equals(getConditionValidityEndDate())) ) {
                    setConditionValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionSequentialNumber") ) {
                final Object value = values.remove("ConditionSequentialNumber");
                if( (value == null) || (!value.equals(getConditionSequentialNumber())) ) {
                    setConditionSequentialNumber(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("ConditionTextID") ) {
                final Object value = values.remove("ConditionTextID");
                if( (value == null) || (!value.equals(getConditionTextID())) ) {
                    setConditionTextID(((String) value));
                }
            }
            if( values.containsKey("ConditionCalculationType") ) {
                final Object value = values.remove("ConditionCalculationType");
                if( (value == null) || (!value.equals(getConditionCalculationType())) ) {
                    setConditionCalculationType(((String) value));
                }
            }
            if( values.containsKey("ConditionRateValue") ) {
                final Object value = values.remove("ConditionRateValue");
                if( (value == null) || (!value.equals(getConditionRateValue())) ) {
                    setConditionRateValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateValueUnit") ) {
                final Object value = values.remove("ConditionRateValueUnit");
                if( (value == null) || (!value.equals(getConditionRateValueUnit())) ) {
                    setConditionRateValueUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionRateRatioUnit") ) {
                final Object value = values.remove("ConditionRateRatioUnit");
                if( (value == null) || (!value.equals(getConditionRateRatioUnit())) ) {
                    setConditionRateRatioUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionRateRatio") ) {
                final Object value = values.remove("ConditionRateRatio");
                if( (value == null) || (!value.equals(getConditionRateRatio())) ) {
                    setConditionRateRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionCurrency") ) {
                final Object value = values.remove("ConditionCurrency");
                if( (value == null) || (!value.equals(getConditionCurrency())) ) {
                    setConditionCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionRateAmount") ) {
                final Object value = values.remove("ConditionRateAmount");
                if( (value == null) || (!value.equals(getConditionRateAmount())) ) {
                    setConditionRateAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionQuantity") ) {
                final Object value = values.remove("ConditionQuantity");
                if( (value == null) || (!value.equals(getConditionQuantity())) ) {
                    setConditionQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnit") ) {
                final Object value = values.remove("ConditionQuantityUnit");
                if( (value == null) || (!value.equals(getConditionQuantityUnit())) ) {
                    setConditionQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionToBaseQtyNmrtr") ) {
                final Object value = values.remove("ConditionToBaseQtyNmrtr");
                if( (value == null) || (!value.equals(getConditionToBaseQtyNmrtr())) ) {
                    setConditionToBaseQtyNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionToBaseQtyDnmntr") ) {
                final Object value = values.remove("ConditionToBaseQtyDnmntr");
                if( (value == null) || (!value.equals(getConditionToBaseQtyDnmntr())) ) {
                    setConditionToBaseQtyDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionLowerLimit") ) {
                final Object value = values.remove("ConditionLowerLimit");
                if( (value == null) || (!value.equals(getConditionLowerLimit())) ) {
                    setConditionLowerLimit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionUpperLimit") ) {
                final Object value = values.remove("ConditionUpperLimit");
                if( (value == null) || (!value.equals(getConditionUpperLimit())) ) {
                    setConditionUpperLimit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionAlternativeCurrency") ) {
                final Object value = values.remove("ConditionAlternativeCurrency");
                if( (value == null) || (!value.equals(getConditionAlternativeCurrency())) ) {
                    setConditionAlternativeCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionExclusion") ) {
                final Object value = values.remove("ConditionExclusion");
                if( (value == null) || (!value.equals(getConditionExclusion())) ) {
                    setConditionExclusion(((String) value));
                }
            }
            if( values.containsKey("ConditionIsDeleted") ) {
                final Object value = values.remove("ConditionIsDeleted");
                if( (value == null) || (!value.equals(getConditionIsDeleted())) ) {
                    setConditionIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("AdditionalValueDays") ) {
                final Object value = values.remove("AdditionalValueDays");
                if( (value == null) || (!value.equals(getAdditionalValueDays())) ) {
                    setAdditionalValueDays(((String) value));
                }
            }
            if( values.containsKey("FixedValueDate") ) {
                final Object value = values.remove("FixedValueDate");
                if( (value == null) || (!value.equals(getFixedValueDate())) ) {
                    setFixedValueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("CndnMaxNumberOfSalesOrders") ) {
                final Object value = values.remove("CndnMaxNumberOfSalesOrders");
                if( (value == null) || (!value.equals(getCndnMaxNumberOfSalesOrders())) ) {
                    setCndnMaxNumberOfSalesOrders(((String) value));
                }
            }
            if( values.containsKey("MinimumConditionBasisValue") ) {
                final Object value = values.remove("MinimumConditionBasisValue");
                if( (value == null) || (!value.equals(getMinimumConditionBasisValue())) ) {
                    setMinimumConditionBasisValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumConditionBasisValue") ) {
                final Object value = values.remove("MaximumConditionBasisValue");
                if( (value == null) || (!value.equals(getMaximumConditionBasisValue())) ) {
                    setMaximumConditionBasisValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumConditionAmount") ) {
                final Object value = values.remove("MaximumConditionAmount");
                if( (value == null) || (!value.equals(getMaximumConditionAmount())) ) {
                    setMaximumConditionAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionReleaseStatus") ) {
                final Object value = values.remove("ConditionReleaseStatus");
                if( (value == null) || (!value.equals(getConditionReleaseStatus())) ) {
                    setConditionReleaseStatus(((String) value));
                }
            }
            if( values.containsKey("ConditionChangeReason") ) {
                final Object value = values.remove("ConditionChangeReason");
                if( (value == null) || (!value.equals(getConditionChangeReason())) ) {
                    setConditionChangeReason(((String) value));
                }
            }
            if( values.containsKey("CmmdtyPricingEngineIsEnabled") ) {
                final Object value = values.remove("CmmdtyPricingEngineIsEnabled");
                if( (value == null) || (!value.equals(getCmmdtyPricingEngineIsEnabled())) ) {
                    setCmmdtyPricingEngineIsEnabled(((String) value));
                }
            }
            if( values.containsKey("ConditionValidityStartDate") ) {
                final Object value = values.remove("ConditionValidityStartDate");
                if( (value == null) || (!value.equals(getConditionValidityStartDate())) ) {
                    setConditionValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProcmtHubPlantUniqueID") ) {
                final Object value = values.remove("ProcmtHubPlantUniqueID");
                if( (value == null) || (!value.equals(getProcmtHubPlantUniqueID())) ) {
                    setProcmtHubPlantUniqueID(((String) value));
                }
            }
            if( values.containsKey("PricingScaleType") ) {
                final Object value = values.remove("PricingScaleType");
                if( (value == null) || (!value.equals(getPricingScaleType())) ) {
                    setPricingScaleType(((String) value));
                }
            }
            if( values.containsKey("PricingScaleBasis") ) {
                final Object value = values.remove("PricingScaleBasis");
                if( (value == null) || (!value.equals(getPricingScaleBasis())) ) {
                    setPricingScaleBasis(((String) value));
                }
            }
            if( values.containsKey("PricingScaleCheckingRule") ) {
                final Object value = values.remove("PricingScaleCheckingRule");
                if( (value == null) || (!value.equals(getPricingScaleCheckingRule())) ) {
                    setPricingScaleCheckingRule(((String) value));
                }
            }
            if( values.containsKey("PricingScaleLine") ) {
                final Object value = values.remove("PricingScaleLine");
                if( (value == null) || (!value.equals(getPricingScaleLine())) ) {
                    setPricingScaleLine(((String) value));
                }
            }
            if( values.containsKey("ConditionHasScales") ) {
                final Object value = values.remove("ConditionHasScales");
                if( (value == null) || (!value.equals(getConditionHasScales())) ) {
                    setConditionHasScales(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CentralPurchaseContract") ) {
                final Object value = (values).remove("to_CentralPurchaseContract");
                if( value instanceof Map ) {
                    if( toCentralPurchaseContract == null ) {
                        toCentralPurchaseContract = new CentralPurchaseContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCentralPurchaseContract.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CntrlPurContrItmCndnScales") ) {
                final Object value = (values).remove("to_CntrlPurContrItmCndnScales");
                if( value instanceof Iterable ) {
                    if( toCntrlPurContrItmCndnScales == null ) {
                        toCntrlPurContrItmCndnScales = Lists.newArrayList();
                    } else {
                        toCntrlPurContrItmCndnScales = Lists.newArrayList(toCntrlPurContrItmCndnScales);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurContrItmCndnScales entity;
                        if( toCntrlPurContrItmCndnScales.size() > i ) {
                            entity = toCntrlPurContrItmCndnScales.get(i);
                        } else {
                            entity = new CntrlPurContrItmCndnScales();
                            toCntrlPurContrItmCndnScales.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CntrlPurContrItmCndnValdty") ) {
                final Object value = (values).remove("to_CntrlPurContrItmCndnValdty");
                if( value instanceof Map ) {
                    if( toCntrlPurContrItmCndnValdty == null ) {
                        toCntrlPurContrItmCndnValdty = new CntrlPurContrItmCndnValdty();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCntrlPurContrItmCndnValdty.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CntrlPurContrItmCndnAmountField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CntrlPurContrItmCndnAmountField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CntrlPurContrItmCndnAmountField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CntrlPurContrItmCndnAmountField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCentralPurchaseContract != null ) {
            (values).put("to_CentralPurchaseContract", toCentralPurchaseContract);
        }
        if( toCntrlPurContrItmCndnScales != null ) {
            (values).put("to_CntrlPurContrItmCndnScales", toCntrlPurContrItmCndnScales);
        }
        if( toCntrlPurContrItmCndnValdty != null ) {
            (values).put("to_CntrlPurContrItmCndnValdty", toCntrlPurContrItmCndnValdty);
        }
        return values;
    }

    /**
     * Fetches the <b>CentralPurchaseContract</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CentralPurchaseContract</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CentralPurchaseContract fetchCentralPurchaseContract()
    {
        return fetchFieldAsSingle("to_CentralPurchaseContract", CentralPurchaseContract.class);
    }

    /**
     * Retrieval of associated <b>CentralPurchaseContract</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * If the navigation property <b>to_CentralPurchaseContract</b> of a queried <b>CntrlPurContrItmCndnAmount</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CentralPurchaseContract</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CentralPurchaseContract getCentralPurchaseContractOrFetch()
    {
        if( toCentralPurchaseContract == null ) {
            toCentralPurchaseContract = fetchCentralPurchaseContract();
        }
        return toCentralPurchaseContract;
    }

    /**
     * Retrieval of associated <b>CentralPurchaseContract</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurContrItmCndnAmount</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CentralPurchaseContract</b> is already loaded, the
     *         result will contain the <b>CentralPurchaseContract</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CentralPurchaseContract> getCentralPurchaseContractIfPresent()
    {
        return Option.of(toCentralPurchaseContract);
    }

    /**
     * Overwrites the associated <b>CentralPurchaseContract</b> entity for the loaded navigation property
     * <b>to_CentralPurchaseContract</b>.
     *
     * @param value
     *            New <b>CentralPurchaseContract</b> entity.
     */
    public void setCentralPurchaseContract( final CentralPurchaseContract value )
    {
        toCentralPurchaseContract = value;
    }

    /**
     * Fetches the <b>CntrlPurContrItmCndnScales</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CntrlPurContrItmCndnScales</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurContrItmCndnScales</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrItmCndnScales> fetchCntrlPurContrItmCndnScales()
    {
        return fetchFieldAsList("to_CntrlPurContrItmCndnScales", CntrlPurContrItmCndnScales.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContrItmCndnScales</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmCndnScales</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmCndnScales</b> of a queried <b>CntrlPurContrItmCndnAmount</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContrItmCndnScales</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrItmCndnScales> getCntrlPurContrItmCndnScalesOrFetch()
    {
        if( toCntrlPurContrItmCndnScales == null ) {
            toCntrlPurContrItmCndnScales = fetchCntrlPurContrItmCndnScales();
        }
        return toCntrlPurContrItmCndnScales;
    }

    /**
     * Retrieval of associated <b>CntrlPurContrItmCndnScales</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmCndnScales</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurContrItmCndnAmount</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlPurContrItmCndnScales</b> is already loaded, the
     *         result will contain the <b>CntrlPurContrItmCndnScales</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurContrItmCndnScales>> getCntrlPurContrItmCndnScalesIfPresent()
    {
        return Option.of(toCntrlPurContrItmCndnScales);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurContrItmCndnScales</b> entities for the loaded navigation property
     * <b>to_CntrlPurContrItmCndnScales</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmCndnScales</b> of a queried <b>CntrlPurContrItmCndnAmount</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurContrItmCndnScales</b> entities.
     */
    public void setCntrlPurContrItmCndnScales( @Nonnull final List<CntrlPurContrItmCndnScales> value )
    {
        if( toCntrlPurContrItmCndnScales == null ) {
            toCntrlPurContrItmCndnScales = Lists.newArrayList();
        }
        toCntrlPurContrItmCndnScales.clear();
        toCntrlPurContrItmCndnScales.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurContrItmCndnScales</b> entities. This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmCndnScales</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmCndnScales</b> of a queried <b>CntrlPurContrItmCndnAmount</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurContrItmCndnScales</b> entities.
     */
    public void addCntrlPurContrItmCndnScales( CntrlPurContrItmCndnScales... entity )
    {
        if( toCntrlPurContrItmCndnScales == null ) {
            toCntrlPurContrItmCndnScales = Lists.newArrayList();
        }
        toCntrlPurContrItmCndnScales.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CntrlPurContrItmCndnValdty</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CntrlPurContrItmCndnValdty</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CntrlPurContrItmCndnValdty</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CntrlPurContrItmCndnValdty fetchCntrlPurContrItmCndnValdty()
    {
        return fetchFieldAsSingle("to_CntrlPurContrItmCndnValdty", CntrlPurContrItmCndnValdty.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContrItmCndnValdty</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmCndnValdty</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmCndnValdty</b> of a queried <b>CntrlPurContrItmCndnAmount</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContrItmCndnValdty</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CntrlPurContrItmCndnValdty getCntrlPurContrItmCndnValdtyOrFetch()
    {
        if( toCntrlPurContrItmCndnValdty == null ) {
            toCntrlPurContrItmCndnValdty = fetchCntrlPurContrItmCndnValdty();
        }
        return toCntrlPurContrItmCndnValdty;
    }

    /**
     * Retrieval of associated <b>CntrlPurContrItmCndnValdty</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmCndnValdty</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurContrItmCndnAmount</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlPurContrItmCndnValdty</b> is already loaded, the
     *         result will contain the <b>CntrlPurContrItmCndnValdty</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CntrlPurContrItmCndnValdty> getCntrlPurContrItmCndnValdtyIfPresent()
    {
        return Option.of(toCntrlPurContrItmCndnValdty);
    }

    /**
     * Overwrites the associated <b>CntrlPurContrItmCndnValdty</b> entity for the loaded navigation property
     * <b>to_CntrlPurContrItmCndnValdty</b>.
     *
     * @param value
     *            New <b>CntrlPurContrItmCndnValdty</b> entity.
     */
    public void setCntrlPurContrItmCndnValdty( final CntrlPurContrItmCndnValdty value )
    {
        toCntrlPurContrItmCndnValdty = value;
    }

    /**
     * Helper class to allow for fluent creation of CntrlPurContrItmCndnAmount instances.
     *
     */
    public final static class CntrlPurContrItmCndnAmountBuilder
    {

        private CentralPurchaseContract toCentralPurchaseContract;
        private String centralPurchaseContract = null;
        private List<CntrlPurContrItmCndnScales> toCntrlPurContrItmCndnScales = Lists.newArrayList();
        private CntrlPurContrItmCndnValdty toCntrlPurContrItmCndnValdty;

        private CntrlPurContrItmCndnAmount.CntrlPurContrItmCndnAmountBuilder toCentralPurchaseContract(
            final CentralPurchaseContract value )
        {
            toCentralPurchaseContract = value;
            return this;
        }

        /**
         * Navigation property <b>to_CentralPurchaseContract</b> for <b>CntrlPurContrItmCndnAmount</b> to single
         * <b>CentralPurchaseContract</b>.
         *
         * @param value
         *            The CentralPurchaseContract to build this CntrlPurContrItmCndnAmount with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrItmCndnAmount.CntrlPurContrItmCndnAmountBuilder centralPurchaseContract(
            final CentralPurchaseContract value )
        {
            return toCentralPurchaseContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
         * </p>
         *
         * @param value
         *            The centralPurchaseContract to build this CntrlPurContrItmCndnAmount with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrItmCndnAmount.CntrlPurContrItmCndnAmountBuilder centralPurchaseContract(
            final String value )
        {
            centralPurchaseContract = value;
            return this;
        }

        private CntrlPurContrItmCndnAmount.CntrlPurContrItmCndnAmountBuilder toCntrlPurContrItmCndnScales(
            final List<CntrlPurContrItmCndnScales> value )
        {
            toCntrlPurContrItmCndnScales.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CntrlPurContrItmCndnScales</b> for <b>CntrlPurContrItmCndnAmount</b> to multiple
         * <b>CntrlPurContrItmCndnScales</b>.
         *
         * @param value
         *            The CntrlPurContrItmCndnScaless to build this CntrlPurContrItmCndnAmount with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrItmCndnAmount.CntrlPurContrItmCndnAmountBuilder cntrlPurContrItmCndnScales(
            CntrlPurContrItmCndnScales... value )
        {
            return toCntrlPurContrItmCndnScales(Lists.newArrayList(value));
        }

        private CntrlPurContrItmCndnAmount.CntrlPurContrItmCndnAmountBuilder toCntrlPurContrItmCndnValdty(
            final CntrlPurContrItmCndnValdty value )
        {
            toCntrlPurContrItmCndnValdty = value;
            return this;
        }

        /**
         * Navigation property <b>to_CntrlPurContrItmCndnValdty</b> for <b>CntrlPurContrItmCndnAmount</b> to single
         * <b>CntrlPurContrItmCndnValdty</b>.
         *
         * @param value
         *            The CntrlPurContrItmCndnValdty to build this CntrlPurContrItmCndnAmount with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrItmCndnAmount.CntrlPurContrItmCndnAmountBuilder cntrlPurContrItmCndnValdty(
            final CntrlPurContrItmCndnValdty value )
        {
            return toCntrlPurContrItmCndnValdty(value);
        }

    }

}
