/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContrItmCndnAmountSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnAmount
 * CntrlPurContrItmCndnAmount} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class CntrlPurContrItmCndnAmountByKeyFluentHelper
    extends
    FluentHelperByKey<CntrlPurContrItmCndnAmountByKeyFluentHelper, CntrlPurContrItmCndnAmount, CntrlPurContrItmCndnAmountSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnAmount
     * CntrlPurContrItmCndnAmount} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CntrlPurContrItmCndnAmount}
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param centralPurchaseContractItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CntrlPurContrItmCndnAmount}
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public CntrlPurContrItmCndnAmountByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String centralPurchaseContract,
        final String centralPurchaseContractItem,
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate,
        final String conditionSequentialNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("CentralPurchaseContract", centralPurchaseContract);
        this.key.put("CentralPurchaseContractItem", centralPurchaseContractItem);
        this.key.put("ConditionRecord", conditionRecord);
        this.key.put("ConditionValidityEndDate", conditionValidityEndDate);
        this.key.put("ConditionSequentialNumber", conditionSequentialNumber);
    }

    @Override
    @Nonnull
    protected Class<CntrlPurContrItmCndnAmount> getEntityClass()
    {
        return CntrlPurContrItmCndnAmount.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
