/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrItmCndnValdtyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrItmCndnValdtyLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrItmCndnValdtyOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContrItmCndnValdtySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Condition Validity
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CntrlPurContrItmCndnValdtyType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CntrlPurContrItmCndnValdty extends VdmEntity<CntrlPurContrItmCndnValdty>
{

    /**
     * Selector for all available fields of CntrlPurContrItmCndnValdty.
     *
     */
    public final static CntrlPurContrItmCndnValdtySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "CentralPurchaseContract" )
    @JsonProperty( "CentralPurchaseContract" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContract" )
    private String centralPurchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContract</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnValdtyField<String> CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurContrItmCndnValdtyField<String>("CentralPurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "CentralPurchaseContractItem" )
    @JsonProperty( "CentralPurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContractItem" )
    private String centralPurchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContractItem</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnValdtyField<String> CENTRAL_PURCHASE_CONTRACT_ITEM =
        new CntrlPurContrItmCndnValdtyField<String>("CentralPurchaseContractItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @Key
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnValdtyField<String> CONDITION_RECORD =
        new CntrlPurContrItmCndnValdtyField<String>("ConditionRecord");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @return Validity end date of the condition record
     */
    @Key
    @SerializedName( "ConditionValidityEndDate" )
    @JsonProperty( "ConditionValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityEndDate</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnValdtyField<LocalDateTime> CONDITION_VALIDITY_END_DATE =
        new CntrlPurContrItmCndnValdtyField<LocalDateTime>("ConditionValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @return Application
     */
    @SerializedName( "ConditionApplication" )
    @JsonProperty( "ConditionApplication" )
    @Nullable
    @ODataField( odataName = "ConditionApplication" )
    private String conditionApplication;
    /**
     * Use with available fluent helpers to apply the <b>ConditionApplication</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnValdtyField<String> CONDITION_APPLICATION =
        new CntrlPurContrItmCndnValdtyField<String>("ConditionApplication");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnValdtyField<String> CONDITION_TYPE =
        new CntrlPurContrItmCndnValdtyField<String>("ConditionType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @return Validity start date of the condition record
     */
    @SerializedName( "ConditionValidityStartDate" )
    @JsonProperty( "ConditionValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityStartDate</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnValdtyField<LocalDateTime> CONDITION_VALIDITY_START_DATE =
        new CntrlPurContrItmCndnValdtyField<LocalDateTime>("ConditionValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPlantUniqueID</b>
     * </p>
     *
     * @return Plant Unique ID
     */
    @SerializedName( "ProcmtHubPlantUniqueID" )
    @JsonProperty( "ProcmtHubPlantUniqueID" )
    @Nullable
    @ODataField( odataName = "ProcmtHubPlantUniqueID" )
    private String procmtHubPlantUniqueID;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubPlantUniqueID</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnValdtyField<String> PROCMT_HUB_PLANT_UNIQUE_ID =
        new CntrlPurContrItmCndnValdtyField<String>("ProcmtHubPlantUniqueID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator for Condition Record
     */
    @SerializedName( "ConditionIsDeleted" )
    @JsonProperty( "ConditionIsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsDeleted" )
    private Boolean conditionIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsDeleted</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmCndnValdtyField<Boolean> CONDITION_IS_DELETED =
        new CntrlPurContrItmCndnValdtyField<Boolean>("ConditionIsDeleted");
    /**
     * Navigation property <b>to_CentralPurchaseContract</b> for <b>CntrlPurContrItmCndnValdty</b> to single
     * <b>CentralPurchaseContract</b>.
     *
     */
    @SerializedName( "to_CentralPurchaseContract" )
    @JsonProperty( "to_CentralPurchaseContract" )
    @ODataField( odataName = "to_CentralPurchaseContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CentralPurchaseContract toCentralPurchaseContract;
    /**
     * Navigation property <b>to_CntrlPurchaseContractItem</b> for <b>CntrlPurContrItmCndnValdty</b> to single
     * <b>CntrlPurchaseContractItem</b>.
     *
     */
    @SerializedName( "to_CntrlPurchaseContractItem" )
    @JsonProperty( "to_CntrlPurchaseContractItem" )
    @ODataField( odataName = "to_CntrlPurchaseContractItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CntrlPurchaseContractItem toCntrlPurchaseContractItem;
    /**
     * Navigation property <b>to_CntrlPurContrItmCndnAmount</b> for <b>CntrlPurContrItmCndnValdty</b> to multiple
     * <b>CntrlPurContrItmCndnAmount</b>.
     *
     */
    @SerializedName( "to_CntrlPurContrItmCndnAmount" )
    @JsonProperty( "to_CntrlPurContrItmCndnAmount" )
    @ODataField( odataName = "to_CntrlPurContrItmCndnAmount" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurContrItmCndnAmount> toCntrlPurContrItmCndnAmount;
    /**
     * Use with available fluent helpers to apply the <b>to_CentralPurchaseContract</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurContrItmCndnValdtyOneToOneLink<CentralPurchaseContract> TO_CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurContrItmCndnValdtyOneToOneLink<CentralPurchaseContract>("to_CentralPurchaseContract");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlPurchaseContractItem</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurContrItmCndnValdtyOneToOneLink<CntrlPurchaseContractItem> TO_CNTRL_PURCHASE_CONTRACT_ITEM =
        new CntrlPurContrItmCndnValdtyOneToOneLink<CntrlPurchaseContractItem>("to_CntrlPurchaseContractItem");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlPurContrItmCndnAmount</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurContrItmCndnValdtyLink<CntrlPurContrItmCndnAmount> TO_CNTRL_PUR_CONTR_ITM_CNDN_AMOUNT =
        new CntrlPurContrItmCndnValdtyLink<CntrlPurContrItmCndnAmount>("to_CntrlPurContrItmCndnAmount");

    @Nonnull
    @Override
    public Class<CntrlPurContrItmCndnValdty> getType()
    {
        return CntrlPurContrItmCndnValdty.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @param centralPurchaseContract
     *            Purchasing Document Number
     */
    public void setCentralPurchaseContract( @Nullable final String centralPurchaseContract )
    {
        rememberChangedField("CentralPurchaseContract", this.centralPurchaseContract);
        this.centralPurchaseContract = centralPurchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContractItem</b>
     * </p>
     *
     * @param centralPurchaseContractItem
     *            Item Number of Purchasing Document
     */
    public void setCentralPurchaseContractItem( @Nullable final String centralPurchaseContractItem )
    {
        rememberChangedField("CentralPurchaseContractItem", this.centralPurchaseContractItem);
        this.centralPurchaseContractItem = centralPurchaseContractItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     */
    public void setConditionValidityEndDate( @Nullable final LocalDateTime conditionValidityEndDate )
    {
        rememberChangedField("ConditionValidityEndDate", this.conditionValidityEndDate);
        this.conditionValidityEndDate = conditionValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @param conditionValidityStartDate
     *            Validity start date of the condition record
     */
    public void setConditionValidityStartDate( @Nullable final LocalDateTime conditionValidityStartDate )
    {
        rememberChangedField("ConditionValidityStartDate", this.conditionValidityStartDate);
        this.conditionValidityStartDate = conditionValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPlantUniqueID</b>
     * </p>
     *
     * @param procmtHubPlantUniqueID
     *            Plant Unique ID
     */
    public void setProcmtHubPlantUniqueID( @Nullable final String procmtHubPlantUniqueID )
    {
        rememberChangedField("ProcmtHubPlantUniqueID", this.procmtHubPlantUniqueID);
        this.procmtHubPlantUniqueID = procmtHubPlantUniqueID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsDeleted</b>
     * </p>
     *
     * @param conditionIsDeleted
     *            Deletion Indicator for Condition Record
     */
    public void setConditionIsDeleted( @Nullable final Boolean conditionIsDeleted )
    {
        rememberChangedField("ConditionIsDeleted", this.conditionIsDeleted);
        this.conditionIsDeleted = conditionIsDeleted;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CntrlPurContrItmCndnValdty";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CentralPurchaseContract", getCentralPurchaseContract());
        result.put("CentralPurchaseContractItem", getCentralPurchaseContractItem());
        result.put("ConditionRecord", getConditionRecord());
        result.put("ConditionValidityEndDate", getConditionValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CentralPurchaseContract", getCentralPurchaseContract());
        values.put("CentralPurchaseContractItem", getCentralPurchaseContractItem());
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionValidityEndDate", getConditionValidityEndDate());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionType", getConditionType());
        values.put("ConditionValidityStartDate", getConditionValidityStartDate());
        values.put("ProcmtHubPlantUniqueID", getProcmtHubPlantUniqueID());
        values.put("ConditionIsDeleted", getConditionIsDeleted());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CentralPurchaseContract") ) {
                final Object value = values.remove("CentralPurchaseContract");
                if( (value == null) || (!value.equals(getCentralPurchaseContract())) ) {
                    setCentralPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("CentralPurchaseContractItem") ) {
                final Object value = values.remove("CentralPurchaseContractItem");
                if( (value == null) || (!value.equals(getCentralPurchaseContractItem())) ) {
                    setCentralPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionValidityEndDate") ) {
                final Object value = values.remove("ConditionValidityEndDate");
                if( (value == null) || (!value.equals(getConditionValidityEndDate())) ) {
                    setConditionValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("ConditionValidityStartDate") ) {
                final Object value = values.remove("ConditionValidityStartDate");
                if( (value == null) || (!value.equals(getConditionValidityStartDate())) ) {
                    setConditionValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProcmtHubPlantUniqueID") ) {
                final Object value = values.remove("ProcmtHubPlantUniqueID");
                if( (value == null) || (!value.equals(getProcmtHubPlantUniqueID())) ) {
                    setProcmtHubPlantUniqueID(((String) value));
                }
            }
            if( values.containsKey("ConditionIsDeleted") ) {
                final Object value = values.remove("ConditionIsDeleted");
                if( (value == null) || (!value.equals(getConditionIsDeleted())) ) {
                    setConditionIsDeleted(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CentralPurchaseContract") ) {
                final Object value = (values).remove("to_CentralPurchaseContract");
                if( value instanceof Map ) {
                    if( toCentralPurchaseContract == null ) {
                        toCentralPurchaseContract = new CentralPurchaseContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCentralPurchaseContract.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CntrlPurchaseContractItem") ) {
                final Object value = (values).remove("to_CntrlPurchaseContractItem");
                if( value instanceof Map ) {
                    if( toCntrlPurchaseContractItem == null ) {
                        toCntrlPurchaseContractItem = new CntrlPurchaseContractItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCntrlPurchaseContractItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CntrlPurContrItmCndnAmount") ) {
                final Object value = (values).remove("to_CntrlPurContrItmCndnAmount");
                if( value instanceof Iterable ) {
                    if( toCntrlPurContrItmCndnAmount == null ) {
                        toCntrlPurContrItmCndnAmount = Lists.newArrayList();
                    } else {
                        toCntrlPurContrItmCndnAmount = Lists.newArrayList(toCntrlPurContrItmCndnAmount);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurContrItmCndnAmount entity;
                        if( toCntrlPurContrItmCndnAmount.size() > i ) {
                            entity = toCntrlPurContrItmCndnAmount.get(i);
                        } else {
                            entity = new CntrlPurContrItmCndnAmount();
                            toCntrlPurContrItmCndnAmount.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CntrlPurContrItmCndnValdtyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CntrlPurContrItmCndnValdtyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CntrlPurContrItmCndnValdtyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CntrlPurContrItmCndnValdtyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCentralPurchaseContract != null ) {
            (values).put("to_CentralPurchaseContract", toCentralPurchaseContract);
        }
        if( toCntrlPurchaseContractItem != null ) {
            (values).put("to_CntrlPurchaseContractItem", toCntrlPurchaseContractItem);
        }
        if( toCntrlPurContrItmCndnAmount != null ) {
            (values).put("to_CntrlPurContrItmCndnAmount", toCntrlPurContrItmCndnAmount);
        }
        return values;
    }

    /**
     * Fetches the <b>CentralPurchaseContract</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CentralPurchaseContract</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CentralPurchaseContract fetchCentralPurchaseContract()
    {
        return fetchFieldAsSingle("to_CentralPurchaseContract", CentralPurchaseContract.class);
    }

    /**
     * Retrieval of associated <b>CentralPurchaseContract</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * If the navigation property <b>to_CentralPurchaseContract</b> of a queried <b>CntrlPurContrItmCndnValdty</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CentralPurchaseContract</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CentralPurchaseContract getCentralPurchaseContractOrFetch()
    {
        if( toCentralPurchaseContract == null ) {
            toCentralPurchaseContract = fetchCentralPurchaseContract();
        }
        return toCentralPurchaseContract;
    }

    /**
     * Retrieval of associated <b>CentralPurchaseContract</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurContrItmCndnValdty</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CentralPurchaseContract</b> is already loaded, the
     *         result will contain the <b>CentralPurchaseContract</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CentralPurchaseContract> getCentralPurchaseContractIfPresent()
    {
        return Option.of(toCentralPurchaseContract);
    }

    /**
     * Overwrites the associated <b>CentralPurchaseContract</b> entity for the loaded navigation property
     * <b>to_CentralPurchaseContract</b>.
     *
     * @param value
     *            New <b>CentralPurchaseContract</b> entity.
     */
    public void setCentralPurchaseContract( final CentralPurchaseContract value )
    {
        toCentralPurchaseContract = value;
    }

    /**
     * Fetches the <b>CntrlPurchaseContractItem</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CntrlPurchaseContractItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CntrlPurchaseContractItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CntrlPurchaseContractItem fetchCntrlPurchaseContractItem()
    {
        return fetchFieldAsSingle("to_CntrlPurchaseContractItem", CntrlPurchaseContractItem.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurchaseContractItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CntrlPurchaseContractItem</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurchaseContractItem</b> of a queried <b>CntrlPurContrItmCndnValdty</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurchaseContractItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CntrlPurchaseContractItem getCntrlPurchaseContractItemOrFetch()
    {
        if( toCntrlPurchaseContractItem == null ) {
            toCntrlPurchaseContractItem = fetchCntrlPurchaseContractItem();
        }
        return toCntrlPurchaseContractItem;
    }

    /**
     * Retrieval of associated <b>CntrlPurchaseContractItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CntrlPurchaseContractItem</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurContrItmCndnValdty</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlPurchaseContractItem</b> is already loaded, the
     *         result will contain the <b>CntrlPurchaseContractItem</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CntrlPurchaseContractItem> getCntrlPurchaseContractItemIfPresent()
    {
        return Option.of(toCntrlPurchaseContractItem);
    }

    /**
     * Overwrites the associated <b>CntrlPurchaseContractItem</b> entity for the loaded navigation property
     * <b>to_CntrlPurchaseContractItem</b>.
     *
     * @param value
     *            New <b>CntrlPurchaseContractItem</b> entity.
     */
    public void setCntrlPurchaseContractItem( final CntrlPurchaseContractItem value )
    {
        toCntrlPurchaseContractItem = value;
    }

    /**
     * Fetches the <b>CntrlPurContrItmCndnAmount</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CntrlPurContrItmCndnAmount</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurContrItmCndnAmount</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrItmCndnAmount> fetchCntrlPurContrItmCndnAmount()
    {
        return fetchFieldAsList("to_CntrlPurContrItmCndnAmount", CntrlPurContrItmCndnAmount.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContrItmCndnAmount</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmCndnAmount</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmCndnAmount</b> of a queried <b>CntrlPurContrItmCndnValdty</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContrItmCndnAmount</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrItmCndnAmount> getCntrlPurContrItmCndnAmountOrFetch()
    {
        if( toCntrlPurContrItmCndnAmount == null ) {
            toCntrlPurContrItmCndnAmount = fetchCntrlPurContrItmCndnAmount();
        }
        return toCntrlPurContrItmCndnAmount;
    }

    /**
     * Retrieval of associated <b>CntrlPurContrItmCndnAmount</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmCndnAmount</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurContrItmCndnValdty</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlPurContrItmCndnAmount</b> is already loaded, the
     *         result will contain the <b>CntrlPurContrItmCndnAmount</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurContrItmCndnAmount>> getCntrlPurContrItmCndnAmountIfPresent()
    {
        return Option.of(toCntrlPurContrItmCndnAmount);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurContrItmCndnAmount</b> entities for the loaded navigation property
     * <b>to_CntrlPurContrItmCndnAmount</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmCndnAmount</b> of a queried <b>CntrlPurContrItmCndnValdty</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurContrItmCndnAmount</b> entities.
     */
    public void setCntrlPurContrItmCndnAmount( @Nonnull final List<CntrlPurContrItmCndnAmount> value )
    {
        if( toCntrlPurContrItmCndnAmount == null ) {
            toCntrlPurContrItmCndnAmount = Lists.newArrayList();
        }
        toCntrlPurContrItmCndnAmount.clear();
        toCntrlPurContrItmCndnAmount.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurContrItmCndnAmount</b> entities. This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmCndnAmount</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmCndnAmount</b> of a queried <b>CntrlPurContrItmCndnValdty</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurContrItmCndnAmount</b> entities.
     */
    public void addCntrlPurContrItmCndnAmount( CntrlPurContrItmCndnAmount... entity )
    {
        if( toCntrlPurContrItmCndnAmount == null ) {
            toCntrlPurContrItmCndnAmount = Lists.newArrayList();
        }
        toCntrlPurContrItmCndnAmount.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CntrlPurContrItmCndnValdty instances.
     *
     */
    public final static class CntrlPurContrItmCndnValdtyBuilder
    {

        private CentralPurchaseContract toCentralPurchaseContract;
        private String centralPurchaseContract = null;
        private CntrlPurchaseContractItem toCntrlPurchaseContractItem;
        private List<CntrlPurContrItmCndnAmount> toCntrlPurContrItmCndnAmount = Lists.newArrayList();

        private CntrlPurContrItmCndnValdty.CntrlPurContrItmCndnValdtyBuilder toCentralPurchaseContract(
            final CentralPurchaseContract value )
        {
            toCentralPurchaseContract = value;
            return this;
        }

        /**
         * Navigation property <b>to_CentralPurchaseContract</b> for <b>CntrlPurContrItmCndnValdty</b> to single
         * <b>CentralPurchaseContract</b>.
         *
         * @param value
         *            The CentralPurchaseContract to build this CntrlPurContrItmCndnValdty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrItmCndnValdty.CntrlPurContrItmCndnValdtyBuilder centralPurchaseContract(
            final CentralPurchaseContract value )
        {
            return toCentralPurchaseContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
         * </p>
         *
         * @param value
         *            The centralPurchaseContract to build this CntrlPurContrItmCndnValdty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrItmCndnValdty.CntrlPurContrItmCndnValdtyBuilder centralPurchaseContract(
            final String value )
        {
            centralPurchaseContract = value;
            return this;
        }

        private CntrlPurContrItmCndnValdty.CntrlPurContrItmCndnValdtyBuilder toCntrlPurchaseContractItem(
            final CntrlPurchaseContractItem value )
        {
            toCntrlPurchaseContractItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_CntrlPurchaseContractItem</b> for <b>CntrlPurContrItmCndnValdty</b> to single
         * <b>CntrlPurchaseContractItem</b>.
         *
         * @param value
         *            The CntrlPurchaseContractItem to build this CntrlPurContrItmCndnValdty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrItmCndnValdty.CntrlPurContrItmCndnValdtyBuilder cntrlPurchaseContractItem(
            final CntrlPurchaseContractItem value )
        {
            return toCntrlPurchaseContractItem(value);
        }

        private CntrlPurContrItmCndnValdty.CntrlPurContrItmCndnValdtyBuilder toCntrlPurContrItmCndnAmount(
            final List<CntrlPurContrItmCndnAmount> value )
        {
            toCntrlPurContrItmCndnAmount.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CntrlPurContrItmCndnAmount</b> for <b>CntrlPurContrItmCndnValdty</b> to multiple
         * <b>CntrlPurContrItmCndnAmount</b>.
         *
         * @param value
         *            The CntrlPurContrItmCndnAmounts to build this CntrlPurContrItmCndnValdty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrItmCndnValdty.CntrlPurContrItmCndnValdtyBuilder cntrlPurContrItmCndnAmount(
            CntrlPurContrItmCndnAmount... value )
        {
            return toCntrlPurContrItmCndnAmount(Lists.newArrayList(value));
        }

    }

}
