/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrItmDistributionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrItmDistributionLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrItmDistributionOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContrItmDistributionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Distribution
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CntrlPurContrItmDistributionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CntrlPurContrItmDistribution extends VdmEntity<CntrlPurContrItmDistribution>
{

    /**
     * Selector for all available fields of CntrlPurContrItmDistribution.
     *
     */
    public final static CntrlPurContrItmDistributionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "CentralPurchaseContract" )
    @JsonProperty( "CentralPurchaseContract" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContract" )
    private String centralPurchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContract</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurContrItmDistributionField<String>("CentralPurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "CentralPurchaseContractItem" )
    @JsonProperty( "CentralPurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContractItem" )
    private String centralPurchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContractItem</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> CENTRAL_PURCHASE_CONTRACT_ITEM =
        new CntrlPurContrItmDistributionField<String>("CentralPurchaseContractItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DistributionKey</b>
     * </p>
     *
     * @return Distribution Number of Central Purchasing Document
     */
    @Key
    @SerializedName( "DistributionKey" )
    @JsonProperty( "DistributionKey" )
    @Nullable
    @ODataField( odataName = "DistributionKey" )
    private String distributionKey;
    /**
     * Use with available fluent helpers to apply the <b>DistributionKey</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> DISTRIBUTION_KEY =
        new CntrlPurContrItmDistributionField<String>("DistributionKey");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubCompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "ProcmtHubCompanyCode" )
    @JsonProperty( "ProcmtHubCompanyCode" )
    @Nullable
    @ODataField( odataName = "ProcmtHubCompanyCode" )
    private String procmtHubCompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubCompanyCode</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_COMPANY_CODE =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPlant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "ProcmtHubPlant" )
    @JsonProperty( "ProcmtHubPlant" )
    @Nullable
    @ODataField( odataName = "ProcmtHubPlant" )
    private String procmtHubPlant;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubPlant</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_PLANT =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPurchasingOrg</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "ProcmtHubPurchasingOrg" )
    @JsonProperty( "ProcmtHubPurchasingOrg" )
    @Nullable
    @ODataField( odataName = "ProcmtHubPurchasingOrg" )
    private String procmtHubPurchasingOrg;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubPurchasingOrg</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_PURCHASING_ORG =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubPurchasingOrg");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "ProcmtHubPurchasingGroup" )
    @JsonProperty( "ProcmtHubPurchasingGroup" )
    @Nullable
    @ODataField( odataName = "ProcmtHubPurchasingGroup" )
    private String procmtHubPurchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubPurchasingGroup</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_PURCHASING_GROUP =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubPurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubCompanyCodeGroupingID</b>
     * </p>
     *
     * @return Grouping ID for Company Codes
     */
    @SerializedName( "ProcmtHubCompanyCodeGroupingID" )
    @JsonProperty( "ProcmtHubCompanyCodeGroupingID" )
    @Nullable
    @ODataField( odataName = "ProcmtHubCompanyCodeGroupingID" )
    private String procmtHubCompanyCodeGroupingID;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubCompanyCodeGroupingID</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_COMPANY_CODE_GROUPING_ID =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubCompanyCodeGroupingID");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrDistrCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "CntrlPurContrDistrCurrency" )
    @JsonProperty( "CntrlPurContrDistrCurrency" )
    @Nullable
    @ODataField( odataName = "CntrlPurContrDistrCurrency" )
    private String cntrlPurContrDistrCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CntrlPurContrDistrCurrency</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> CNTRL_PUR_CONTR_DISTR_CURRENCY =
        new CntrlPurContrItmDistributionField<String>("CntrlPurContrDistrCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PAYMENT_TERMS =
        new CntrlPurContrItmDistributionField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @return Cash discount days 1
     */
    @SerializedName( "CashDiscount1Days" )
    @JsonProperty( "CashDiscount1Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Days" )
    private BigDecimal cashDiscount1Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Days</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<BigDecimal> CASH_DISCOUNT1_DAYS =
        new CntrlPurContrItmDistributionField<BigDecimal>("CashDiscount1Days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @return Cash discount days 2
     */
    @SerializedName( "CashDiscount2Days" )
    @JsonProperty( "CashDiscount2Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Days" )
    private BigDecimal cashDiscount2Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Days</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<BigDecimal> CASH_DISCOUNT2_DAYS =
        new CntrlPurContrItmDistributionField<BigDecimal>("CashDiscount2Days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @return Net Payment Terms Period
     */
    @SerializedName( "NetPaymentDays" )
    @JsonProperty( "NetPaymentDays" )
    @Nullable
    @ODataField( odataName = "NetPaymentDays" )
    private BigDecimal netPaymentDays;
    /**
     * Use with available fluent helpers to apply the <b>NetPaymentDays</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<BigDecimal> NET_PAYMENT_DAYS =
        new CntrlPurContrItmDistributionField<BigDecimal>("NetPaymentDays");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 1
     */
    @SerializedName( "CashDiscount1Percent" )
    @JsonProperty( "CashDiscount1Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Percent" )
    private BigDecimal cashDiscount1Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Percent</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<BigDecimal> CASH_DISCOUNT1_PERCENT =
        new CntrlPurContrItmDistributionField<BigDecimal>("CashDiscount1Percent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 2
     */
    @SerializedName( "CashDiscount2Percent" )
    @JsonProperty( "CashDiscount2Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Percent" )
    private BigDecimal cashDiscount2Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Percent</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<BigDecimal> CASH_DISCOUNT2_PERCENT =
        new CntrlPurContrItmDistributionField<BigDecimal>("CashDiscount2Percent");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionType</b>
     * </p>
     *
     * @return Distribution Type for Central Purchase Contract Item
     */
    @SerializedName( "DistributionType" )
    @JsonProperty( "DistributionType" )
    @Nullable
    @ODataField( odataName = "DistributionType" )
    private String distributionType;
    /**
     * Use with available fluent helpers to apply the <b>DistributionType</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> DISTRIBUTION_TYPE =
        new CntrlPurContrItmDistributionField<String>("DistributionType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ExternalReferenceDocument</b>
     * </p>
     *
     * @return Document Number of External Reference Document
     */
    @SerializedName( "ExternalReferenceDocument" )
    @JsonProperty( "ExternalReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ExternalReferenceDocument" )
    private String externalReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ExternalReferenceDocument</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> EXTERNAL_REFERENCE_DOCUMENT =
        new CntrlPurContrItmDistributionField<String>("ExternalReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ExternalReferenceDocumentItem</b>
     * </p>
     *
     * @return Document Item Number of External Reference Document
     */
    @SerializedName( "ExternalReferenceDocumentItem" )
    @JsonProperty( "ExternalReferenceDocumentItem" )
    @Nullable
    @ODataField( odataName = "ExternalReferenceDocumentItem" )
    private String externalReferenceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ExternalReferenceDocumentItem</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> EXTERNAL_REFERENCE_DOCUMENT_ITEM =
        new CntrlPurContrItmDistributionField<String>("ExternalReferenceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ExternalRefDocCategory</b>
     * </p>
     *
     * @return Category of an external transaction or element
     */
    @SerializedName( "ExternalRefDocCategory" )
    @JsonProperty( "ExternalRefDocCategory" )
    @Nullable
    @ODataField( odataName = "ExternalRefDocCategory" )
    private String externalRefDocCategory;
    /**
     * Use with available fluent helpers to apply the <b>ExternalRefDocCategory</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> EXTERNAL_REF_DOC_CATEGORY =
        new CntrlPurContrItmDistributionField<String>("ExternalRefDocCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @return Purchasing Document Category
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentCategory</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PURCHASING_DOCUMENT_CATEGORY =
        new CntrlPurContrItmDistributionField<String>("PurchasingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentType</b>
     * </p>
     *
     * @return Purchasing Document Type
     */
    @SerializedName( "PurchasingDocumentType" )
    @JsonProperty( "PurchasingDocumentType" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentType" )
    private String purchasingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentType</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PURCHASING_DOCUMENT_TYPE =
        new CntrlPurContrItmDistributionField<String>("PurchasingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> STORAGE_LOCATION =
        new CntrlPurContrItmDistributionField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrDistributionPct</b>
     * </p>
     *
     * @return Distribution Percentage in Central Purchasing Document
     */
    @SerializedName( "CntrlPurContrDistributionPct" )
    @JsonProperty( "CntrlPurContrDistributionPct" )
    @Nullable
    @ODataField( odataName = "CntrlPurContrDistributionPct" )
    private BigDecimal cntrlPurContrDistributionPct;
    /**
     * Use with available fluent helpers to apply the <b>CntrlPurContrDistributionPct</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<BigDecimal> CNTRL_PUR_CONTR_DISTRIBUTION_PCT =
        new CntrlPurContrItmDistributionField<BigDecimal>("CntrlPurContrDistributionPct");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrItmDistrQty</b>
     * </p>
     *
     * @return Target Quantity
     */
    @SerializedName( "CntrlPurContrItmDistrQty" )
    @JsonProperty( "CntrlPurContrItmDistrQty" )
    @Nullable
    @ODataField( odataName = "CntrlPurContrItmDistrQty" )
    private BigDecimal cntrlPurContrItmDistrQty;
    /**
     * Use with available fluent helpers to apply the <b>CntrlPurContrItmDistrQty</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<BigDecimal> CNTRL_PUR_CONTR_ITM_DISTR_QTY =
        new CntrlPurContrItmDistributionField<BigDecimal>("CntrlPurContrItmDistrQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> ORDER_QUANTITY_UNIT =
        new CntrlPurContrItmDistributionField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrItmDistrAmt</b>
     * </p>
     *
     * @return Target Value for Header Area per Distribution
     */
    @SerializedName( "CntrlPurContrItmDistrAmt" )
    @JsonProperty( "CntrlPurContrItmDistrAmt" )
    @Nullable
    @ODataField( odataName = "CntrlPurContrItmDistrAmt" )
    private BigDecimal cntrlPurContrItmDistrAmt;
    /**
     * Use with available fluent helpers to apply the <b>CntrlPurContrItmDistrAmt</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<BigDecimal> CNTRL_PUR_CONTR_ITM_DISTR_AMT =
        new CntrlPurContrItmDistributionField<BigDecimal>("CntrlPurContrItmDistrAmt");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementHubSourceSystem</b>
     * </p>
     *
     * @return Logical System
     */
    @SerializedName( "ProcurementHubSourceSystem" )
    @JsonProperty( "ProcurementHubSourceSystem" )
    @Nullable
    @ODataField( odataName = "ProcurementHubSourceSystem" )
    private String procurementHubSourceSystem;
    /**
     * Use with available fluent helpers to apply the <b>ProcurementHubSourceSystem</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCUREMENT_HUB_SOURCE_SYSTEM =
        new CntrlPurContrItmDistributionField<String>("ProcurementHubSourceSystem");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubProduct</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "ProcmtHubProduct" )
    @JsonProperty( "ProcmtHubProduct" )
    @Nullable
    @ODataField( odataName = "ProcmtHubProduct" )
    private String procmtHubProduct;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubProduct</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_PRODUCT =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubProduct");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubProductGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "ProcmtHubProductGroup" )
    @JsonProperty( "ProcmtHubProductGroup" )
    @Nullable
    @ODataField( odataName = "ProcmtHubProductGroup" )
    private String procmtHubProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubProductGroup</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_PRODUCT_GROUP =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPurchaseContract</b>
     * </p>
     *
     * @return Contract of External System
     */
    @SerializedName( "ProcmtHubPurchaseContract" )
    @JsonProperty( "ProcmtHubPurchaseContract" )
    @Nullable
    @ODataField( odataName = "ProcmtHubPurchaseContract" )
    private String procmtHubPurchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubPurchaseContract</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_PURCHASE_CONTRACT =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubPurchaseContract");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPurchaseContractItem</b>
     * </p>
     *
     * @return Contract Item of External System
     */
    @SerializedName( "ProcmtHubPurchaseContractItem" )
    @JsonProperty( "ProcmtHubPurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "ProcmtHubPurchaseContractItem" )
    private String procmtHubPurchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubPurchaseContractItem</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_PURCHASE_CONTRACT_ITEM =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubPurchaseContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemDistributionStatus</b>
     * </p>
     *
     * @return Distribution Status
     */
    @SerializedName( "ItemDistributionStatus" )
    @JsonProperty( "ItemDistributionStatus" )
    @Nullable
    @ODataField( odataName = "ItemDistributionStatus" )
    private String itemDistributionStatus;
    /**
     * Use with available fluent helpers to apply the <b>ItemDistributionStatus</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> ITEM_DISTRIBUTION_STATUS =
        new CntrlPurContrItmDistributionField<String>("ItemDistributionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceHeaderDistributionKey</b>
     * </p>
     *
     * @return Distribution Number of Central Purchasing Document
     */
    @SerializedName( "ReferenceHeaderDistributionKey" )
    @JsonProperty( "ReferenceHeaderDistributionKey" )
    @Nullable
    @ODataField( odataName = "ReferenceHeaderDistributionKey" )
    private String referenceHeaderDistributionKey;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceHeaderDistributionKey</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> REFERENCE_HEADER_DISTRIBUTION_KEY =
        new CntrlPurContrItmDistributionField<String>("ReferenceHeaderDistributionKey");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Link field for view query
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @ODataField( odataName = "IsDeleted" )
    private String isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> IS_DELETED =
        new CntrlPurContrItmDistributionField<String>("IsDeleted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OutlineAgrmtItmIsBlocked</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "OutlineAgrmtItmIsBlocked" )
    @JsonProperty( "OutlineAgrmtItmIsBlocked" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "OutlineAgrmtItmIsBlocked" )
    private Boolean outlineAgrmtItmIsBlocked;
    /**
     * Use with available fluent helpers to apply the <b>OutlineAgrmtItmIsBlocked</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<Boolean> OUTLINE_AGRMT_ITM_IS_BLOCKED =
        new CntrlPurContrItmDistributionField<Boolean>("OutlineAgrmtItmIsBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocItmBlkRsnCode</b>
     * </p>
     *
     * @return Block Reason Code
     */
    @SerializedName( "PurgDocItmBlkRsnCode" )
    @JsonProperty( "PurgDocItmBlkRsnCode" )
    @Nullable
    @ODataField( odataName = "PurgDocItmBlkRsnCode" )
    private String purgDocItmBlkRsnCode;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocItmBlkRsnCode</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PURG_DOC_ITM_BLK_RSN_CODE =
        new CntrlPurContrItmDistributionField<String>("PurgDocItmBlkRsnCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecordUpdateCode</b>
     * </p>
     *
     * @return Indicator: Update Info Record
     */
    @SerializedName( "PurchasingInfoRecordUpdateCode" )
    @JsonProperty( "PurchasingInfoRecordUpdateCode" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecordUpdateCode" )
    private String purchasingInfoRecordUpdateCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecordUpdateCode</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PURCHASING_INFO_RECORD_UPDATE_CODE =
        new CntrlPurContrItmDistributionField<String>("PurchasingInfoRecordUpdateCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDistributionNumber</b>
     * </p>
     *
     * @return Distribution Number of Central Purchasing Document
     */
    @SerializedName( "ReferenceDistributionNumber" )
    @JsonProperty( "ReferenceDistributionNumber" )
    @Nullable
    @ODataField( odataName = "ReferenceDistributionNumber" )
    private String referenceDistributionNumber;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDistributionNumber</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> REFERENCE_DISTRIBUTION_NUMBER =
        new CntrlPurContrItmDistributionField<String>("ReferenceDistributionNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SourceListIsUpdated</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "SourceListIsUpdated" )
    @JsonProperty( "SourceListIsUpdated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SourceListIsUpdated" )
    private Boolean sourceListIsUpdated;
    /**
     * Use with available fluent helpers to apply the <b>SourceListIsUpdated</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<Boolean> SOURCE_LIST_IS_UPDATED =
        new CntrlPurContrItmDistributionField<Boolean>("SourceListIsUpdated");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceListRestriction</b>
     * </p>
     *
     * @return Source List Restriction Indicator
     */
    @SerializedName( "SourceListRestriction" )
    @JsonProperty( "SourceListRestriction" )
    @Nullable
    @ODataField( odataName = "SourceListRestriction" )
    private String sourceListRestriction;
    /**
     * Use with available fluent helpers to apply the <b>SourceListRestriction</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> SOURCE_LIST_RESTRICTION =
        new CntrlPurContrItmDistributionField<String>("SourceListRestriction");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> INCOTERMS_CLASSIFICATION =
        new CntrlPurContrItmDistributionField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> INCOTERMS_LOCATION1 =
        new CntrlPurContrItmDistributionField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingInstruction</b>
     * </p>
     *
     * @return Shipping Instructions
     */
    @SerializedName( "ShippingInstruction" )
    @JsonProperty( "ShippingInstruction" )
    @Nullable
    @ODataField( odataName = "ShippingInstruction" )
    private String shippingInstruction;
    /**
     * Use with available fluent helpers to apply the <b>ShippingInstruction</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> SHIPPING_INSTRUCTION =
        new CntrlPurContrItmDistributionField<String>("ShippingInstruction");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubDelivAddressTypeCode</b>
     * </p>
     *
     * @return Source of the Delivery Address
     */
    @SerializedName( "ProcmtHubDelivAddressTypeCode" )
    @JsonProperty( "ProcmtHubDelivAddressTypeCode" )
    @Nullable
    @ODataField( odataName = "ProcmtHubDelivAddressTypeCode" )
    private String procmtHubDelivAddressTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubDelivAddressTypeCode</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_DELIV_ADDRESS_TYPE_CODE =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubDelivAddressTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDeliveryAddressID</b>
     * </p>
     *
     * @return Number of delivery address
     */
    @SerializedName( "ReferenceDeliveryAddressID" )
    @JsonProperty( "ReferenceDeliveryAddressID" )
    @Nullable
    @ODataField( odataName = "ReferenceDeliveryAddressID" )
    private String referenceDeliveryAddressID;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDeliveryAddressID</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> REFERENCE_DELIVERY_ADDRESS_ID =
        new CntrlPurContrItmDistributionField<String>("ReferenceDeliveryAddressID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubSubcontractor</b>
     * </p>
     *
     * @return Supplier to be Supplied/Who is to Receive Delivery
     */
    @SerializedName( "ProcmtHubSubcontractor" )
    @JsonProperty( "ProcmtHubSubcontractor" )
    @Nullable
    @ODataField( odataName = "ProcmtHubSubcontractor" )
    private String procmtHubSubcontractor;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubSubcontractor</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_SUBCONTRACTOR =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubSubcontractor");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubSuplrIsSubcontractor</b>
     * </p>
     *
     * @return Subcontracting Supplier
     */
    @SerializedName( "ProcmtHubSuplrIsSubcontractor" )
    @JsonProperty( "ProcmtHubSuplrIsSubcontractor" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ProcmtHubSuplrIsSubcontractor" )
    private Boolean procmtHubSuplrIsSubcontractor;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubSuplrIsSubcontractor</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<Boolean> PROCMT_HUB_SUPLR_IS_SUBCONTRACTOR =
        new CntrlPurContrItmDistributionField<Boolean>("ProcmtHubSuplrIsSubcontractor");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @return Form-of-Address Key
     */
    @SerializedName( "FormOfAddress" )
    @JsonProperty( "FormOfAddress" )
    @Nullable
    @ODataField( odataName = "FormOfAddress" )
    private String formOfAddress;
    /**
     * Use with available fluent helpers to apply the <b>FormOfAddress</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> FORM_OF_ADDRESS =
        new CntrlPurContrItmDistributionField<String>("FormOfAddress");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubBusinessPartnerName1</b>
     * </p>
     *
     * @return Name 1
     */
    @SerializedName( "ProcmtHubBusinessPartnerName1" )
    @JsonProperty( "ProcmtHubBusinessPartnerName1" )
    @Nullable
    @ODataField( odataName = "ProcmtHubBusinessPartnerName1" )
    private String procmtHubBusinessPartnerName1;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubBusinessPartnerName1</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_BUSINESS_PARTNER_NAME1 =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubBusinessPartnerName1");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubBusinessPartnerName2</b>
     * </p>
     *
     * @return Name 2
     */
    @SerializedName( "ProcmtHubBusinessPartnerName2" )
    @JsonProperty( "ProcmtHubBusinessPartnerName2" )
    @Nullable
    @ODataField( odataName = "ProcmtHubBusinessPartnerName2" )
    private String procmtHubBusinessPartnerName2;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubBusinessPartnerName2</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_BUSINESS_PARTNER_NAME2 =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubBusinessPartnerName2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubBusinessPartnerName3</b>
     * </p>
     *
     * @return Name 3
     */
    @SerializedName( "ProcmtHubBusinessPartnerName3" )
    @JsonProperty( "ProcmtHubBusinessPartnerName3" )
    @Nullable
    @ODataField( odataName = "ProcmtHubBusinessPartnerName3" )
    private String procmtHubBusinessPartnerName3;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubBusinessPartnerName3</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_BUSINESS_PARTNER_NAME3 =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubBusinessPartnerName3");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubBusinessPartnerName4</b>
     * </p>
     *
     * @return Name 4
     */
    @SerializedName( "ProcmtHubBusinessPartnerName4" )
    @JsonProperty( "ProcmtHubBusinessPartnerName4" )
    @Nullable
    @ODataField( odataName = "ProcmtHubBusinessPartnerName4" )
    private String procmtHubBusinessPartnerName4;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubBusinessPartnerName4</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_BUSINESS_PARTNER_NAME4 =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubBusinessPartnerName4");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubStreetName</b>
     * </p>
     *
     * @return Street
     */
    @SerializedName( "ProcmtHubStreetName" )
    @JsonProperty( "ProcmtHubStreetName" )
    @Nullable
    @ODataField( odataName = "ProcmtHubStreetName" )
    private String procmtHubStreetName;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubStreetName</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_STREET_NAME =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubStreetName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubHouseNumber</b>
     * </p>
     *
     * @return House Number
     */
    @SerializedName( "ProcmtHubHouseNumber" )
    @JsonProperty( "ProcmtHubHouseNumber" )
    @Nullable
    @ODataField( odataName = "ProcmtHubHouseNumber" )
    private String procmtHubHouseNumber;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubHouseNumber</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_HOUSE_NUMBER =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubHouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPostalCode</b>
     * </p>
     *
     * @return City Postal Code
     */
    @SerializedName( "ProcmtHubPostalCode" )
    @JsonProperty( "ProcmtHubPostalCode" )
    @Nullable
    @ODataField( odataName = "ProcmtHubPostalCode" )
    private String procmtHubPostalCode;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubPostalCode</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_POSTAL_CODE =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubPostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubCityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "ProcmtHubCityName" )
    @JsonProperty( "ProcmtHubCityName" )
    @Nullable
    @ODataField( odataName = "ProcmtHubCityName" )
    private String procmtHubCityName;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubCityName</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_CITY_NAME =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubCityName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubCountry</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "ProcmtHubCountry" )
    @JsonProperty( "ProcmtHubCountry" )
    @Nullable
    @ODataField( odataName = "ProcmtHubCountry" )
    private String procmtHubCountry;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubCountry</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_COUNTRY =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubCountry");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubRegion</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "ProcmtHubRegion" )
    @JsonProperty( "ProcmtHubRegion" )
    @Nullable
    @ODataField( odataName = "ProcmtHubRegion" )
    private String procmtHubRegion;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubRegion</b> field to query operations.
     *
     */
    public final static CntrlPurContrItmDistributionField<String> PROCMT_HUB_REGION =
        new CntrlPurContrItmDistributionField<String>("ProcmtHubRegion");
    /**
     * Navigation property <b>to_CentralPurchaseContract</b> for <b>CntrlPurContrItmDistribution</b> to single
     * <b>CentralPurchaseContract</b>.
     *
     */
    @SerializedName( "to_CentralPurchaseContract" )
    @JsonProperty( "to_CentralPurchaseContract" )
    @ODataField( odataName = "to_CentralPurchaseContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CentralPurchaseContract toCentralPurchaseContract;
    /**
     * Navigation property <b>to_CentralPurchaseContractItem</b> for <b>CntrlPurContrItmDistribution</b> to single
     * <b>CntrlPurchaseContractItem</b>.
     *
     */
    @SerializedName( "to_CentralPurchaseContractItem" )
    @JsonProperty( "to_CentralPurchaseContractItem" )
    @ODataField( odataName = "to_CentralPurchaseContractItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CntrlPurchaseContractItem toCentralPurchaseContractItem;
    /**
     * Navigation property <b>to_CntrlPurContrItemPartner</b> for <b>CntrlPurContrItmDistribution</b> to multiple
     * <b>CntrlPurContrItemPartner</b>.
     *
     */
    @SerializedName( "to_CntrlPurContrItemPartner" )
    @JsonProperty( "to_CntrlPurContrItemPartner" )
    @ODataField( odataName = "to_CntrlPurContrItemPartner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurContrItemPartner> toCntrlPurContrItemPartner;
    /**
     * Use with available fluent helpers to apply the <b>to_CentralPurchaseContract</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurContrItmDistributionOneToOneLink<CentralPurchaseContract> TO_CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurContrItmDistributionOneToOneLink<CentralPurchaseContract>("to_CentralPurchaseContract");
    /**
     * Use with available fluent helpers to apply the <b>to_CentralPurchaseContractItem</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurContrItmDistributionOneToOneLink<CntrlPurchaseContractItem> TO_CENTRAL_PURCHASE_CONTRACT_ITEM =
        new CntrlPurContrItmDistributionOneToOneLink<CntrlPurchaseContractItem>("to_CentralPurchaseContractItem");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlPurContrItemPartner</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurContrItmDistributionLink<CntrlPurContrItemPartner> TO_CNTRL_PUR_CONTR_ITEM_PARTNER =
        new CntrlPurContrItmDistributionLink<CntrlPurContrItemPartner>("to_CntrlPurContrItemPartner");

    @Nonnull
    @Override
    public Class<CntrlPurContrItmDistribution> getType()
    {
        return CntrlPurContrItmDistribution.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @param centralPurchaseContract
     *            Purchasing Document Number
     */
    public void setCentralPurchaseContract( @Nullable final String centralPurchaseContract )
    {
        rememberChangedField("CentralPurchaseContract", this.centralPurchaseContract);
        this.centralPurchaseContract = centralPurchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContractItem</b>
     * </p>
     *
     * @param centralPurchaseContractItem
     *            Item Number of Purchasing Document
     */
    public void setCentralPurchaseContractItem( @Nullable final String centralPurchaseContractItem )
    {
        rememberChangedField("CentralPurchaseContractItem", this.centralPurchaseContractItem);
        this.centralPurchaseContractItem = centralPurchaseContractItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DistributionKey</b>
     * </p>
     *
     * @param distributionKey
     *            Distribution Number of Central Purchasing Document
     */
    public void setDistributionKey( @Nullable final String distributionKey )
    {
        rememberChangedField("DistributionKey", this.distributionKey);
        this.distributionKey = distributionKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubCompanyCode</b>
     * </p>
     *
     * @param procmtHubCompanyCode
     *            Company Code
     */
    public void setProcmtHubCompanyCode( @Nullable final String procmtHubCompanyCode )
    {
        rememberChangedField("ProcmtHubCompanyCode", this.procmtHubCompanyCode);
        this.procmtHubCompanyCode = procmtHubCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPlant</b>
     * </p>
     *
     * @param procmtHubPlant
     *            Plant
     */
    public void setProcmtHubPlant( @Nullable final String procmtHubPlant )
    {
        rememberChangedField("ProcmtHubPlant", this.procmtHubPlant);
        this.procmtHubPlant = procmtHubPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPurchasingOrg</b>
     * </p>
     *
     * @param procmtHubPurchasingOrg
     *            Purchasing Organization
     */
    public void setProcmtHubPurchasingOrg( @Nullable final String procmtHubPurchasingOrg )
    {
        rememberChangedField("ProcmtHubPurchasingOrg", this.procmtHubPurchasingOrg);
        this.procmtHubPurchasingOrg = procmtHubPurchasingOrg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPurchasingGroup</b>
     * </p>
     *
     * @param procmtHubPurchasingGroup
     *            Purchasing Group
     */
    public void setProcmtHubPurchasingGroup( @Nullable final String procmtHubPurchasingGroup )
    {
        rememberChangedField("ProcmtHubPurchasingGroup", this.procmtHubPurchasingGroup);
        this.procmtHubPurchasingGroup = procmtHubPurchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubCompanyCodeGroupingID</b>
     * </p>
     *
     * @param procmtHubCompanyCodeGroupingID
     *            Grouping ID for Company Codes
     */
    public void setProcmtHubCompanyCodeGroupingID( @Nullable final String procmtHubCompanyCodeGroupingID )
    {
        rememberChangedField("ProcmtHubCompanyCodeGroupingID", this.procmtHubCompanyCodeGroupingID);
        this.procmtHubCompanyCodeGroupingID = procmtHubCompanyCodeGroupingID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrDistrCurrency</b>
     * </p>
     *
     * @param cntrlPurContrDistrCurrency
     *            Currency Key
     */
    public void setCntrlPurContrDistrCurrency( @Nullable final String cntrlPurContrDistrCurrency )
    {
        rememberChangedField("CntrlPurContrDistrCurrency", this.cntrlPurContrDistrCurrency);
        this.cntrlPurContrDistrCurrency = cntrlPurContrDistrCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @param cashDiscount1Days
     *            Cash discount days 1
     */
    public void setCashDiscount1Days( @Nullable final BigDecimal cashDiscount1Days )
    {
        rememberChangedField("CashDiscount1Days", this.cashDiscount1Days);
        this.cashDiscount1Days = cashDiscount1Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @param cashDiscount2Days
     *            Cash discount days 2
     */
    public void setCashDiscount2Days( @Nullable final BigDecimal cashDiscount2Days )
    {
        rememberChangedField("CashDiscount2Days", this.cashDiscount2Days);
        this.cashDiscount2Days = cashDiscount2Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @param netPaymentDays
     *            Net Payment Terms Period
     */
    public void setNetPaymentDays( @Nullable final BigDecimal netPaymentDays )
    {
        rememberChangedField("NetPaymentDays", this.netPaymentDays);
        this.netPaymentDays = netPaymentDays;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @param cashDiscount1Percent
     *            Cash Discount Percentage 1
     */
    public void setCashDiscount1Percent( @Nullable final BigDecimal cashDiscount1Percent )
    {
        rememberChangedField("CashDiscount1Percent", this.cashDiscount1Percent);
        this.cashDiscount1Percent = cashDiscount1Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @param cashDiscount2Percent
     *            Cash Discount Percentage 2
     */
    public void setCashDiscount2Percent( @Nullable final BigDecimal cashDiscount2Percent )
    {
        rememberChangedField("CashDiscount2Percent", this.cashDiscount2Percent);
        this.cashDiscount2Percent = cashDiscount2Percent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionType</b>
     * </p>
     *
     * @param distributionType
     *            Distribution Type for Central Purchase Contract Item
     */
    public void setDistributionType( @Nullable final String distributionType )
    {
        rememberChangedField("DistributionType", this.distributionType);
        this.distributionType = distributionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ExternalReferenceDocument</b>
     * </p>
     *
     * @param externalReferenceDocument
     *            Document Number of External Reference Document
     */
    public void setExternalReferenceDocument( @Nullable final String externalReferenceDocument )
    {
        rememberChangedField("ExternalReferenceDocument", this.externalReferenceDocument);
        this.externalReferenceDocument = externalReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ExternalReferenceDocumentItem</b>
     * </p>
     *
     * @param externalReferenceDocumentItem
     *            Document Item Number of External Reference Document
     */
    public void setExternalReferenceDocumentItem( @Nullable final String externalReferenceDocumentItem )
    {
        rememberChangedField("ExternalReferenceDocumentItem", this.externalReferenceDocumentItem);
        this.externalReferenceDocumentItem = externalReferenceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ExternalRefDocCategory</b>
     * </p>
     *
     * @param externalRefDocCategory
     *            Category of an external transaction or element
     */
    public void setExternalRefDocCategory( @Nullable final String externalRefDocCategory )
    {
        rememberChangedField("ExternalRefDocCategory", this.externalRefDocCategory);
        this.externalRefDocCategory = externalRefDocCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Purchasing Document Category
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentType</b>
     * </p>
     *
     * @param purchasingDocumentType
     *            Purchasing Document Type
     */
    public void setPurchasingDocumentType( @Nullable final String purchasingDocumentType )
    {
        rememberChangedField("PurchasingDocumentType", this.purchasingDocumentType);
        this.purchasingDocumentType = purchasingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrDistributionPct</b>
     * </p>
     *
     * @param cntrlPurContrDistributionPct
     *            Distribution Percentage in Central Purchasing Document
     */
    public void setCntrlPurContrDistributionPct( @Nullable final BigDecimal cntrlPurContrDistributionPct )
    {
        rememberChangedField("CntrlPurContrDistributionPct", this.cntrlPurContrDistributionPct);
        this.cntrlPurContrDistributionPct = cntrlPurContrDistributionPct;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrItmDistrQty</b>
     * </p>
     *
     * @param cntrlPurContrItmDistrQty
     *            Target Quantity
     */
    public void setCntrlPurContrItmDistrQty( @Nullable final BigDecimal cntrlPurContrItmDistrQty )
    {
        rememberChangedField("CntrlPurContrItmDistrQty", this.cntrlPurContrItmDistrQty);
        this.cntrlPurContrItmDistrQty = cntrlPurContrItmDistrQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrItmDistrAmt</b>
     * </p>
     *
     * @param cntrlPurContrItmDistrAmt
     *            Target Value for Header Area per Distribution
     */
    public void setCntrlPurContrItmDistrAmt( @Nullable final BigDecimal cntrlPurContrItmDistrAmt )
    {
        rememberChangedField("CntrlPurContrItmDistrAmt", this.cntrlPurContrItmDistrAmt);
        this.cntrlPurContrItmDistrAmt = cntrlPurContrItmDistrAmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementHubSourceSystem</b>
     * </p>
     *
     * @param procurementHubSourceSystem
     *            Logical System
     */
    public void setProcurementHubSourceSystem( @Nullable final String procurementHubSourceSystem )
    {
        rememberChangedField("ProcurementHubSourceSystem", this.procurementHubSourceSystem);
        this.procurementHubSourceSystem = procurementHubSourceSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubProduct</b>
     * </p>
     *
     * @param procmtHubProduct
     *            Material Number
     */
    public void setProcmtHubProduct( @Nullable final String procmtHubProduct )
    {
        rememberChangedField("ProcmtHubProduct", this.procmtHubProduct);
        this.procmtHubProduct = procmtHubProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubProductGroup</b>
     * </p>
     *
     * @param procmtHubProductGroup
     *            Material Group
     */
    public void setProcmtHubProductGroup( @Nullable final String procmtHubProductGroup )
    {
        rememberChangedField("ProcmtHubProductGroup", this.procmtHubProductGroup);
        this.procmtHubProductGroup = procmtHubProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPurchaseContract</b>
     * </p>
     *
     * @param procmtHubPurchaseContract
     *            Contract of External System
     */
    public void setProcmtHubPurchaseContract( @Nullable final String procmtHubPurchaseContract )
    {
        rememberChangedField("ProcmtHubPurchaseContract", this.procmtHubPurchaseContract);
        this.procmtHubPurchaseContract = procmtHubPurchaseContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPurchaseContractItem</b>
     * </p>
     *
     * @param procmtHubPurchaseContractItem
     *            Contract Item of External System
     */
    public void setProcmtHubPurchaseContractItem( @Nullable final String procmtHubPurchaseContractItem )
    {
        rememberChangedField("ProcmtHubPurchaseContractItem", this.procmtHubPurchaseContractItem);
        this.procmtHubPurchaseContractItem = procmtHubPurchaseContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemDistributionStatus</b>
     * </p>
     *
     * @param itemDistributionStatus
     *            Distribution Status
     */
    public void setItemDistributionStatus( @Nullable final String itemDistributionStatus )
    {
        rememberChangedField("ItemDistributionStatus", this.itemDistributionStatus);
        this.itemDistributionStatus = itemDistributionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceHeaderDistributionKey</b>
     * </p>
     *
     * @param referenceHeaderDistributionKey
     *            Distribution Number of Central Purchasing Document
     */
    public void setReferenceHeaderDistributionKey( @Nullable final String referenceHeaderDistributionKey )
    {
        rememberChangedField("ReferenceHeaderDistributionKey", this.referenceHeaderDistributionKey);
        this.referenceHeaderDistributionKey = referenceHeaderDistributionKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Link field for view query
     */
    public void setIsDeleted( @Nullable final String isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OutlineAgrmtItmIsBlocked</b>
     * </p>
     *
     * @param outlineAgrmtItmIsBlocked
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setOutlineAgrmtItmIsBlocked( @Nullable final Boolean outlineAgrmtItmIsBlocked )
    {
        rememberChangedField("OutlineAgrmtItmIsBlocked", this.outlineAgrmtItmIsBlocked);
        this.outlineAgrmtItmIsBlocked = outlineAgrmtItmIsBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocItmBlkRsnCode</b>
     * </p>
     *
     * @param purgDocItmBlkRsnCode
     *            Block Reason Code
     */
    public void setPurgDocItmBlkRsnCode( @Nullable final String purgDocItmBlkRsnCode )
    {
        rememberChangedField("PurgDocItmBlkRsnCode", this.purgDocItmBlkRsnCode);
        this.purgDocItmBlkRsnCode = purgDocItmBlkRsnCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecordUpdateCode</b>
     * </p>
     *
     * @param purchasingInfoRecordUpdateCode
     *            Indicator: Update Info Record
     */
    public void setPurchasingInfoRecordUpdateCode( @Nullable final String purchasingInfoRecordUpdateCode )
    {
        rememberChangedField("PurchasingInfoRecordUpdateCode", this.purchasingInfoRecordUpdateCode);
        this.purchasingInfoRecordUpdateCode = purchasingInfoRecordUpdateCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDistributionNumber</b>
     * </p>
     *
     * @param referenceDistributionNumber
     *            Distribution Number of Central Purchasing Document
     */
    public void setReferenceDistributionNumber( @Nullable final String referenceDistributionNumber )
    {
        rememberChangedField("ReferenceDistributionNumber", this.referenceDistributionNumber);
        this.referenceDistributionNumber = referenceDistributionNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SourceListIsUpdated</b>
     * </p>
     *
     * @param sourceListIsUpdated
     *            Checkbox
     */
    public void setSourceListIsUpdated( @Nullable final Boolean sourceListIsUpdated )
    {
        rememberChangedField("SourceListIsUpdated", this.sourceListIsUpdated);
        this.sourceListIsUpdated = sourceListIsUpdated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceListRestriction</b>
     * </p>
     *
     * @param sourceListRestriction
     *            Source List Restriction Indicator
     */
    public void setSourceListRestriction( @Nullable final String sourceListRestriction )
    {
        rememberChangedField("SourceListRestriction", this.sourceListRestriction);
        this.sourceListRestriction = sourceListRestriction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingInstruction</b>
     * </p>
     *
     * @param shippingInstruction
     *            Shipping Instructions
     */
    public void setShippingInstruction( @Nullable final String shippingInstruction )
    {
        rememberChangedField("ShippingInstruction", this.shippingInstruction);
        this.shippingInstruction = shippingInstruction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubDelivAddressTypeCode</b>
     * </p>
     *
     * @param procmtHubDelivAddressTypeCode
     *            Source of the Delivery Address
     */
    public void setProcmtHubDelivAddressTypeCode( @Nullable final String procmtHubDelivAddressTypeCode )
    {
        rememberChangedField("ProcmtHubDelivAddressTypeCode", this.procmtHubDelivAddressTypeCode);
        this.procmtHubDelivAddressTypeCode = procmtHubDelivAddressTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDeliveryAddressID</b>
     * </p>
     *
     * @param referenceDeliveryAddressID
     *            Number of delivery address
     */
    public void setReferenceDeliveryAddressID( @Nullable final String referenceDeliveryAddressID )
    {
        rememberChangedField("ReferenceDeliveryAddressID", this.referenceDeliveryAddressID);
        this.referenceDeliveryAddressID = referenceDeliveryAddressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubSubcontractor</b>
     * </p>
     *
     * @param procmtHubSubcontractor
     *            Supplier to be Supplied/Who is to Receive Delivery
     */
    public void setProcmtHubSubcontractor( @Nullable final String procmtHubSubcontractor )
    {
        rememberChangedField("ProcmtHubSubcontractor", this.procmtHubSubcontractor);
        this.procmtHubSubcontractor = procmtHubSubcontractor;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubSuplrIsSubcontractor</b>
     * </p>
     *
     * @param procmtHubSuplrIsSubcontractor
     *            Subcontracting Supplier
     */
    public void setProcmtHubSuplrIsSubcontractor( @Nullable final Boolean procmtHubSuplrIsSubcontractor )
    {
        rememberChangedField("ProcmtHubSuplrIsSubcontractor", this.procmtHubSuplrIsSubcontractor);
        this.procmtHubSuplrIsSubcontractor = procmtHubSuplrIsSubcontractor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @param formOfAddress
     *            Form-of-Address Key
     */
    public void setFormOfAddress( @Nullable final String formOfAddress )
    {
        rememberChangedField("FormOfAddress", this.formOfAddress);
        this.formOfAddress = formOfAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubBusinessPartnerName1</b>
     * </p>
     *
     * @param procmtHubBusinessPartnerName1
     *            Name 1
     */
    public void setProcmtHubBusinessPartnerName1( @Nullable final String procmtHubBusinessPartnerName1 )
    {
        rememberChangedField("ProcmtHubBusinessPartnerName1", this.procmtHubBusinessPartnerName1);
        this.procmtHubBusinessPartnerName1 = procmtHubBusinessPartnerName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubBusinessPartnerName2</b>
     * </p>
     *
     * @param procmtHubBusinessPartnerName2
     *            Name 2
     */
    public void setProcmtHubBusinessPartnerName2( @Nullable final String procmtHubBusinessPartnerName2 )
    {
        rememberChangedField("ProcmtHubBusinessPartnerName2", this.procmtHubBusinessPartnerName2);
        this.procmtHubBusinessPartnerName2 = procmtHubBusinessPartnerName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubBusinessPartnerName3</b>
     * </p>
     *
     * @param procmtHubBusinessPartnerName3
     *            Name 3
     */
    public void setProcmtHubBusinessPartnerName3( @Nullable final String procmtHubBusinessPartnerName3 )
    {
        rememberChangedField("ProcmtHubBusinessPartnerName3", this.procmtHubBusinessPartnerName3);
        this.procmtHubBusinessPartnerName3 = procmtHubBusinessPartnerName3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubBusinessPartnerName4</b>
     * </p>
     *
     * @param procmtHubBusinessPartnerName4
     *            Name 4
     */
    public void setProcmtHubBusinessPartnerName4( @Nullable final String procmtHubBusinessPartnerName4 )
    {
        rememberChangedField("ProcmtHubBusinessPartnerName4", this.procmtHubBusinessPartnerName4);
        this.procmtHubBusinessPartnerName4 = procmtHubBusinessPartnerName4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubStreetName</b>
     * </p>
     *
     * @param procmtHubStreetName
     *            Street
     */
    public void setProcmtHubStreetName( @Nullable final String procmtHubStreetName )
    {
        rememberChangedField("ProcmtHubStreetName", this.procmtHubStreetName);
        this.procmtHubStreetName = procmtHubStreetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubHouseNumber</b>
     * </p>
     *
     * @param procmtHubHouseNumber
     *            House Number
     */
    public void setProcmtHubHouseNumber( @Nullable final String procmtHubHouseNumber )
    {
        rememberChangedField("ProcmtHubHouseNumber", this.procmtHubHouseNumber);
        this.procmtHubHouseNumber = procmtHubHouseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPostalCode</b>
     * </p>
     *
     * @param procmtHubPostalCode
     *            City Postal Code
     */
    public void setProcmtHubPostalCode( @Nullable final String procmtHubPostalCode )
    {
        rememberChangedField("ProcmtHubPostalCode", this.procmtHubPostalCode);
        this.procmtHubPostalCode = procmtHubPostalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubCityName</b>
     * </p>
     *
     * @param procmtHubCityName
     *            City
     */
    public void setProcmtHubCityName( @Nullable final String procmtHubCityName )
    {
        rememberChangedField("ProcmtHubCityName", this.procmtHubCityName);
        this.procmtHubCityName = procmtHubCityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubCountry</b>
     * </p>
     *
     * @param procmtHubCountry
     *            Country/Region Key
     */
    public void setProcmtHubCountry( @Nullable final String procmtHubCountry )
    {
        rememberChangedField("ProcmtHubCountry", this.procmtHubCountry);
        this.procmtHubCountry = procmtHubCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubRegion</b>
     * </p>
     *
     * @param procmtHubRegion
     *            Region (State, Province, County)
     */
    public void setProcmtHubRegion( @Nullable final String procmtHubRegion )
    {
        rememberChangedField("ProcmtHubRegion", this.procmtHubRegion);
        this.procmtHubRegion = procmtHubRegion;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CntrlPurContrItmDistribution";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CentralPurchaseContract", getCentralPurchaseContract());
        result.put("CentralPurchaseContractItem", getCentralPurchaseContractItem());
        result.put("DistributionKey", getDistributionKey());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CentralPurchaseContract", getCentralPurchaseContract());
        values.put("CentralPurchaseContractItem", getCentralPurchaseContractItem());
        values.put("DistributionKey", getDistributionKey());
        values.put("ProcmtHubCompanyCode", getProcmtHubCompanyCode());
        values.put("ProcmtHubPlant", getProcmtHubPlant());
        values.put("ProcmtHubPurchasingOrg", getProcmtHubPurchasingOrg());
        values.put("ProcmtHubPurchasingGroup", getProcmtHubPurchasingGroup());
        values.put("ProcmtHubCompanyCodeGroupingID", getProcmtHubCompanyCodeGroupingID());
        values.put("CntrlPurContrDistrCurrency", getCntrlPurContrDistrCurrency());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("CashDiscount1Days", getCashDiscount1Days());
        values.put("CashDiscount2Days", getCashDiscount2Days());
        values.put("NetPaymentDays", getNetPaymentDays());
        values.put("CashDiscount1Percent", getCashDiscount1Percent());
        values.put("CashDiscount2Percent", getCashDiscount2Percent());
        values.put("DistributionType", getDistributionType());
        values.put("ExternalReferenceDocument", getExternalReferenceDocument());
        values.put("ExternalReferenceDocumentItem", getExternalReferenceDocumentItem());
        values.put("ExternalRefDocCategory", getExternalRefDocCategory());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("PurchasingDocumentType", getPurchasingDocumentType());
        values.put("StorageLocation", getStorageLocation());
        values.put("CntrlPurContrDistributionPct", getCntrlPurContrDistributionPct());
        values.put("CntrlPurContrItmDistrQty", getCntrlPurContrItmDistrQty());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("CntrlPurContrItmDistrAmt", getCntrlPurContrItmDistrAmt());
        values.put("ProcurementHubSourceSystem", getProcurementHubSourceSystem());
        values.put("ProcmtHubProduct", getProcmtHubProduct());
        values.put("ProcmtHubProductGroup", getProcmtHubProductGroup());
        values.put("ProcmtHubPurchaseContract", getProcmtHubPurchaseContract());
        values.put("ProcmtHubPurchaseContractItem", getProcmtHubPurchaseContractItem());
        values.put("ItemDistributionStatus", getItemDistributionStatus());
        values.put("ReferenceHeaderDistributionKey", getReferenceHeaderDistributionKey());
        values.put("IsDeleted", getIsDeleted());
        values.put("OutlineAgrmtItmIsBlocked", getOutlineAgrmtItmIsBlocked());
        values.put("PurgDocItmBlkRsnCode", getPurgDocItmBlkRsnCode());
        values.put("PurchasingInfoRecordUpdateCode", getPurchasingInfoRecordUpdateCode());
        values.put("ReferenceDistributionNumber", getReferenceDistributionNumber());
        values.put("SourceListIsUpdated", getSourceListIsUpdated());
        values.put("SourceListRestriction", getSourceListRestriction());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("ShippingInstruction", getShippingInstruction());
        values.put("ProcmtHubDelivAddressTypeCode", getProcmtHubDelivAddressTypeCode());
        values.put("ReferenceDeliveryAddressID", getReferenceDeliveryAddressID());
        values.put("ProcmtHubSubcontractor", getProcmtHubSubcontractor());
        values.put("ProcmtHubSuplrIsSubcontractor", getProcmtHubSuplrIsSubcontractor());
        values.put("FormOfAddress", getFormOfAddress());
        values.put("ProcmtHubBusinessPartnerName1", getProcmtHubBusinessPartnerName1());
        values.put("ProcmtHubBusinessPartnerName2", getProcmtHubBusinessPartnerName2());
        values.put("ProcmtHubBusinessPartnerName3", getProcmtHubBusinessPartnerName3());
        values.put("ProcmtHubBusinessPartnerName4", getProcmtHubBusinessPartnerName4());
        values.put("ProcmtHubStreetName", getProcmtHubStreetName());
        values.put("ProcmtHubHouseNumber", getProcmtHubHouseNumber());
        values.put("ProcmtHubPostalCode", getProcmtHubPostalCode());
        values.put("ProcmtHubCityName", getProcmtHubCityName());
        values.put("ProcmtHubCountry", getProcmtHubCountry());
        values.put("ProcmtHubRegion", getProcmtHubRegion());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CentralPurchaseContract") ) {
                final Object value = values.remove("CentralPurchaseContract");
                if( (value == null) || (!value.equals(getCentralPurchaseContract())) ) {
                    setCentralPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("CentralPurchaseContractItem") ) {
                final Object value = values.remove("CentralPurchaseContractItem");
                if( (value == null) || (!value.equals(getCentralPurchaseContractItem())) ) {
                    setCentralPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("DistributionKey") ) {
                final Object value = values.remove("DistributionKey");
                if( (value == null) || (!value.equals(getDistributionKey())) ) {
                    setDistributionKey(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubCompanyCode") ) {
                final Object value = values.remove("ProcmtHubCompanyCode");
                if( (value == null) || (!value.equals(getProcmtHubCompanyCode())) ) {
                    setProcmtHubCompanyCode(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubPlant") ) {
                final Object value = values.remove("ProcmtHubPlant");
                if( (value == null) || (!value.equals(getProcmtHubPlant())) ) {
                    setProcmtHubPlant(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubPurchasingOrg") ) {
                final Object value = values.remove("ProcmtHubPurchasingOrg");
                if( (value == null) || (!value.equals(getProcmtHubPurchasingOrg())) ) {
                    setProcmtHubPurchasingOrg(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubPurchasingGroup") ) {
                final Object value = values.remove("ProcmtHubPurchasingGroup");
                if( (value == null) || (!value.equals(getProcmtHubPurchasingGroup())) ) {
                    setProcmtHubPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubCompanyCodeGroupingID") ) {
                final Object value = values.remove("ProcmtHubCompanyCodeGroupingID");
                if( (value == null) || (!value.equals(getProcmtHubCompanyCodeGroupingID())) ) {
                    setProcmtHubCompanyCodeGroupingID(((String) value));
                }
            }
            if( values.containsKey("CntrlPurContrDistrCurrency") ) {
                final Object value = values.remove("CntrlPurContrDistrCurrency");
                if( (value == null) || (!value.equals(getCntrlPurContrDistrCurrency())) ) {
                    setCntrlPurContrDistrCurrency(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("CashDiscount1Days") ) {
                final Object value = values.remove("CashDiscount1Days");
                if( (value == null) || (!value.equals(getCashDiscount1Days())) ) {
                    setCashDiscount1Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Days") ) {
                final Object value = values.remove("CashDiscount2Days");
                if( (value == null) || (!value.equals(getCashDiscount2Days())) ) {
                    setCashDiscount2Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPaymentDays") ) {
                final Object value = values.remove("NetPaymentDays");
                if( (value == null) || (!value.equals(getNetPaymentDays())) ) {
                    setNetPaymentDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount1Percent") ) {
                final Object value = values.remove("CashDiscount1Percent");
                if( (value == null) || (!value.equals(getCashDiscount1Percent())) ) {
                    setCashDiscount1Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Percent") ) {
                final Object value = values.remove("CashDiscount2Percent");
                if( (value == null) || (!value.equals(getCashDiscount2Percent())) ) {
                    setCashDiscount2Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("DistributionType") ) {
                final Object value = values.remove("DistributionType");
                if( (value == null) || (!value.equals(getDistributionType())) ) {
                    setDistributionType(((String) value));
                }
            }
            if( values.containsKey("ExternalReferenceDocument") ) {
                final Object value = values.remove("ExternalReferenceDocument");
                if( (value == null) || (!value.equals(getExternalReferenceDocument())) ) {
                    setExternalReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ExternalReferenceDocumentItem") ) {
                final Object value = values.remove("ExternalReferenceDocumentItem");
                if( (value == null) || (!value.equals(getExternalReferenceDocumentItem())) ) {
                    setExternalReferenceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("ExternalRefDocCategory") ) {
                final Object value = values.remove("ExternalRefDocCategory");
                if( (value == null) || (!value.equals(getExternalRefDocCategory())) ) {
                    setExternalRefDocCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentType") ) {
                final Object value = values.remove("PurchasingDocumentType");
                if( (value == null) || (!value.equals(getPurchasingDocumentType())) ) {
                    setPurchasingDocumentType(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("CntrlPurContrDistributionPct") ) {
                final Object value = values.remove("CntrlPurContrDistributionPct");
                if( (value == null) || (!value.equals(getCntrlPurContrDistributionPct())) ) {
                    setCntrlPurContrDistributionPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("CntrlPurContrItmDistrQty") ) {
                final Object value = values.remove("CntrlPurContrItmDistrQty");
                if( (value == null) || (!value.equals(getCntrlPurContrItmDistrQty())) ) {
                    setCntrlPurContrItmDistrQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("CntrlPurContrItmDistrAmt") ) {
                final Object value = values.remove("CntrlPurContrItmDistrAmt");
                if( (value == null) || (!value.equals(getCntrlPurContrItmDistrAmt())) ) {
                    setCntrlPurContrItmDistrAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProcurementHubSourceSystem") ) {
                final Object value = values.remove("ProcurementHubSourceSystem");
                if( (value == null) || (!value.equals(getProcurementHubSourceSystem())) ) {
                    setProcurementHubSourceSystem(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubProduct") ) {
                final Object value = values.remove("ProcmtHubProduct");
                if( (value == null) || (!value.equals(getProcmtHubProduct())) ) {
                    setProcmtHubProduct(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubProductGroup") ) {
                final Object value = values.remove("ProcmtHubProductGroup");
                if( (value == null) || (!value.equals(getProcmtHubProductGroup())) ) {
                    setProcmtHubProductGroup(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubPurchaseContract") ) {
                final Object value = values.remove("ProcmtHubPurchaseContract");
                if( (value == null) || (!value.equals(getProcmtHubPurchaseContract())) ) {
                    setProcmtHubPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubPurchaseContractItem") ) {
                final Object value = values.remove("ProcmtHubPurchaseContractItem");
                if( (value == null) || (!value.equals(getProcmtHubPurchaseContractItem())) ) {
                    setProcmtHubPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("ItemDistributionStatus") ) {
                final Object value = values.remove("ItemDistributionStatus");
                if( (value == null) || (!value.equals(getItemDistributionStatus())) ) {
                    setItemDistributionStatus(((String) value));
                }
            }
            if( values.containsKey("ReferenceHeaderDistributionKey") ) {
                final Object value = values.remove("ReferenceHeaderDistributionKey");
                if( (value == null) || (!value.equals(getReferenceHeaderDistributionKey())) ) {
                    setReferenceHeaderDistributionKey(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((String) value));
                }
            }
            if( values.containsKey("OutlineAgrmtItmIsBlocked") ) {
                final Object value = values.remove("OutlineAgrmtItmIsBlocked");
                if( (value == null) || (!value.equals(getOutlineAgrmtItmIsBlocked())) ) {
                    setOutlineAgrmtItmIsBlocked(((Boolean) value));
                }
            }
            if( values.containsKey("PurgDocItmBlkRsnCode") ) {
                final Object value = values.remove("PurgDocItmBlkRsnCode");
                if( (value == null) || (!value.equals(getPurgDocItmBlkRsnCode())) ) {
                    setPurgDocItmBlkRsnCode(((String) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecordUpdateCode") ) {
                final Object value = values.remove("PurchasingInfoRecordUpdateCode");
                if( (value == null) || (!value.equals(getPurchasingInfoRecordUpdateCode())) ) {
                    setPurchasingInfoRecordUpdateCode(((String) value));
                }
            }
            if( values.containsKey("ReferenceDistributionNumber") ) {
                final Object value = values.remove("ReferenceDistributionNumber");
                if( (value == null) || (!value.equals(getReferenceDistributionNumber())) ) {
                    setReferenceDistributionNumber(((String) value));
                }
            }
            if( values.containsKey("SourceListIsUpdated") ) {
                final Object value = values.remove("SourceListIsUpdated");
                if( (value == null) || (!value.equals(getSourceListIsUpdated())) ) {
                    setSourceListIsUpdated(((Boolean) value));
                }
            }
            if( values.containsKey("SourceListRestriction") ) {
                final Object value = values.remove("SourceListRestriction");
                if( (value == null) || (!value.equals(getSourceListRestriction())) ) {
                    setSourceListRestriction(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("ShippingInstruction") ) {
                final Object value = values.remove("ShippingInstruction");
                if( (value == null) || (!value.equals(getShippingInstruction())) ) {
                    setShippingInstruction(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubDelivAddressTypeCode") ) {
                final Object value = values.remove("ProcmtHubDelivAddressTypeCode");
                if( (value == null) || (!value.equals(getProcmtHubDelivAddressTypeCode())) ) {
                    setProcmtHubDelivAddressTypeCode(((String) value));
                }
            }
            if( values.containsKey("ReferenceDeliveryAddressID") ) {
                final Object value = values.remove("ReferenceDeliveryAddressID");
                if( (value == null) || (!value.equals(getReferenceDeliveryAddressID())) ) {
                    setReferenceDeliveryAddressID(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubSubcontractor") ) {
                final Object value = values.remove("ProcmtHubSubcontractor");
                if( (value == null) || (!value.equals(getProcmtHubSubcontractor())) ) {
                    setProcmtHubSubcontractor(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubSuplrIsSubcontractor") ) {
                final Object value = values.remove("ProcmtHubSuplrIsSubcontractor");
                if( (value == null) || (!value.equals(getProcmtHubSuplrIsSubcontractor())) ) {
                    setProcmtHubSuplrIsSubcontractor(((Boolean) value));
                }
            }
            if( values.containsKey("FormOfAddress") ) {
                final Object value = values.remove("FormOfAddress");
                if( (value == null) || (!value.equals(getFormOfAddress())) ) {
                    setFormOfAddress(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubBusinessPartnerName1") ) {
                final Object value = values.remove("ProcmtHubBusinessPartnerName1");
                if( (value == null) || (!value.equals(getProcmtHubBusinessPartnerName1())) ) {
                    setProcmtHubBusinessPartnerName1(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubBusinessPartnerName2") ) {
                final Object value = values.remove("ProcmtHubBusinessPartnerName2");
                if( (value == null) || (!value.equals(getProcmtHubBusinessPartnerName2())) ) {
                    setProcmtHubBusinessPartnerName2(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubBusinessPartnerName3") ) {
                final Object value = values.remove("ProcmtHubBusinessPartnerName3");
                if( (value == null) || (!value.equals(getProcmtHubBusinessPartnerName3())) ) {
                    setProcmtHubBusinessPartnerName3(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubBusinessPartnerName4") ) {
                final Object value = values.remove("ProcmtHubBusinessPartnerName4");
                if( (value == null) || (!value.equals(getProcmtHubBusinessPartnerName4())) ) {
                    setProcmtHubBusinessPartnerName4(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubStreetName") ) {
                final Object value = values.remove("ProcmtHubStreetName");
                if( (value == null) || (!value.equals(getProcmtHubStreetName())) ) {
                    setProcmtHubStreetName(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubHouseNumber") ) {
                final Object value = values.remove("ProcmtHubHouseNumber");
                if( (value == null) || (!value.equals(getProcmtHubHouseNumber())) ) {
                    setProcmtHubHouseNumber(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubPostalCode") ) {
                final Object value = values.remove("ProcmtHubPostalCode");
                if( (value == null) || (!value.equals(getProcmtHubPostalCode())) ) {
                    setProcmtHubPostalCode(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubCityName") ) {
                final Object value = values.remove("ProcmtHubCityName");
                if( (value == null) || (!value.equals(getProcmtHubCityName())) ) {
                    setProcmtHubCityName(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubCountry") ) {
                final Object value = values.remove("ProcmtHubCountry");
                if( (value == null) || (!value.equals(getProcmtHubCountry())) ) {
                    setProcmtHubCountry(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubRegion") ) {
                final Object value = values.remove("ProcmtHubRegion");
                if( (value == null) || (!value.equals(getProcmtHubRegion())) ) {
                    setProcmtHubRegion(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CentralPurchaseContract") ) {
                final Object value = (values).remove("to_CentralPurchaseContract");
                if( value instanceof Map ) {
                    if( toCentralPurchaseContract == null ) {
                        toCentralPurchaseContract = new CentralPurchaseContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCentralPurchaseContract.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CentralPurchaseContractItem") ) {
                final Object value = (values).remove("to_CentralPurchaseContractItem");
                if( value instanceof Map ) {
                    if( toCentralPurchaseContractItem == null ) {
                        toCentralPurchaseContractItem = new CntrlPurchaseContractItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCentralPurchaseContractItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CntrlPurContrItemPartner") ) {
                final Object value = (values).remove("to_CntrlPurContrItemPartner");
                if( value instanceof Iterable ) {
                    if( toCntrlPurContrItemPartner == null ) {
                        toCntrlPurContrItemPartner = Lists.newArrayList();
                    } else {
                        toCntrlPurContrItemPartner = Lists.newArrayList(toCntrlPurContrItemPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurContrItemPartner entity;
                        if( toCntrlPurContrItemPartner.size() > i ) {
                            entity = toCntrlPurContrItemPartner.get(i);
                        } else {
                            entity = new CntrlPurContrItemPartner();
                            toCntrlPurContrItemPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CntrlPurContrItmDistributionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CntrlPurContrItmDistributionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CntrlPurContrItmDistributionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CntrlPurContrItmDistributionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCentralPurchaseContract != null ) {
            (values).put("to_CentralPurchaseContract", toCentralPurchaseContract);
        }
        if( toCentralPurchaseContractItem != null ) {
            (values).put("to_CentralPurchaseContractItem", toCentralPurchaseContractItem);
        }
        if( toCntrlPurContrItemPartner != null ) {
            (values).put("to_CntrlPurContrItemPartner", toCntrlPurContrItemPartner);
        }
        return values;
    }

    /**
     * Fetches the <b>CentralPurchaseContract</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CentralPurchaseContract</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CentralPurchaseContract fetchCentralPurchaseContract()
    {
        return fetchFieldAsSingle("to_CentralPurchaseContract", CentralPurchaseContract.class);
    }

    /**
     * Retrieval of associated <b>CentralPurchaseContract</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * If the navigation property <b>to_CentralPurchaseContract</b> of a queried <b>CntrlPurContrItmDistribution</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CentralPurchaseContract</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CentralPurchaseContract getCentralPurchaseContractOrFetch()
    {
        if( toCentralPurchaseContract == null ) {
            toCentralPurchaseContract = fetchCentralPurchaseContract();
        }
        return toCentralPurchaseContract;
    }

    /**
     * Retrieval of associated <b>CentralPurchaseContract</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurContrItmDistribution</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CentralPurchaseContract</b> is already loaded, the
     *         result will contain the <b>CentralPurchaseContract</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CentralPurchaseContract> getCentralPurchaseContractIfPresent()
    {
        return Option.of(toCentralPurchaseContract);
    }

    /**
     * Overwrites the associated <b>CentralPurchaseContract</b> entity for the loaded navigation property
     * <b>to_CentralPurchaseContract</b>.
     *
     * @param value
     *            New <b>CentralPurchaseContract</b> entity.
     */
    public void setCentralPurchaseContract( final CentralPurchaseContract value )
    {
        toCentralPurchaseContract = value;
    }

    /**
     * Fetches the <b>CntrlPurchaseContractItem</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CentralPurchaseContractItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CntrlPurchaseContractItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CntrlPurchaseContractItem fetchCentralPurchaseContractItem()
    {
        return fetchFieldAsSingle("to_CentralPurchaseContractItem", CntrlPurchaseContractItem.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurchaseContractItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContractItem</b>.
     * <p>
     * If the navigation property <b>to_CentralPurchaseContractItem</b> of a queried <b>CntrlPurContrItmDistribution</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurchaseContractItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CntrlPurchaseContractItem getCentralPurchaseContractItemOrFetch()
    {
        if( toCentralPurchaseContractItem == null ) {
            toCentralPurchaseContractItem = fetchCentralPurchaseContractItem();
        }
        return toCentralPurchaseContractItem;
    }

    /**
     * Retrieval of associated <b>CntrlPurchaseContractItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContractItem</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurContrItmDistribution</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CentralPurchaseContractItem</b> is already loaded, the
     *         result will contain the <b>CntrlPurchaseContractItem</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CntrlPurchaseContractItem> getCentralPurchaseContractItemIfPresent()
    {
        return Option.of(toCentralPurchaseContractItem);
    }

    /**
     * Overwrites the associated <b>CntrlPurchaseContractItem</b> entity for the loaded navigation property
     * <b>to_CentralPurchaseContractItem</b>.
     *
     * @param value
     *            New <b>CntrlPurchaseContractItem</b> entity.
     */
    public void setCentralPurchaseContractItem( final CntrlPurchaseContractItem value )
    {
        toCentralPurchaseContractItem = value;
    }

    /**
     * Fetches the <b>CntrlPurContrItemPartner</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CntrlPurContrItemPartner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurContrItemPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrItemPartner> fetchCntrlPurContrItemPartner()
    {
        return fetchFieldAsList("to_CntrlPurContrItemPartner", CntrlPurContrItemPartner.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContrItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItemPartner</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItemPartner</b> of a queried <b>CntrlPurContrItmDistribution</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContrItemPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrItemPartner> getCntrlPurContrItemPartnerOrFetch()
    {
        if( toCntrlPurContrItemPartner == null ) {
            toCntrlPurContrItemPartner = fetchCntrlPurContrItemPartner();
        }
        return toCntrlPurContrItemPartner;
    }

    /**
     * Retrieval of associated <b>CntrlPurContrItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItemPartner</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurContrItmDistribution</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlPurContrItemPartner</b> is already loaded, the
     *         result will contain the <b>CntrlPurContrItemPartner</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurContrItemPartner>> getCntrlPurContrItemPartnerIfPresent()
    {
        return Option.of(toCntrlPurContrItemPartner);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurContrItemPartner</b> entities for the loaded navigation property
     * <b>to_CntrlPurContrItemPartner</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItemPartner</b> of a queried <b>CntrlPurContrItmDistribution</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurContrItemPartner</b> entities.
     */
    public void setCntrlPurContrItemPartner( @Nonnull final List<CntrlPurContrItemPartner> value )
    {
        if( toCntrlPurContrItemPartner == null ) {
            toCntrlPurContrItemPartner = Lists.newArrayList();
        }
        toCntrlPurContrItemPartner.clear();
        toCntrlPurContrItemPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurContrItemPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItemPartner</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItemPartner</b> of a queried <b>CntrlPurContrItmDistribution</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurContrItemPartner</b> entities.
     */
    public void addCntrlPurContrItemPartner( CntrlPurContrItemPartner... entity )
    {
        if( toCntrlPurContrItemPartner == null ) {
            toCntrlPurContrItemPartner = Lists.newArrayList();
        }
        toCntrlPurContrItemPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CntrlPurContrItmDistribution instances.
     *
     */
    public final static class CntrlPurContrItmDistributionBuilder
    {

        private CentralPurchaseContract toCentralPurchaseContract;
        private String centralPurchaseContract = null;
        private CntrlPurchaseContractItem toCentralPurchaseContractItem;
        private String centralPurchaseContractItem = null;
        private List<CntrlPurContrItemPartner> toCntrlPurContrItemPartner = Lists.newArrayList();

        private CntrlPurContrItmDistribution.CntrlPurContrItmDistributionBuilder toCentralPurchaseContract(
            final CentralPurchaseContract value )
        {
            toCentralPurchaseContract = value;
            return this;
        }

        /**
         * Navigation property <b>to_CentralPurchaseContract</b> for <b>CntrlPurContrItmDistribution</b> to single
         * <b>CentralPurchaseContract</b>.
         *
         * @param value
         *            The CentralPurchaseContract to build this CntrlPurContrItmDistribution with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrItmDistribution.CntrlPurContrItmDistributionBuilder centralPurchaseContract(
            final CentralPurchaseContract value )
        {
            return toCentralPurchaseContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
         * </p>
         *
         * @param value
         *            The centralPurchaseContract to build this CntrlPurContrItmDistribution with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrItmDistribution.CntrlPurContrItmDistributionBuilder centralPurchaseContract(
            final String value )
        {
            centralPurchaseContract = value;
            return this;
        }

        private CntrlPurContrItmDistribution.CntrlPurContrItmDistributionBuilder toCentralPurchaseContractItem(
            final CntrlPurchaseContractItem value )
        {
            toCentralPurchaseContractItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_CentralPurchaseContractItem</b> for <b>CntrlPurContrItmDistribution</b> to single
         * <b>CntrlPurchaseContractItem</b>.
         *
         * @param value
         *            The CntrlPurchaseContractItem to build this CntrlPurContrItmDistribution with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrItmDistribution.CntrlPurContrItmDistributionBuilder centralPurchaseContractItem(
            final CntrlPurchaseContractItem value )
        {
            return toCentralPurchaseContractItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 5
         * <p>
         * Original property name from the Odata EDM: <b>CentralPurchaseContractItem</b>
         * </p>
         *
         * @param value
         *            The centralPurchaseContractItem to build this CntrlPurContrItmDistribution with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrItmDistribution.CntrlPurContrItmDistributionBuilder centralPurchaseContractItem(
            final String value )
        {
            centralPurchaseContractItem = value;
            return this;
        }

        private CntrlPurContrItmDistribution.CntrlPurContrItmDistributionBuilder toCntrlPurContrItemPartner(
            final List<CntrlPurContrItemPartner> value )
        {
            toCntrlPurContrItemPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CntrlPurContrItemPartner</b> for <b>CntrlPurContrItmDistribution</b> to multiple
         * <b>CntrlPurContrItemPartner</b>.
         *
         * @param value
         *            The CntrlPurContrItemPartners to build this CntrlPurContrItmDistribution with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrItmDistribution.CntrlPurContrItmDistributionBuilder cntrlPurContrItemPartner(
            CntrlPurContrItemPartner... value )
        {
            return toCntrlPurContrItemPartner(Lists.newArrayList(value));
        }

    }

}
