/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrLegalTransField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContrLegalTransSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Legal Transaction
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CntrlPurContrLegalTransType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CntrlPurContrLegalTrans extends VdmEntity<CntrlPurContrLegalTrans>
{

    /**
     * Selector for all available fields of CntrlPurContrLegalTrans.
     *
     */
    public final static CntrlPurContrLegalTransSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @return Central Purchase Contract
     */
    @Key
    @SerializedName( "CentralPurchaseContract" )
    @JsonProperty( "CentralPurchaseContract" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContract" )
    private String centralPurchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContract</b> field to query operations.
     *
     */
    public final static CntrlPurContrLegalTransField<String> CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurContrLegalTransField<String>("CentralPurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransaction</b>
     * </p>
     *
     * @return Legal Transaction ID
     */
    @Key
    @SerializedName( "LegalTransaction" )
    @JsonProperty( "LegalTransaction" )
    @Nullable
    @ODataField( odataName = "LegalTransaction" )
    private String legalTransaction;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransaction</b> field to query operations.
     *
     */
    public final static CntrlPurContrLegalTransField<String> LEGAL_TRANSACTION =
        new CntrlPurContrLegalTransField<String>("LegalTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionTitle</b>
     * </p>
     *
     * @return Legal Transaction Name
     */
    @SerializedName( "LegalTransactionTitle" )
    @JsonProperty( "LegalTransactionTitle" )
    @Nullable
    @ODataField( odataName = "LegalTransactionTitle" )
    private String legalTransactionTitle;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionTitle</b> field to query operations.
     *
     */
    public final static CntrlPurContrLegalTransField<String> LEGAL_TRANSACTION_TITLE =
        new CntrlPurContrLegalTransField<String>("LegalTransactionTitle");

    @Nonnull
    @Override
    public Class<CntrlPurContrLegalTrans> getType()
    {
        return CntrlPurContrLegalTrans.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @param centralPurchaseContract
     *            Central Purchase Contract
     */
    public void setCentralPurchaseContract( @Nullable final String centralPurchaseContract )
    {
        rememberChangedField("CentralPurchaseContract", this.centralPurchaseContract);
        this.centralPurchaseContract = centralPurchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransaction</b>
     * </p>
     *
     * @param legalTransaction
     *            Legal Transaction ID
     */
    public void setLegalTransaction( @Nullable final String legalTransaction )
    {
        rememberChangedField("LegalTransaction", this.legalTransaction);
        this.legalTransaction = legalTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionTitle</b>
     * </p>
     *
     * @param legalTransactionTitle
     *            Legal Transaction Name
     */
    public void setLegalTransactionTitle( @Nullable final String legalTransactionTitle )
    {
        rememberChangedField("LegalTransactionTitle", this.legalTransactionTitle);
        this.legalTransactionTitle = legalTransactionTitle;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CntrlPurContrLegalTrans";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CentralPurchaseContract", getCentralPurchaseContract());
        result.put("LegalTransaction", getLegalTransaction());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CentralPurchaseContract", getCentralPurchaseContract());
        values.put("LegalTransaction", getLegalTransaction());
        values.put("LegalTransactionTitle", getLegalTransactionTitle());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CentralPurchaseContract") ) {
                final Object value = values.remove("CentralPurchaseContract");
                if( (value == null) || (!value.equals(getCentralPurchaseContract())) ) {
                    setCentralPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("LegalTransaction") ) {
                final Object value = values.remove("LegalTransaction");
                if( (value == null) || (!value.equals(getLegalTransaction())) ) {
                    setLegalTransaction(((String) value));
                }
            }
            if( values.containsKey("LegalTransactionTitle") ) {
                final Object value = values.remove("LegalTransactionTitle");
                if( (value == null) || (!value.equals(getLegalTransactionTitle())) ) {
                    setLegalTransactionTitle(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CntrlPurContrLegalTransField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CntrlPurContrLegalTransField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CntrlPurContrLegalTransField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CntrlPurContrLegalTransField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

}
