/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContrLegalTransSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrLegalTrans
 * CntrlPurContrLegalTrans} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class CntrlPurContrLegalTransByKeyFluentHelper
    extends
    FluentHelperByKey<CntrlPurContrLegalTransByKeyFluentHelper, CntrlPurContrLegalTrans, CntrlPurContrLegalTransSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrLegalTrans
     * CntrlPurContrLegalTrans} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CntrlPurContrLegalTrans}
     * @param centralPurchaseContract
     *            Central Purchase Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CntrlPurContrLegalTrans}
     * @param legalTransaction
     *            Legal Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public CntrlPurContrLegalTransByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String centralPurchaseContract,
        final String legalTransaction )
    {
        super(servicePath, entityCollection);
        this.key.put("CentralPurchaseContract", centralPurchaseContract);
        this.key.put("LegalTransaction", legalTransaction);
    }

    @Override
    @Nonnull
    protected Class<CntrlPurContrLegalTrans> getEntityClass()
    {
        return CntrlPurContrLegalTrans.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
