/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrVersionHistoryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrVersionHistoryLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContrVersionHistorySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Version History
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CntrlPurContrVersionHistoryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CntrlPurContrVersionHistory extends VdmEntity<CntrlPurContrVersionHistory>
{

    /**
     * Selector for all available fields of CntrlPurContrVersionHistory.
     *
     */
    public final static CntrlPurContrVersionHistorySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @return Active Purchasing Document
     */
    @Key
    @SerializedName( "CentralPurchaseContract" )
    @JsonProperty( "CentralPurchaseContract" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContract" )
    private String centralPurchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContract</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurContrVersionHistoryField<String>("CentralPurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentVersion</b>
     * </p>
     *
     * @return Version number in Purchasing
     */
    @Key
    @SerializedName( "PurchasingDocumentVersion" )
    @JsonProperty( "PurchasingDocumentVersion" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentVersion" )
    private String purchasingDocumentVersion;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentVersion</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> PURCHASING_DOCUMENT_VERSION =
        new CntrlPurContrVersionHistoryField<String>("PurchasingDocumentVersion");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ActivePurchasingDocument</b>
     * </p>
     *
     * @return Central Purchase Contract
     */
    @SerializedName( "ActivePurchasingDocument" )
    @JsonProperty( "ActivePurchasingDocument" )
    @Nullable
    @ODataField( odataName = "ActivePurchasingDocument" )
    private String activePurchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>ActivePurchasingDocument</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> ACTIVE_PURCHASING_DOCUMENT =
        new CntrlPurContrVersionHistoryField<String>("ActivePurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractType</b>
     * </p>
     *
     * @return Purchasing Document Type
     */
    @SerializedName( "PurchaseContractType" )
    @JsonProperty( "PurchaseContractType" )
    @Nullable
    @ODataField( odataName = "PurchaseContractType" )
    private String purchaseContractType;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractType</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> PURCHASE_CONTRACT_TYPE =
        new CntrlPurContrVersionHistoryField<String>("PurchaseContractType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @return Purchasing Document Category
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentCategory</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> PURCHASING_DOCUMENT_CATEGORY =
        new CntrlPurContrVersionHistoryField<String>("PurchasingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> SUPPLIER =
        new CntrlPurContrVersionHistoryField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> COMPANY_CODE =
        new CntrlPurContrVersionHistoryField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> PURCHASING_ORGANIZATION =
        new CntrlPurContrVersionHistoryField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> PURCHASING_GROUP =
        new CntrlPurContrVersionHistoryField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Start of Validity Period
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<LocalDateTime> VALIDITY_START_DATE =
        new CntrlPurContrVersionHistoryField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return End of Validity Period
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<LocalDateTime> VALIDITY_END_DATE =
        new CntrlPurContrVersionHistoryField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> DOCUMENT_CURRENCY =
        new CntrlPurContrVersionHistoryField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRequestNote</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "ChangeRequestNote" )
    @JsonProperty( "ChangeRequestNote" )
    @Nullable
    @ODataField( odataName = "ChangeRequestNote" )
    private String changeRequestNote;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRequestNote</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> CHANGE_REQUEST_NOTE =
        new CntrlPurContrVersionHistoryField<String>("ChangeRequestNote");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> CREATED_BY_USER =
        new CntrlPurContrVersionHistoryField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 81
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserDescription</b>
     * </p>
     *
     * @return User Description for field CreatedByUser
     */
    @SerializedName( "CreatedByUserDescription" )
    @JsonProperty( "CreatedByUserDescription" )
    @Nullable
    @ODataField( odataName = "CreatedByUserDescription" )
    private String createdByUserDescription;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUserDescription</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> CREATED_BY_USER_DESCRIPTION =
        new CntrlPurContrVersionHistoryField<String>("CreatedByUserDescription");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<LocalDateTime> CREATION_DATE =
        new CntrlPurContrVersionHistoryField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Entry time
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<LocalTime> CREATION_TIME =
        new CntrlPurContrVersionHistoryField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocVersionReasonCode</b>
     * </p>
     *
     * @return Reason for change
     */
    @SerializedName( "PurchasingDocVersionReasonCode" )
    @JsonProperty( "PurchasingDocVersionReasonCode" )
    @Nullable
    @ODataField( odataName = "PurchasingDocVersionReasonCode" )
    private String purchasingDocVersionReasonCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocVersionReasonCode</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> PURCHASING_DOC_VERSION_REASON_CODE =
        new CntrlPurContrVersionHistoryField<String>("PurchasingDocVersionReasonCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocVersionStatus</b>
     * </p>
     *
     * @return Version status
     */
    @SerializedName( "PurchasingDocVersionStatus" )
    @JsonProperty( "PurchasingDocVersionStatus" )
    @Nullable
    @ODataField( odataName = "PurchasingDocVersionStatus" )
    private String purchasingDocVersionStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocVersionStatus</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> PURCHASING_DOC_VERSION_STATUS =
        new CntrlPurContrVersionHistoryField<String>("PurchasingDocVersionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> CURRENCY =
        new CntrlPurContrVersionHistoryField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> INCOTERMS_CLASSIFICATION =
        new CntrlPurContrVersionHistoryField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> INCOTERMS_TRANSFER_LOCATION =
        new CntrlPurContrVersionHistoryField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @return Incoterms Version
     */
    @SerializedName( "IncotermsVersion" )
    @JsonProperty( "IncotermsVersion" )
    @Nullable
    @ODataField( odataName = "IncotermsVersion" )
    private String incotermsVersion;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsVersion</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> INCOTERMS_VERSION =
        new CntrlPurContrVersionHistoryField<String>("IncotermsVersion");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> INCOTERMS_LOCATION1 =
        new CntrlPurContrVersionHistoryField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> INCOTERMS_LOCATION2 =
        new CntrlPurContrVersionHistoryField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentName</b>
     * </p>
     *
     * @return Name of Purchasing Document
     */
    @SerializedName( "PurchasingDocumentName" )
    @JsonProperty( "PurchasingDocumentName" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentName" )
    private String purchasingDocumentName;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentName</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> PURCHASING_DOCUMENT_NAME =
        new CntrlPurContrVersionHistoryField<String>("PurchasingDocumentName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> PAYMENT_TERMS =
        new CntrlPurContrVersionHistoryField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @return Cash discount days 1
     */
    @SerializedName( "CashDiscount1Days" )
    @JsonProperty( "CashDiscount1Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Days" )
    private BigDecimal cashDiscount1Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Days</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<BigDecimal> CASH_DISCOUNT1_DAYS =
        new CntrlPurContrVersionHistoryField<BigDecimal>("CashDiscount1Days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @return Cash discount days 2
     */
    @SerializedName( "CashDiscount2Days" )
    @JsonProperty( "CashDiscount2Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Days" )
    private BigDecimal cashDiscount2Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Days</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<BigDecimal> CASH_DISCOUNT2_DAYS =
        new CntrlPurContrVersionHistoryField<BigDecimal>("CashDiscount2Days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @return Net Payment Terms Period
     */
    @SerializedName( "NetPaymentDays" )
    @JsonProperty( "NetPaymentDays" )
    @Nullable
    @ODataField( odataName = "NetPaymentDays" )
    private BigDecimal netPaymentDays;
    /**
     * Use with available fluent helpers to apply the <b>NetPaymentDays</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<BigDecimal> NET_PAYMENT_DAYS =
        new CntrlPurContrVersionHistoryField<BigDecimal>("NetPaymentDays");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 1
     */
    @SerializedName( "CashDiscount1Percent" )
    @JsonProperty( "CashDiscount1Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Percent" )
    private BigDecimal cashDiscount1Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Percent</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<BigDecimal> CASH_DISCOUNT1_PERCENT =
        new CntrlPurContrVersionHistoryField<BigDecimal>("CashDiscount1Percent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 2
     */
    @SerializedName( "CashDiscount2Percent" )
    @JsonProperty( "CashDiscount2Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Percent" )
    private BigDecimal cashDiscount2Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Percent</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<BigDecimal> CASH_DISCOUNT2_PERCENT =
        new CntrlPurContrVersionHistoryField<BigDecimal>("CashDiscount2Percent");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractTargetAmount</b>
     * </p>
     *
     * @return Target Value for Header Area per Distribution
     */
    @SerializedName( "PurchaseContractTargetAmount" )
    @JsonProperty( "PurchaseContractTargetAmount" )
    @Nullable
    @ODataField( odataName = "PurchaseContractTargetAmount" )
    private BigDecimal purchaseContractTargetAmount;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractTargetAmount</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<BigDecimal> PURCHASE_CONTRACT_TARGET_AMOUNT =
        new CntrlPurContrVersionHistoryField<BigDecimal>("PurchaseContractTargetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseCode</b>
     * </p>
     *
     * @return Release Indicator: Purchasing Document
     */
    @SerializedName( "ReleaseCode" )
    @JsonProperty( "ReleaseCode" )
    @Nullable
    @ODataField( odataName = "ReleaseCode" )
    private String releaseCode;
    /**
     * Use with available fluent helpers to apply the <b>ReleaseCode</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> RELEASE_CODE =
        new CntrlPurContrVersionHistoryField<String>("ReleaseCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentDeletionCode</b>
     * </p>
     *
     * @return Deletion Indicator in Purchasing Document
     */
    @SerializedName( "PurchasingDocumentDeletionCode" )
    @JsonProperty( "PurchasingDocumentDeletionCode" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentDeletionCode" )
    private String purchasingDocumentDeletionCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentDeletionCode</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> PURCHASING_DOCUMENT_DELETION_CODE =
        new CntrlPurContrVersionHistoryField<String>("PurchasingDocumentDeletionCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingSupplier</b>
     * </p>
     *
     * @return Goods Supplier
     */
    @SerializedName( "SupplyingSupplier" )
    @JsonProperty( "SupplyingSupplier" )
    @Nullable
    @ODataField( odataName = "SupplyingSupplier" )
    private String supplyingSupplier;
    /**
     * Use with available fluent helpers to apply the <b>SupplyingSupplier</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> SUPPLYING_SUPPLIER =
        new CntrlPurContrVersionHistoryField<String>("SupplyingSupplier");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateIsFixed</b>
     * </p>
     *
     * @return Indicator for Fixed Exchange Rate
     */
    @SerializedName( "ExchangeRateIsFixed" )
    @JsonProperty( "ExchangeRateIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ExchangeRateIsFixed" )
    private Boolean exchangeRateIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRateIsFixed</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<Boolean> EXCHANGE_RATE_IS_FIXED =
        new CntrlPurContrVersionHistoryField<Boolean>("ExchangeRateIsFixed");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuotationSubmissionDate</b>
     * </p>
     *
     * @return Quotation Submission Date
     */
    @SerializedName( "QuotationSubmissionDate" )
    @JsonProperty( "QuotationSubmissionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "QuotationSubmissionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime quotationSubmissionDate;
    /**
     * Use with available fluent helpers to apply the <b>QuotationSubmissionDate</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<LocalDateTime> QUOTATION_SUBMISSION_DATE =
        new CntrlPurContrVersionHistoryField<LocalDateTime>("QuotationSubmissionDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotation</b>
     * </p>
     *
     * @return Quotation Number
     */
    @SerializedName( "SupplierQuotation" )
    @JsonProperty( "SupplierQuotation" )
    @Nullable
    @ODataField( odataName = "SupplierQuotation" )
    private String supplierQuotation;
    /**
     * Use with available fluent helpers to apply the <b>SupplierQuotation</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> SUPPLIER_QUOTATION =
        new CntrlPurContrVersionHistoryField<String>("SupplierQuotation");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CorrespncExternalReference</b>
     * </p>
     *
     * @return Your Reference
     */
    @SerializedName( "CorrespncExternalReference" )
    @JsonProperty( "CorrespncExternalReference" )
    @Nullable
    @ODataField( odataName = "CorrespncExternalReference" )
    private String correspncExternalReference;
    /**
     * Use with available fluent helpers to apply the <b>CorrespncExternalReference</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> CORRESPNC_EXTERNAL_REFERENCE =
        new CntrlPurContrVersionHistoryField<String>("CorrespncExternalReference");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CorrespncInternalReference</b>
     * </p>
     *
     * @return Our Reference
     */
    @SerializedName( "CorrespncInternalReference" )
    @JsonProperty( "CorrespncInternalReference" )
    @Nullable
    @ODataField( odataName = "CorrespncInternalReference" )
    private String correspncInternalReference;
    /**
     * Use with available fluent helpers to apply the <b>CorrespncInternalReference</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> CORRESPNC_INTERNAL_REFERENCE =
        new CntrlPurContrVersionHistoryField<String>("CorrespncInternalReference");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SupplierRespSalesPersonName</b>
     * </p>
     *
     * @return Responsible Salesperson at Supplier's Office
     */
    @SerializedName( "SupplierRespSalesPersonName" )
    @JsonProperty( "SupplierRespSalesPersonName" )
    @Nullable
    @ODataField( odataName = "SupplierRespSalesPersonName" )
    private String supplierRespSalesPersonName;
    /**
     * Use with available fluent helpers to apply the <b>SupplierRespSalesPersonName</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> SUPPLIER_RESP_SALES_PERSON_NAME =
        new CntrlPurContrVersionHistoryField<String>("SupplierRespSalesPersonName");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPhoneNumber</b>
     * </p>
     *
     * @return Supplier's Phone Number
     */
    @SerializedName( "SupplierPhoneNumber" )
    @JsonProperty( "SupplierPhoneNumber" )
    @Nullable
    @ODataField( odataName = "SupplierPhoneNumber" )
    private String supplierPhoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>SupplierPhoneNumber</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> SUPPLIER_PHONE_NUMBER =
        new CntrlPurContrVersionHistoryField<String>("SupplierPhoneNumber");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Change Time Stamp
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new CntrlPurContrVersionHistoryField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgContractIsInPreparation</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "PurgContractIsInPreparation" )
    @JsonProperty( "PurgContractIsInPreparation" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PurgContractIsInPreparation" )
    private Boolean purgContractIsInPreparation;
    /**
     * Use with available fluent helpers to apply the <b>PurgContractIsInPreparation</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<Boolean> PURG_CONTRACT_IS_IN_PREPARATION =
        new CntrlPurContrVersionHistoryField<Boolean>("PurgContractIsInPreparation");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingProcessingStatus</b>
     * </p>
     *
     * @return Purchasing Document Processing State
     */
    @SerializedName( "PurchasingProcessingStatus" )
    @JsonProperty( "PurchasingProcessingStatus" )
    @Nullable
    @ODataField( odataName = "PurchasingProcessingStatus" )
    private String purchasingProcessingStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingProcessingStatus</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> PURCHASING_PROCESSING_STATUS =
        new CntrlPurContrVersionHistoryField<String>("PurchasingProcessingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrOvrlDistrStsTxt</b>
     * </p>
     *
     * @return The cntrlPurContrOvrlDistrStsTxt contained in this entity.
     */
    @SerializedName( "CntrlPurContrOvrlDistrStsTxt" )
    @JsonProperty( "CntrlPurContrOvrlDistrStsTxt" )
    @Nullable
    @ODataField( odataName = "CntrlPurContrOvrlDistrStsTxt" )
    private String cntrlPurContrOvrlDistrStsTxt;
    /**
     * Use with available fluent helpers to apply the <b>CntrlPurContrOvrlDistrStsTxt</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> CNTRL_PUR_CONTR_OVRL_DISTR_STS_TXT =
        new CntrlPurContrVersionHistoryField<String>("CntrlPurContrOvrlDistrStsTxt");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrFlxblDistrIsAllwd</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "CntrlPurContrFlxblDistrIsAllwd" )
    @JsonProperty( "CntrlPurContrFlxblDistrIsAllwd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CntrlPurContrFlxblDistrIsAllwd" )
    private Boolean cntrlPurContrFlxblDistrIsAllwd;
    /**
     * Use with available fluent helpers to apply the <b>CntrlPurContrFlxblDistrIsAllwd</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<Boolean> CNTRL_PUR_CONTR_FLXBL_DISTR_IS_ALLWD =
        new CntrlPurContrVersionHistoryField<Boolean>("CntrlPurContrFlxblDistrIsAllwd");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocChangeRequestStatus</b>
     * </p>
     *
     * @return Change Request Status
     */
    @SerializedName( "PurgDocChangeRequestStatus" )
    @JsonProperty( "PurgDocChangeRequestStatus" )
    @Nullable
    @ODataField( odataName = "PurgDocChangeRequestStatus" )
    private String purgDocChangeRequestStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocChangeRequestStatus</b> field to query operations.
     *
     */
    public final static CntrlPurContrVersionHistoryField<String> PURG_DOC_CHANGE_REQUEST_STATUS =
        new CntrlPurContrVersionHistoryField<String>("PurgDocChangeRequestStatus");
    /**
     * Navigation property <b>to_CentralPurchaseContractItem</b> for <b>CntrlPurContrVersionHistory</b> to multiple
     * <b>CntrlPurchaseContractItem</b>.
     *
     */
    @SerializedName( "to_CentralPurchaseContractItem" )
    @JsonProperty( "to_CentralPurchaseContractItem" )
    @ODataField( odataName = "to_CentralPurchaseContractItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurchaseContractItem> toCentralPurchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>to_CentralPurchaseContractItem</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurContrVersionHistoryLink<CntrlPurchaseContractItem> TO_CENTRAL_PURCHASE_CONTRACT_ITEM =
        new CntrlPurContrVersionHistoryLink<CntrlPurchaseContractItem>("to_CentralPurchaseContractItem");

    @Nonnull
    @Override
    public Class<CntrlPurContrVersionHistory> getType()
    {
        return CntrlPurContrVersionHistory.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @param centralPurchaseContract
     *            Active Purchasing Document
     */
    public void setCentralPurchaseContract( @Nullable final String centralPurchaseContract )
    {
        rememberChangedField("CentralPurchaseContract", this.centralPurchaseContract);
        this.centralPurchaseContract = centralPurchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentVersion</b>
     * </p>
     *
     * @param purchasingDocumentVersion
     *            Version number in Purchasing
     */
    public void setPurchasingDocumentVersion( @Nullable final String purchasingDocumentVersion )
    {
        rememberChangedField("PurchasingDocumentVersion", this.purchasingDocumentVersion);
        this.purchasingDocumentVersion = purchasingDocumentVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ActivePurchasingDocument</b>
     * </p>
     *
     * @param activePurchasingDocument
     *            Central Purchase Contract
     */
    public void setActivePurchasingDocument( @Nullable final String activePurchasingDocument )
    {
        rememberChangedField("ActivePurchasingDocument", this.activePurchasingDocument);
        this.activePurchasingDocument = activePurchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractType</b>
     * </p>
     *
     * @param purchaseContractType
     *            Purchasing Document Type
     */
    public void setPurchaseContractType( @Nullable final String purchaseContractType )
    {
        rememberChangedField("PurchaseContractType", this.purchaseContractType);
        this.purchaseContractType = purchaseContractType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Purchasing Document Category
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Start of Validity Period
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            End of Validity Period
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRequestNote</b>
     * </p>
     *
     * @param changeRequestNote
     *            Short Text for Fixed Values
     */
    public void setChangeRequestNote( @Nullable final String changeRequestNote )
    {
        rememberChangedField("ChangeRequestNote", this.changeRequestNote);
        this.changeRequestNote = changeRequestNote;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 81
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserDescription</b>
     * </p>
     *
     * @param createdByUserDescription
     *            User Description for field CreatedByUser
     */
    public void setCreatedByUserDescription( @Nullable final String createdByUserDescription )
    {
        rememberChangedField("CreatedByUserDescription", this.createdByUserDescription);
        this.createdByUserDescription = createdByUserDescription;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Entry time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocVersionReasonCode</b>
     * </p>
     *
     * @param purchasingDocVersionReasonCode
     *            Reason for change
     */
    public void setPurchasingDocVersionReasonCode( @Nullable final String purchasingDocVersionReasonCode )
    {
        rememberChangedField("PurchasingDocVersionReasonCode", this.purchasingDocVersionReasonCode);
        this.purchasingDocVersionReasonCode = purchasingDocVersionReasonCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocVersionStatus</b>
     * </p>
     *
     * @param purchasingDocVersionStatus
     *            Version status
     */
    public void setPurchasingDocVersionStatus( @Nullable final String purchasingDocVersionStatus )
    {
        rememberChangedField("PurchasingDocVersionStatus", this.purchasingDocVersionStatus);
        this.purchasingDocVersionStatus = purchasingDocVersionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *            Incoterms Version
     */
    public void setIncotermsVersion( @Nullable final String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentName</b>
     * </p>
     *
     * @param purchasingDocumentName
     *            Name of Purchasing Document
     */
    public void setPurchasingDocumentName( @Nullable final String purchasingDocumentName )
    {
        rememberChangedField("PurchasingDocumentName", this.purchasingDocumentName);
        this.purchasingDocumentName = purchasingDocumentName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @param cashDiscount1Days
     *            Cash discount days 1
     */
    public void setCashDiscount1Days( @Nullable final BigDecimal cashDiscount1Days )
    {
        rememberChangedField("CashDiscount1Days", this.cashDiscount1Days);
        this.cashDiscount1Days = cashDiscount1Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @param cashDiscount2Days
     *            Cash discount days 2
     */
    public void setCashDiscount2Days( @Nullable final BigDecimal cashDiscount2Days )
    {
        rememberChangedField("CashDiscount2Days", this.cashDiscount2Days);
        this.cashDiscount2Days = cashDiscount2Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @param netPaymentDays
     *            Net Payment Terms Period
     */
    public void setNetPaymentDays( @Nullable final BigDecimal netPaymentDays )
    {
        rememberChangedField("NetPaymentDays", this.netPaymentDays);
        this.netPaymentDays = netPaymentDays;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @param cashDiscount1Percent
     *            Cash Discount Percentage 1
     */
    public void setCashDiscount1Percent( @Nullable final BigDecimal cashDiscount1Percent )
    {
        rememberChangedField("CashDiscount1Percent", this.cashDiscount1Percent);
        this.cashDiscount1Percent = cashDiscount1Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @param cashDiscount2Percent
     *            Cash Discount Percentage 2
     */
    public void setCashDiscount2Percent( @Nullable final BigDecimal cashDiscount2Percent )
    {
        rememberChangedField("CashDiscount2Percent", this.cashDiscount2Percent);
        this.cashDiscount2Percent = cashDiscount2Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractTargetAmount</b>
     * </p>
     *
     * @param purchaseContractTargetAmount
     *            Target Value for Header Area per Distribution
     */
    public void setPurchaseContractTargetAmount( @Nullable final BigDecimal purchaseContractTargetAmount )
    {
        rememberChangedField("PurchaseContractTargetAmount", this.purchaseContractTargetAmount);
        this.purchaseContractTargetAmount = purchaseContractTargetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseCode</b>
     * </p>
     *
     * @param releaseCode
     *            Release Indicator: Purchasing Document
     */
    public void setReleaseCode( @Nullable final String releaseCode )
    {
        rememberChangedField("ReleaseCode", this.releaseCode);
        this.releaseCode = releaseCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentDeletionCode</b>
     * </p>
     *
     * @param purchasingDocumentDeletionCode
     *            Deletion Indicator in Purchasing Document
     */
    public void setPurchasingDocumentDeletionCode( @Nullable final String purchasingDocumentDeletionCode )
    {
        rememberChangedField("PurchasingDocumentDeletionCode", this.purchasingDocumentDeletionCode);
        this.purchasingDocumentDeletionCode = purchasingDocumentDeletionCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingSupplier</b>
     * </p>
     *
     * @param supplyingSupplier
     *            Goods Supplier
     */
    public void setSupplyingSupplier( @Nullable final String supplyingSupplier )
    {
        rememberChangedField("SupplyingSupplier", this.supplyingSupplier);
        this.supplyingSupplier = supplyingSupplier;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateIsFixed</b>
     * </p>
     *
     * @param exchangeRateIsFixed
     *            Indicator for Fixed Exchange Rate
     */
    public void setExchangeRateIsFixed( @Nullable final Boolean exchangeRateIsFixed )
    {
        rememberChangedField("ExchangeRateIsFixed", this.exchangeRateIsFixed);
        this.exchangeRateIsFixed = exchangeRateIsFixed;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuotationSubmissionDate</b>
     * </p>
     *
     * @param quotationSubmissionDate
     *            Quotation Submission Date
     */
    public void setQuotationSubmissionDate( @Nullable final LocalDateTime quotationSubmissionDate )
    {
        rememberChangedField("QuotationSubmissionDate", this.quotationSubmissionDate);
        this.quotationSubmissionDate = quotationSubmissionDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotation</b>
     * </p>
     *
     * @param supplierQuotation
     *            Quotation Number
     */
    public void setSupplierQuotation( @Nullable final String supplierQuotation )
    {
        rememberChangedField("SupplierQuotation", this.supplierQuotation);
        this.supplierQuotation = supplierQuotation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CorrespncExternalReference</b>
     * </p>
     *
     * @param correspncExternalReference
     *            Your Reference
     */
    public void setCorrespncExternalReference( @Nullable final String correspncExternalReference )
    {
        rememberChangedField("CorrespncExternalReference", this.correspncExternalReference);
        this.correspncExternalReference = correspncExternalReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CorrespncInternalReference</b>
     * </p>
     *
     * @param correspncInternalReference
     *            Our Reference
     */
    public void setCorrespncInternalReference( @Nullable final String correspncInternalReference )
    {
        rememberChangedField("CorrespncInternalReference", this.correspncInternalReference);
        this.correspncInternalReference = correspncInternalReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SupplierRespSalesPersonName</b>
     * </p>
     *
     * @param supplierRespSalesPersonName
     *            Responsible Salesperson at Supplier's Office
     */
    public void setSupplierRespSalesPersonName( @Nullable final String supplierRespSalesPersonName )
    {
        rememberChangedField("SupplierRespSalesPersonName", this.supplierRespSalesPersonName);
        this.supplierRespSalesPersonName = supplierRespSalesPersonName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPhoneNumber</b>
     * </p>
     *
     * @param supplierPhoneNumber
     *            Supplier's Phone Number
     */
    public void setSupplierPhoneNumber( @Nullable final String supplierPhoneNumber )
    {
        rememberChangedField("SupplierPhoneNumber", this.supplierPhoneNumber);
        this.supplierPhoneNumber = supplierPhoneNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Change Time Stamp
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgContractIsInPreparation</b>
     * </p>
     *
     * @param purgContractIsInPreparation
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setPurgContractIsInPreparation( @Nullable final Boolean purgContractIsInPreparation )
    {
        rememberChangedField("PurgContractIsInPreparation", this.purgContractIsInPreparation);
        this.purgContractIsInPreparation = purgContractIsInPreparation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingProcessingStatus</b>
     * </p>
     *
     * @param purchasingProcessingStatus
     *            Purchasing Document Processing State
     */
    public void setPurchasingProcessingStatus( @Nullable final String purchasingProcessingStatus )
    {
        rememberChangedField("PurchasingProcessingStatus", this.purchasingProcessingStatus);
        this.purchasingProcessingStatus = purchasingProcessingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrOvrlDistrStsTxt</b>
     * </p>
     *
     * @param cntrlPurContrOvrlDistrStsTxt
     *            The cntrlPurContrOvrlDistrStsTxt to set.
     */
    public void setCntrlPurContrOvrlDistrStsTxt( @Nullable final String cntrlPurContrOvrlDistrStsTxt )
    {
        rememberChangedField("CntrlPurContrOvrlDistrStsTxt", this.cntrlPurContrOvrlDistrStsTxt);
        this.cntrlPurContrOvrlDistrStsTxt = cntrlPurContrOvrlDistrStsTxt;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrFlxblDistrIsAllwd</b>
     * </p>
     *
     * @param cntrlPurContrFlxblDistrIsAllwd
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setCntrlPurContrFlxblDistrIsAllwd( @Nullable final Boolean cntrlPurContrFlxblDistrIsAllwd )
    {
        rememberChangedField("CntrlPurContrFlxblDistrIsAllwd", this.cntrlPurContrFlxblDistrIsAllwd);
        this.cntrlPurContrFlxblDistrIsAllwd = cntrlPurContrFlxblDistrIsAllwd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocChangeRequestStatus</b>
     * </p>
     *
     * @param purgDocChangeRequestStatus
     *            Change Request Status
     */
    public void setPurgDocChangeRequestStatus( @Nullable final String purgDocChangeRequestStatus )
    {
        rememberChangedField("PurgDocChangeRequestStatus", this.purgDocChangeRequestStatus);
        this.purgDocChangeRequestStatus = purgDocChangeRequestStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CntrlPurContrVersionHistory";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CentralPurchaseContract", getCentralPurchaseContract());
        result.put("PurchasingDocumentVersion", getPurchasingDocumentVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CentralPurchaseContract", getCentralPurchaseContract());
        values.put("PurchasingDocumentVersion", getPurchasingDocumentVersion());
        values.put("ActivePurchasingDocument", getActivePurchasingDocument());
        values.put("PurchaseContractType", getPurchaseContractType());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("Supplier", getSupplier());
        values.put("CompanyCode", getCompanyCode());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("ChangeRequestNote", getChangeRequestNote());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreatedByUserDescription", getCreatedByUserDescription());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("PurchasingDocVersionReasonCode", getPurchasingDocVersionReasonCode());
        values.put("PurchasingDocVersionStatus", getPurchasingDocVersionStatus());
        values.put("Currency", getCurrency());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsVersion", getIncotermsVersion());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("PurchasingDocumentName", getPurchasingDocumentName());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("CashDiscount1Days", getCashDiscount1Days());
        values.put("CashDiscount2Days", getCashDiscount2Days());
        values.put("NetPaymentDays", getNetPaymentDays());
        values.put("CashDiscount1Percent", getCashDiscount1Percent());
        values.put("CashDiscount2Percent", getCashDiscount2Percent());
        values.put("PurchaseContractTargetAmount", getPurchaseContractTargetAmount());
        values.put("ReleaseCode", getReleaseCode());
        values.put("PurchasingDocumentDeletionCode", getPurchasingDocumentDeletionCode());
        values.put("SupplyingSupplier", getSupplyingSupplier());
        values.put("ExchangeRateIsFixed", getExchangeRateIsFixed());
        values.put("QuotationSubmissionDate", getQuotationSubmissionDate());
        values.put("SupplierQuotation", getSupplierQuotation());
        values.put("CorrespncExternalReference", getCorrespncExternalReference());
        values.put("CorrespncInternalReference", getCorrespncInternalReference());
        values.put("SupplierRespSalesPersonName", getSupplierRespSalesPersonName());
        values.put("SupplierPhoneNumber", getSupplierPhoneNumber());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("PurgContractIsInPreparation", getPurgContractIsInPreparation());
        values.put("PurchasingProcessingStatus", getPurchasingProcessingStatus());
        values.put("CntrlPurContrOvrlDistrStsTxt", getCntrlPurContrOvrlDistrStsTxt());
        values.put("CntrlPurContrFlxblDistrIsAllwd", getCntrlPurContrFlxblDistrIsAllwd());
        values.put("PurgDocChangeRequestStatus", getPurgDocChangeRequestStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CentralPurchaseContract") ) {
                final Object value = values.remove("CentralPurchaseContract");
                if( (value == null) || (!value.equals(getCentralPurchaseContract())) ) {
                    setCentralPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentVersion") ) {
                final Object value = values.remove("PurchasingDocumentVersion");
                if( (value == null) || (!value.equals(getPurchasingDocumentVersion())) ) {
                    setPurchasingDocumentVersion(((String) value));
                }
            }
            if( values.containsKey("ActivePurchasingDocument") ) {
                final Object value = values.remove("ActivePurchasingDocument");
                if( (value == null) || (!value.equals(getActivePurchasingDocument())) ) {
                    setActivePurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractType") ) {
                final Object value = values.remove("PurchaseContractType");
                if( (value == null) || (!value.equals(getPurchaseContractType())) ) {
                    setPurchaseContractType(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("ChangeRequestNote") ) {
                final Object value = values.remove("ChangeRequestNote");
                if( (value == null) || (!value.equals(getChangeRequestNote())) ) {
                    setChangeRequestNote(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreatedByUserDescription") ) {
                final Object value = values.remove("CreatedByUserDescription");
                if( (value == null) || (!value.equals(getCreatedByUserDescription())) ) {
                    setCreatedByUserDescription(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("PurchasingDocVersionReasonCode") ) {
                final Object value = values.remove("PurchasingDocVersionReasonCode");
                if( (value == null) || (!value.equals(getPurchasingDocVersionReasonCode())) ) {
                    setPurchasingDocVersionReasonCode(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocVersionStatus") ) {
                final Object value = values.remove("PurchasingDocVersionStatus");
                if( (value == null) || (!value.equals(getPurchasingDocVersionStatus())) ) {
                    setPurchasingDocVersionStatus(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentName") ) {
                final Object value = values.remove("PurchasingDocumentName");
                if( (value == null) || (!value.equals(getPurchasingDocumentName())) ) {
                    setPurchasingDocumentName(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("CashDiscount1Days") ) {
                final Object value = values.remove("CashDiscount1Days");
                if( (value == null) || (!value.equals(getCashDiscount1Days())) ) {
                    setCashDiscount1Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Days") ) {
                final Object value = values.remove("CashDiscount2Days");
                if( (value == null) || (!value.equals(getCashDiscount2Days())) ) {
                    setCashDiscount2Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPaymentDays") ) {
                final Object value = values.remove("NetPaymentDays");
                if( (value == null) || (!value.equals(getNetPaymentDays())) ) {
                    setNetPaymentDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount1Percent") ) {
                final Object value = values.remove("CashDiscount1Percent");
                if( (value == null) || (!value.equals(getCashDiscount1Percent())) ) {
                    setCashDiscount1Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Percent") ) {
                final Object value = values.remove("CashDiscount2Percent");
                if( (value == null) || (!value.equals(getCashDiscount2Percent())) ) {
                    setCashDiscount2Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchaseContractTargetAmount") ) {
                final Object value = values.remove("PurchaseContractTargetAmount");
                if( (value == null) || (!value.equals(getPurchaseContractTargetAmount())) ) {
                    setPurchaseContractTargetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReleaseCode") ) {
                final Object value = values.remove("ReleaseCode");
                if( (value == null) || (!value.equals(getReleaseCode())) ) {
                    setReleaseCode(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentDeletionCode") ) {
                final Object value = values.remove("PurchasingDocumentDeletionCode");
                if( (value == null) || (!value.equals(getPurchasingDocumentDeletionCode())) ) {
                    setPurchasingDocumentDeletionCode(((String) value));
                }
            }
            if( values.containsKey("SupplyingSupplier") ) {
                final Object value = values.remove("SupplyingSupplier");
                if( (value == null) || (!value.equals(getSupplyingSupplier())) ) {
                    setSupplyingSupplier(((String) value));
                }
            }
            if( values.containsKey("ExchangeRateIsFixed") ) {
                final Object value = values.remove("ExchangeRateIsFixed");
                if( (value == null) || (!value.equals(getExchangeRateIsFixed())) ) {
                    setExchangeRateIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("QuotationSubmissionDate") ) {
                final Object value = values.remove("QuotationSubmissionDate");
                if( (value == null) || (!value.equals(getQuotationSubmissionDate())) ) {
                    setQuotationSubmissionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SupplierQuotation") ) {
                final Object value = values.remove("SupplierQuotation");
                if( (value == null) || (!value.equals(getSupplierQuotation())) ) {
                    setSupplierQuotation(((String) value));
                }
            }
            if( values.containsKey("CorrespncExternalReference") ) {
                final Object value = values.remove("CorrespncExternalReference");
                if( (value == null) || (!value.equals(getCorrespncExternalReference())) ) {
                    setCorrespncExternalReference(((String) value));
                }
            }
            if( values.containsKey("CorrespncInternalReference") ) {
                final Object value = values.remove("CorrespncInternalReference");
                if( (value == null) || (!value.equals(getCorrespncInternalReference())) ) {
                    setCorrespncInternalReference(((String) value));
                }
            }
            if( values.containsKey("SupplierRespSalesPersonName") ) {
                final Object value = values.remove("SupplierRespSalesPersonName");
                if( (value == null) || (!value.equals(getSupplierRespSalesPersonName())) ) {
                    setSupplierRespSalesPersonName(((String) value));
                }
            }
            if( values.containsKey("SupplierPhoneNumber") ) {
                final Object value = values.remove("SupplierPhoneNumber");
                if( (value == null) || (!value.equals(getSupplierPhoneNumber())) ) {
                    setSupplierPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PurgContractIsInPreparation") ) {
                final Object value = values.remove("PurgContractIsInPreparation");
                if( (value == null) || (!value.equals(getPurgContractIsInPreparation())) ) {
                    setPurgContractIsInPreparation(((Boolean) value));
                }
            }
            if( values.containsKey("PurchasingProcessingStatus") ) {
                final Object value = values.remove("PurchasingProcessingStatus");
                if( (value == null) || (!value.equals(getPurchasingProcessingStatus())) ) {
                    setPurchasingProcessingStatus(((String) value));
                }
            }
            if( values.containsKey("CntrlPurContrOvrlDistrStsTxt") ) {
                final Object value = values.remove("CntrlPurContrOvrlDistrStsTxt");
                if( (value == null) || (!value.equals(getCntrlPurContrOvrlDistrStsTxt())) ) {
                    setCntrlPurContrOvrlDistrStsTxt(((String) value));
                }
            }
            if( values.containsKey("CntrlPurContrFlxblDistrIsAllwd") ) {
                final Object value = values.remove("CntrlPurContrFlxblDistrIsAllwd");
                if( (value == null) || (!value.equals(getCntrlPurContrFlxblDistrIsAllwd())) ) {
                    setCntrlPurContrFlxblDistrIsAllwd(((Boolean) value));
                }
            }
            if( values.containsKey("PurgDocChangeRequestStatus") ) {
                final Object value = values.remove("PurgDocChangeRequestStatus");
                if( (value == null) || (!value.equals(getPurgDocChangeRequestStatus())) ) {
                    setPurgDocChangeRequestStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CentralPurchaseContractItem") ) {
                final Object value = (values).remove("to_CentralPurchaseContractItem");
                if( value instanceof Iterable ) {
                    if( toCentralPurchaseContractItem == null ) {
                        toCentralPurchaseContractItem = Lists.newArrayList();
                    } else {
                        toCentralPurchaseContractItem = Lists.newArrayList(toCentralPurchaseContractItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurchaseContractItem entity;
                        if( toCentralPurchaseContractItem.size() > i ) {
                            entity = toCentralPurchaseContractItem.get(i);
                        } else {
                            entity = new CntrlPurchaseContractItem();
                            toCentralPurchaseContractItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CntrlPurContrVersionHistoryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CntrlPurContrVersionHistoryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CntrlPurContrVersionHistoryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CntrlPurContrVersionHistoryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCentralPurchaseContractItem != null ) {
            (values).put("to_CentralPurchaseContractItem", toCentralPurchaseContractItem);
        }
        return values;
    }

    /**
     * Fetches the <b>CntrlPurchaseContractItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CentralPurchaseContractItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurchaseContractItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurchaseContractItem> fetchCentralPurchaseContractItem()
    {
        return fetchFieldAsList("to_CentralPurchaseContractItem", CntrlPurchaseContractItem.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurchaseContractItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContractItem</b>.
     * <p>
     * If the navigation property <b>to_CentralPurchaseContractItem</b> of a queried <b>CntrlPurContrVersionHistory</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurchaseContractItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurchaseContractItem> getCentralPurchaseContractItemOrFetch()
    {
        if( toCentralPurchaseContractItem == null ) {
            toCentralPurchaseContractItem = fetchCentralPurchaseContractItem();
        }
        return toCentralPurchaseContractItem;
    }

    /**
     * Retrieval of associated <b>CntrlPurchaseContractItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContractItem</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurContrVersionHistory</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CentralPurchaseContractItem</b> is already loaded, the
     *         result will contain the <b>CntrlPurchaseContractItem</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurchaseContractItem>> getCentralPurchaseContractItemIfPresent()
    {
        return Option.of(toCentralPurchaseContractItem);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurchaseContractItem</b> entities for the loaded navigation property
     * <b>to_CentralPurchaseContractItem</b>.
     * <p>
     * If the navigation property <b>to_CentralPurchaseContractItem</b> of a queried <b>CntrlPurContrVersionHistory</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurchaseContractItem</b> entities.
     */
    public void setCentralPurchaseContractItem( @Nonnull final List<CntrlPurchaseContractItem> value )
    {
        if( toCentralPurchaseContractItem == null ) {
            toCentralPurchaseContractItem = Lists.newArrayList();
        }
        toCentralPurchaseContractItem.clear();
        toCentralPurchaseContractItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurchaseContractItem</b> entities. This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContractItem</b>.
     * <p>
     * If the navigation property <b>to_CentralPurchaseContractItem</b> of a queried <b>CntrlPurContrVersionHistory</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurchaseContractItem</b> entities.
     */
    public void addCentralPurchaseContractItem( CntrlPurchaseContractItem... entity )
    {
        if( toCentralPurchaseContractItem == null ) {
            toCentralPurchaseContractItem = Lists.newArrayList();
        }
        toCentralPurchaseContractItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CntrlPurContrVersionHistory instances.
     *
     */
    public final static class CntrlPurContrVersionHistoryBuilder
    {

        private List<CntrlPurchaseContractItem> toCentralPurchaseContractItem = Lists.newArrayList();

        private CntrlPurContrVersionHistory.CntrlPurContrVersionHistoryBuilder toCentralPurchaseContractItem(
            final List<CntrlPurchaseContractItem> value )
        {
            toCentralPurchaseContractItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CentralPurchaseContractItem</b> for <b>CntrlPurContrVersionHistory</b> to multiple
         * <b>CntrlPurchaseContractItem</b>.
         *
         * @param value
         *            The CntrlPurchaseContractItems to build this CntrlPurContrVersionHistory with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrVersionHistory.CntrlPurContrVersionHistoryBuilder centralPurchaseContractItem(
            CntrlPurchaseContractItem... value )
        {
            return toCentralPurchaseContractItem(Lists.newArrayList(value));
        }

    }

}
