/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContrVersionHistorySelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory
 * CntrlPurContrVersionHistory} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class CntrlPurContrVersionHistoryByKeyFluentHelper
    extends
    FluentHelperByKey<CntrlPurContrVersionHistoryByKeyFluentHelper, CntrlPurContrVersionHistory, CntrlPurContrVersionHistorySelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory
     * CntrlPurContrVersionHistory} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CntrlPurContrVersionHistory}
     * @param purchasingDocumentVersion
     *            Version number in Purchasing
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param centralPurchaseContract
     *            Active Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CntrlPurContrVersionHistory}
     */
    public CntrlPurContrVersionHistoryByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String centralPurchaseContract,
        final String purchasingDocumentVersion )
    {
        super(servicePath, entityCollection);
        this.key.put("CentralPurchaseContract", centralPurchaseContract);
        this.key.put("PurchasingDocumentVersion", purchasingDocumentVersion);
    }

    @Override
    @Nonnull
    protected Class<CntrlPurContrVersionHistory> getEntityClass()
    {
        return CntrlPurContrVersionHistory.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
