/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContractHeaderNotesField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContractHeaderNotesSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Header Notes
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CntrlPurContractHeaderNotesType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CntrlPurContractHeaderNotes extends VdmEntity<CntrlPurContractHeaderNotes>
{

    /**
     * Selector for all available fields of CntrlPurContractHeaderNotes.
     *
     */
    public final static CntrlPurContractHeaderNotesSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentNoteObjectID</b>
     * </p>
     *
     * @return Application Object ID
     */
    @Key
    @SerializedName( "PurchasingDocumentNoteObjectID" )
    @JsonProperty( "PurchasingDocumentNoteObjectID" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentNoteObjectID" )
    private String purchasingDocumentNoteObjectID;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentNoteObjectID</b> field to query operations.
     *
     */
    public final static CntrlPurContractHeaderNotesField<String> PURCHASING_DOCUMENT_NOTE_OBJECT_ID =
        new CntrlPurContractHeaderNotesField<String>("PurchasingDocumentNoteObjectID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentNoteType</b>
     * </p>
     *
     * @return Name of Note Type
     */
    @Key
    @SerializedName( "PurchasingDocumentNoteType" )
    @JsonProperty( "PurchasingDocumentNoteType" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentNoteType" )
    private String purchasingDocumentNoteType;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentNoteType</b> field to query operations.
     *
     */
    public final static CntrlPurContractHeaderNotesField<String> PURCHASING_DOCUMENT_NOTE_TYPE =
        new CntrlPurContractHeaderNotesField<String>("PurchasingDocumentNoteType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentNoteLanguage</b>
     * </p>
     *
     * @return Language
     */
    @Key
    @SerializedName( "PurchasingDocumentNoteLanguage" )
    @JsonProperty( "PurchasingDocumentNoteLanguage" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentNoteLanguage" )
    private String purchasingDocumentNoteLanguage;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentNoteLanguage</b> field to query operations.
     *
     */
    public final static CntrlPurContractHeaderNotesField<String> PURCHASING_DOCUMENT_NOTE_LANGUAGE =
        new CntrlPurContractHeaderNotesField<String>("PurchasingDocumentNoteLanguage");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocNoteText</b>
     * </p>
     *
     * @return Content of note
     */
    @SerializedName( "PurgDocNoteText" )
    @JsonProperty( "PurgDocNoteText" )
    @Nullable
    @ODataField( odataName = "PurgDocNoteText" )
    private String purgDocNoteText;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocNoteText</b> field to query operations.
     *
     */
    public final static CntrlPurContractHeaderNotesField<String> PURG_DOC_NOTE_TEXT =
        new CntrlPurContractHeaderNotesField<String>("PurgDocNoteText");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentNoteTitle</b>
     * </p>
     *
     * @return Description of Note Type
     */
    @SerializedName( "PurchasingDocumentNoteTitle" )
    @JsonProperty( "PurchasingDocumentNoteTitle" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentNoteTitle" )
    private String purchasingDocumentNoteTitle;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentNoteTitle</b> field to query operations.
     *
     */
    public final static CntrlPurContractHeaderNotesField<String> PURCHASING_DOCUMENT_NOTE_TITLE =
        new CntrlPurContractHeaderNotesField<String>("PurchasingDocumentNoteTitle");

    @Nonnull
    @Override
    public Class<CntrlPurContractHeaderNotes> getType()
    {
        return CntrlPurContractHeaderNotes.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentNoteObjectID</b>
     * </p>
     *
     * @param purchasingDocumentNoteObjectID
     *            Application Object ID
     */
    public void setPurchasingDocumentNoteObjectID( @Nullable final String purchasingDocumentNoteObjectID )
    {
        rememberChangedField("PurchasingDocumentNoteObjectID", this.purchasingDocumentNoteObjectID);
        this.purchasingDocumentNoteObjectID = purchasingDocumentNoteObjectID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentNoteType</b>
     * </p>
     *
     * @param purchasingDocumentNoteType
     *            Name of Note Type
     */
    public void setPurchasingDocumentNoteType( @Nullable final String purchasingDocumentNoteType )
    {
        rememberChangedField("PurchasingDocumentNoteType", this.purchasingDocumentNoteType);
        this.purchasingDocumentNoteType = purchasingDocumentNoteType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentNoteLanguage</b>
     * </p>
     *
     * @param purchasingDocumentNoteLanguage
     *            Language
     */
    public void setPurchasingDocumentNoteLanguage( @Nullable final String purchasingDocumentNoteLanguage )
    {
        rememberChangedField("PurchasingDocumentNoteLanguage", this.purchasingDocumentNoteLanguage);
        this.purchasingDocumentNoteLanguage = purchasingDocumentNoteLanguage;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocNoteText</b>
     * </p>
     *
     * @param purgDocNoteText
     *            Content of note
     */
    public void setPurgDocNoteText( @Nullable final String purgDocNoteText )
    {
        rememberChangedField("PurgDocNoteText", this.purgDocNoteText);
        this.purgDocNoteText = purgDocNoteText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentNoteTitle</b>
     * </p>
     *
     * @param purchasingDocumentNoteTitle
     *            Description of Note Type
     */
    public void setPurchasingDocumentNoteTitle( @Nullable final String purchasingDocumentNoteTitle )
    {
        rememberChangedField("PurchasingDocumentNoteTitle", this.purchasingDocumentNoteTitle);
        this.purchasingDocumentNoteTitle = purchasingDocumentNoteTitle;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CntrlPurContractHeaderNotes";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchasingDocumentNoteObjectID", getPurchasingDocumentNoteObjectID());
        result.put("PurchasingDocumentNoteType", getPurchasingDocumentNoteType());
        result.put("PurchasingDocumentNoteLanguage", getPurchasingDocumentNoteLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchasingDocumentNoteObjectID", getPurchasingDocumentNoteObjectID());
        values.put("PurchasingDocumentNoteType", getPurchasingDocumentNoteType());
        values.put("PurchasingDocumentNoteLanguage", getPurchasingDocumentNoteLanguage());
        values.put("PurgDocNoteText", getPurgDocNoteText());
        values.put("PurchasingDocumentNoteTitle", getPurchasingDocumentNoteTitle());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchasingDocumentNoteObjectID") ) {
                final Object value = values.remove("PurchasingDocumentNoteObjectID");
                if( (value == null) || (!value.equals(getPurchasingDocumentNoteObjectID())) ) {
                    setPurchasingDocumentNoteObjectID(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentNoteType") ) {
                final Object value = values.remove("PurchasingDocumentNoteType");
                if( (value == null) || (!value.equals(getPurchasingDocumentNoteType())) ) {
                    setPurchasingDocumentNoteType(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentNoteLanguage") ) {
                final Object value = values.remove("PurchasingDocumentNoteLanguage");
                if( (value == null) || (!value.equals(getPurchasingDocumentNoteLanguage())) ) {
                    setPurchasingDocumentNoteLanguage(((String) value));
                }
            }
            if( values.containsKey("PurgDocNoteText") ) {
                final Object value = values.remove("PurgDocNoteText");
                if( (value == null) || (!value.equals(getPurgDocNoteText())) ) {
                    setPurgDocNoteText(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentNoteTitle") ) {
                final Object value = values.remove("PurchasingDocumentNoteTitle");
                if( (value == null) || (!value.equals(getPurchasingDocumentNoteTitle())) ) {
                    setPurchasingDocumentNoteTitle(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CntrlPurContractHeaderNotesField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CntrlPurContractHeaderNotesField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CntrlPurContractHeaderNotesField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CntrlPurContractHeaderNotesField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

}
