/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContractItemNotesSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotes
 * CntrlPurContractItemNotes} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class CntrlPurContractItemNotesByKeyFluentHelper
    extends
    FluentHelperByKey<CntrlPurContractItemNotesByKeyFluentHelper, CntrlPurContractItemNotes, CntrlPurContractItemNotesSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotes
     * CntrlPurContractItemNotes} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CntrlPurContractItemNotes}
     * @param purchasingDocumentNoteLanguage
     *            Language
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CntrlPurContractItemNotes}
     * @param purchasingDocumentNoteObjectID
     *            Application Object ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param purchasingDocumentNoteType
     *            Name of Note Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     */
    public CntrlPurContractItemNotesByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String purchasingDocumentNoteObjectID,
        final String purchasingDocumentNoteType,
        final String purchasingDocumentNoteLanguage )
    {
        super(servicePath, entityCollection);
        this.key.put("PurchasingDocumentNoteObjectID", purchasingDocumentNoteObjectID);
        this.key.put("PurchasingDocumentNoteType", purchasingDocumentNoteType);
        this.key.put("PurchasingDocumentNoteLanguage", purchasingDocumentNoteLanguage);
    }

    @Override
    @Nonnull
    protected Class<CntrlPurContractItemNotes> getEntityClass()
    {
        return CntrlPurContractItemNotes.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
