/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurchaseContractItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurchaseContractItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurchaseContractItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurchaseContractItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CntrlPurchaseContractItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CntrlPurchaseContractItem extends VdmEntity<CntrlPurchaseContractItem>
{

    /**
     * Selector for all available fields of CntrlPurchaseContractItem.
     *
     */
    public final static CntrlPurchaseContractItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @return Central Purchase Contract
     */
    @Key
    @SerializedName( "CentralPurchaseContract" )
    @JsonProperty( "CentralPurchaseContract" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContract" )
    private String centralPurchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContract</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurchaseContractItemField<String>("CentralPurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContractItem</b>
     * </p>
     *
     * @return Central Purchase Contract Item
     */
    @Key
    @SerializedName( "CentralPurchaseContractItem" )
    @JsonProperty( "CentralPurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContractItem" )
    private String centralPurchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContractItem</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> CENTRAL_PURCHASE_CONTRACT_ITEM =
        new CntrlPurchaseContractItemField<String>("CentralPurchaseContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemCategory</b>
     * </p>
     *
     * @return Item category in purchasing document
     */
    @SerializedName( "PurchasingDocumentItemCategory" )
    @JsonProperty( "PurchasingDocumentItemCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItemCategory" )
    private String purchasingDocumentItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItemCategory</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> PURCHASING_DOCUMENT_ITEM_CATEGORY =
        new CntrlPurchaseContractItemField<String>("PurchasingDocumentItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>FormattedPurchaseContractItem</b>
     * </p>
     *
     * @return The formattedPurchaseContractItem contained in this entity.
     */
    @SerializedName( "FormattedPurchaseContractItem" )
    @JsonProperty( "FormattedPurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "FormattedPurchaseContractItem" )
    private String formattedPurchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>FormattedPurchaseContractItem</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> FORMATTED_PURCHASE_CONTRACT_ITEM =
        new CntrlPurchaseContractItemField<String>("FormattedPurchaseContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> MATERIAL_GROUP =
        new CntrlPurchaseContractItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingCentralMaterial</b>
     * </p>
     *
     * @return Material of External System
     */
    @SerializedName( "PurchasingCentralMaterial" )
    @JsonProperty( "PurchasingCentralMaterial" )
    @Nullable
    @ODataField( odataName = "PurchasingCentralMaterial" )
    private String purchasingCentralMaterial;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingCentralMaterial</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> PURCHASING_CENTRAL_MATERIAL =
        new CntrlPurchaseContractItemField<String>("PurchasingCentralMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubRefcdConnectedSystem</b>
     * </p>
     *
     * @return Source Connected System ID
     */
    @SerializedName( "ProcmtHubRefcdConnectedSystem" )
    @JsonProperty( "ProcmtHubRefcdConnectedSystem" )
    @Nullable
    @ODataField( odataName = "ProcmtHubRefcdConnectedSystem" )
    private String procmtHubRefcdConnectedSystem;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubRefcdConnectedSystem</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> PROCMT_HUB_REFCD_CONNECTED_SYSTEM =
        new CntrlPurchaseContractItemField<String>("ProcmtHubRefcdConnectedSystem");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContractItemText</b>
     * </p>
     *
     * @return Short Text
     */
    @SerializedName( "CntrlPurContractItemText" )
    @JsonProperty( "CntrlPurContractItemText" )
    @Nullable
    @ODataField( odataName = "CntrlPurContractItemText" )
    private String cntrlPurContractItemText;
    /**
     * Use with available fluent helpers to apply the <b>CntrlPurContractItemText</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> CNTRL_PUR_CONTRACT_ITEM_TEXT =
        new CntrlPurchaseContractItemField<String>("CntrlPurContractItemText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     *
     * @return Product Type Group
     */
    @SerializedName( "ProductType" )
    @JsonProperty( "ProductType" )
    @Nullable
    @ODataField( odataName = "ProductType" )
    private String productType;
    /**
     * Use with available fluent helpers to apply the <b>ProductType</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> PRODUCT_TYPE =
        new CntrlPurchaseContractItemField<String>("ProductType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ActivePurchasingDocument</b>
     * </p>
     *
     * @return Active Purchasing Document
     */
    @SerializedName( "ActivePurchasingDocument" )
    @JsonProperty( "ActivePurchasingDocument" )
    @Nullable
    @ODataField( odataName = "ActivePurchasingDocument" )
    private String activePurchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>ActivePurchasingDocument</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> ACTIVE_PURCHASING_DOCUMENT =
        new CntrlPurchaseContractItemField<String>("ActivePurchasingDocument");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantity</b>
     * </p>
     *
     * @return Price Unit
     */
    @SerializedName( "NetPriceQuantity" )
    @JsonProperty( "NetPriceQuantity" )
    @Nullable
    @ODataField( odataName = "NetPriceQuantity" )
    private BigDecimal netPriceQuantity;
    /**
     * Use with available fluent helpers to apply the <b>NetPriceQuantity</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<BigDecimal> NET_PRICE_QUANTITY =
        new CntrlPurchaseContractItemField<BigDecimal>("NetPriceQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnit</b>
     * </p>
     *
     * @return Order Price Unit (Purchasing)
     */
    @SerializedName( "OrderPriceUnit" )
    @JsonProperty( "OrderPriceUnit" )
    @Nullable
    @ODataField( odataName = "OrderPriceUnit" )
    private String orderPriceUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderPriceUnit</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> ORDER_PRICE_UNIT =
        new CntrlPurchaseContractItemField<String>("OrderPriceUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TargetQuantity</b>
     * </p>
     *
     * @return Target Quantity
     */
    @SerializedName( "TargetQuantity" )
    @JsonProperty( "TargetQuantity" )
    @Nullable
    @ODataField( odataName = "TargetQuantity" )
    private BigDecimal targetQuantity;
    /**
     * Use with available fluent helpers to apply the <b>TargetQuantity</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<BigDecimal> TARGET_QUANTITY =
        new CntrlPurchaseContractItemField<BigDecimal>("TargetQuantity");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrItmTargetAmount</b>
     * </p>
     *
     * @return Target Value at Item Level in Procurement Hub
     */
    @SerializedName( "CntrlPurContrItmTargetAmount" )
    @JsonProperty( "CntrlPurContrItmTargetAmount" )
    @Nullable
    @ODataField( odataName = "CntrlPurContrItmTargetAmount" )
    private BigDecimal cntrlPurContrItmTargetAmount;
    /**
     * Use with available fluent helpers to apply the <b>CntrlPurContrItmTargetAmount</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<BigDecimal> CNTRL_PUR_CONTR_ITM_TARGET_AMOUNT =
        new CntrlPurchaseContractItemField<BigDecimal>("CntrlPurContrItmTargetAmount");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ContractNetPriceAmount</b>
     * </p>
     *
     * @return Net Price in Purchasing Document (in Document Currency)
     */
    @SerializedName( "ContractNetPriceAmount" )
    @JsonProperty( "ContractNetPriceAmount" )
    @Nullable
    @ODataField( odataName = "ContractNetPriceAmount" )
    private BigDecimal contractNetPriceAmount;
    /**
     * Use with available fluent helpers to apply the <b>ContractNetPriceAmount</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<BigDecimal> CONTRACT_NET_PRICE_AMOUNT =
        new CntrlPurchaseContractItemField<BigDecimal>("ContractNetPriceAmount");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> ORDER_QUANTITY_UNIT =
        new CntrlPurchaseContractItemField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocReleaseOrderQuantity</b>
     * </p>
     *
     * @return Standard release order quantity
     */
    @SerializedName( "PurgDocReleaseOrderQuantity" )
    @JsonProperty( "PurgDocReleaseOrderQuantity" )
    @Nullable
    @ODataField( odataName = "PurgDocReleaseOrderQuantity" )
    private BigDecimal purgDocReleaseOrderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocReleaseOrderQuantity</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<BigDecimal> PURG_DOC_RELEASE_ORDER_QUANTITY =
        new CntrlPurchaseContractItemField<BigDecimal>("PurgDocReleaseOrderQuantity");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrdPriceUnitToOrderUnitDnmntr</b>
     * </p>
     *
     * @return Denominator for Conv. of Order Price Unit into Order Unit
     */
    @SerializedName( "OrdPriceUnitToOrderUnitDnmntr" )
    @JsonProperty( "OrdPriceUnitToOrderUnitDnmntr" )
    @Nullable
    @ODataField( odataName = "OrdPriceUnitToOrderUnitDnmntr" )
    private BigDecimal ordPriceUnitToOrderUnitDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>OrdPriceUnitToOrderUnitDnmntr</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<BigDecimal> ORD_PRICE_UNIT_TO_ORDER_UNIT_DNMNTR =
        new CntrlPurchaseContractItemField<BigDecimal>("OrdPriceUnitToOrderUnitDnmntr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnitToOrderUnitNmrtr</b>
     * </p>
     *
     * @return Numerator for Conversion of Order Price Unit into Order Unit
     */
    @SerializedName( "OrderPriceUnitToOrderUnitNmrtr" )
    @JsonProperty( "OrderPriceUnitToOrderUnitNmrtr" )
    @Nullable
    @ODataField( odataName = "OrderPriceUnitToOrderUnitNmrtr" )
    private BigDecimal orderPriceUnitToOrderUnitNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>OrderPriceUnitToOrderUnitNmrtr</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<BigDecimal> ORDER_PRICE_UNIT_TO_ORDER_UNIT_NMRTR =
        new CntrlPurchaseContractItemField<BigDecimal>("OrderPriceUnitToOrderUnitNmrtr");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> DOCUMENT_CURRENCY =
        new CntrlPurchaseContractItemField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder1</b>
     * </p>
     *
     * @return Number of Days for First Reminder/Expediter
     */
    @SerializedName( "NoDaysReminder1" )
    @JsonProperty( "NoDaysReminder1" )
    @Nullable
    @ODataField( odataName = "NoDaysReminder1" )
    private BigDecimal noDaysReminder1;
    /**
     * Use with available fluent helpers to apply the <b>NoDaysReminder1</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<BigDecimal> NO_DAYS_REMINDER1 =
        new CntrlPurchaseContractItemField<BigDecimal>("NoDaysReminder1");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder2</b>
     * </p>
     *
     * @return Number of Days for Second Reminder/Expediter
     */
    @SerializedName( "NoDaysReminder2" )
    @JsonProperty( "NoDaysReminder2" )
    @Nullable
    @ODataField( odataName = "NoDaysReminder2" )
    private BigDecimal noDaysReminder2;
    /**
     * Use with available fluent helpers to apply the <b>NoDaysReminder2</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<BigDecimal> NO_DAYS_REMINDER2 =
        new CntrlPurchaseContractItemField<BigDecimal>("NoDaysReminder2");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder3</b>
     * </p>
     *
     * @return Number of Days for Third Reminder/Expediter
     */
    @SerializedName( "NoDaysReminder3" )
    @JsonProperty( "NoDaysReminder3" )
    @Nullable
    @ODataField( odataName = "NoDaysReminder3" )
    private BigDecimal noDaysReminder3;
    /**
     * Use with available fluent helpers to apply the <b>NoDaysReminder3</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<BigDecimal> NO_DAYS_REMINDER3 =
        new CntrlPurchaseContractItemField<BigDecimal>("NoDaysReminder3");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocOrderAcknNumber</b>
     * </p>
     *
     * @return Order Acknowledgment Number
     */
    @SerializedName( "PurgDocOrderAcknNumber" )
    @JsonProperty( "PurgDocOrderAcknNumber" )
    @Nullable
    @ODataField( odataName = "PurgDocOrderAcknNumber" )
    private String purgDocOrderAcknNumber;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocOrderAcknNumber</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> PURG_DOC_ORDER_ACKN_NUMBER =
        new CntrlPurchaseContractItemField<String>("PurgDocOrderAcknNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequirementTracking</b>
     * </p>
     *
     * @return Requirement Tracking Number
     */
    @SerializedName( "RequirementTracking" )
    @JsonProperty( "RequirementTracking" )
    @Nullable
    @ODataField( odataName = "RequirementTracking" )
    private String requirementTracking;
    /**
     * Use with available fluent helpers to apply the <b>RequirementTracking</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> REQUIREMENT_TRACKING =
        new CntrlPurchaseContractItemField<String>("RequirementTracking");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialNumber</b>
     * </p>
     *
     * @return Material Number Used by Supplier
     */
    @SerializedName( "SupplierMaterialNumber" )
    @JsonProperty( "SupplierMaterialNumber" )
    @Nullable
    @ODataField( odataName = "SupplierMaterialNumber" )
    private String supplierMaterialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SupplierMaterialNumber</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> SUPPLIER_MATERIAL_NUMBER =
        new CntrlPurchaseContractItemField<String>("SupplierMaterialNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsOrderAcknRqd</b>
     * </p>
     *
     * @return Order Acknowledgment Requirement
     */
    @SerializedName( "IsOrderAcknRqd" )
    @JsonProperty( "IsOrderAcknRqd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsOrderAcknRqd" )
    private Boolean isOrderAcknRqd;
    /**
     * Use with available fluent helpers to apply the <b>IsOrderAcknRqd</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<Boolean> IS_ORDER_ACKN_RQD =
        new CntrlPurchaseContractItemField<Boolean>("IsOrderAcknRqd");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocEstimatedPrice</b>
     * </p>
     *
     * @return Indicator: Estimated Price
     */
    @SerializedName( "PurgDocEstimatedPrice" )
    @JsonProperty( "PurgDocEstimatedPrice" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PurgDocEstimatedPrice" )
    private Boolean purgDocEstimatedPrice;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocEstimatedPrice</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<Boolean> PURG_DOC_ESTIMATED_PRICE =
        new CntrlPurchaseContractItemField<Boolean>("PurgDocEstimatedPrice");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriceIsToBePrinted</b>
     * </p>
     *
     * @return Price Printout
     */
    @SerializedName( "PriceIsToBePrinted" )
    @JsonProperty( "PriceIsToBePrinted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PriceIsToBePrinted" )
    private Boolean priceIsToBePrinted;
    /**
     * Use with available fluent helpers to apply the <b>PriceIsToBePrinted</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<Boolean> PRICE_IS_TO_BE_PRINTED =
        new CntrlPurchaseContractItemField<Boolean>("PriceIsToBePrinted");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @return Underdelivery Tolerance
     */
    @SerializedName( "UnderdelivTolrtdLmtRatioInPct" )
    @JsonProperty( "UnderdelivTolrtdLmtRatioInPct" )
    @Nullable
    @ODataField( odataName = "UnderdelivTolrtdLmtRatioInPct" )
    private BigDecimal underdelivTolrtdLmtRatioInPct;
    /**
     * Use with available fluent helpers to apply the <b>UnderdelivTolrtdLmtRatioInPct</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<BigDecimal> UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT =
        new CntrlPurchaseContractItemField<BigDecimal>("UnderdelivTolrtdLmtRatioInPct");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @return Overdelivery Tolerance
     */
    @SerializedName( "OverdelivTolrtdLmtRatioInPct" )
    @JsonProperty( "OverdelivTolrtdLmtRatioInPct" )
    @Nullable
    @ODataField( odataName = "OverdelivTolrtdLmtRatioInPct" )
    private BigDecimal overdelivTolrtdLmtRatioInPct;
    /**
     * Use with available fluent helpers to apply the <b>OverdelivTolrtdLmtRatioInPct</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<BigDecimal> OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT =
        new CntrlPurchaseContractItemField<BigDecimal>("OverdelivTolrtdLmtRatioInPct");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverdeliveryIsAllowed</b>
     * </p>
     *
     * @return Unlimited Overdelivery Allowed
     */
    @SerializedName( "UnlimitedOverdeliveryIsAllowed" )
    @JsonProperty( "UnlimitedOverdeliveryIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "UnlimitedOverdeliveryIsAllowed" )
    private Boolean unlimitedOverdeliveryIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>UnlimitedOverdeliveryIsAllowed</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<Boolean> UNLIMITED_OVERDELIVERY_IS_ALLOWED =
        new CntrlPurchaseContractItemField<Boolean>("UnlimitedOverdeliveryIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockType</b>
     * </p>
     *
     * @return Stock Type
     */
    @SerializedName( "StockType" )
    @JsonProperty( "StockType" )
    @Nullable
    @ODataField( odataName = "StockType" )
    private String stockType;
    /**
     * Use with available fluent helpers to apply the <b>StockType</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> STOCK_TYPE =
        new CntrlPurchaseContractItemField<String>("StockType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> TAX_CODE =
        new CntrlPurchaseContractItemField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingInstruction</b>
     * </p>
     *
     * @return Shipping Instructions
     */
    @SerializedName( "ShippingInstruction" )
    @JsonProperty( "ShippingInstruction" )
    @Nullable
    @ODataField( odataName = "ShippingInstruction" )
    private String shippingInstruction;
    /**
     * Use with available fluent helpers to apply the <b>ShippingInstruction</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> SHIPPING_INSTRUCTION =
        new CntrlPurchaseContractItemField<String>("ShippingInstruction");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsExpected</b>
     * </p>
     *
     * @return Goods Receipt Indicator
     */
    @SerializedName( "GoodsReceiptIsExpected" )
    @JsonProperty( "GoodsReceiptIsExpected" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GoodsReceiptIsExpected" )
    private Boolean goodsReceiptIsExpected;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptIsExpected</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<Boolean> GOODS_RECEIPT_IS_EXPECTED =
        new CntrlPurchaseContractItemField<Boolean>("GoodsReceiptIsExpected");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsNonValuated</b>
     * </p>
     *
     * @return Goods Receipt, Non-Valuated
     */
    @SerializedName( "GoodsReceiptIsNonValuated" )
    @JsonProperty( "GoodsReceiptIsNonValuated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GoodsReceiptIsNonValuated" )
    private Boolean goodsReceiptIsNonValuated;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptIsNonValuated</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<Boolean> GOODS_RECEIPT_IS_NON_VALUATED =
        new CntrlPurchaseContractItemField<Boolean>("GoodsReceiptIsNonValuated");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsExpected</b>
     * </p>
     *
     * @return Invoice Receipt Indicator
     */
    @SerializedName( "InvoiceIsExpected" )
    @JsonProperty( "InvoiceIsExpected" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InvoiceIsExpected" )
    private Boolean invoiceIsExpected;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceIsExpected</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<Boolean> INVOICE_IS_EXPECTED =
        new CntrlPurchaseContractItemField<Boolean>("InvoiceIsExpected");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsGoodsReceiptBased</b>
     * </p>
     *
     * @return Indicator: GR-Based Invoice Verification
     */
    @SerializedName( "InvoiceIsGoodsReceiptBased" )
    @JsonProperty( "InvoiceIsGoodsReceiptBased" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InvoiceIsGoodsReceiptBased" )
    private Boolean invoiceIsGoodsReceiptBased;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceIsGoodsReceiptBased</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<Boolean> INVOICE_IS_GOODS_RECEIPT_BASED =
        new CntrlPurchaseContractItemField<Boolean>("InvoiceIsGoodsReceiptBased");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EvaldRcptSettlmtIsAllowed</b>
     * </p>
     *
     * @return Evaluated Receipt Settlement (ERS)
     */
    @SerializedName( "EvaldRcptSettlmtIsAllowed" )
    @JsonProperty( "EvaldRcptSettlmtIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EvaldRcptSettlmtIsAllowed" )
    private Boolean evaldRcptSettlmtIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>EvaldRcptSettlmtIsAllowed</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<Boolean> EVALD_RCPT_SETTLMT_IS_ALLOWED =
        new CntrlPurchaseContractItemField<Boolean>("EvaldRcptSettlmtIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingContractDeletionCode</b>
     * </p>
     *
     * @return Deletion Indicator in Purchasing Document
     */
    @SerializedName( "PurchasingContractDeletionCode" )
    @JsonProperty( "PurchasingContractDeletionCode" )
    @Nullable
    @ODataField( odataName = "PurchasingContractDeletionCode" )
    private String purchasingContractDeletionCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingContractDeletionCode</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> PURCHASING_CONTRACT_DELETION_CODE =
        new CntrlPurchaseContractItemField<String>("PurchasingContractDeletionCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OutlineAgrmtItmIsBlocked</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "OutlineAgrmtItmIsBlocked" )
    @JsonProperty( "OutlineAgrmtItmIsBlocked" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "OutlineAgrmtItmIsBlocked" )
    private Boolean outlineAgrmtItmIsBlocked;
    /**
     * Use with available fluent helpers to apply the <b>OutlineAgrmtItmIsBlocked</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<Boolean> OUTLINE_AGRMT_ITM_IS_BLOCKED =
        new CntrlPurchaseContractItemField<Boolean>("OutlineAgrmtItmIsBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocItmBlkRsnCode</b>
     * </p>
     *
     * @return Blocking Reason - ID
     */
    @SerializedName( "PurgDocItmBlkRsnCode" )
    @JsonProperty( "PurgDocItmBlkRsnCode" )
    @Nullable
    @ODataField( odataName = "PurgDocItmBlkRsnCode" )
    private String purgDocItmBlkRsnCode;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocItmBlkRsnCode</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> PURG_DOC_ITM_BLK_RSN_CODE =
        new CntrlPurchaseContractItemField<String>("PurgDocItmBlkRsnCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocItemRenegotiationStatus</b>
     * </p>
     *
     * @return Renegotiation Status
     */
    @SerializedName( "PurgDocItemRenegotiationStatus" )
    @JsonProperty( "PurgDocItemRenegotiationStatus" )
    @Nullable
    @ODataField( odataName = "PurgDocItemRenegotiationStatus" )
    private String purgDocItemRenegotiationStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocItemRenegotiationStatus</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> PURG_DOC_ITEM_RENEGOTIATION_STATUS =
        new CntrlPurchaseContractItemField<String>("PurgDocItemRenegotiationStatus");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingParentItem</b>
     * </p>
     *
     * @return Higher-Level Item in Purchasing Documents
     */
    @SerializedName( "PurchasingParentItem" )
    @JsonProperty( "PurchasingParentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingParentItem" )
    private String purchasingParentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingParentItem</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> PURCHASING_PARENT_ITEM =
        new CntrlPurchaseContractItemField<String>("PurchasingParentItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsOutline</b>
     * </p>
     *
     * @return Item is statistical
     */
    @SerializedName( "IsOutline" )
    @JsonProperty( "IsOutline" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsOutline" )
    private Boolean isOutline;
    /**
     * Use with available fluent helpers to apply the <b>IsOutline</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<Boolean> IS_OUTLINE =
        new CntrlPurchaseContractItemField<Boolean>("IsOutline");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurgConfigurableItemNumber</b>
     * </p>
     *
     * @return Hierarchy Number
     */
    @SerializedName( "PurgConfigurableItemNumber" )
    @JsonProperty( "PurgConfigurableItemNumber" )
    @Nullable
    @ODataField( odataName = "PurgConfigurableItemNumber" )
    private String purgConfigurableItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>PurgConfigurableItemNumber</b> field to query operations.
     *
     */
    public final static CntrlPurchaseContractItemField<String> PURG_CONFIGURABLE_ITEM_NUMBER =
        new CntrlPurchaseContractItemField<String>("PurgConfigurableItemNumber");
    /**
     * Navigation property <b>to_CentralPurchaseContract</b> for <b>CntrlPurchaseContractItem</b> to single
     * <b>CentralPurchaseContract</b>.
     *
     */
    @SerializedName( "to_CentralPurchaseContract" )
    @JsonProperty( "to_CentralPurchaseContract" )
    @ODataField( odataName = "to_CentralPurchaseContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CentralPurchaseContract toCentralPurchaseContract;
    /**
     * Navigation property <b>to_CntrlPurConItmDistribution</b> for <b>CntrlPurchaseContractItem</b> to multiple
     * <b>CntrlPurContrItmDistribution</b>.
     *
     */
    @SerializedName( "to_CntrlPurConItmDistribution" )
    @JsonProperty( "to_CntrlPurConItmDistribution" )
    @ODataField( odataName = "to_CntrlPurConItmDistribution" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurContrItmDistribution> toCntrlPurConItmDistribution;
    /**
     * Navigation property <b>to_CntrlPurContrItmCmmdtyQty</b> for <b>CntrlPurchaseContractItem</b> to multiple
     * <b>CntrlPurContrItmCmmdtyQty</b>.
     *
     */
    @SerializedName( "to_CntrlPurContrItmCmmdtyQty" )
    @JsonProperty( "to_CntrlPurContrItmCmmdtyQty" )
    @ODataField( odataName = "to_CntrlPurContrItmCmmdtyQty" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurContrItmCmmdtyQty> toCntrlPurContrItmCmmdtyQty;
    /**
     * Navigation property <b>to_CntrlPurContrItmCndnValdty</b> for <b>CntrlPurchaseContractItem</b> to multiple
     * <b>CntrlPurContrItmCndnValdty</b>.
     *
     */
    @SerializedName( "to_CntrlPurContrItmCndnValdty" )
    @JsonProperty( "to_CntrlPurContrItmCndnValdty" )
    @ODataField( odataName = "to_CntrlPurContrItmCndnValdty" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurContrItmCndnValdty> toCntrlPurContrItmCndnValdty;
    /**
     * Navigation property <b>to_CntrlPurContrItmNotes</b> for <b>CntrlPurchaseContractItem</b> to multiple
     * <b>CntrlPurContractItemNotes</b>.
     *
     */
    @SerializedName( "to_CntrlPurContrItmNotes" )
    @JsonProperty( "to_CntrlPurContrItmNotes" )
    @ODataField( odataName = "to_CntrlPurContrItmNotes" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurContractItemNotes> toCntrlPurContrItmNotes;
    /**
     * Use with available fluent helpers to apply the <b>to_CentralPurchaseContract</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurchaseContractItemOneToOneLink<CentralPurchaseContract> TO_CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurchaseContractItemOneToOneLink<CentralPurchaseContract>("to_CentralPurchaseContract");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlPurConItmDistribution</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurchaseContractItemLink<CntrlPurContrItmDistribution> TO_CNTRL_PUR_CON_ITM_DISTRIBUTION =
        new CntrlPurchaseContractItemLink<CntrlPurContrItmDistribution>("to_CntrlPurConItmDistribution");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlPurContrItmCmmdtyQty</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurchaseContractItemLink<CntrlPurContrItmCmmdtyQty> TO_CNTRL_PUR_CONTR_ITM_CMMDTY_QTY =
        new CntrlPurchaseContractItemLink<CntrlPurContrItmCmmdtyQty>("to_CntrlPurContrItmCmmdtyQty");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlPurContrItmCndnValdty</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurchaseContractItemLink<CntrlPurContrItmCndnValdty> TO_CNTRL_PUR_CONTR_ITM_CNDN_VALDTY =
        new CntrlPurchaseContractItemLink<CntrlPurContrItmCndnValdty>("to_CntrlPurContrItmCndnValdty");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlPurContrItmNotes</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurchaseContractItemLink<CntrlPurContractItemNotes> TO_CNTRL_PUR_CONTR_ITM_NOTES =
        new CntrlPurchaseContractItemLink<CntrlPurContractItemNotes>("to_CntrlPurContrItmNotes");

    @Nonnull
    @Override
    public Class<CntrlPurchaseContractItem> getType()
    {
        return CntrlPurchaseContractItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @param centralPurchaseContract
     *            Central Purchase Contract
     */
    public void setCentralPurchaseContract( @Nullable final String centralPurchaseContract )
    {
        rememberChangedField("CentralPurchaseContract", this.centralPurchaseContract);
        this.centralPurchaseContract = centralPurchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContractItem</b>
     * </p>
     *
     * @param centralPurchaseContractItem
     *            Central Purchase Contract Item
     */
    public void setCentralPurchaseContractItem( @Nullable final String centralPurchaseContractItem )
    {
        rememberChangedField("CentralPurchaseContractItem", this.centralPurchaseContractItem);
        this.centralPurchaseContractItem = centralPurchaseContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemCategory</b>
     * </p>
     *
     * @param purchasingDocumentItemCategory
     *            Item category in purchasing document
     */
    public void setPurchasingDocumentItemCategory( @Nullable final String purchasingDocumentItemCategory )
    {
        rememberChangedField("PurchasingDocumentItemCategory", this.purchasingDocumentItemCategory);
        this.purchasingDocumentItemCategory = purchasingDocumentItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>FormattedPurchaseContractItem</b>
     * </p>
     *
     * @param formattedPurchaseContractItem
     *            The formattedPurchaseContractItem to set.
     */
    public void setFormattedPurchaseContractItem( @Nullable final String formattedPurchaseContractItem )
    {
        rememberChangedField("FormattedPurchaseContractItem", this.formattedPurchaseContractItem);
        this.formattedPurchaseContractItem = formattedPurchaseContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingCentralMaterial</b>
     * </p>
     *
     * @param purchasingCentralMaterial
     *            Material of External System
     */
    public void setPurchasingCentralMaterial( @Nullable final String purchasingCentralMaterial )
    {
        rememberChangedField("PurchasingCentralMaterial", this.purchasingCentralMaterial);
        this.purchasingCentralMaterial = purchasingCentralMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubRefcdConnectedSystem</b>
     * </p>
     *
     * @param procmtHubRefcdConnectedSystem
     *            Source Connected System ID
     */
    public void setProcmtHubRefcdConnectedSystem( @Nullable final String procmtHubRefcdConnectedSystem )
    {
        rememberChangedField("ProcmtHubRefcdConnectedSystem", this.procmtHubRefcdConnectedSystem);
        this.procmtHubRefcdConnectedSystem = procmtHubRefcdConnectedSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContractItemText</b>
     * </p>
     *
     * @param cntrlPurContractItemText
     *            Short Text
     */
    public void setCntrlPurContractItemText( @Nullable final String cntrlPurContractItemText )
    {
        rememberChangedField("CntrlPurContractItemText", this.cntrlPurContractItemText);
        this.cntrlPurContractItemText = cntrlPurContractItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     *
     * @param productType
     *            Product Type Group
     */
    public void setProductType( @Nullable final String productType )
    {
        rememberChangedField("ProductType", this.productType);
        this.productType = productType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ActivePurchasingDocument</b>
     * </p>
     *
     * @param activePurchasingDocument
     *            Active Purchasing Document
     */
    public void setActivePurchasingDocument( @Nullable final String activePurchasingDocument )
    {
        rememberChangedField("ActivePurchasingDocument", this.activePurchasingDocument);
        this.activePurchasingDocument = activePurchasingDocument;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantity</b>
     * </p>
     *
     * @param netPriceQuantity
     *            Price Unit
     */
    public void setNetPriceQuantity( @Nullable final BigDecimal netPriceQuantity )
    {
        rememberChangedField("NetPriceQuantity", this.netPriceQuantity);
        this.netPriceQuantity = netPriceQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnit</b>
     * </p>
     *
     * @param orderPriceUnit
     *            Order Price Unit (Purchasing)
     */
    public void setOrderPriceUnit( @Nullable final String orderPriceUnit )
    {
        rememberChangedField("OrderPriceUnit", this.orderPriceUnit);
        this.orderPriceUnit = orderPriceUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TargetQuantity</b>
     * </p>
     *
     * @param targetQuantity
     *            Target Quantity
     */
    public void setTargetQuantity( @Nullable final BigDecimal targetQuantity )
    {
        rememberChangedField("TargetQuantity", this.targetQuantity);
        this.targetQuantity = targetQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrItmTargetAmount</b>
     * </p>
     *
     * @param cntrlPurContrItmTargetAmount
     *            Target Value at Item Level in Procurement Hub
     */
    public void setCntrlPurContrItmTargetAmount( @Nullable final BigDecimal cntrlPurContrItmTargetAmount )
    {
        rememberChangedField("CntrlPurContrItmTargetAmount", this.cntrlPurContrItmTargetAmount);
        this.cntrlPurContrItmTargetAmount = cntrlPurContrItmTargetAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ContractNetPriceAmount</b>
     * </p>
     *
     * @param contractNetPriceAmount
     *            Net Price in Purchasing Document (in Document Currency)
     */
    public void setContractNetPriceAmount( @Nullable final BigDecimal contractNetPriceAmount )
    {
        rememberChangedField("ContractNetPriceAmount", this.contractNetPriceAmount);
        this.contractNetPriceAmount = contractNetPriceAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocReleaseOrderQuantity</b>
     * </p>
     *
     * @param purgDocReleaseOrderQuantity
     *            Standard release order quantity
     */
    public void setPurgDocReleaseOrderQuantity( @Nullable final BigDecimal purgDocReleaseOrderQuantity )
    {
        rememberChangedField("PurgDocReleaseOrderQuantity", this.purgDocReleaseOrderQuantity);
        this.purgDocReleaseOrderQuantity = purgDocReleaseOrderQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrdPriceUnitToOrderUnitDnmntr</b>
     * </p>
     *
     * @param ordPriceUnitToOrderUnitDnmntr
     *            Denominator for Conv. of Order Price Unit into Order Unit
     */
    public void setOrdPriceUnitToOrderUnitDnmntr( @Nullable final BigDecimal ordPriceUnitToOrderUnitDnmntr )
    {
        rememberChangedField("OrdPriceUnitToOrderUnitDnmntr", this.ordPriceUnitToOrderUnitDnmntr);
        this.ordPriceUnitToOrderUnitDnmntr = ordPriceUnitToOrderUnitDnmntr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnitToOrderUnitNmrtr</b>
     * </p>
     *
     * @param orderPriceUnitToOrderUnitNmrtr
     *            Numerator for Conversion of Order Price Unit into Order Unit
     */
    public void setOrderPriceUnitToOrderUnitNmrtr( @Nullable final BigDecimal orderPriceUnitToOrderUnitNmrtr )
    {
        rememberChangedField("OrderPriceUnitToOrderUnitNmrtr", this.orderPriceUnitToOrderUnitNmrtr);
        this.orderPriceUnitToOrderUnitNmrtr = orderPriceUnitToOrderUnitNmrtr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder1</b>
     * </p>
     *
     * @param noDaysReminder1
     *            Number of Days for First Reminder/Expediter
     */
    public void setNoDaysReminder1( @Nullable final BigDecimal noDaysReminder1 )
    {
        rememberChangedField("NoDaysReminder1", this.noDaysReminder1);
        this.noDaysReminder1 = noDaysReminder1;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder2</b>
     * </p>
     *
     * @param noDaysReminder2
     *            Number of Days for Second Reminder/Expediter
     */
    public void setNoDaysReminder2( @Nullable final BigDecimal noDaysReminder2 )
    {
        rememberChangedField("NoDaysReminder2", this.noDaysReminder2);
        this.noDaysReminder2 = noDaysReminder2;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder3</b>
     * </p>
     *
     * @param noDaysReminder3
     *            Number of Days for Third Reminder/Expediter
     */
    public void setNoDaysReminder3( @Nullable final BigDecimal noDaysReminder3 )
    {
        rememberChangedField("NoDaysReminder3", this.noDaysReminder3);
        this.noDaysReminder3 = noDaysReminder3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocOrderAcknNumber</b>
     * </p>
     *
     * @param purgDocOrderAcknNumber
     *            Order Acknowledgment Number
     */
    public void setPurgDocOrderAcknNumber( @Nullable final String purgDocOrderAcknNumber )
    {
        rememberChangedField("PurgDocOrderAcknNumber", this.purgDocOrderAcknNumber);
        this.purgDocOrderAcknNumber = purgDocOrderAcknNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequirementTracking</b>
     * </p>
     *
     * @param requirementTracking
     *            Requirement Tracking Number
     */
    public void setRequirementTracking( @Nullable final String requirementTracking )
    {
        rememberChangedField("RequirementTracking", this.requirementTracking);
        this.requirementTracking = requirementTracking;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialNumber</b>
     * </p>
     *
     * @param supplierMaterialNumber
     *            Material Number Used by Supplier
     */
    public void setSupplierMaterialNumber( @Nullable final String supplierMaterialNumber )
    {
        rememberChangedField("SupplierMaterialNumber", this.supplierMaterialNumber);
        this.supplierMaterialNumber = supplierMaterialNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsOrderAcknRqd</b>
     * </p>
     *
     * @param isOrderAcknRqd
     *            Order Acknowledgment Requirement
     */
    public void setIsOrderAcknRqd( @Nullable final Boolean isOrderAcknRqd )
    {
        rememberChangedField("IsOrderAcknRqd", this.isOrderAcknRqd);
        this.isOrderAcknRqd = isOrderAcknRqd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocEstimatedPrice</b>
     * </p>
     *
     * @param purgDocEstimatedPrice
     *            Indicator: Estimated Price
     */
    public void setPurgDocEstimatedPrice( @Nullable final Boolean purgDocEstimatedPrice )
    {
        rememberChangedField("PurgDocEstimatedPrice", this.purgDocEstimatedPrice);
        this.purgDocEstimatedPrice = purgDocEstimatedPrice;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriceIsToBePrinted</b>
     * </p>
     *
     * @param priceIsToBePrinted
     *            Price Printout
     */
    public void setPriceIsToBePrinted( @Nullable final Boolean priceIsToBePrinted )
    {
        rememberChangedField("PriceIsToBePrinted", this.priceIsToBePrinted);
        this.priceIsToBePrinted = priceIsToBePrinted;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @param underdelivTolrtdLmtRatioInPct
     *            Underdelivery Tolerance
     */
    public void setUnderdelivTolrtdLmtRatioInPct( @Nullable final BigDecimal underdelivTolrtdLmtRatioInPct )
    {
        rememberChangedField("UnderdelivTolrtdLmtRatioInPct", this.underdelivTolrtdLmtRatioInPct);
        this.underdelivTolrtdLmtRatioInPct = underdelivTolrtdLmtRatioInPct;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @param overdelivTolrtdLmtRatioInPct
     *            Overdelivery Tolerance
     */
    public void setOverdelivTolrtdLmtRatioInPct( @Nullable final BigDecimal overdelivTolrtdLmtRatioInPct )
    {
        rememberChangedField("OverdelivTolrtdLmtRatioInPct", this.overdelivTolrtdLmtRatioInPct);
        this.overdelivTolrtdLmtRatioInPct = overdelivTolrtdLmtRatioInPct;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverdeliveryIsAllowed</b>
     * </p>
     *
     * @param unlimitedOverdeliveryIsAllowed
     *            Unlimited Overdelivery Allowed
     */
    public void setUnlimitedOverdeliveryIsAllowed( @Nullable final Boolean unlimitedOverdeliveryIsAllowed )
    {
        rememberChangedField("UnlimitedOverdeliveryIsAllowed", this.unlimitedOverdeliveryIsAllowed);
        this.unlimitedOverdeliveryIsAllowed = unlimitedOverdeliveryIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockType</b>
     * </p>
     *
     * @param stockType
     *            Stock Type
     */
    public void setStockType( @Nullable final String stockType )
    {
        rememberChangedField("StockType", this.stockType);
        this.stockType = stockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingInstruction</b>
     * </p>
     *
     * @param shippingInstruction
     *            Shipping Instructions
     */
    public void setShippingInstruction( @Nullable final String shippingInstruction )
    {
        rememberChangedField("ShippingInstruction", this.shippingInstruction);
        this.shippingInstruction = shippingInstruction;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsExpected</b>
     * </p>
     *
     * @param goodsReceiptIsExpected
     *            Goods Receipt Indicator
     */
    public void setGoodsReceiptIsExpected( @Nullable final Boolean goodsReceiptIsExpected )
    {
        rememberChangedField("GoodsReceiptIsExpected", this.goodsReceiptIsExpected);
        this.goodsReceiptIsExpected = goodsReceiptIsExpected;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsNonValuated</b>
     * </p>
     *
     * @param goodsReceiptIsNonValuated
     *            Goods Receipt, Non-Valuated
     */
    public void setGoodsReceiptIsNonValuated( @Nullable final Boolean goodsReceiptIsNonValuated )
    {
        rememberChangedField("GoodsReceiptIsNonValuated", this.goodsReceiptIsNonValuated);
        this.goodsReceiptIsNonValuated = goodsReceiptIsNonValuated;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsExpected</b>
     * </p>
     *
     * @param invoiceIsExpected
     *            Invoice Receipt Indicator
     */
    public void setInvoiceIsExpected( @Nullable final Boolean invoiceIsExpected )
    {
        rememberChangedField("InvoiceIsExpected", this.invoiceIsExpected);
        this.invoiceIsExpected = invoiceIsExpected;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsGoodsReceiptBased</b>
     * </p>
     *
     * @param invoiceIsGoodsReceiptBased
     *            Indicator: GR-Based Invoice Verification
     */
    public void setInvoiceIsGoodsReceiptBased( @Nullable final Boolean invoiceIsGoodsReceiptBased )
    {
        rememberChangedField("InvoiceIsGoodsReceiptBased", this.invoiceIsGoodsReceiptBased);
        this.invoiceIsGoodsReceiptBased = invoiceIsGoodsReceiptBased;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EvaldRcptSettlmtIsAllowed</b>
     * </p>
     *
     * @param evaldRcptSettlmtIsAllowed
     *            Evaluated Receipt Settlement (ERS)
     */
    public void setEvaldRcptSettlmtIsAllowed( @Nullable final Boolean evaldRcptSettlmtIsAllowed )
    {
        rememberChangedField("EvaldRcptSettlmtIsAllowed", this.evaldRcptSettlmtIsAllowed);
        this.evaldRcptSettlmtIsAllowed = evaldRcptSettlmtIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingContractDeletionCode</b>
     * </p>
     *
     * @param purchasingContractDeletionCode
     *            Deletion Indicator in Purchasing Document
     */
    public void setPurchasingContractDeletionCode( @Nullable final String purchasingContractDeletionCode )
    {
        rememberChangedField("PurchasingContractDeletionCode", this.purchasingContractDeletionCode);
        this.purchasingContractDeletionCode = purchasingContractDeletionCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OutlineAgrmtItmIsBlocked</b>
     * </p>
     *
     * @param outlineAgrmtItmIsBlocked
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setOutlineAgrmtItmIsBlocked( @Nullable final Boolean outlineAgrmtItmIsBlocked )
    {
        rememberChangedField("OutlineAgrmtItmIsBlocked", this.outlineAgrmtItmIsBlocked);
        this.outlineAgrmtItmIsBlocked = outlineAgrmtItmIsBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocItmBlkRsnCode</b>
     * </p>
     *
     * @param purgDocItmBlkRsnCode
     *            Blocking Reason - ID
     */
    public void setPurgDocItmBlkRsnCode( @Nullable final String purgDocItmBlkRsnCode )
    {
        rememberChangedField("PurgDocItmBlkRsnCode", this.purgDocItmBlkRsnCode);
        this.purgDocItmBlkRsnCode = purgDocItmBlkRsnCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocItemRenegotiationStatus</b>
     * </p>
     *
     * @param purgDocItemRenegotiationStatus
     *            Renegotiation Status
     */
    public void setPurgDocItemRenegotiationStatus( @Nullable final String purgDocItemRenegotiationStatus )
    {
        rememberChangedField("PurgDocItemRenegotiationStatus", this.purgDocItemRenegotiationStatus);
        this.purgDocItemRenegotiationStatus = purgDocItemRenegotiationStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingParentItem</b>
     * </p>
     *
     * @param purchasingParentItem
     *            Higher-Level Item in Purchasing Documents
     */
    public void setPurchasingParentItem( @Nullable final String purchasingParentItem )
    {
        rememberChangedField("PurchasingParentItem", this.purchasingParentItem);
        this.purchasingParentItem = purchasingParentItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsOutline</b>
     * </p>
     *
     * @param isOutline
     *            Item is statistical
     */
    public void setIsOutline( @Nullable final Boolean isOutline )
    {
        rememberChangedField("IsOutline", this.isOutline);
        this.isOutline = isOutline;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurgConfigurableItemNumber</b>
     * </p>
     *
     * @param purgConfigurableItemNumber
     *            Hierarchy Number
     */
    public void setPurgConfigurableItemNumber( @Nullable final String purgConfigurableItemNumber )
    {
        rememberChangedField("PurgConfigurableItemNumber", this.purgConfigurableItemNumber);
        this.purgConfigurableItemNumber = purgConfigurableItemNumber;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CntrlPurchaseContractItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CentralPurchaseContract", getCentralPurchaseContract());
        result.put("CentralPurchaseContractItem", getCentralPurchaseContractItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CentralPurchaseContract", getCentralPurchaseContract());
        values.put("CentralPurchaseContractItem", getCentralPurchaseContractItem());
        values.put("PurchasingDocumentItemCategory", getPurchasingDocumentItemCategory());
        values.put("FormattedPurchaseContractItem", getFormattedPurchaseContractItem());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("PurchasingCentralMaterial", getPurchasingCentralMaterial());
        values.put("ProcmtHubRefcdConnectedSystem", getProcmtHubRefcdConnectedSystem());
        values.put("CntrlPurContractItemText", getCntrlPurContractItemText());
        values.put("ProductType", getProductType());
        values.put("ActivePurchasingDocument", getActivePurchasingDocument());
        values.put("NetPriceQuantity", getNetPriceQuantity());
        values.put("OrderPriceUnit", getOrderPriceUnit());
        values.put("TargetQuantity", getTargetQuantity());
        values.put("CntrlPurContrItmTargetAmount", getCntrlPurContrItmTargetAmount());
        values.put("ContractNetPriceAmount", getContractNetPriceAmount());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("PurgDocReleaseOrderQuantity", getPurgDocReleaseOrderQuantity());
        values.put("OrdPriceUnitToOrderUnitDnmntr", getOrdPriceUnitToOrderUnitDnmntr());
        values.put("OrderPriceUnitToOrderUnitNmrtr", getOrderPriceUnitToOrderUnitNmrtr());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("NoDaysReminder1", getNoDaysReminder1());
        values.put("NoDaysReminder2", getNoDaysReminder2());
        values.put("NoDaysReminder3", getNoDaysReminder3());
        values.put("PurgDocOrderAcknNumber", getPurgDocOrderAcknNumber());
        values.put("RequirementTracking", getRequirementTracking());
        values.put("SupplierMaterialNumber", getSupplierMaterialNumber());
        values.put("IsOrderAcknRqd", getIsOrderAcknRqd());
        values.put("PurgDocEstimatedPrice", getPurgDocEstimatedPrice());
        values.put("PriceIsToBePrinted", getPriceIsToBePrinted());
        values.put("UnderdelivTolrtdLmtRatioInPct", getUnderdelivTolrtdLmtRatioInPct());
        values.put("OverdelivTolrtdLmtRatioInPct", getOverdelivTolrtdLmtRatioInPct());
        values.put("UnlimitedOverdeliveryIsAllowed", getUnlimitedOverdeliveryIsAllowed());
        values.put("StockType", getStockType());
        values.put("TaxCode", getTaxCode());
        values.put("ShippingInstruction", getShippingInstruction());
        values.put("GoodsReceiptIsExpected", getGoodsReceiptIsExpected());
        values.put("GoodsReceiptIsNonValuated", getGoodsReceiptIsNonValuated());
        values.put("InvoiceIsExpected", getInvoiceIsExpected());
        values.put("InvoiceIsGoodsReceiptBased", getInvoiceIsGoodsReceiptBased());
        values.put("EvaldRcptSettlmtIsAllowed", getEvaldRcptSettlmtIsAllowed());
        values.put("PurchasingContractDeletionCode", getPurchasingContractDeletionCode());
        values.put("OutlineAgrmtItmIsBlocked", getOutlineAgrmtItmIsBlocked());
        values.put("PurgDocItmBlkRsnCode", getPurgDocItmBlkRsnCode());
        values.put("PurgDocItemRenegotiationStatus", getPurgDocItemRenegotiationStatus());
        values.put("PurchasingParentItem", getPurchasingParentItem());
        values.put("IsOutline", getIsOutline());
        values.put("PurgConfigurableItemNumber", getPurgConfigurableItemNumber());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CentralPurchaseContract") ) {
                final Object value = values.remove("CentralPurchaseContract");
                if( (value == null) || (!value.equals(getCentralPurchaseContract())) ) {
                    setCentralPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("CentralPurchaseContractItem") ) {
                final Object value = values.remove("CentralPurchaseContractItem");
                if( (value == null) || (!value.equals(getCentralPurchaseContractItem())) ) {
                    setCentralPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItemCategory") ) {
                final Object value = values.remove("PurchasingDocumentItemCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentItemCategory())) ) {
                    setPurchasingDocumentItemCategory(((String) value));
                }
            }
            if( values.containsKey("FormattedPurchaseContractItem") ) {
                final Object value = values.remove("FormattedPurchaseContractItem");
                if( (value == null) || (!value.equals(getFormattedPurchaseContractItem())) ) {
                    setFormattedPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("PurchasingCentralMaterial") ) {
                final Object value = values.remove("PurchasingCentralMaterial");
                if( (value == null) || (!value.equals(getPurchasingCentralMaterial())) ) {
                    setPurchasingCentralMaterial(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubRefcdConnectedSystem") ) {
                final Object value = values.remove("ProcmtHubRefcdConnectedSystem");
                if( (value == null) || (!value.equals(getProcmtHubRefcdConnectedSystem())) ) {
                    setProcmtHubRefcdConnectedSystem(((String) value));
                }
            }
            if( values.containsKey("CntrlPurContractItemText") ) {
                final Object value = values.remove("CntrlPurContractItemText");
                if( (value == null) || (!value.equals(getCntrlPurContractItemText())) ) {
                    setCntrlPurContractItemText(((String) value));
                }
            }
            if( values.containsKey("ProductType") ) {
                final Object value = values.remove("ProductType");
                if( (value == null) || (!value.equals(getProductType())) ) {
                    setProductType(((String) value));
                }
            }
            if( values.containsKey("ActivePurchasingDocument") ) {
                final Object value = values.remove("ActivePurchasingDocument");
                if( (value == null) || (!value.equals(getActivePurchasingDocument())) ) {
                    setActivePurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("NetPriceQuantity") ) {
                final Object value = values.remove("NetPriceQuantity");
                if( (value == null) || (!value.equals(getNetPriceQuantity())) ) {
                    setNetPriceQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderPriceUnit") ) {
                final Object value = values.remove("OrderPriceUnit");
                if( (value == null) || (!value.equals(getOrderPriceUnit())) ) {
                    setOrderPriceUnit(((String) value));
                }
            }
            if( values.containsKey("TargetQuantity") ) {
                final Object value = values.remove("TargetQuantity");
                if( (value == null) || (!value.equals(getTargetQuantity())) ) {
                    setTargetQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("CntrlPurContrItmTargetAmount") ) {
                final Object value = values.remove("CntrlPurContrItmTargetAmount");
                if( (value == null) || (!value.equals(getCntrlPurContrItmTargetAmount())) ) {
                    setCntrlPurContrItmTargetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ContractNetPriceAmount") ) {
                final Object value = values.remove("ContractNetPriceAmount");
                if( (value == null) || (!value.equals(getContractNetPriceAmount())) ) {
                    setContractNetPriceAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("PurgDocReleaseOrderQuantity") ) {
                final Object value = values.remove("PurgDocReleaseOrderQuantity");
                if( (value == null) || (!value.equals(getPurgDocReleaseOrderQuantity())) ) {
                    setPurgDocReleaseOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrdPriceUnitToOrderUnitDnmntr") ) {
                final Object value = values.remove("OrdPriceUnitToOrderUnitDnmntr");
                if( (value == null) || (!value.equals(getOrdPriceUnitToOrderUnitDnmntr())) ) {
                    setOrdPriceUnitToOrderUnitDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderPriceUnitToOrderUnitNmrtr") ) {
                final Object value = values.remove("OrderPriceUnitToOrderUnitNmrtr");
                if( (value == null) || (!value.equals(getOrderPriceUnitToOrderUnitNmrtr())) ) {
                    setOrderPriceUnitToOrderUnitNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("NoDaysReminder1") ) {
                final Object value = values.remove("NoDaysReminder1");
                if( (value == null) || (!value.equals(getNoDaysReminder1())) ) {
                    setNoDaysReminder1(((BigDecimal) value));
                }
            }
            if( values.containsKey("NoDaysReminder2") ) {
                final Object value = values.remove("NoDaysReminder2");
                if( (value == null) || (!value.equals(getNoDaysReminder2())) ) {
                    setNoDaysReminder2(((BigDecimal) value));
                }
            }
            if( values.containsKey("NoDaysReminder3") ) {
                final Object value = values.remove("NoDaysReminder3");
                if( (value == null) || (!value.equals(getNoDaysReminder3())) ) {
                    setNoDaysReminder3(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurgDocOrderAcknNumber") ) {
                final Object value = values.remove("PurgDocOrderAcknNumber");
                if( (value == null) || (!value.equals(getPurgDocOrderAcknNumber())) ) {
                    setPurgDocOrderAcknNumber(((String) value));
                }
            }
            if( values.containsKey("RequirementTracking") ) {
                final Object value = values.remove("RequirementTracking");
                if( (value == null) || (!value.equals(getRequirementTracking())) ) {
                    setRequirementTracking(((String) value));
                }
            }
            if( values.containsKey("SupplierMaterialNumber") ) {
                final Object value = values.remove("SupplierMaterialNumber");
                if( (value == null) || (!value.equals(getSupplierMaterialNumber())) ) {
                    setSupplierMaterialNumber(((String) value));
                }
            }
            if( values.containsKey("IsOrderAcknRqd") ) {
                final Object value = values.remove("IsOrderAcknRqd");
                if( (value == null) || (!value.equals(getIsOrderAcknRqd())) ) {
                    setIsOrderAcknRqd(((Boolean) value));
                }
            }
            if( values.containsKey("PurgDocEstimatedPrice") ) {
                final Object value = values.remove("PurgDocEstimatedPrice");
                if( (value == null) || (!value.equals(getPurgDocEstimatedPrice())) ) {
                    setPurgDocEstimatedPrice(((Boolean) value));
                }
            }
            if( values.containsKey("PriceIsToBePrinted") ) {
                final Object value = values.remove("PriceIsToBePrinted");
                if( (value == null) || (!value.equals(getPriceIsToBePrinted())) ) {
                    setPriceIsToBePrinted(((Boolean) value));
                }
            }
            if( values.containsKey("UnderdelivTolrtdLmtRatioInPct") ) {
                final Object value = values.remove("UnderdelivTolrtdLmtRatioInPct");
                if( (value == null) || (!value.equals(getUnderdelivTolrtdLmtRatioInPct())) ) {
                    setUnderdelivTolrtdLmtRatioInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("OverdelivTolrtdLmtRatioInPct") ) {
                final Object value = values.remove("OverdelivTolrtdLmtRatioInPct");
                if( (value == null) || (!value.equals(getOverdelivTolrtdLmtRatioInPct())) ) {
                    setOverdelivTolrtdLmtRatioInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnlimitedOverdeliveryIsAllowed") ) {
                final Object value = values.remove("UnlimitedOverdeliveryIsAllowed");
                if( (value == null) || (!value.equals(getUnlimitedOverdeliveryIsAllowed())) ) {
                    setUnlimitedOverdeliveryIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("StockType") ) {
                final Object value = values.remove("StockType");
                if( (value == null) || (!value.equals(getStockType())) ) {
                    setStockType(((String) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("ShippingInstruction") ) {
                final Object value = values.remove("ShippingInstruction");
                if( (value == null) || (!value.equals(getShippingInstruction())) ) {
                    setShippingInstruction(((String) value));
                }
            }
            if( values.containsKey("GoodsReceiptIsExpected") ) {
                final Object value = values.remove("GoodsReceiptIsExpected");
                if( (value == null) || (!value.equals(getGoodsReceiptIsExpected())) ) {
                    setGoodsReceiptIsExpected(((Boolean) value));
                }
            }
            if( values.containsKey("GoodsReceiptIsNonValuated") ) {
                final Object value = values.remove("GoodsReceiptIsNonValuated");
                if( (value == null) || (!value.equals(getGoodsReceiptIsNonValuated())) ) {
                    setGoodsReceiptIsNonValuated(((Boolean) value));
                }
            }
            if( values.containsKey("InvoiceIsExpected") ) {
                final Object value = values.remove("InvoiceIsExpected");
                if( (value == null) || (!value.equals(getInvoiceIsExpected())) ) {
                    setInvoiceIsExpected(((Boolean) value));
                }
            }
            if( values.containsKey("InvoiceIsGoodsReceiptBased") ) {
                final Object value = values.remove("InvoiceIsGoodsReceiptBased");
                if( (value == null) || (!value.equals(getInvoiceIsGoodsReceiptBased())) ) {
                    setInvoiceIsGoodsReceiptBased(((Boolean) value));
                }
            }
            if( values.containsKey("EvaldRcptSettlmtIsAllowed") ) {
                final Object value = values.remove("EvaldRcptSettlmtIsAllowed");
                if( (value == null) || (!value.equals(getEvaldRcptSettlmtIsAllowed())) ) {
                    setEvaldRcptSettlmtIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("PurchasingContractDeletionCode") ) {
                final Object value = values.remove("PurchasingContractDeletionCode");
                if( (value == null) || (!value.equals(getPurchasingContractDeletionCode())) ) {
                    setPurchasingContractDeletionCode(((String) value));
                }
            }
            if( values.containsKey("OutlineAgrmtItmIsBlocked") ) {
                final Object value = values.remove("OutlineAgrmtItmIsBlocked");
                if( (value == null) || (!value.equals(getOutlineAgrmtItmIsBlocked())) ) {
                    setOutlineAgrmtItmIsBlocked(((Boolean) value));
                }
            }
            if( values.containsKey("PurgDocItmBlkRsnCode") ) {
                final Object value = values.remove("PurgDocItmBlkRsnCode");
                if( (value == null) || (!value.equals(getPurgDocItmBlkRsnCode())) ) {
                    setPurgDocItmBlkRsnCode(((String) value));
                }
            }
            if( values.containsKey("PurgDocItemRenegotiationStatus") ) {
                final Object value = values.remove("PurgDocItemRenegotiationStatus");
                if( (value == null) || (!value.equals(getPurgDocItemRenegotiationStatus())) ) {
                    setPurgDocItemRenegotiationStatus(((String) value));
                }
            }
            if( values.containsKey("PurchasingParentItem") ) {
                final Object value = values.remove("PurchasingParentItem");
                if( (value == null) || (!value.equals(getPurchasingParentItem())) ) {
                    setPurchasingParentItem(((String) value));
                }
            }
            if( values.containsKey("IsOutline") ) {
                final Object value = values.remove("IsOutline");
                if( (value == null) || (!value.equals(getIsOutline())) ) {
                    setIsOutline(((Boolean) value));
                }
            }
            if( values.containsKey("PurgConfigurableItemNumber") ) {
                final Object value = values.remove("PurgConfigurableItemNumber");
                if( (value == null) || (!value.equals(getPurgConfigurableItemNumber())) ) {
                    setPurgConfigurableItemNumber(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CentralPurchaseContract") ) {
                final Object value = (values).remove("to_CentralPurchaseContract");
                if( value instanceof Map ) {
                    if( toCentralPurchaseContract == null ) {
                        toCentralPurchaseContract = new CentralPurchaseContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCentralPurchaseContract.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CntrlPurConItmDistribution") ) {
                final Object value = (values).remove("to_CntrlPurConItmDistribution");
                if( value instanceof Iterable ) {
                    if( toCntrlPurConItmDistribution == null ) {
                        toCntrlPurConItmDistribution = Lists.newArrayList();
                    } else {
                        toCntrlPurConItmDistribution = Lists.newArrayList(toCntrlPurConItmDistribution);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurContrItmDistribution entity;
                        if( toCntrlPurConItmDistribution.size() > i ) {
                            entity = toCntrlPurConItmDistribution.get(i);
                        } else {
                            entity = new CntrlPurContrItmDistribution();
                            toCntrlPurConItmDistribution.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CntrlPurContrItmCmmdtyQty") ) {
                final Object value = (values).remove("to_CntrlPurContrItmCmmdtyQty");
                if( value instanceof Iterable ) {
                    if( toCntrlPurContrItmCmmdtyQty == null ) {
                        toCntrlPurContrItmCmmdtyQty = Lists.newArrayList();
                    } else {
                        toCntrlPurContrItmCmmdtyQty = Lists.newArrayList(toCntrlPurContrItmCmmdtyQty);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurContrItmCmmdtyQty entity;
                        if( toCntrlPurContrItmCmmdtyQty.size() > i ) {
                            entity = toCntrlPurContrItmCmmdtyQty.get(i);
                        } else {
                            entity = new CntrlPurContrItmCmmdtyQty();
                            toCntrlPurContrItmCmmdtyQty.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CntrlPurContrItmCndnValdty") ) {
                final Object value = (values).remove("to_CntrlPurContrItmCndnValdty");
                if( value instanceof Iterable ) {
                    if( toCntrlPurContrItmCndnValdty == null ) {
                        toCntrlPurContrItmCndnValdty = Lists.newArrayList();
                    } else {
                        toCntrlPurContrItmCndnValdty = Lists.newArrayList(toCntrlPurContrItmCndnValdty);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurContrItmCndnValdty entity;
                        if( toCntrlPurContrItmCndnValdty.size() > i ) {
                            entity = toCntrlPurContrItmCndnValdty.get(i);
                        } else {
                            entity = new CntrlPurContrItmCndnValdty();
                            toCntrlPurContrItmCndnValdty.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CntrlPurContrItmNotes") ) {
                final Object value = (values).remove("to_CntrlPurContrItmNotes");
                if( value instanceof Iterable ) {
                    if( toCntrlPurContrItmNotes == null ) {
                        toCntrlPurContrItmNotes = Lists.newArrayList();
                    } else {
                        toCntrlPurContrItmNotes = Lists.newArrayList(toCntrlPurContrItmNotes);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurContractItemNotes entity;
                        if( toCntrlPurContrItmNotes.size() > i ) {
                            entity = toCntrlPurContrItmNotes.get(i);
                        } else {
                            entity = new CntrlPurContractItemNotes();
                            toCntrlPurContrItmNotes.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CntrlPurchaseContractItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CntrlPurchaseContractItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CntrlPurchaseContractItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CntrlPurchaseContractItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCentralPurchaseContract != null ) {
            (values).put("to_CentralPurchaseContract", toCentralPurchaseContract);
        }
        if( toCntrlPurConItmDistribution != null ) {
            (values).put("to_CntrlPurConItmDistribution", toCntrlPurConItmDistribution);
        }
        if( toCntrlPurContrItmCmmdtyQty != null ) {
            (values).put("to_CntrlPurContrItmCmmdtyQty", toCntrlPurContrItmCmmdtyQty);
        }
        if( toCntrlPurContrItmCndnValdty != null ) {
            (values).put("to_CntrlPurContrItmCndnValdty", toCntrlPurContrItmCndnValdty);
        }
        if( toCntrlPurContrItmNotes != null ) {
            (values).put("to_CntrlPurContrItmNotes", toCntrlPurContrItmNotes);
        }
        return values;
    }

    /**
     * Fetches the <b>CentralPurchaseContract</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CentralPurchaseContract</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CentralPurchaseContract fetchCentralPurchaseContract()
    {
        return fetchFieldAsSingle("to_CentralPurchaseContract", CentralPurchaseContract.class);
    }

    /**
     * Retrieval of associated <b>CentralPurchaseContract</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * If the navigation property <b>to_CentralPurchaseContract</b> of a queried <b>CntrlPurchaseContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CentralPurchaseContract</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CentralPurchaseContract getCentralPurchaseContractOrFetch()
    {
        if( toCentralPurchaseContract == null ) {
            toCentralPurchaseContract = fetchCentralPurchaseContract();
        }
        return toCentralPurchaseContract;
    }

    /**
     * Retrieval of associated <b>CentralPurchaseContract</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurchaseContractItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CentralPurchaseContract</b> is already loaded, the
     *         result will contain the <b>CentralPurchaseContract</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CentralPurchaseContract> getCentralPurchaseContractIfPresent()
    {
        return Option.of(toCentralPurchaseContract);
    }

    /**
     * Overwrites the associated <b>CentralPurchaseContract</b> entity for the loaded navigation property
     * <b>to_CentralPurchaseContract</b>.
     *
     * @param value
     *            New <b>CentralPurchaseContract</b> entity.
     */
    public void setCentralPurchaseContract( final CentralPurchaseContract value )
    {
        toCentralPurchaseContract = value;
    }

    /**
     * Fetches the <b>CntrlPurContrItmDistribution</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CntrlPurConItmDistribution</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurContrItmDistribution</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrItmDistribution> fetchCntrlPurConItmDistribution()
    {
        return fetchFieldAsList("to_CntrlPurConItmDistribution", CntrlPurContrItmDistribution.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContrItmDistribution</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurConItmDistribution</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurConItmDistribution</b> of a queried <b>CntrlPurchaseContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContrItmDistribution</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrItmDistribution> getCntrlPurConItmDistributionOrFetch()
    {
        if( toCntrlPurConItmDistribution == null ) {
            toCntrlPurConItmDistribution = fetchCntrlPurConItmDistribution();
        }
        return toCntrlPurConItmDistribution;
    }

    /**
     * Retrieval of associated <b>CntrlPurContrItmDistribution</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurConItmDistribution</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurchaseContractItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlPurConItmDistribution</b> is already loaded, the
     *         result will contain the <b>CntrlPurContrItmDistribution</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurContrItmDistribution>> getCntrlPurConItmDistributionIfPresent()
    {
        return Option.of(toCntrlPurConItmDistribution);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurContrItmDistribution</b> entities for the loaded navigation property
     * <b>to_CntrlPurConItmDistribution</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurConItmDistribution</b> of a queried <b>CntrlPurchaseContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurContrItmDistribution</b> entities.
     */
    public void setCntrlPurConItmDistribution( @Nonnull final List<CntrlPurContrItmDistribution> value )
    {
        if( toCntrlPurConItmDistribution == null ) {
            toCntrlPurConItmDistribution = Lists.newArrayList();
        }
        toCntrlPurConItmDistribution.clear();
        toCntrlPurConItmDistribution.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurContrItmDistribution</b> entities. This corresponds to the
     * OData navigation property <b>to_CntrlPurConItmDistribution</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurConItmDistribution</b> of a queried <b>CntrlPurchaseContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurContrItmDistribution</b> entities.
     */
    public void addCntrlPurConItmDistribution( CntrlPurContrItmDistribution... entity )
    {
        if( toCntrlPurConItmDistribution == null ) {
            toCntrlPurConItmDistribution = Lists.newArrayList();
        }
        toCntrlPurConItmDistribution.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CntrlPurContrItmCmmdtyQty</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CntrlPurContrItmCmmdtyQty</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurContrItmCmmdtyQty</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrItmCmmdtyQty> fetchCntrlPurContrItmCmmdtyQty()
    {
        return fetchFieldAsList("to_CntrlPurContrItmCmmdtyQty", CntrlPurContrItmCmmdtyQty.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContrItmCmmdtyQty</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmCmmdtyQty</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmCmmdtyQty</b> of a queried <b>CntrlPurchaseContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContrItmCmmdtyQty</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrItmCmmdtyQty> getCntrlPurContrItmCmmdtyQtyOrFetch()
    {
        if( toCntrlPurContrItmCmmdtyQty == null ) {
            toCntrlPurContrItmCmmdtyQty = fetchCntrlPurContrItmCmmdtyQty();
        }
        return toCntrlPurContrItmCmmdtyQty;
    }

    /**
     * Retrieval of associated <b>CntrlPurContrItmCmmdtyQty</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmCmmdtyQty</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurchaseContractItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlPurContrItmCmmdtyQty</b> is already loaded, the
     *         result will contain the <b>CntrlPurContrItmCmmdtyQty</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurContrItmCmmdtyQty>> getCntrlPurContrItmCmmdtyQtyIfPresent()
    {
        return Option.of(toCntrlPurContrItmCmmdtyQty);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurContrItmCmmdtyQty</b> entities for the loaded navigation property
     * <b>to_CntrlPurContrItmCmmdtyQty</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmCmmdtyQty</b> of a queried <b>CntrlPurchaseContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurContrItmCmmdtyQty</b> entities.
     */
    public void setCntrlPurContrItmCmmdtyQty( @Nonnull final List<CntrlPurContrItmCmmdtyQty> value )
    {
        if( toCntrlPurContrItmCmmdtyQty == null ) {
            toCntrlPurContrItmCmmdtyQty = Lists.newArrayList();
        }
        toCntrlPurContrItmCmmdtyQty.clear();
        toCntrlPurContrItmCmmdtyQty.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurContrItmCmmdtyQty</b> entities. This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmCmmdtyQty</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmCmmdtyQty</b> of a queried <b>CntrlPurchaseContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurContrItmCmmdtyQty</b> entities.
     */
    public void addCntrlPurContrItmCmmdtyQty( CntrlPurContrItmCmmdtyQty... entity )
    {
        if( toCntrlPurContrItmCmmdtyQty == null ) {
            toCntrlPurContrItmCmmdtyQty = Lists.newArrayList();
        }
        toCntrlPurContrItmCmmdtyQty.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CntrlPurContrItmCndnValdty</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CntrlPurContrItmCndnValdty</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurContrItmCndnValdty</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrItmCndnValdty> fetchCntrlPurContrItmCndnValdty()
    {
        return fetchFieldAsList("to_CntrlPurContrItmCndnValdty", CntrlPurContrItmCndnValdty.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContrItmCndnValdty</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmCndnValdty</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmCndnValdty</b> of a queried <b>CntrlPurchaseContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContrItmCndnValdty</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrItmCndnValdty> getCntrlPurContrItmCndnValdtyOrFetch()
    {
        if( toCntrlPurContrItmCndnValdty == null ) {
            toCntrlPurContrItmCndnValdty = fetchCntrlPurContrItmCndnValdty();
        }
        return toCntrlPurContrItmCndnValdty;
    }

    /**
     * Retrieval of associated <b>CntrlPurContrItmCndnValdty</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmCndnValdty</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurchaseContractItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlPurContrItmCndnValdty</b> is already loaded, the
     *         result will contain the <b>CntrlPurContrItmCndnValdty</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurContrItmCndnValdty>> getCntrlPurContrItmCndnValdtyIfPresent()
    {
        return Option.of(toCntrlPurContrItmCndnValdty);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurContrItmCndnValdty</b> entities for the loaded navigation property
     * <b>to_CntrlPurContrItmCndnValdty</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmCndnValdty</b> of a queried <b>CntrlPurchaseContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurContrItmCndnValdty</b> entities.
     */
    public void setCntrlPurContrItmCndnValdty( @Nonnull final List<CntrlPurContrItmCndnValdty> value )
    {
        if( toCntrlPurContrItmCndnValdty == null ) {
            toCntrlPurContrItmCndnValdty = Lists.newArrayList();
        }
        toCntrlPurContrItmCndnValdty.clear();
        toCntrlPurContrItmCndnValdty.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurContrItmCndnValdty</b> entities. This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmCndnValdty</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmCndnValdty</b> of a queried <b>CntrlPurchaseContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurContrItmCndnValdty</b> entities.
     */
    public void addCntrlPurContrItmCndnValdty( CntrlPurContrItmCndnValdty... entity )
    {
        if( toCntrlPurContrItmCndnValdty == null ) {
            toCntrlPurContrItmCndnValdty = Lists.newArrayList();
        }
        toCntrlPurContrItmCndnValdty.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CntrlPurContractItemNotes</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CntrlPurContrItmNotes</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurContractItemNotes</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContractItemNotes> fetchCntrlPurContrItmNotes()
    {
        return fetchFieldAsList("to_CntrlPurContrItmNotes", CntrlPurContractItemNotes.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContractItemNotes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmNotes</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmNotes</b> of a queried <b>CntrlPurchaseContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContractItemNotes</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContractItemNotes> getCntrlPurContrItmNotesOrFetch()
    {
        if( toCntrlPurContrItmNotes == null ) {
            toCntrlPurContrItmNotes = fetchCntrlPurContrItmNotes();
        }
        return toCntrlPurContrItmNotes;
    }

    /**
     * Retrieval of associated <b>CntrlPurContractItemNotes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmNotes</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurchaseContractItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlPurContrItmNotes</b> is already loaded, the result
     *         will contain the <b>CntrlPurContractItemNotes</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurContractItemNotes>> getCntrlPurContrItmNotesIfPresent()
    {
        return Option.of(toCntrlPurContrItmNotes);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurContractItemNotes</b> entities for the loaded navigation property
     * <b>to_CntrlPurContrItmNotes</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmNotes</b> of a queried <b>CntrlPurchaseContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurContractItemNotes</b> entities.
     */
    public void setCntrlPurContrItmNotes( @Nonnull final List<CntrlPurContractItemNotes> value )
    {
        if( toCntrlPurContrItmNotes == null ) {
            toCntrlPurContrItmNotes = Lists.newArrayList();
        }
        toCntrlPurContrItmNotes.clear();
        toCntrlPurContrItmNotes.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurContractItemNotes</b> entities. This corresponds to the OData
     * navigation property <b>to_CntrlPurContrItmNotes</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrItmNotes</b> of a queried <b>CntrlPurchaseContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurContractItemNotes</b> entities.
     */
    public void addCntrlPurContrItmNotes( CntrlPurContractItemNotes... entity )
    {
        if( toCntrlPurContrItmNotes == null ) {
            toCntrlPurContrItmNotes = Lists.newArrayList();
        }
        toCntrlPurContrItmNotes.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CntrlPurchaseContractItem instances.
     *
     */
    public final static class CntrlPurchaseContractItemBuilder
    {

        private CentralPurchaseContract toCentralPurchaseContract;
        private String centralPurchaseContract = null;
        private List<CntrlPurContrItmDistribution> toCntrlPurConItmDistribution = Lists.newArrayList();
        private List<CntrlPurContrItmCmmdtyQty> toCntrlPurContrItmCmmdtyQty = Lists.newArrayList();
        private List<CntrlPurContrItmCndnValdty> toCntrlPurContrItmCndnValdty = Lists.newArrayList();
        private List<CntrlPurContractItemNotes> toCntrlPurContrItmNotes = Lists.newArrayList();

        private CntrlPurchaseContractItem.CntrlPurchaseContractItemBuilder toCentralPurchaseContract(
            final CentralPurchaseContract value )
        {
            toCentralPurchaseContract = value;
            return this;
        }

        /**
         * Navigation property <b>to_CentralPurchaseContract</b> for <b>CntrlPurchaseContractItem</b> to single
         * <b>CentralPurchaseContract</b>.
         *
         * @param value
         *            The CentralPurchaseContract to build this CntrlPurchaseContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurchaseContractItem.CntrlPurchaseContractItemBuilder centralPurchaseContract(
            final CentralPurchaseContract value )
        {
            return toCentralPurchaseContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
         * </p>
         *
         * @param value
         *            The centralPurchaseContract to build this CntrlPurchaseContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurchaseContractItem.CntrlPurchaseContractItemBuilder centralPurchaseContract( final String value )
        {
            centralPurchaseContract = value;
            return this;
        }

        private CntrlPurchaseContractItem.CntrlPurchaseContractItemBuilder toCntrlPurConItmDistribution(
            final List<CntrlPurContrItmDistribution> value )
        {
            toCntrlPurConItmDistribution.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CntrlPurConItmDistribution</b> for <b>CntrlPurchaseContractItem</b> to multiple
         * <b>CntrlPurContrItmDistribution</b>.
         *
         * @param value
         *            The CntrlPurContrItmDistributions to build this CntrlPurchaseContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurchaseContractItem.CntrlPurchaseContractItemBuilder cntrlPurConItmDistribution(
            CntrlPurContrItmDistribution... value )
        {
            return toCntrlPurConItmDistribution(Lists.newArrayList(value));
        }

        private CntrlPurchaseContractItem.CntrlPurchaseContractItemBuilder toCntrlPurContrItmCmmdtyQty(
            final List<CntrlPurContrItmCmmdtyQty> value )
        {
            toCntrlPurContrItmCmmdtyQty.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CntrlPurContrItmCmmdtyQty</b> for <b>CntrlPurchaseContractItem</b> to multiple
         * <b>CntrlPurContrItmCmmdtyQty</b>.
         *
         * @param value
         *            The CntrlPurContrItmCmmdtyQtys to build this CntrlPurchaseContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurchaseContractItem.CntrlPurchaseContractItemBuilder cntrlPurContrItmCmmdtyQty(
            CntrlPurContrItmCmmdtyQty... value )
        {
            return toCntrlPurContrItmCmmdtyQty(Lists.newArrayList(value));
        }

        private CntrlPurchaseContractItem.CntrlPurchaseContractItemBuilder toCntrlPurContrItmCndnValdty(
            final List<CntrlPurContrItmCndnValdty> value )
        {
            toCntrlPurContrItmCndnValdty.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CntrlPurContrItmCndnValdty</b> for <b>CntrlPurchaseContractItem</b> to multiple
         * <b>CntrlPurContrItmCndnValdty</b>.
         *
         * @param value
         *            The CntrlPurContrItmCndnValdtys to build this CntrlPurchaseContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurchaseContractItem.CntrlPurchaseContractItemBuilder cntrlPurContrItmCndnValdty(
            CntrlPurContrItmCndnValdty... value )
        {
            return toCntrlPurContrItmCndnValdty(Lists.newArrayList(value));
        }

        private CntrlPurchaseContractItem.CntrlPurchaseContractItemBuilder toCntrlPurContrItmNotes(
            final List<CntrlPurContractItemNotes> value )
        {
            toCntrlPurContrItmNotes.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CntrlPurContrItmNotes</b> for <b>CntrlPurchaseContractItem</b> to multiple
         * <b>CntrlPurContractItemNotes</b>.
         *
         * @param value
         *            The CntrlPurContractItemNotess to build this CntrlPurchaseContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurchaseContractItem.CntrlPurchaseContractItemBuilder cntrlPurContrItmNotes(
            CntrlPurContractItemNotes... value )
        {
            return toCntrlPurContrItmNotes(Lists.newArrayList(value));
        }

    }

}
