/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurchaseContractItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem
 * CntrlPurchaseContractItem} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class CntrlPurchaseContractItemByKeyFluentHelper
    extends
    FluentHelperByKey<CntrlPurchaseContractItemByKeyFluentHelper, CntrlPurchaseContractItem, CntrlPurchaseContractItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem
     * CntrlPurchaseContractItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CntrlPurchaseContractItem}
     * @param centralPurchaseContract
     *            Central Purchase Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param centralPurchaseContractItem
     *            Central Purchase Contract Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CntrlPurchaseContractItem}
     */
    public CntrlPurchaseContractItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String centralPurchaseContract,
        final String centralPurchaseContractItem )
    {
        super(servicePath, entityCollection);
        this.key.put("CentralPurchaseContract", centralPurchaseContract);
        this.key.put("CentralPurchaseContractItem", centralPurchaseContractItem);
    }

    @Override
    @Nonnull
    protected Class<CntrlPurchaseContractItem> getEntityClass()
    {
        return CntrlPurchaseContractItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
