/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.SubordinateCntrlContractField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.SubordinateCntrlContractSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Subordinate Central Contract
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SubordinateCntrlContractType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SubordinateCntrlContract extends VdmEntity<SubordinateCntrlContract>
{

    /**
     * Selector for all available fields of SubordinateCntrlContract.
     *
     */
    public final static SubordinateCntrlContractSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingParentDocument</b>
     * </p>
     *
     * @return ID of the Parent Document
     */
    @Key
    @SerializedName( "PurchasingParentDocument" )
    @JsonProperty( "PurchasingParentDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingParentDocument" )
    private String purchasingParentDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingParentDocument</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<String> PURCHASING_PARENT_DOCUMENT =
        new SubordinateCntrlContractField<String>("PurchasingParentDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SubordCntrlPurContract</b>
     * </p>
     *
     * @return Active Purchasing Document
     */
    @Key
    @SerializedName( "SubordCntrlPurContract" )
    @JsonProperty( "SubordCntrlPurContract" )
    @Nullable
    @ODataField( odataName = "SubordCntrlPurContract" )
    private String subordCntrlPurContract;
    /**
     * Use with available fluent helpers to apply the <b>SubordCntrlPurContract</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<String> SUBORD_CNTRL_PUR_CONTRACT =
        new SubordinateCntrlContractField<String>("SubordCntrlPurContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubCompanyCodeGroupingID</b>
     * </p>
     *
     * @return Grouping ID for Company Codes
     */
    @Key
    @SerializedName( "ProcmtHubCompanyCodeGroupingID" )
    @JsonProperty( "ProcmtHubCompanyCodeGroupingID" )
    @Nullable
    @ODataField( odataName = "ProcmtHubCompanyCodeGroupingID" )
    private String procmtHubCompanyCodeGroupingID;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubCompanyCodeGroupingID</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<String> PROCMT_HUB_COMPANY_CODE_GROUPING_ID =
        new SubordinateCntrlContractField<String>("ProcmtHubCompanyCodeGroupingID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ActivePurchasingDocument</b>
     * </p>
     *
     * @return Active Purchasing Document
     */
    @SerializedName( "ActivePurchasingDocument" )
    @JsonProperty( "ActivePurchasingDocument" )
    @Nullable
    @ODataField( odataName = "ActivePurchasingDocument" )
    private String activePurchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>ActivePurchasingDocument</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<String> ACTIVE_PURCHASING_DOCUMENT =
        new SubordinateCntrlContractField<String>("ActivePurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractType</b>
     * </p>
     *
     * @return Purchasing Document Type
     */
    @SerializedName( "PurchaseContractType" )
    @JsonProperty( "PurchaseContractType" )
    @Nullable
    @ODataField( odataName = "PurchaseContractType" )
    private String purchaseContractType;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractType</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<String> PURCHASE_CONTRACT_TYPE =
        new SubordinateCntrlContractField<String>("PurchaseContractType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<String> COMPANY_CODE =
        new SubordinateCntrlContractField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentSubtype</b>
     * </p>
     *
     * @return Control indicator for purchasing document type
     */
    @SerializedName( "PurchasingDocumentSubtype" )
    @JsonProperty( "PurchasingDocumentSubtype" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentSubtype" )
    private String purchasingDocumentSubtype;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentSubtype</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<String> PURCHASING_DOCUMENT_SUBTYPE =
        new SubordinateCntrlContractField<String>("PurchasingDocumentSubtype");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<String> PURCHASING_ORGANIZATION =
        new SubordinateCntrlContractField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Start of Validity Period
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<LocalDateTime> VALIDITY_START_DATE =
        new SubordinateCntrlContractField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return End of Validity Period
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<LocalDateTime> VALIDITY_END_DATE =
        new SubordinateCntrlContractField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<String> PURCHASING_GROUP =
        new SubordinateCntrlContractField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @return The isEndOfPurposeBlocked contained in this entity.
     */
    @SerializedName( "IsEndOfPurposeBlocked" )
    @JsonProperty( "IsEndOfPurposeBlocked" )
    @Nullable
    @ODataField( odataName = "IsEndOfPurposeBlocked" )
    private String isEndOfPurposeBlocked;
    /**
     * Use with available fluent helpers to apply the <b>IsEndOfPurposeBlocked</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<String> IS_END_OF_PURPOSE_BLOCKED =
        new SubordinateCntrlContractField<String>("IsEndOfPurposeBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrDescription</b>
     * </p>
     *
     * @return Name of Purchasing Document
     */
    @SerializedName( "CntrlPurContrDescription" )
    @JsonProperty( "CntrlPurContrDescription" )
    @Nullable
    @ODataField( odataName = "CntrlPurContrDescription" )
    private String cntrlPurContrDescription;
    /**
     * Use with available fluent helpers to apply the <b>CntrlPurContrDescription</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<String> CNTRL_PUR_CONTR_DESCRIPTION =
        new SubordinateCntrlContractField<String>("CntrlPurContrDescription");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SubordCntrlPurContrLastUpdtSts</b>
     * </p>
     *
     * @return Document Update Status
     */
    @SerializedName( "SubordCntrlPurContrLastUpdtSts" )
    @JsonProperty( "SubordCntrlPurContrLastUpdtSts" )
    @Nullable
    @ODataField( odataName = "SubordCntrlPurContrLastUpdtSts" )
    private String subordCntrlPurContrLastUpdtSts;
    /**
     * Use with available fluent helpers to apply the <b>SubordCntrlPurContrLastUpdtSts</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<String> SUBORD_CNTRL_PUR_CONTR_LAST_UPDT_STS =
        new SubordinateCntrlContractField<String>("SubordCntrlPurContrLastUpdtSts");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SubordCntrlContrLastUpdtDteTme</b>
     * </p>
     *
     * @return Change Time Stamp
     */
    @SerializedName( "SubordCntrlContrLastUpdtDteTme" )
    @JsonProperty( "SubordCntrlContrLastUpdtDteTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SubordCntrlContrLastUpdtDteTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime subordCntrlContrLastUpdtDteTme;
    /**
     * Use with available fluent helpers to apply the <b>SubordCntrlContrLastUpdtDteTme</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<ZonedDateTime> SUBORD_CNTRL_CONTR_LAST_UPDT_DTE_TME =
        new SubordinateCntrlContractField<ZonedDateTime>("SubordCntrlContrLastUpdtDteTme");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DistrResponseMessageUUID</b>
     * </p>
     *
     * @return Generic Data Element for GUID Fields (X16)
     */
    @SerializedName( "DistrResponseMessageUUID" )
    @JsonProperty( "DistrResponseMessageUUID" )
    @Nullable
    @ODataField( odataName = "DistrResponseMessageUUID" )
    private UUID distrResponseMessageUUID;
    /**
     * Use with available fluent helpers to apply the <b>DistrResponseMessageUUID</b> field to query operations.
     *
     */
    public final static SubordinateCntrlContractField<UUID> DISTR_RESPONSE_MESSAGE_UUID =
        new SubordinateCntrlContractField<UUID>("DistrResponseMessageUUID");

    @Nonnull
    @Override
    public Class<SubordinateCntrlContract> getType()
    {
        return SubordinateCntrlContract.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingParentDocument</b>
     * </p>
     *
     * @param purchasingParentDocument
     *            ID of the Parent Document
     */
    public void setPurchasingParentDocument( @Nullable final String purchasingParentDocument )
    {
        rememberChangedField("PurchasingParentDocument", this.purchasingParentDocument);
        this.purchasingParentDocument = purchasingParentDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SubordCntrlPurContract</b>
     * </p>
     *
     * @param subordCntrlPurContract
     *            Active Purchasing Document
     */
    public void setSubordCntrlPurContract( @Nullable final String subordCntrlPurContract )
    {
        rememberChangedField("SubordCntrlPurContract", this.subordCntrlPurContract);
        this.subordCntrlPurContract = subordCntrlPurContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubCompanyCodeGroupingID</b>
     * </p>
     *
     * @param procmtHubCompanyCodeGroupingID
     *            Grouping ID for Company Codes
     */
    public void setProcmtHubCompanyCodeGroupingID( @Nullable final String procmtHubCompanyCodeGroupingID )
    {
        rememberChangedField("ProcmtHubCompanyCodeGroupingID", this.procmtHubCompanyCodeGroupingID);
        this.procmtHubCompanyCodeGroupingID = procmtHubCompanyCodeGroupingID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ActivePurchasingDocument</b>
     * </p>
     *
     * @param activePurchasingDocument
     *            Active Purchasing Document
     */
    public void setActivePurchasingDocument( @Nullable final String activePurchasingDocument )
    {
        rememberChangedField("ActivePurchasingDocument", this.activePurchasingDocument);
        this.activePurchasingDocument = activePurchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractType</b>
     * </p>
     *
     * @param purchaseContractType
     *            Purchasing Document Type
     */
    public void setPurchaseContractType( @Nullable final String purchaseContractType )
    {
        rememberChangedField("PurchaseContractType", this.purchaseContractType);
        this.purchaseContractType = purchaseContractType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentSubtype</b>
     * </p>
     *
     * @param purchasingDocumentSubtype
     *            Control indicator for purchasing document type
     */
    public void setPurchasingDocumentSubtype( @Nullable final String purchasingDocumentSubtype )
    {
        rememberChangedField("PurchasingDocumentSubtype", this.purchasingDocumentSubtype);
        this.purchasingDocumentSubtype = purchasingDocumentSubtype;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Start of Validity Period
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            End of Validity Period
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @param isEndOfPurposeBlocked
     *            The isEndOfPurposeBlocked to set.
     */
    public void setIsEndOfPurposeBlocked( @Nullable final String isEndOfPurposeBlocked )
    {
        rememberChangedField("IsEndOfPurposeBlocked", this.isEndOfPurposeBlocked);
        this.isEndOfPurposeBlocked = isEndOfPurposeBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrDescription</b>
     * </p>
     *
     * @param cntrlPurContrDescription
     *            Name of Purchasing Document
     */
    public void setCntrlPurContrDescription( @Nullable final String cntrlPurContrDescription )
    {
        rememberChangedField("CntrlPurContrDescription", this.cntrlPurContrDescription);
        this.cntrlPurContrDescription = cntrlPurContrDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SubordCntrlPurContrLastUpdtSts</b>
     * </p>
     *
     * @param subordCntrlPurContrLastUpdtSts
     *            Document Update Status
     */
    public void setSubordCntrlPurContrLastUpdtSts( @Nullable final String subordCntrlPurContrLastUpdtSts )
    {
        rememberChangedField("SubordCntrlPurContrLastUpdtSts", this.subordCntrlPurContrLastUpdtSts);
        this.subordCntrlPurContrLastUpdtSts = subordCntrlPurContrLastUpdtSts;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SubordCntrlContrLastUpdtDteTme</b>
     * </p>
     *
     * @param subordCntrlContrLastUpdtDteTme
     *            Change Time Stamp
     */
    public void setSubordCntrlContrLastUpdtDteTme( @Nullable final ZonedDateTime subordCntrlContrLastUpdtDteTme )
    {
        rememberChangedField("SubordCntrlContrLastUpdtDteTme", this.subordCntrlContrLastUpdtDteTme);
        this.subordCntrlContrLastUpdtDteTme = subordCntrlContrLastUpdtDteTme;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DistrResponseMessageUUID</b>
     * </p>
     *
     * @param distrResponseMessageUUID
     *            Generic Data Element for GUID Fields (X16)
     */
    public void setDistrResponseMessageUUID( @Nullable final UUID distrResponseMessageUUID )
    {
        rememberChangedField("DistrResponseMessageUUID", this.distrResponseMessageUUID);
        this.distrResponseMessageUUID = distrResponseMessageUUID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SubordinateCntrlContract";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchasingParentDocument", getPurchasingParentDocument());
        result.put("SubordCntrlPurContract", getSubordCntrlPurContract());
        result.put("ProcmtHubCompanyCodeGroupingID", getProcmtHubCompanyCodeGroupingID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchasingParentDocument", getPurchasingParentDocument());
        values.put("SubordCntrlPurContract", getSubordCntrlPurContract());
        values.put("ProcmtHubCompanyCodeGroupingID", getProcmtHubCompanyCodeGroupingID());
        values.put("ActivePurchasingDocument", getActivePurchasingDocument());
        values.put("PurchaseContractType", getPurchaseContractType());
        values.put("CompanyCode", getCompanyCode());
        values.put("PurchasingDocumentSubtype", getPurchasingDocumentSubtype());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("IsEndOfPurposeBlocked", getIsEndOfPurposeBlocked());
        values.put("CntrlPurContrDescription", getCntrlPurContrDescription());
        values.put("SubordCntrlPurContrLastUpdtSts", getSubordCntrlPurContrLastUpdtSts());
        values.put("SubordCntrlContrLastUpdtDteTme", getSubordCntrlContrLastUpdtDteTme());
        values.put("DistrResponseMessageUUID", getDistrResponseMessageUUID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchasingParentDocument") ) {
                final Object value = values.remove("PurchasingParentDocument");
                if( (value == null) || (!value.equals(getPurchasingParentDocument())) ) {
                    setPurchasingParentDocument(((String) value));
                }
            }
            if( values.containsKey("SubordCntrlPurContract") ) {
                final Object value = values.remove("SubordCntrlPurContract");
                if( (value == null) || (!value.equals(getSubordCntrlPurContract())) ) {
                    setSubordCntrlPurContract(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubCompanyCodeGroupingID") ) {
                final Object value = values.remove("ProcmtHubCompanyCodeGroupingID");
                if( (value == null) || (!value.equals(getProcmtHubCompanyCodeGroupingID())) ) {
                    setProcmtHubCompanyCodeGroupingID(((String) value));
                }
            }
            if( values.containsKey("ActivePurchasingDocument") ) {
                final Object value = values.remove("ActivePurchasingDocument");
                if( (value == null) || (!value.equals(getActivePurchasingDocument())) ) {
                    setActivePurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractType") ) {
                final Object value = values.remove("PurchaseContractType");
                if( (value == null) || (!value.equals(getPurchaseContractType())) ) {
                    setPurchaseContractType(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentSubtype") ) {
                final Object value = values.remove("PurchasingDocumentSubtype");
                if( (value == null) || (!value.equals(getPurchasingDocumentSubtype())) ) {
                    setPurchasingDocumentSubtype(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("IsEndOfPurposeBlocked") ) {
                final Object value = values.remove("IsEndOfPurposeBlocked");
                if( (value == null) || (!value.equals(getIsEndOfPurposeBlocked())) ) {
                    setIsEndOfPurposeBlocked(((String) value));
                }
            }
            if( values.containsKey("CntrlPurContrDescription") ) {
                final Object value = values.remove("CntrlPurContrDescription");
                if( (value == null) || (!value.equals(getCntrlPurContrDescription())) ) {
                    setCntrlPurContrDescription(((String) value));
                }
            }
            if( values.containsKey("SubordCntrlPurContrLastUpdtSts") ) {
                final Object value = values.remove("SubordCntrlPurContrLastUpdtSts");
                if( (value == null) || (!value.equals(getSubordCntrlPurContrLastUpdtSts())) ) {
                    setSubordCntrlPurContrLastUpdtSts(((String) value));
                }
            }
            if( values.containsKey("SubordCntrlContrLastUpdtDteTme") ) {
                final Object value = values.remove("SubordCntrlContrLastUpdtDteTme");
                if( (value == null) || (!value.equals(getSubordCntrlContrLastUpdtDteTme())) ) {
                    setSubordCntrlContrLastUpdtDteTme(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("DistrResponseMessageUUID") ) {
                final Object value = values.remove("DistrResponseMessageUUID");
                if( (value == null) || (!value.equals(getDistrResponseMessageUUID())) ) {
                    setDistrResponseMessageUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SubordinateCntrlContractField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SubordinateCntrlContractField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SubordinateCntrlContractField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SubordinateCntrlContractField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

}
