/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService
 * CentralPurchaseContractService}.
 *
 */
public interface CentralPurchaseContractServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<CentralPurchaseContractServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<CentralPurchaseContractServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract
     * CentralPurchaseContract} entity and save it to the S/4HANA system.
     *
     * @param centralPurchaseContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract
     *            CentralPurchaseContract} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CentralPurchaseContractServiceBatchChangeSet
        createCentralPurchaseContract( @Nonnull final CentralPurchaseContract centralPurchaseContract );

}
