/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CentralPurchaseContractServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService
 * CentralPurchaseContractService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultCentralPurchaseContractServiceBatch
    extends
    BatchFluentHelperBasic<CentralPurchaseContractServiceBatch, CentralPurchaseContractServiceBatchChangeSet>
    implements
    CentralPurchaseContractServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCentralPurchaseContractServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCentralPurchaseContractServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCentralPurchaseContractServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCentralPurchaseContractServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCentralPurchaseContractServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CentralPurchaseContractServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCentralPurchaseContractServiceBatchChangeSet(this, service);
    }

}
