/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract;

/**
 * Implementation of the {@link CentralPurchaseContractServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService
 * CentralPurchaseContractService}.
 *
 */
public class DefaultCentralPurchaseContractServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CentralPurchaseContractServiceBatch, CentralPurchaseContractServiceBatchChangeSet>
    implements
    CentralPurchaseContractServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService service;

    @SuppressWarnings( "deprecation" )
    DefaultCentralPurchaseContractServiceBatchChangeSet(
        @Nonnull final DefaultCentralPurchaseContractServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCentralPurchaseContractServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CentralPurchaseContractServiceBatchChangeSet createCentralPurchaseContract(
        @Nonnull final CentralPurchaseContract centralPurchaseContract )
    {
        return addRequestCreate(service::createCentralPurchaseContract, centralPurchaseContract);
    }

}
