/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrms;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrms
 * CePuCoDistrdContrPaytTrms}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CePuCoDistrdContrPaytTrmsField
 * CePuCoDistrdContrPaytTrmsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CePuCoDistrdContrPaytTrmsLink
 * CePuCoDistrdContrPaytTrmsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrms#CENTRAL_PURCHASE_CONTRACT
 * CENTRAL_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrms#EXT_CONTRACT_FOR_PURG
 * EXT_CONTRACT_FOR_PURG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrms#PROCUREMENT_HUB_SOURCE_SYSTEM
 * PROCUREMENT_HUB_SOURCE_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrms#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrms#NET_PAYMENT_DAYS
 * NET_PAYMENT_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrms#CASH_DISCOUNT1_DAYS
 * CASH_DISCOUNT1_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrms#CASH_DISCOUNT1_PERCENT
 * CASH_DISCOUNT1_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrms#CASH_DISCOUNT2_DAYS
 * CASH_DISCOUNT2_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrms#CASH_DISCOUNT2_PERCENT
 * CASH_DISCOUNT2_PERCENT}</li>
 * </ul>
 *
 */
public interface CePuCoDistrdContrPaytTrmsSelectable extends EntitySelectable<CePuCoDistrdContrPaytTrms>
{

}
