/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt
 * CePuCoDistrdOutlineAgrmt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CePuCoDistrdOutlineAgrmtField
 * CePuCoDistrdOutlineAgrmtField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CePuCoDistrdOutlineAgrmtLink
 * CePuCoDistrdOutlineAgrmtLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt#CENTRAL_PURCHASE_CONTRACT
 * CENTRAL_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt#EXT_CONTRACT_FOR_PURG
 * EXT_CONTRACT_FOR_PURG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt#PROCUREMENT_HUB_SOURCE_SYSTEM
 * PROCUREMENT_HUB_SOURCE_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt#PURG_DOC_ITEM_DISTRIBUTION_STATUS
 * PURG_DOC_ITEM_DISTRIBUTION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt#SOURCE_LIST_IS_UPDATED
 * SOURCE_LIST_IS_UPDATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt#SOURCE_LIST_CHANGE_CONF_STATUS
 * SOURCE_LIST_CHANGE_CONF_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt#TO_CENTRAL_PURCHASE_CONTRACT
 * TO_CENTRAL_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt#TO_DISTRIBUTED_PAYMENT_TERMS
 * TO_DISTRIBUTED_PAYMENT_TERMS}</li>
 * </ul>
 *
 */
public interface CePuCoDistrdOutlineAgrmtSelectable extends EntitySelectable<CePuCoDistrdOutlineAgrmt>
{

}
