/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract
 * CentralPurchaseContract}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CentralPurchaseContractField
 * CentralPurchaseContractField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CentralPurchaseContractLink
 * CentralPurchaseContractLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#CENTRAL_PURCHASE_CONTRACT
 * CENTRAL_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#PURCHASE_CONTRACT_TYPE
 * PURCHASE_CONTRACT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#PURCHASING_DOCUMENT_CATEGORY
 * PURCHASING_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#PURCHASING_DOCUMENT_SUBTYPE
 * PURCHASING_DOCUMENT_SUBTYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#DOCUMENT_CURRENCY
 * DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#CASH_DISCOUNT1_DAYS
 * CASH_DISCOUNT1_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#CASH_DISCOUNT2_DAYS
 * CASH_DISCOUNT2_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#CASH_DISCOUNT1_PERCENT
 * CASH_DISCOUNT1_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#CASH_DISCOUNT2_PERCENT
 * CASH_DISCOUNT2_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#NET_PAYMENT_DAYS
 * NET_PAYMENT_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#INCOTERMS_TRANSFER_LOCATION
 * INCOTERMS_TRANSFER_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#INCOTERMS_VERSION
 * INCOTERMS_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#INCOTERMS_LOCATION1
 * INCOTERMS_LOCATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#INCOTERMS_LOCATION2
 * INCOTERMS_LOCATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#PURCHASE_CONTRACT_TARGET_AMOUNT
 * PURCHASE_CONTRACT_TARGET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#EXCHANGE_RATE
 * EXCHANGE_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#EXCHANGE_RATE_IS_FIXED
 * EXCHANGE_RATE_IS_FIXED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#SUPPLYING_SUPPLIER
 * SUPPLYING_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#QUOTATION_SUBMISSION_DATE
 * QUOTATION_SUBMISSION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#SUPPLIER_QUOTATION
 * SUPPLIER_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#CORRESPNC_EXTERNAL_REFERENCE
 * CORRESPNC_EXTERNAL_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#CORRESPNC_INTERNAL_REFERENCE
 * CORRESPNC_INTERNAL_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#SUPPLIER_RESP_SALES_PERSON_NAME
 * SUPPLIER_RESP_SALES_PERSON_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#SUPPLIER_PHONE_NUMBER
 * SUPPLIER_PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#RELEASE_CODE
 * RELEASE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#PURCHASING_DOCUMENT_NAME
 * PURCHASING_DOCUMENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#PURCHASING_DOCUMENT_DELETION_CODE
 * PURCHASING_DOCUMENT_DELETION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#PURCHASING_PROCESSING_STATUS
 * PURCHASING_PROCESSING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#CNTRL_PUR_CONTR_DISTRIBUTION_STS
 * CNTRL_PUR_CONTR_DISTRIBUTION_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#PURG_CONTRACT_IS_IN_PREPARATION
 * PURG_CONTRACT_IS_IN_PREPARATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#PURCHASING_DOC_VERSION_REASON_CODE
 * PURCHASING_DOC_VERSION_REASON_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#CNTRL_PUR_CONTR_FLXBL_DISTR_IS_ALLWD
 * CNTRL_PUR_CONTR_FLXBL_DISTR_IS_ALLWD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#PURCHASING_DOCUMENT_VERSION
 * PURCHASING_DOCUMENT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#PURG_DOC_IS_CHG_VERS
 * PURG_DOC_IS_CHG_VERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#TO_CENTRAL_PURCHASE_CONTRACT_ITEM
 * TO_CENTRAL_PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#TO_CNTRL_CONTR_HDR_DISTRIBUTION
 * TO_CNTRL_CONTR_HDR_DISTRIBUTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#TO_CNTRL_PUR_CONTR_DISTR_MESSAGES
 * TO_CNTRL_PUR_CONTR_DISTR_MESSAGES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#TO_CNTRL_PUR_CONTR_HDR_CNDN_VALDTY
 * TO_CNTRL_PUR_CONTR_HDR_CNDN_VALDTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#TO_CNTRL_PUR_CONTR_HDR_NOTES
 * TO_CNTRL_PUR_CONTR_HDR_NOTES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#TO_CNTRL_PUR_CONTR_VERSION_HISTORY
 * TO_CNTRL_PUR_CONTR_VERSION_HISTORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#TO_DISTRIBUTED_OUTLINE_AGREEMENT
 * TO_DISTRIBUTED_OUTLINE_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#TO_LEGAL_TRANSACTION
 * TO_LEGAL_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract#TO_SUBORDINATE_CNTRL_CONTRACT
 * TO_SUBORDINATE_CNTRL_CONTRACT}</li>
 * </ul>
 *
 */
public interface CentralPurchaseContractSelectable extends EntitySelectable<CentralPurchaseContract>
{

}
