/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages
 * CntrlPurContrDistrMessages}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrDistrMessagesField
 * CntrlPurContrDistrMessagesField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrDistrMessagesLink
 * CntrlPurContrDistrMessagesLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages#SEQUENCE_NUMBER
 * SEQUENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages#DISTR_RESPONSE_MESSAGE_UUID
 * DISTR_RESPONSE_MESSAGE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages#PURCHASING_DOCUMENT
 * PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages#PURCHASING_DOCUMENT_CATEGORY
 * PURCHASING_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages#EXT_CONTRACT_FOR_PURG
 * EXT_CONTRACT_FOR_PURG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages#LOGICAL_SYSTEM
 * LOGICAL_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages#SYSTEM_MESSAGE_TYPE
 * SYSTEM_MESSAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages#SYSTEM_MESSAGE_IDENTIFICATION
 * SYSTEM_MESSAGE_IDENTIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages#SYSTEM_MESSAGE_NUMBER
 * SYSTEM_MESSAGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages#SYSTEM_MESSAGE_VARIABLE1
 * SYSTEM_MESSAGE_VARIABLE1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages#SYSTEM_MESSAGE_VARIABLE2
 * SYSTEM_MESSAGE_VARIABLE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages#SYSTEM_MESSAGE_VARIABLE3
 * SYSTEM_MESSAGE_VARIABLE3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages#SYSTEM_MESSAGE_VARIABLE4
 * SYSTEM_MESSAGE_VARIABLE4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages#SYSTEM_MESSAGE_TEXT
 * SYSTEM_MESSAGE_TEXT}</li>
 * </ul>
 *
 */
public interface CntrlPurContrDistrMessagesSelectable extends EntitySelectable<CntrlPurContrDistrMessages>
{

}
