/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution
 * CntrlPurContrHdrDistribution}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrHdrDistributionField
 * CntrlPurContrHdrDistributionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrHdrDistributionLink
 * CntrlPurContrHdrDistributionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#CENTRAL_PURCHASE_CONTRACT
 * CENTRAL_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#DISTRIBUTION_KEY
 * DISTRIBUTION_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#CENTRAL_PURCHASE_CONTRACT_ITEM
 * CENTRAL_PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#PROCMT_HUB_COMPANY_CODE
 * PROCMT_HUB_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#PROCMT_HUB_PLANT
 * PROCMT_HUB_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#PROCMT_HUB_PURCHASING_ORG
 * PROCMT_HUB_PURCHASING_ORG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#PROCMT_HUB_PURCHASING_GROUP
 * PROCMT_HUB_PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#PROCMT_HUB_COMPANY_CODE_GROUPING_ID
 * PROCMT_HUB_COMPANY_CODE_GROUPING_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#CNTRL_PUR_CONTR_DISTR_CURRENCY
 * CNTRL_PUR_CONTR_DISTR_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#CASH_DISCOUNT1_DAYS
 * CASH_DISCOUNT1_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#CASH_DISCOUNT2_DAYS
 * CASH_DISCOUNT2_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#NET_PAYMENT_DAYS
 * NET_PAYMENT_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#CASH_DISCOUNT1_PERCENT
 * CASH_DISCOUNT1_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#CASH_DISCOUNT2_PERCENT
 * CASH_DISCOUNT2_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#PURCHASING_DOCUMENT_CATEGORY
 * PURCHASING_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#PURCHASING_DOCUMENT_TYPE
 * PURCHASING_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#CNTRL_PUR_CONTR_DISTRIBUTION_PCT
 * CNTRL_PUR_CONTR_DISTRIBUTION_PCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#INCOTERMS_LOCATION1
 * INCOTERMS_LOCATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#SHIPPING_INSTRUCTION
 * SHIPPING_INSTRUCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#CNTRL_PUR_CONTR_ITM_DISTR_AMT
 * CNTRL_PUR_CONTR_ITM_DISTR_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#PROCUREMENT_HUB_SOURCE_SYSTEM
 * PROCUREMENT_HUB_SOURCE_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#PURCHASING_INFO_RECORD_UPDATE_CODE
 * PURCHASING_INFO_RECORD_UPDATE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#SOURCE_LIST_IS_UPDATED
 * SOURCE_LIST_IS_UPDATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#SOURCE_LIST_RESTRICTION
 * SOURCE_LIST_RESTRICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#REFERENCE_DISTRIBUTION_NUMBER
 * REFERENCE_DISTRIBUTION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#TO_CENTRAL_PURCHASE_CONTRACT
 * TO_CENTRAL_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution#TO_CNTRL_PUR_CONTR_HEADER_PARTNER
 * TO_CNTRL_PUR_CONTR_HEADER_PARTNER}</li>
 * </ul>
 *
 */
public interface CntrlPurContrHdrDistributionSelectable extends EntitySelectable<CntrlPurContrHdrDistribution>
{

}
