/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartner
 * CntrlPurContrItemPartner}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrItemPartnerField
 * CntrlPurContrItemPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrItemPartnerLink
 * CntrlPurContrItemPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartner#CENTRAL_PURCHASE_CONTRACT
 * CENTRAL_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartner#CENTRAL_PURCHASE_CONTRACT_ITEM
 * CENTRAL_PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartner#DISTRIBUTION_KEY
 * DISTRIBUTION_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartner#PARTNER_COUNTER
 * PARTNER_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartner#EXT_PLANT_FOR_PURG
 * EXT_PLANT_FOR_PURG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartner#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartner#SUPPLIER_SUBRANGE
 * SUPPLIER_SUBRANGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartner#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * </ul>
 *
 */
public interface CntrlPurContrItemPartnerSelectable extends EntitySelectable<CntrlPurContrItemPartner>
{

}
