/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty
 * CntrlPurContrItmCmmdtyQty}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrItmCmmdtyQtyField
 * CntrlPurContrItmCmmdtyQtyField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrItmCmmdtyQtyLink
 * CntrlPurContrItmCmmdtyQtyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty#CENTRAL_PURCHASE_CONTRACT
 * CENTRAL_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty#CENTRAL_PURCHASE_CONTRACT_ITEM
 * CENTRAL_PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty#PURG_DOC_CMMDTY_QTY_SQNTL_NUMBER
 * PURG_DOC_CMMDTY_QTY_SQNTL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty#COMMODITY
 * COMMODITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty#PURG_DOC_CMMDTY_QTY_VALID_TO_DATE
 * PURG_DOC_CMMDTY_QTY_VALID_TO_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty#PURG_DOC_CMMDTY_QTY_VALID_FROM_DATE
 * PURG_DOC_CMMDTY_QTY_VALID_FROM_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty#COMMODITY_QUANTITY
 * COMMODITY_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty#COMMODITY_UNIT
 * COMMODITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty#PURG_DOC_CMMDTY_REF_DOC_ITM_QTY
 * PURG_DOC_CMMDTY_REF_DOC_ITM_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty#ITEM_QUANTITY_UNIT
 * ITEM_QUANTITY_UNIT}</li>
 * </ul>
 *
 */
public interface CntrlPurContrItmCmmdtyQtySelectable extends EntitySelectable<CntrlPurContrItmCmmdtyQty>
{

}
