/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty
 * CntrlPurContrItmCndnValdty}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrItmCndnValdtyField
 * CntrlPurContrItmCndnValdtyField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrItmCndnValdtyLink
 * CntrlPurContrItmCndnValdtyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty#CENTRAL_PURCHASE_CONTRACT
 * CENTRAL_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty#CENTRAL_PURCHASE_CONTRACT_ITEM
 * CENTRAL_PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty#CONDITION_RECORD
 * CONDITION_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty#CONDITION_VALIDITY_END_DATE
 * CONDITION_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty#CONDITION_APPLICATION
 * CONDITION_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty#CONDITION_VALIDITY_START_DATE
 * CONDITION_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty#PROCMT_HUB_PLANT_UNIQUE_ID
 * PROCMT_HUB_PLANT_UNIQUE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty#CONDITION_IS_DELETED
 * CONDITION_IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty#TO_CENTRAL_PURCHASE_CONTRACT
 * TO_CENTRAL_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty#TO_CNTRL_PURCHASE_CONTRACT_ITEM
 * TO_CNTRL_PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty#TO_CNTRL_PUR_CONTR_ITM_CNDN_AMOUNT
 * TO_CNTRL_PUR_CONTR_ITM_CNDN_AMOUNT}</li>
 * </ul>
 *
 */
public interface CntrlPurContrItmCndnValdtySelectable extends EntitySelectable<CntrlPurContrItmCndnValdty>
{

}
