/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory
 * CntrlPurContrVersionHistory}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrVersionHistoryField
 * CntrlPurContrVersionHistoryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrVersionHistoryLink
 * CntrlPurContrVersionHistoryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#CENTRAL_PURCHASE_CONTRACT
 * CENTRAL_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#PURCHASING_DOCUMENT_VERSION
 * PURCHASING_DOCUMENT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#ACTIVE_PURCHASING_DOCUMENT
 * ACTIVE_PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#PURCHASE_CONTRACT_TYPE
 * PURCHASE_CONTRACT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#PURCHASING_DOCUMENT_CATEGORY
 * PURCHASING_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#DOCUMENT_CURRENCY
 * DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#CHANGE_REQUEST_NOTE
 * CHANGE_REQUEST_NOTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#CREATED_BY_USER_DESCRIPTION
 * CREATED_BY_USER_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#PURCHASING_DOC_VERSION_REASON_CODE
 * PURCHASING_DOC_VERSION_REASON_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#PURCHASING_DOC_VERSION_STATUS
 * PURCHASING_DOC_VERSION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#INCOTERMS_TRANSFER_LOCATION
 * INCOTERMS_TRANSFER_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#INCOTERMS_VERSION
 * INCOTERMS_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#INCOTERMS_LOCATION1
 * INCOTERMS_LOCATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#INCOTERMS_LOCATION2
 * INCOTERMS_LOCATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#PURCHASING_DOCUMENT_NAME
 * PURCHASING_DOCUMENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#CASH_DISCOUNT1_DAYS
 * CASH_DISCOUNT1_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#CASH_DISCOUNT2_DAYS
 * CASH_DISCOUNT2_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#NET_PAYMENT_DAYS
 * NET_PAYMENT_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#CASH_DISCOUNT1_PERCENT
 * CASH_DISCOUNT1_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#CASH_DISCOUNT2_PERCENT
 * CASH_DISCOUNT2_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#PURCHASE_CONTRACT_TARGET_AMOUNT
 * PURCHASE_CONTRACT_TARGET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#RELEASE_CODE
 * RELEASE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#PURCHASING_DOCUMENT_DELETION_CODE
 * PURCHASING_DOCUMENT_DELETION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#SUPPLYING_SUPPLIER
 * SUPPLYING_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#EXCHANGE_RATE_IS_FIXED
 * EXCHANGE_RATE_IS_FIXED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#QUOTATION_SUBMISSION_DATE
 * QUOTATION_SUBMISSION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#SUPPLIER_QUOTATION
 * SUPPLIER_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#CORRESPNC_EXTERNAL_REFERENCE
 * CORRESPNC_EXTERNAL_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#CORRESPNC_INTERNAL_REFERENCE
 * CORRESPNC_INTERNAL_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#SUPPLIER_RESP_SALES_PERSON_NAME
 * SUPPLIER_RESP_SALES_PERSON_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#SUPPLIER_PHONE_NUMBER
 * SUPPLIER_PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#PURG_CONTRACT_IS_IN_PREPARATION
 * PURG_CONTRACT_IS_IN_PREPARATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#PURCHASING_PROCESSING_STATUS
 * PURCHASING_PROCESSING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#CNTRL_PUR_CONTR_OVRL_DISTR_STS_TXT
 * CNTRL_PUR_CONTR_OVRL_DISTR_STS_TXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#CNTRL_PUR_CONTR_FLXBL_DISTR_IS_ALLWD
 * CNTRL_PUR_CONTR_FLXBL_DISTR_IS_ALLWD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#PURG_DOC_CHANGE_REQUEST_STATUS
 * PURG_DOC_CHANGE_REQUEST_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory#TO_CENTRAL_PURCHASE_CONTRACT_ITEM
 * TO_CENTRAL_PURCHASE_CONTRACT_ITEM}</li>
 * </ul>
 *
 */
public interface CntrlPurContrVersionHistorySelectable extends EntitySelectable<CntrlPurContrVersionHistory>
{

}
