/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotes;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotes
 * CntrlPurContractItemNotes}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContractItemNotesField
 * CntrlPurContractItemNotesField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContractItemNotesLink
 * CntrlPurContractItemNotesLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotes#PURCHASING_DOCUMENT_NOTE_OBJECT_ID
 * PURCHASING_DOCUMENT_NOTE_OBJECT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotes#PURCHASING_DOCUMENT_NOTE_TYPE
 * PURCHASING_DOCUMENT_NOTE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotes#PURCHASING_DOCUMENT_NOTE_LANGUAGE
 * PURCHASING_DOCUMENT_NOTE_LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotes#CENTRAL_PURCHASE_CONTRACT
 * CENTRAL_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotes#PURG_DOC_NOTE_TEXT
 * PURG_DOC_NOTE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotes#PURCHASING_DOCUMENT_NOTE_TITLE
 * PURCHASING_DOCUMENT_NOTE_TITLE}</li>
 * </ul>
 *
 */
public interface CntrlPurContractItemNotesSelectable extends EntitySelectable<CntrlPurContractItemNotes>
{

}
