/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem
 * CntrlPurchaseContractItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurchaseContractItemField
 * CntrlPurchaseContractItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurchaseContractItemLink
 * CntrlPurchaseContractItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#CENTRAL_PURCHASE_CONTRACT
 * CENTRAL_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#CENTRAL_PURCHASE_CONTRACT_ITEM
 * CENTRAL_PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#PURCHASING_DOCUMENT_ITEM_CATEGORY
 * PURCHASING_DOCUMENT_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#FORMATTED_PURCHASE_CONTRACT_ITEM
 * FORMATTED_PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#PURCHASING_CENTRAL_MATERIAL
 * PURCHASING_CENTRAL_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#PROCMT_HUB_REFCD_CONNECTED_SYSTEM
 * PROCMT_HUB_REFCD_CONNECTED_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#CNTRL_PUR_CONTRACT_ITEM_TEXT
 * CNTRL_PUR_CONTRACT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#PRODUCT_TYPE
 * PRODUCT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#ACTIVE_PURCHASING_DOCUMENT
 * ACTIVE_PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#NET_PRICE_QUANTITY
 * NET_PRICE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#ORDER_PRICE_UNIT
 * ORDER_PRICE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#TARGET_QUANTITY
 * TARGET_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#CNTRL_PUR_CONTR_ITM_TARGET_AMOUNT
 * CNTRL_PUR_CONTR_ITM_TARGET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#CONTRACT_NET_PRICE_AMOUNT
 * CONTRACT_NET_PRICE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#ORDER_QUANTITY_UNIT
 * ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#PURG_DOC_RELEASE_ORDER_QUANTITY
 * PURG_DOC_RELEASE_ORDER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#ORD_PRICE_UNIT_TO_ORDER_UNIT_DNMNTR
 * ORD_PRICE_UNIT_TO_ORDER_UNIT_DNMNTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#ORDER_PRICE_UNIT_TO_ORDER_UNIT_NMRTR
 * ORDER_PRICE_UNIT_TO_ORDER_UNIT_NMRTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#DOCUMENT_CURRENCY
 * DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#NO_DAYS_REMINDER1
 * NO_DAYS_REMINDER1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#NO_DAYS_REMINDER2
 * NO_DAYS_REMINDER2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#NO_DAYS_REMINDER3
 * NO_DAYS_REMINDER3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#PURG_DOC_ORDER_ACKN_NUMBER
 * PURG_DOC_ORDER_ACKN_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#REQUIREMENT_TRACKING
 * REQUIREMENT_TRACKING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#SUPPLIER_MATERIAL_NUMBER
 * SUPPLIER_MATERIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#IS_ORDER_ACKN_RQD
 * IS_ORDER_ACKN_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#PURG_DOC_ESTIMATED_PRICE
 * PURG_DOC_ESTIMATED_PRICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#PRICE_IS_TO_BE_PRINTED
 * PRICE_IS_TO_BE_PRINTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT
 * UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT
 * OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#UNLIMITED_OVERDELIVERY_IS_ALLOWED
 * UNLIMITED_OVERDELIVERY_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#STOCK_TYPE
 * STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#SHIPPING_INSTRUCTION
 * SHIPPING_INSTRUCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#GOODS_RECEIPT_IS_EXPECTED
 * GOODS_RECEIPT_IS_EXPECTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#GOODS_RECEIPT_IS_NON_VALUATED
 * GOODS_RECEIPT_IS_NON_VALUATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#INVOICE_IS_EXPECTED
 * INVOICE_IS_EXPECTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#INVOICE_IS_GOODS_RECEIPT_BASED
 * INVOICE_IS_GOODS_RECEIPT_BASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#EVALD_RCPT_SETTLMT_IS_ALLOWED
 * EVALD_RCPT_SETTLMT_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#PURCHASING_CONTRACT_DELETION_CODE
 * PURCHASING_CONTRACT_DELETION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#OUTLINE_AGRMT_ITM_IS_BLOCKED
 * OUTLINE_AGRMT_ITM_IS_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#PURG_DOC_ITM_BLK_RSN_CODE
 * PURG_DOC_ITM_BLK_RSN_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#PURG_DOC_ITEM_RENEGOTIATION_STATUS
 * PURG_DOC_ITEM_RENEGOTIATION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#PURCHASING_PARENT_ITEM
 * PURCHASING_PARENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#IS_OUTLINE
 * IS_OUTLINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#PURG_CONFIGURABLE_ITEM_NUMBER
 * PURG_CONFIGURABLE_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#TO_CENTRAL_PURCHASE_CONTRACT
 * TO_CENTRAL_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#TO_CNTRL_PUR_CON_ITM_DISTRIBUTION
 * TO_CNTRL_PUR_CON_ITM_DISTRIBUTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#TO_CNTRL_PUR_CONTR_ITM_CMMDTY_QTY
 * TO_CNTRL_PUR_CONTR_ITM_CMMDTY_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#TO_CNTRL_PUR_CONTR_ITM_CNDN_VALDTY
 * TO_CNTRL_PUR_CONTR_ITM_CNDN_VALDTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem#TO_CNTRL_PUR_CONTR_ITM_NOTES
 * TO_CNTRL_PUR_CONTR_ITM_NOTES}</li>
 * </ul>
 *
 */
public interface CntrlPurchaseContractItemSelectable extends EntitySelectable<CntrlPurchaseContractItem>
{

}
