/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract
 * SubordinateCntrlContract}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.SubordinateCntrlContractField
 * SubordinateCntrlContractField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.SubordinateCntrlContractLink
 * SubordinateCntrlContractLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#PURCHASING_PARENT_DOCUMENT
 * PURCHASING_PARENT_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#SUBORD_CNTRL_PUR_CONTRACT
 * SUBORD_CNTRL_PUR_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#PROCMT_HUB_COMPANY_CODE_GROUPING_ID
 * PROCMT_HUB_COMPANY_CODE_GROUPING_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#ACTIVE_PURCHASING_DOCUMENT
 * ACTIVE_PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#PURCHASE_CONTRACT_TYPE
 * PURCHASE_CONTRACT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#PURCHASING_DOCUMENT_SUBTYPE
 * PURCHASING_DOCUMENT_SUBTYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#IS_END_OF_PURPOSE_BLOCKED
 * IS_END_OF_PURPOSE_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#CNTRL_PUR_CONTR_DESCRIPTION
 * CNTRL_PUR_CONTR_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#SUBORD_CNTRL_PUR_CONTR_LAST_UPDT_STS
 * SUBORD_CNTRL_PUR_CONTR_LAST_UPDT_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#SUBORD_CNTRL_CONTR_LAST_UPDT_DTE_TME
 * SUBORD_CNTRL_CONTR_LAST_UPDT_DTE_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract#DISTR_RESPONSE_MESSAGE_UUID
 * DISTR_RESPONSE_MESSAGE_UUID}</li>
 * </ul>
 *
 */
public interface SubordinateCntrlContractSelectable extends EntitySelectable<SubordinateCntrlContract>
{

}
