/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2;

import java.net.URI;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>AssignAltDateToDocInfoRecdObjectMgmtRec</b> OData function import.
 *
 */
public class AssignAltDateToDocInfoRecdObjectMgmtRecFluentHelper
    extends
    SingleValuedFluentHelperFunction<AssignAltDateToDocInfoRecdObjectMgmtRecFluentHelper, ChangeMstrObMgReDocInfoRecd, ChangeMstrObMgReDocInfoRecd>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>AssignAltDateToDocInfoRecdObjectMgmtRec</b> OData
     * function import with the provided parameters. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param documentInfoRecord
     *            Document
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecord</b>
     *            </p>
     * @param documentPart
     *            Document Part
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentPart</b>
     *            </p>
     * @param documentType
     *            Document Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentType</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param changeNumber
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChangeNumber</b>
     *            </p>
     * @param chgNmbrAlternativeDateID
     *            Alternative date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChgNmbrAlternativeDateID</b>
     *            </p>
     * @param documentVersion
     *            Document Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentVersion</b>
     *            </p>
     */
    public AssignAltDateToDocInfoRecdObjectMgmtRecFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String changeNumber,
        @Nonnull final String documentType,
        @Nonnull final String documentInfoRecord,
        @Nonnull final String documentPart,
        @Nonnull final String documentVersion,
        @Nullable final String chgNmbrAlternativeDateID )
    {
        super(servicePath);
        values.put("ChangeNumber", changeNumber);
        values.put("DocumentType", documentType);
        values.put("DocumentInfoRecord", documentInfoRecord);
        values.put("DocumentPart", documentPart);
        values.put("DocumentVersion", documentVersion);
        if( chgNmbrAlternativeDateID != null ) {
            values.put("ChgNmbrAlternativeDateID", chgNmbrAlternativeDateID);
        }
    }

    @Override
    @Nonnull
    protected Class<ChangeMstrObMgReDocInfoRecd> getEntityClass()
    {
        return ChangeMstrObMgReDocInfoRecd.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "AssignAltDateToDocInfoRecdObjectMgmtRec";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nullable
    public ChangeMstrObMgReDocInfoRecd executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeSingle(destination);
    }

}
