/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.field.ChangeMasterField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.link.ChangeMasterLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.selectable.ChangeMasterSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Change Number
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ChangeMasterType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChangeMaster extends VdmEntity<ChangeMaster>
{

    /**
     * Selector for all available fields of ChangeMaster.
     *
     */
    public final static ChangeMasterSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ShiftValidityStartDate_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "ShiftValidityStartDate_ac" )
    @JsonProperty( "ShiftValidityStartDate_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ShiftValidityStartDate_ac" )
    private Boolean shiftValidityStartDate_ac;
    /**
     * Use with available fluent helpers to apply the <b>ShiftValidityStartDate_ac</b> field to query operations.
     *
     */
    public final static ChangeMasterField<Boolean> SHIFT_VALIDITY_START_DATE_AC =
        new ChangeMasterField<Boolean>("ShiftValidityStartDate_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ChangeMasterField<Boolean> DELETE_MC = new ChangeMasterField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ChangeMasterField<Boolean> UPDATE_MC = new ChangeMasterField<Boolean>("Update_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_AlternativeDate_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_AlternativeDate_oc" )
    @JsonProperty( "to_AlternativeDate_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_AlternativeDate_oc" )
    private Boolean alternativeDate_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_AlternativeDate_oc</b> field to query operations.
     *
     */
    public final static ChangeMasterField<Boolean> ALTERNATIVE_DATE_OC =
        new ChangeMasterField<Boolean>("to_AlternativeDate_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeMstrObMgReDocInfoRecd_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeMstrObMgReDocInfoRecd_oc" )
    @JsonProperty( "to_ChangeMstrObMgReDocInfoRecd_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeMstrObMgReDocInfoRecd_oc" )
    private Boolean changeMstrObMgReDocInfoRecd_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeMstrObMgReDocInfoRecd_oc</b> field to query
     * operations.
     *
     */
    public final static ChangeMasterField<Boolean> CHANGE_MSTR_OB_MG_RE_DOC_INFO_RECD_OC =
        new ChangeMasterField<Boolean>("to_ChangeMstrObMgReDocInfoRecd_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeMstrObMgReMaterial_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeMstrObMgReMaterial_oc" )
    @JsonProperty( "to_ChangeMstrObMgReMaterial_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeMstrObMgReMaterial_oc" )
    private Boolean changeMstrObMgReMaterial_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeMstrObMgReMaterial_oc</b> field to query operations.
     *
     */
    public final static ChangeMasterField<Boolean> CHANGE_MSTR_OB_MG_RE_MATERIAL_OC =
        new ChangeMasterField<Boolean>("to_ChangeMstrObMgReMaterial_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeMstrObMgReMatlBOM_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeMstrObMgReMatlBOM_oc" )
    @JsonProperty( "to_ChangeMstrObMgReMatlBOM_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeMstrObMgReMatlBOM_oc" )
    private Boolean changeMstrObMgReMatlBOM_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeMstrObMgReMatlBOM_oc</b> field to query operations.
     *
     */
    public final static ChangeMasterField<Boolean> CHANGE_MSTR_OB_MG_RE_MATL_BOM_OC =
        new ChangeMasterField<Boolean>("to_ChangeMstrObMgReMatlBOM_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ObjTypeAssignment_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ObjTypeAssignment_oc" )
    @JsonProperty( "to_ObjTypeAssignment_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ObjTypeAssignment_oc" )
    private Boolean objTypeAssignment_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ObjTypeAssignment_oc</b> field to query operations.
     *
     */
    public final static ChangeMasterField<Boolean> OBJ_TYPE_ASSIGNMENT_OC =
        new ChangeMasterField<Boolean>("to_ObjTypeAssignment_oc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @Key
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ChangeMasterField<String> CHANGE_NUMBER = new ChangeMasterField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberStatus</b>
     * </p>
     *
     * @return Status of Change Number
     */
    @SerializedName( "ChangeNumberStatus" )
    @JsonProperty( "ChangeNumberStatus" )
    @Nullable
    @ODataField( odataName = "ChangeNumberStatus" )
    private String changeNumberStatus;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumberStatus</b> field to query operations.
     *
     */
    public final static ChangeMasterField<String> CHANGE_NUMBER_STATUS =
        new ChangeMasterField<String>("ChangeNumberStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @return Authorization group for change master record
     */
    @SerializedName( "AuthorizationGroup" )
    @JsonProperty( "AuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "AuthorizationGroup" )
    private String authorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationGroup</b> field to query operations.
     *
     */
    public final static ChangeMasterField<String> AUTHORIZATION_GROUP =
        new ChangeMasterField<String>("AuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberFunction</b>
     * </p>
     *
     * @return Change number function
     */
    @SerializedName( "ChangeNumberFunction" )
    @JsonProperty( "ChangeNumberFunction" )
    @Nullable
    @ODataField( odataName = "ChangeNumberFunction" )
    private String changeNumberFunction;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumberFunction</b> field to query operations.
     *
     */
    public final static ChangeMasterField<String> CHANGE_NUMBER_FUNCTION =
        new ChangeMasterField<String>("ChangeNumberFunction");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsTechnicallyReleased</b>
     * </p>
     *
     * @return Indicator: Technical release occurs
     */
    @SerializedName( "IsTechnicallyReleased" )
    @JsonProperty( "IsTechnicallyReleased" )
    @Nullable
    @ODataField( odataName = "IsTechnicallyReleased" )
    private String isTechnicallyReleased;
    /**
     * Use with available fluent helpers to apply the <b>IsTechnicallyReleased</b> field to query operations.
     *
     */
    public final static ChangeMasterField<String> IS_TECHNICALLY_RELEASED =
        new ChangeMasterField<String>("IsTechnicallyReleased");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberReleaseKey</b>
     * </p>
     *
     * @return Release Key for Change Master Record
     */
    @SerializedName( "ChangeNumberReleaseKey" )
    @JsonProperty( "ChangeNumberReleaseKey" )
    @Nullable
    @ODataField( odataName = "ChangeNumberReleaseKey" )
    private String changeNumberReleaseKey;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumberReleaseKey</b> field to query operations.
     *
     */
    public final static ChangeMasterField<String> CHANGE_NUMBER_RELEASE_KEY =
        new ChangeMasterField<String>("ChangeNumberReleaseKey");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ReasonForChangeText</b>
     * </p>
     *
     * @return Reason for change
     */
    @SerializedName( "ReasonForChangeText" )
    @JsonProperty( "ReasonForChangeText" )
    @Nullable
    @ODataField( odataName = "ReasonForChangeText" )
    private String reasonForChangeText;
    /**
     * Use with available fluent helpers to apply the <b>ReasonForChangeText</b> field to query operations.
     *
     */
    public final static ChangeMasterField<String> REASON_FOR_CHANGE_TEXT =
        new ChangeMasterField<String>("ReasonForChangeText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberDescription</b>
     * </p>
     *
     * @return Change number description
     */
    @SerializedName( "ChangeNumberDescription" )
    @JsonProperty( "ChangeNumberDescription" )
    @Nullable
    @ODataField( odataName = "ChangeNumberDescription" )
    private String changeNumberDescription;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumberDescription</b> field to query operations.
     *
     */
    public final static ChangeMasterField<String> CHANGE_NUMBER_DESCRIPTION =
        new ChangeMasterField<String>("ChangeNumberDescription");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberValidFromDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ChangeNumberValidFromDate" )
    @JsonProperty( "ChangeNumberValidFromDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangeNumberValidFromDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime changeNumberValidFromDate;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumberValidFromDate</b> field to query operations.
     *
     */
    public final static ChangeMasterField<LocalDateTime> CHANGE_NUMBER_VALID_FROM_DATE =
        new ChangeMasterField<LocalDateTime>("ChangeNumberValidFromDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberCreationDate</b>
     * </p>
     *
     * @return Date on Which Record Was Created
     */
    @SerializedName( "ChangeNumberCreationDate" )
    @JsonProperty( "ChangeNumberCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangeNumberCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime changeNumberCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumberCreationDate</b> field to query operations.
     *
     */
    public final static ChangeMasterField<LocalDateTime> CHANGE_NUMBER_CREATION_DATE =
        new ChangeMasterField<LocalDateTime>("ChangeNumberCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberCreatedByUser</b>
     * </p>
     *
     * @return User Who Created Record
     */
    @SerializedName( "ChangeNumberCreatedByUser" )
    @JsonProperty( "ChangeNumberCreatedByUser" )
    @Nullable
    @ODataField( odataName = "ChangeNumberCreatedByUser" )
    private String changeNumberCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumberCreatedByUser</b> field to query operations.
     *
     */
    public final static ChangeMasterField<String> CHANGE_NUMBER_CREATED_BY_USER =
        new ChangeMasterField<String>("ChangeNumberCreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberLastChangedDate</b>
     * </p>
     *
     * @return Changed On
     */
    @SerializedName( "ChangeNumberLastChangedDate" )
    @JsonProperty( "ChangeNumberLastChangedDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangeNumberLastChangedDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime changeNumberLastChangedDate;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumberLastChangedDate</b> field to query operations.
     *
     */
    public final static ChangeMasterField<LocalDateTime> CHANGE_NUMBER_LAST_CHANGED_DATE =
        new ChangeMasterField<LocalDateTime>("ChangeNumberLastChangedDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberLastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "ChangeNumberLastChangedByUser" )
    @JsonProperty( "ChangeNumberLastChangedByUser" )
    @Nullable
    @ODataField( odataName = "ChangeNumberLastChangedByUser" )
    private String changeNumberLastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumberLastChangedByUser</b> field to query operations.
     *
     */
    public final static ChangeMasterField<String> CHANGE_NUMBER_LAST_CHANGED_BY_USER =
        new ChangeMasterField<String>("ChangeNumberLastChangedByUser");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsUsedForDataDefinition</b>
     * </p>
     *
     * @return Change Number Is Currently Being Used in Objects
     */
    @SerializedName( "IsUsedForDataDefinition" )
    @JsonProperty( "IsUsedForDataDefinition" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsUsedForDataDefinition" )
    private Boolean isUsedForDataDefinition;
    /**
     * Use with available fluent helpers to apply the <b>IsUsedForDataDefinition</b> field to query operations.
     *
     */
    public final static ChangeMasterField<Boolean> IS_USED_FOR_DATA_DEFINITION =
        new ChangeMasterField<Boolean>("IsUsedForDataDefinition");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberIsMrkdForDeletion</b>
     * </p>
     *
     * @return Deletion Flag for Change Number (Reorganization)
     */
    @SerializedName( "ChangeNumberIsMrkdForDeletion" )
    @JsonProperty( "ChangeNumberIsMrkdForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ChangeNumberIsMrkdForDeletion" )
    private Boolean changeNumberIsMrkdForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumberIsMrkdForDeletion</b> field to query operations.
     *
     */
    public final static ChangeMasterField<Boolean> CHANGE_NUMBER_IS_MRKD_FOR_DELETION =
        new ChangeMasterField<Boolean>("ChangeNumberIsMrkdForDeletion");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberLastChgdDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "ChangeNumberLastChgdDateTime" )
    @JsonProperty( "ChangeNumberLastChgdDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangeNumberLastChgdDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changeNumberLastChgdDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumberLastChgdDateTime</b> field to query operations.
     *
     */
    public final static ChangeMasterField<ZonedDateTime> CHANGE_NUMBER_LAST_CHGD_DATE_TIME =
        new ChangeMasterField<ZonedDateTime>("ChangeNumberLastChgdDateTime");
    /**
     * Navigation property <b>to_AlternativeDate</b> for <b>ChangeMaster</b> to multiple <b>ChangeMasterAltDate</b>.
     *
     */
    @SerializedName( "to_AlternativeDate" )
    @JsonProperty( "to_AlternativeDate" )
    @ODataField( odataName = "to_AlternativeDate" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeMasterAltDate> toAlternativeDate;
    /**
     * Navigation property <b>to_ChangeMstrObjectMgmtRecord</b> for <b>ChangeMaster</b> to multiple
     * <b>ChangeMstrObjectMgmtRecord</b>.
     *
     */
    @SerializedName( "to_ChangeMstrObjectMgmtRecord" )
    @JsonProperty( "to_ChangeMstrObjectMgmtRecord" )
    @ODataField( odataName = "to_ChangeMstrObjectMgmtRecord" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeMstrObjectMgmtRecord> toChangeMstrObjectMgmtRecord;
    /**
     * Navigation property <b>to_ChangeMstrObMgReDocInfoRecd</b> for <b>ChangeMaster</b> to multiple
     * <b>ChangeMstrObMgReDocInfoRecd</b>.
     *
     */
    @SerializedName( "to_ChangeMstrObMgReDocInfoRecd" )
    @JsonProperty( "to_ChangeMstrObMgReDocInfoRecd" )
    @ODataField( odataName = "to_ChangeMstrObMgReDocInfoRecd" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeMstrObMgReDocInfoRecd> toChangeMstrObMgReDocInfoRecd;
    /**
     * Navigation property <b>to_ChangeMstrObMgReMaterial</b> for <b>ChangeMaster</b> to multiple
     * <b>ChangeMstrObMgReMaterial</b>.
     *
     */
    @SerializedName( "to_ChangeMstrObMgReMaterial" )
    @JsonProperty( "to_ChangeMstrObMgReMaterial" )
    @ODataField( odataName = "to_ChangeMstrObMgReMaterial" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeMstrObMgReMaterial> toChangeMstrObMgReMaterial;
    /**
     * Navigation property <b>to_ChangeMstrObMgReMatlBOM</b> for <b>ChangeMaster</b> to multiple
     * <b>ChangeMstrObMgReMatlBOM</b>.
     *
     */
    @SerializedName( "to_ChangeMstrObMgReMatlBOM" )
    @JsonProperty( "to_ChangeMstrObMgReMatlBOM" )
    @ODataField( odataName = "to_ChangeMstrObMgReMatlBOM" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeMstrObMgReMatlBOM> toChangeMstrObMgReMatlBOM;
    /**
     * Navigation property <b>to_Characteristics</b> for <b>ChangeMaster</b> to multiple <b>ChangeMasterCharc</b>.
     *
     */
    @SerializedName( "to_Characteristics" )
    @JsonProperty( "to_Characteristics" )
    @ODataField( odataName = "to_Characteristics" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeMasterCharc> toCharacteristics;
    /**
     * Navigation property <b>to_Classification</b> for <b>ChangeMaster</b> to multiple <b>ChangeMasterClass</b>.
     *
     */
    @SerializedName( "to_Classification" )
    @JsonProperty( "to_Classification" )
    @ODataField( odataName = "to_Classification" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeMasterClass> toClassification;
    /**
     * Navigation property <b>to_ObjTypeAssignment</b> for <b>ChangeMaster</b> to multiple
     * <b>ChangeMasterObjTypeAssgmt</b>.
     *
     */
    @SerializedName( "to_ObjTypeAssignment" )
    @JsonProperty( "to_ObjTypeAssignment" )
    @ODataField( odataName = "to_ObjTypeAssignment" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeMasterObjTypeAssgmt> toObjTypeAssignment;
    /**
     * Use with available fluent helpers to apply the <b>to_AlternativeDate</b> navigation property to query operations.
     *
     */
    public final static ChangeMasterLink<ChangeMasterAltDate> TO_ALTERNATIVE_DATE =
        new ChangeMasterLink<ChangeMasterAltDate>("to_AlternativeDate");
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeMstrObjectMgmtRecord</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeMasterLink<ChangeMstrObjectMgmtRecord> TO_CHANGE_MSTR_OBJECT_MGMT_RECORD =
        new ChangeMasterLink<ChangeMstrObjectMgmtRecord>("to_ChangeMstrObjectMgmtRecord");
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeMstrObMgReDocInfoRecd</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeMasterLink<ChangeMstrObMgReDocInfoRecd> TO_CHANGE_MSTR_OB_MG_RE_DOC_INFO_RECD =
        new ChangeMasterLink<ChangeMstrObMgReDocInfoRecd>("to_ChangeMstrObMgReDocInfoRecd");
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeMstrObMgReMaterial</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeMasterLink<ChangeMstrObMgReMaterial> TO_CHANGE_MSTR_OB_MG_RE_MATERIAL =
        new ChangeMasterLink<ChangeMstrObMgReMaterial>("to_ChangeMstrObMgReMaterial");
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeMstrObMgReMatlBOM</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeMasterLink<ChangeMstrObMgReMatlBOM> TO_CHANGE_MSTR_OB_MG_RE_MATL_BOM =
        new ChangeMasterLink<ChangeMstrObMgReMatlBOM>("to_ChangeMstrObMgReMatlBOM");
    /**
     * Use with available fluent helpers to apply the <b>to_Characteristics</b> navigation property to query operations.
     *
     */
    public final static ChangeMasterLink<ChangeMasterCharc> TO_CHARACTERISTICS =
        new ChangeMasterLink<ChangeMasterCharc>("to_Characteristics");
    /**
     * Use with available fluent helpers to apply the <b>to_Classification</b> navigation property to query operations.
     *
     */
    public final static ChangeMasterLink<ChangeMasterClass> TO_CLASSIFICATION =
        new ChangeMasterLink<ChangeMasterClass>("to_Classification");
    /**
     * Use with available fluent helpers to apply the <b>to_ObjTypeAssignment</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeMasterLink<ChangeMasterObjTypeAssgmt> TO_OBJ_TYPE_ASSIGNMENT =
        new ChangeMasterLink<ChangeMasterObjTypeAssgmt>("to_ObjTypeAssignment");

    @Nonnull
    @Override
    public Class<ChangeMaster> getType()
    {
        return ChangeMaster.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ShiftValidityStartDate_ac</b>
     * </p>
     *
     * @param shiftValidityStartDate_ac
     *            Dyn. Action Control
     */
    public void setShiftValidityStartDate_ac( @Nullable final Boolean shiftValidityStartDate_ac )
    {
        rememberChangedField("ShiftValidityStartDate_ac", this.shiftValidityStartDate_ac);
        this.shiftValidityStartDate_ac = shiftValidityStartDate_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_AlternativeDate_oc</b>
     * </p>
     *
     * @param alternativeDate_oc
     *            Dynamic CbA-Control
     */
    public void setAlternativeDate_oc( @Nullable final Boolean alternativeDate_oc )
    {
        rememberChangedField("to_AlternativeDate_oc", this.alternativeDate_oc);
        this.alternativeDate_oc = alternativeDate_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeMstrObMgReDocInfoRecd_oc</b>
     * </p>
     *
     * @param changeMstrObMgReDocInfoRecd_oc
     *            Dynamic CbA-Control
     */
    public void setChangeMstrObMgReDocInfoRecd_oc( @Nullable final Boolean changeMstrObMgReDocInfoRecd_oc )
    {
        rememberChangedField("to_ChangeMstrObMgReDocInfoRecd_oc", this.changeMstrObMgReDocInfoRecd_oc);
        this.changeMstrObMgReDocInfoRecd_oc = changeMstrObMgReDocInfoRecd_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeMstrObMgReMaterial_oc</b>
     * </p>
     *
     * @param changeMstrObMgReMaterial_oc
     *            Dynamic CbA-Control
     */
    public void setChangeMstrObMgReMaterial_oc( @Nullable final Boolean changeMstrObMgReMaterial_oc )
    {
        rememberChangedField("to_ChangeMstrObMgReMaterial_oc", this.changeMstrObMgReMaterial_oc);
        this.changeMstrObMgReMaterial_oc = changeMstrObMgReMaterial_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeMstrObMgReMatlBOM_oc</b>
     * </p>
     *
     * @param changeMstrObMgReMatlBOM_oc
     *            Dynamic CbA-Control
     */
    public void setChangeMstrObMgReMatlBOM_oc( @Nullable final Boolean changeMstrObMgReMatlBOM_oc )
    {
        rememberChangedField("to_ChangeMstrObMgReMatlBOM_oc", this.changeMstrObMgReMatlBOM_oc);
        this.changeMstrObMgReMatlBOM_oc = changeMstrObMgReMatlBOM_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ObjTypeAssignment_oc</b>
     * </p>
     *
     * @param objTypeAssignment_oc
     *            Dynamic CbA-Control
     */
    public void setObjTypeAssignment_oc( @Nullable final Boolean objTypeAssignment_oc )
    {
        rememberChangedField("to_ObjTypeAssignment_oc", this.objTypeAssignment_oc);
        this.objTypeAssignment_oc = objTypeAssignment_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberStatus</b>
     * </p>
     *
     * @param changeNumberStatus
     *            Status of Change Number
     */
    public void setChangeNumberStatus( @Nullable final String changeNumberStatus )
    {
        rememberChangedField("ChangeNumberStatus", this.changeNumberStatus);
        this.changeNumberStatus = changeNumberStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @param authorizationGroup
     *            Authorization group for change master record
     */
    public void setAuthorizationGroup( @Nullable final String authorizationGroup )
    {
        rememberChangedField("AuthorizationGroup", this.authorizationGroup);
        this.authorizationGroup = authorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberFunction</b>
     * </p>
     *
     * @param changeNumberFunction
     *            Change number function
     */
    public void setChangeNumberFunction( @Nullable final String changeNumberFunction )
    {
        rememberChangedField("ChangeNumberFunction", this.changeNumberFunction);
        this.changeNumberFunction = changeNumberFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsTechnicallyReleased</b>
     * </p>
     *
     * @param isTechnicallyReleased
     *            Indicator: Technical release occurs
     */
    public void setIsTechnicallyReleased( @Nullable final String isTechnicallyReleased )
    {
        rememberChangedField("IsTechnicallyReleased", this.isTechnicallyReleased);
        this.isTechnicallyReleased = isTechnicallyReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberReleaseKey</b>
     * </p>
     *
     * @param changeNumberReleaseKey
     *            Release Key for Change Master Record
     */
    public void setChangeNumberReleaseKey( @Nullable final String changeNumberReleaseKey )
    {
        rememberChangedField("ChangeNumberReleaseKey", this.changeNumberReleaseKey);
        this.changeNumberReleaseKey = changeNumberReleaseKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ReasonForChangeText</b>
     * </p>
     *
     * @param reasonForChangeText
     *            Reason for change
     */
    public void setReasonForChangeText( @Nullable final String reasonForChangeText )
    {
        rememberChangedField("ReasonForChangeText", this.reasonForChangeText);
        this.reasonForChangeText = reasonForChangeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberDescription</b>
     * </p>
     *
     * @param changeNumberDescription
     *            Change number description
     */
    public void setChangeNumberDescription( @Nullable final String changeNumberDescription )
    {
        rememberChangedField("ChangeNumberDescription", this.changeNumberDescription);
        this.changeNumberDescription = changeNumberDescription;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberValidFromDate</b>
     * </p>
     *
     * @param changeNumberValidFromDate
     *            Valid-From Date
     */
    public void setChangeNumberValidFromDate( @Nullable final LocalDateTime changeNumberValidFromDate )
    {
        rememberChangedField("ChangeNumberValidFromDate", this.changeNumberValidFromDate);
        this.changeNumberValidFromDate = changeNumberValidFromDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberCreationDate</b>
     * </p>
     *
     * @param changeNumberCreationDate
     *            Date on Which Record Was Created
     */
    public void setChangeNumberCreationDate( @Nullable final LocalDateTime changeNumberCreationDate )
    {
        rememberChangedField("ChangeNumberCreationDate", this.changeNumberCreationDate);
        this.changeNumberCreationDate = changeNumberCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberCreatedByUser</b>
     * </p>
     *
     * @param changeNumberCreatedByUser
     *            User Who Created Record
     */
    public void setChangeNumberCreatedByUser( @Nullable final String changeNumberCreatedByUser )
    {
        rememberChangedField("ChangeNumberCreatedByUser", this.changeNumberCreatedByUser);
        this.changeNumberCreatedByUser = changeNumberCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberLastChangedDate</b>
     * </p>
     *
     * @param changeNumberLastChangedDate
     *            Changed On
     */
    public void setChangeNumberLastChangedDate( @Nullable final LocalDateTime changeNumberLastChangedDate )
    {
        rememberChangedField("ChangeNumberLastChangedDate", this.changeNumberLastChangedDate);
        this.changeNumberLastChangedDate = changeNumberLastChangedDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberLastChangedByUser</b>
     * </p>
     *
     * @param changeNumberLastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setChangeNumberLastChangedByUser( @Nullable final String changeNumberLastChangedByUser )
    {
        rememberChangedField("ChangeNumberLastChangedByUser", this.changeNumberLastChangedByUser);
        this.changeNumberLastChangedByUser = changeNumberLastChangedByUser;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsUsedForDataDefinition</b>
     * </p>
     *
     * @param isUsedForDataDefinition
     *            Change Number Is Currently Being Used in Objects
     */
    public void setIsUsedForDataDefinition( @Nullable final Boolean isUsedForDataDefinition )
    {
        rememberChangedField("IsUsedForDataDefinition", this.isUsedForDataDefinition);
        this.isUsedForDataDefinition = isUsedForDataDefinition;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberIsMrkdForDeletion</b>
     * </p>
     *
     * @param changeNumberIsMrkdForDeletion
     *            Deletion Flag for Change Number (Reorganization)
     */
    public void setChangeNumberIsMrkdForDeletion( @Nullable final Boolean changeNumberIsMrkdForDeletion )
    {
        rememberChangedField("ChangeNumberIsMrkdForDeletion", this.changeNumberIsMrkdForDeletion);
        this.changeNumberIsMrkdForDeletion = changeNumberIsMrkdForDeletion;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberLastChgdDateTime</b>
     * </p>
     *
     * @param changeNumberLastChgdDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setChangeNumberLastChgdDateTime( @Nullable final ZonedDateTime changeNumberLastChgdDateTime )
    {
        rememberChangedField("ChangeNumberLastChgdDateTime", this.changeNumberLastChgdDateTime);
        this.changeNumberLastChgdDateTime = changeNumberLastChgdDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ChangeMaster";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChangeNumber", getChangeNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ShiftValidityStartDate_ac", getShiftValidityStartDate_ac());
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("to_AlternativeDate_oc", getAlternativeDate_oc());
        values.put("to_ChangeMstrObMgReDocInfoRecd_oc", getChangeMstrObMgReDocInfoRecd_oc());
        values.put("to_ChangeMstrObMgReMaterial_oc", getChangeMstrObMgReMaterial_oc());
        values.put("to_ChangeMstrObMgReMatlBOM_oc", getChangeMstrObMgReMatlBOM_oc());
        values.put("to_ObjTypeAssignment_oc", getObjTypeAssignment_oc());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ChangeNumberStatus", getChangeNumberStatus());
        values.put("AuthorizationGroup", getAuthorizationGroup());
        values.put("ChangeNumberFunction", getChangeNumberFunction());
        values.put("IsTechnicallyReleased", getIsTechnicallyReleased());
        values.put("ChangeNumberReleaseKey", getChangeNumberReleaseKey());
        values.put("ReasonForChangeText", getReasonForChangeText());
        values.put("ChangeNumberDescription", getChangeNumberDescription());
        values.put("ChangeNumberValidFromDate", getChangeNumberValidFromDate());
        values.put("ChangeNumberCreationDate", getChangeNumberCreationDate());
        values.put("ChangeNumberCreatedByUser", getChangeNumberCreatedByUser());
        values.put("ChangeNumberLastChangedDate", getChangeNumberLastChangedDate());
        values.put("ChangeNumberLastChangedByUser", getChangeNumberLastChangedByUser());
        values.put("IsUsedForDataDefinition", getIsUsedForDataDefinition());
        values.put("ChangeNumberIsMrkdForDeletion", getChangeNumberIsMrkdForDeletion());
        values.put("ChangeNumberLastChgdDateTime", getChangeNumberLastChgdDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ShiftValidityStartDate_ac") ) {
                final Object value = values.remove("ShiftValidityStartDate_ac");
                if( (value == null) || (!value.equals(getShiftValidityStartDate_ac())) ) {
                    setShiftValidityStartDate_ac(((Boolean) value));
                }
            }
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("to_AlternativeDate_oc") ) {
                final Object value = values.remove("to_AlternativeDate_oc");
                if( (value == null) || (!value.equals(getAlternativeDate_oc())) ) {
                    setAlternativeDate_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeMstrObMgReDocInfoRecd_oc") ) {
                final Object value = values.remove("to_ChangeMstrObMgReDocInfoRecd_oc");
                if( (value == null) || (!value.equals(getChangeMstrObMgReDocInfoRecd_oc())) ) {
                    setChangeMstrObMgReDocInfoRecd_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeMstrObMgReMaterial_oc") ) {
                final Object value = values.remove("to_ChangeMstrObMgReMaterial_oc");
                if( (value == null) || (!value.equals(getChangeMstrObMgReMaterial_oc())) ) {
                    setChangeMstrObMgReMaterial_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeMstrObMgReMatlBOM_oc") ) {
                final Object value = values.remove("to_ChangeMstrObMgReMatlBOM_oc");
                if( (value == null) || (!value.equals(getChangeMstrObMgReMatlBOM_oc())) ) {
                    setChangeMstrObMgReMatlBOM_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ObjTypeAssignment_oc") ) {
                final Object value = values.remove("to_ObjTypeAssignment_oc");
                if( (value == null) || (!value.equals(getObjTypeAssignment_oc())) ) {
                    setObjTypeAssignment_oc(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ChangeNumberStatus") ) {
                final Object value = values.remove("ChangeNumberStatus");
                if( (value == null) || (!value.equals(getChangeNumberStatus())) ) {
                    setChangeNumberStatus(((String) value));
                }
            }
            if( values.containsKey("AuthorizationGroup") ) {
                final Object value = values.remove("AuthorizationGroup");
                if( (value == null) || (!value.equals(getAuthorizationGroup())) ) {
                    setAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("ChangeNumberFunction") ) {
                final Object value = values.remove("ChangeNumberFunction");
                if( (value == null) || (!value.equals(getChangeNumberFunction())) ) {
                    setChangeNumberFunction(((String) value));
                }
            }
            if( values.containsKey("IsTechnicallyReleased") ) {
                final Object value = values.remove("IsTechnicallyReleased");
                if( (value == null) || (!value.equals(getIsTechnicallyReleased())) ) {
                    setIsTechnicallyReleased(((String) value));
                }
            }
            if( values.containsKey("ChangeNumberReleaseKey") ) {
                final Object value = values.remove("ChangeNumberReleaseKey");
                if( (value == null) || (!value.equals(getChangeNumberReleaseKey())) ) {
                    setChangeNumberReleaseKey(((String) value));
                }
            }
            if( values.containsKey("ReasonForChangeText") ) {
                final Object value = values.remove("ReasonForChangeText");
                if( (value == null) || (!value.equals(getReasonForChangeText())) ) {
                    setReasonForChangeText(((String) value));
                }
            }
            if( values.containsKey("ChangeNumberDescription") ) {
                final Object value = values.remove("ChangeNumberDescription");
                if( (value == null) || (!value.equals(getChangeNumberDescription())) ) {
                    setChangeNumberDescription(((String) value));
                }
            }
            if( values.containsKey("ChangeNumberValidFromDate") ) {
                final Object value = values.remove("ChangeNumberValidFromDate");
                if( (value == null) || (!value.equals(getChangeNumberValidFromDate())) ) {
                    setChangeNumberValidFromDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumberCreationDate") ) {
                final Object value = values.remove("ChangeNumberCreationDate");
                if( (value == null) || (!value.equals(getChangeNumberCreationDate())) ) {
                    setChangeNumberCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumberCreatedByUser") ) {
                final Object value = values.remove("ChangeNumberCreatedByUser");
                if( (value == null) || (!value.equals(getChangeNumberCreatedByUser())) ) {
                    setChangeNumberCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("ChangeNumberLastChangedDate") ) {
                final Object value = values.remove("ChangeNumberLastChangedDate");
                if( (value == null) || (!value.equals(getChangeNumberLastChangedDate())) ) {
                    setChangeNumberLastChangedDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumberLastChangedByUser") ) {
                final Object value = values.remove("ChangeNumberLastChangedByUser");
                if( (value == null) || (!value.equals(getChangeNumberLastChangedByUser())) ) {
                    setChangeNumberLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("IsUsedForDataDefinition") ) {
                final Object value = values.remove("IsUsedForDataDefinition");
                if( (value == null) || (!value.equals(getIsUsedForDataDefinition())) ) {
                    setIsUsedForDataDefinition(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeNumberIsMrkdForDeletion") ) {
                final Object value = values.remove("ChangeNumberIsMrkdForDeletion");
                if( (value == null) || (!value.equals(getChangeNumberIsMrkdForDeletion())) ) {
                    setChangeNumberIsMrkdForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeNumberLastChgdDateTime") ) {
                final Object value = values.remove("ChangeNumberLastChgdDateTime");
                if( (value == null) || (!value.equals(getChangeNumberLastChgdDateTime())) ) {
                    setChangeNumberLastChgdDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_AlternativeDate") ) {
                final Object value = (values).remove("to_AlternativeDate");
                if( value instanceof Iterable ) {
                    if( toAlternativeDate == null ) {
                        toAlternativeDate = Lists.newArrayList();
                    } else {
                        toAlternativeDate = Lists.newArrayList(toAlternativeDate);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeMasterAltDate entity;
                        if( toAlternativeDate.size() > i ) {
                            entity = toAlternativeDate.get(i);
                        } else {
                            entity = new ChangeMasterAltDate();
                            toAlternativeDate.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChangeMstrObjectMgmtRecord") ) {
                final Object value = (values).remove("to_ChangeMstrObjectMgmtRecord");
                if( value instanceof Iterable ) {
                    if( toChangeMstrObjectMgmtRecord == null ) {
                        toChangeMstrObjectMgmtRecord = Lists.newArrayList();
                    } else {
                        toChangeMstrObjectMgmtRecord = Lists.newArrayList(toChangeMstrObjectMgmtRecord);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeMstrObjectMgmtRecord entity;
                        if( toChangeMstrObjectMgmtRecord.size() > i ) {
                            entity = toChangeMstrObjectMgmtRecord.get(i);
                        } else {
                            entity = new ChangeMstrObjectMgmtRecord();
                            toChangeMstrObjectMgmtRecord.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChangeMstrObMgReDocInfoRecd") ) {
                final Object value = (values).remove("to_ChangeMstrObMgReDocInfoRecd");
                if( value instanceof Iterable ) {
                    if( toChangeMstrObMgReDocInfoRecd == null ) {
                        toChangeMstrObMgReDocInfoRecd = Lists.newArrayList();
                    } else {
                        toChangeMstrObMgReDocInfoRecd = Lists.newArrayList(toChangeMstrObMgReDocInfoRecd);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeMstrObMgReDocInfoRecd entity;
                        if( toChangeMstrObMgReDocInfoRecd.size() > i ) {
                            entity = toChangeMstrObMgReDocInfoRecd.get(i);
                        } else {
                            entity = new ChangeMstrObMgReDocInfoRecd();
                            toChangeMstrObMgReDocInfoRecd.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChangeMstrObMgReMaterial") ) {
                final Object value = (values).remove("to_ChangeMstrObMgReMaterial");
                if( value instanceof Iterable ) {
                    if( toChangeMstrObMgReMaterial == null ) {
                        toChangeMstrObMgReMaterial = Lists.newArrayList();
                    } else {
                        toChangeMstrObMgReMaterial = Lists.newArrayList(toChangeMstrObMgReMaterial);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeMstrObMgReMaterial entity;
                        if( toChangeMstrObMgReMaterial.size() > i ) {
                            entity = toChangeMstrObMgReMaterial.get(i);
                        } else {
                            entity = new ChangeMstrObMgReMaterial();
                            toChangeMstrObMgReMaterial.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChangeMstrObMgReMatlBOM") ) {
                final Object value = (values).remove("to_ChangeMstrObMgReMatlBOM");
                if( value instanceof Iterable ) {
                    if( toChangeMstrObMgReMatlBOM == null ) {
                        toChangeMstrObMgReMatlBOM = Lists.newArrayList();
                    } else {
                        toChangeMstrObMgReMatlBOM = Lists.newArrayList(toChangeMstrObMgReMatlBOM);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeMstrObMgReMatlBOM entity;
                        if( toChangeMstrObMgReMatlBOM.size() > i ) {
                            entity = toChangeMstrObMgReMatlBOM.get(i);
                        } else {
                            entity = new ChangeMstrObMgReMatlBOM();
                            toChangeMstrObMgReMatlBOM.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Characteristics") ) {
                final Object value = (values).remove("to_Characteristics");
                if( value instanceof Iterable ) {
                    if( toCharacteristics == null ) {
                        toCharacteristics = Lists.newArrayList();
                    } else {
                        toCharacteristics = Lists.newArrayList(toCharacteristics);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeMasterCharc entity;
                        if( toCharacteristics.size() > i ) {
                            entity = toCharacteristics.get(i);
                        } else {
                            entity = new ChangeMasterCharc();
                            toCharacteristics.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Classification") ) {
                final Object value = (values).remove("to_Classification");
                if( value instanceof Iterable ) {
                    if( toClassification == null ) {
                        toClassification = Lists.newArrayList();
                    } else {
                        toClassification = Lists.newArrayList(toClassification);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeMasterClass entity;
                        if( toClassification.size() > i ) {
                            entity = toClassification.get(i);
                        } else {
                            entity = new ChangeMasterClass();
                            toClassification.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ObjTypeAssignment") ) {
                final Object value = (values).remove("to_ObjTypeAssignment");
                if( value instanceof Iterable ) {
                    if( toObjTypeAssignment == null ) {
                        toObjTypeAssignment = Lists.newArrayList();
                    } else {
                        toObjTypeAssignment = Lists.newArrayList(toObjTypeAssignment);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeMasterObjTypeAssgmt entity;
                        if( toObjTypeAssignment.size() > i ) {
                            entity = toObjTypeAssignment.get(i);
                        } else {
                            entity = new ChangeMasterObjTypeAssgmt();
                            toObjTypeAssignment.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ChangeMasterField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ChangeMasterField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChangeMasterField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChangeMasterField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeMasterV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toAlternativeDate != null ) {
            (values).put("to_AlternativeDate", toAlternativeDate);
        }
        if( toChangeMstrObjectMgmtRecord != null ) {
            (values).put("to_ChangeMstrObjectMgmtRecord", toChangeMstrObjectMgmtRecord);
        }
        if( toChangeMstrObMgReDocInfoRecd != null ) {
            (values).put("to_ChangeMstrObMgReDocInfoRecd", toChangeMstrObMgReDocInfoRecd);
        }
        if( toChangeMstrObMgReMaterial != null ) {
            (values).put("to_ChangeMstrObMgReMaterial", toChangeMstrObMgReMaterial);
        }
        if( toChangeMstrObMgReMatlBOM != null ) {
            (values).put("to_ChangeMstrObMgReMatlBOM", toChangeMstrObMgReMatlBOM);
        }
        if( toCharacteristics != null ) {
            (values).put("to_Characteristics", toCharacteristics);
        }
        if( toClassification != null ) {
            (values).put("to_Classification", toClassification);
        }
        if( toObjTypeAssignment != null ) {
            (values).put("to_ObjTypeAssignment", toObjTypeAssignment);
        }
        return values;
    }

    /**
     * Fetches the <b>ChangeMasterAltDate</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_AlternativeDate</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeMasterAltDate</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMasterAltDate> fetchAlternativeDate()
    {
        return fetchFieldAsList("to_AlternativeDate", ChangeMasterAltDate.class);
    }

    /**
     * Retrieval of associated <b>ChangeMasterAltDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_AlternativeDate</b>.
     * <p>
     * If the navigation property <b>to_AlternativeDate</b> of a queried <b>ChangeMaster</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeMasterAltDate</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMasterAltDate> getAlternativeDateOrFetch()
    {
        if( toAlternativeDate == null ) {
            toAlternativeDate = fetchAlternativeDate();
        }
        return toAlternativeDate;
    }

    /**
     * Retrieval of associated <b>ChangeMasterAltDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_AlternativeDate</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeMaster</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_AlternativeDate</b> is already loaded, the result will
     *         contain the <b>ChangeMasterAltDate</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeMasterAltDate>> getAlternativeDateIfPresent()
    {
        return Option.of(toAlternativeDate);
    }

    /**
     * Overwrites the list of associated <b>ChangeMasterAltDate</b> entities for the loaded navigation property
     * <b>to_AlternativeDate</b>.
     * <p>
     * If the navigation property <b>to_AlternativeDate</b> of a queried <b>ChangeMaster</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeMasterAltDate</b> entities.
     */
    public void setAlternativeDate( @Nonnull final List<ChangeMasterAltDate> value )
    {
        if( toAlternativeDate == null ) {
            toAlternativeDate = Lists.newArrayList();
        }
        toAlternativeDate.clear();
        toAlternativeDate.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeMasterAltDate</b> entities. This corresponds to the OData
     * navigation property <b>to_AlternativeDate</b>.
     * <p>
     * If the navigation property <b>to_AlternativeDate</b> of a queried <b>ChangeMaster</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeMasterAltDate</b> entities.
     */
    public void addAlternativeDate( ChangeMasterAltDate... entity )
    {
        if( toAlternativeDate == null ) {
            toAlternativeDate = Lists.newArrayList();
        }
        toAlternativeDate.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeMstrObjectMgmtRecord</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ChangeMstrObjectMgmtRecord</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeMstrObjectMgmtRecord</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMstrObjectMgmtRecord> fetchChangeMstrObjectMgmtRecord()
    {
        return fetchFieldAsList("to_ChangeMstrObjectMgmtRecord", ChangeMstrObjectMgmtRecord.class);
    }

    /**
     * Retrieval of associated <b>ChangeMstrObjectMgmtRecord</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeMstrObjectMgmtRecord</b>.
     * <p>
     * If the navigation property <b>to_ChangeMstrObjectMgmtRecord</b> of a queried <b>ChangeMaster</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeMstrObjectMgmtRecord</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMstrObjectMgmtRecord> getChangeMstrObjectMgmtRecordOrFetch()
    {
        if( toChangeMstrObjectMgmtRecord == null ) {
            toChangeMstrObjectMgmtRecord = fetchChangeMstrObjectMgmtRecord();
        }
        return toChangeMstrObjectMgmtRecord;
    }

    /**
     * Retrieval of associated <b>ChangeMstrObjectMgmtRecord</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeMstrObjectMgmtRecord</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeMaster</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChangeMstrObjectMgmtRecord</b> is already loaded, the
     *         result will contain the <b>ChangeMstrObjectMgmtRecord</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeMstrObjectMgmtRecord>> getChangeMstrObjectMgmtRecordIfPresent()
    {
        return Option.of(toChangeMstrObjectMgmtRecord);
    }

    /**
     * Overwrites the list of associated <b>ChangeMstrObjectMgmtRecord</b> entities for the loaded navigation property
     * <b>to_ChangeMstrObjectMgmtRecord</b>.
     * <p>
     * If the navigation property <b>to_ChangeMstrObjectMgmtRecord</b> of a queried <b>ChangeMaster</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeMstrObjectMgmtRecord</b> entities.
     */
    public void setChangeMstrObjectMgmtRecord( @Nonnull final List<ChangeMstrObjectMgmtRecord> value )
    {
        if( toChangeMstrObjectMgmtRecord == null ) {
            toChangeMstrObjectMgmtRecord = Lists.newArrayList();
        }
        toChangeMstrObjectMgmtRecord.clear();
        toChangeMstrObjectMgmtRecord.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeMstrObjectMgmtRecord</b> entities. This corresponds to the OData
     * navigation property <b>to_ChangeMstrObjectMgmtRecord</b>.
     * <p>
     * If the navigation property <b>to_ChangeMstrObjectMgmtRecord</b> of a queried <b>ChangeMaster</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeMstrObjectMgmtRecord</b> entities.
     */
    public void addChangeMstrObjectMgmtRecord( ChangeMstrObjectMgmtRecord... entity )
    {
        if( toChangeMstrObjectMgmtRecord == null ) {
            toChangeMstrObjectMgmtRecord = Lists.newArrayList();
        }
        toChangeMstrObjectMgmtRecord.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeMstrObMgReDocInfoRecd</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ChangeMstrObMgReDocInfoRecd</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeMstrObMgReDocInfoRecd</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMstrObMgReDocInfoRecd> fetchChangeMstrObMgReDocInfoRecd()
    {
        return fetchFieldAsList("to_ChangeMstrObMgReDocInfoRecd", ChangeMstrObMgReDocInfoRecd.class);
    }

    /**
     * Retrieval of associated <b>ChangeMstrObMgReDocInfoRecd</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeMstrObMgReDocInfoRecd</b>.
     * <p>
     * If the navigation property <b>to_ChangeMstrObMgReDocInfoRecd</b> of a queried <b>ChangeMaster</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeMstrObMgReDocInfoRecd</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMstrObMgReDocInfoRecd> getChangeMstrObMgReDocInfoRecdOrFetch()
    {
        if( toChangeMstrObMgReDocInfoRecd == null ) {
            toChangeMstrObMgReDocInfoRecd = fetchChangeMstrObMgReDocInfoRecd();
        }
        return toChangeMstrObMgReDocInfoRecd;
    }

    /**
     * Retrieval of associated <b>ChangeMstrObMgReDocInfoRecd</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeMstrObMgReDocInfoRecd</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeMaster</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChangeMstrObMgReDocInfoRecd</b> is already loaded, the
     *         result will contain the <b>ChangeMstrObMgReDocInfoRecd</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeMstrObMgReDocInfoRecd>> getChangeMstrObMgReDocInfoRecdIfPresent()
    {
        return Option.of(toChangeMstrObMgReDocInfoRecd);
    }

    /**
     * Overwrites the list of associated <b>ChangeMstrObMgReDocInfoRecd</b> entities for the loaded navigation property
     * <b>to_ChangeMstrObMgReDocInfoRecd</b>.
     * <p>
     * If the navigation property <b>to_ChangeMstrObMgReDocInfoRecd</b> of a queried <b>ChangeMaster</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeMstrObMgReDocInfoRecd</b> entities.
     */
    public void setChangeMstrObMgReDocInfoRecd( @Nonnull final List<ChangeMstrObMgReDocInfoRecd> value )
    {
        if( toChangeMstrObMgReDocInfoRecd == null ) {
            toChangeMstrObMgReDocInfoRecd = Lists.newArrayList();
        }
        toChangeMstrObMgReDocInfoRecd.clear();
        toChangeMstrObMgReDocInfoRecd.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeMstrObMgReDocInfoRecd</b> entities. This corresponds to the
     * OData navigation property <b>to_ChangeMstrObMgReDocInfoRecd</b>.
     * <p>
     * If the navigation property <b>to_ChangeMstrObMgReDocInfoRecd</b> of a queried <b>ChangeMaster</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeMstrObMgReDocInfoRecd</b> entities.
     */
    public void addChangeMstrObMgReDocInfoRecd( ChangeMstrObMgReDocInfoRecd... entity )
    {
        if( toChangeMstrObMgReDocInfoRecd == null ) {
            toChangeMstrObMgReDocInfoRecd = Lists.newArrayList();
        }
        toChangeMstrObMgReDocInfoRecd.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeMstrObMgReMaterial</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ChangeMstrObMgReMaterial</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeMstrObMgReMaterial</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMstrObMgReMaterial> fetchChangeMstrObMgReMaterial()
    {
        return fetchFieldAsList("to_ChangeMstrObMgReMaterial", ChangeMstrObMgReMaterial.class);
    }

    /**
     * Retrieval of associated <b>ChangeMstrObMgReMaterial</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeMstrObMgReMaterial</b>.
     * <p>
     * If the navigation property <b>to_ChangeMstrObMgReMaterial</b> of a queried <b>ChangeMaster</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeMstrObMgReMaterial</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMstrObMgReMaterial> getChangeMstrObMgReMaterialOrFetch()
    {
        if( toChangeMstrObMgReMaterial == null ) {
            toChangeMstrObMgReMaterial = fetchChangeMstrObMgReMaterial();
        }
        return toChangeMstrObMgReMaterial;
    }

    /**
     * Retrieval of associated <b>ChangeMstrObMgReMaterial</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeMstrObMgReMaterial</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeMaster</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChangeMstrObMgReMaterial</b> is already loaded, the
     *         result will contain the <b>ChangeMstrObMgReMaterial</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeMstrObMgReMaterial>> getChangeMstrObMgReMaterialIfPresent()
    {
        return Option.of(toChangeMstrObMgReMaterial);
    }

    /**
     * Overwrites the list of associated <b>ChangeMstrObMgReMaterial</b> entities for the loaded navigation property
     * <b>to_ChangeMstrObMgReMaterial</b>.
     * <p>
     * If the navigation property <b>to_ChangeMstrObMgReMaterial</b> of a queried <b>ChangeMaster</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeMstrObMgReMaterial</b> entities.
     */
    public void setChangeMstrObMgReMaterial( @Nonnull final List<ChangeMstrObMgReMaterial> value )
    {
        if( toChangeMstrObMgReMaterial == null ) {
            toChangeMstrObMgReMaterial = Lists.newArrayList();
        }
        toChangeMstrObMgReMaterial.clear();
        toChangeMstrObMgReMaterial.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeMstrObMgReMaterial</b> entities. This corresponds to the OData
     * navigation property <b>to_ChangeMstrObMgReMaterial</b>.
     * <p>
     * If the navigation property <b>to_ChangeMstrObMgReMaterial</b> of a queried <b>ChangeMaster</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeMstrObMgReMaterial</b> entities.
     */
    public void addChangeMstrObMgReMaterial( ChangeMstrObMgReMaterial... entity )
    {
        if( toChangeMstrObMgReMaterial == null ) {
            toChangeMstrObMgReMaterial = Lists.newArrayList();
        }
        toChangeMstrObMgReMaterial.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeMstrObMgReMatlBOM</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ChangeMstrObMgReMatlBOM</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeMstrObMgReMatlBOM</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMstrObMgReMatlBOM> fetchChangeMstrObMgReMatlBOM()
    {
        return fetchFieldAsList("to_ChangeMstrObMgReMatlBOM", ChangeMstrObMgReMatlBOM.class);
    }

    /**
     * Retrieval of associated <b>ChangeMstrObMgReMatlBOM</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeMstrObMgReMatlBOM</b>.
     * <p>
     * If the navigation property <b>to_ChangeMstrObMgReMatlBOM</b> of a queried <b>ChangeMaster</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeMstrObMgReMatlBOM</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMstrObMgReMatlBOM> getChangeMstrObMgReMatlBOMOrFetch()
    {
        if( toChangeMstrObMgReMatlBOM == null ) {
            toChangeMstrObMgReMatlBOM = fetchChangeMstrObMgReMatlBOM();
        }
        return toChangeMstrObMgReMatlBOM;
    }

    /**
     * Retrieval of associated <b>ChangeMstrObMgReMatlBOM</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeMstrObMgReMatlBOM</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeMaster</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChangeMstrObMgReMatlBOM</b> is already loaded, the
     *         result will contain the <b>ChangeMstrObMgReMatlBOM</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeMstrObMgReMatlBOM>> getChangeMstrObMgReMatlBOMIfPresent()
    {
        return Option.of(toChangeMstrObMgReMatlBOM);
    }

    /**
     * Overwrites the list of associated <b>ChangeMstrObMgReMatlBOM</b> entities for the loaded navigation property
     * <b>to_ChangeMstrObMgReMatlBOM</b>.
     * <p>
     * If the navigation property <b>to_ChangeMstrObMgReMatlBOM</b> of a queried <b>ChangeMaster</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeMstrObMgReMatlBOM</b> entities.
     */
    public void setChangeMstrObMgReMatlBOM( @Nonnull final List<ChangeMstrObMgReMatlBOM> value )
    {
        if( toChangeMstrObMgReMatlBOM == null ) {
            toChangeMstrObMgReMatlBOM = Lists.newArrayList();
        }
        toChangeMstrObMgReMatlBOM.clear();
        toChangeMstrObMgReMatlBOM.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeMstrObMgReMatlBOM</b> entities. This corresponds to the OData
     * navigation property <b>to_ChangeMstrObMgReMatlBOM</b>.
     * <p>
     * If the navigation property <b>to_ChangeMstrObMgReMatlBOM</b> of a queried <b>ChangeMaster</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeMstrObMgReMatlBOM</b> entities.
     */
    public void addChangeMstrObMgReMatlBOM( ChangeMstrObMgReMatlBOM... entity )
    {
        if( toChangeMstrObMgReMatlBOM == null ) {
            toChangeMstrObMgReMatlBOM = Lists.newArrayList();
        }
        toChangeMstrObMgReMatlBOM.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeMasterCharc</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Characteristics</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeMasterCharc</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMasterCharc> fetchCharacteristics()
    {
        return fetchFieldAsList("to_Characteristics", ChangeMasterCharc.class);
    }

    /**
     * Retrieval of associated <b>ChangeMasterCharc</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Characteristics</b>.
     * <p>
     * If the navigation property <b>to_Characteristics</b> of a queried <b>ChangeMaster</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeMasterCharc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMasterCharc> getCharacteristicsOrFetch()
    {
        if( toCharacteristics == null ) {
            toCharacteristics = fetchCharacteristics();
        }
        return toCharacteristics;
    }

    /**
     * Retrieval of associated <b>ChangeMasterCharc</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Characteristics</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeMaster</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Characteristics</b> is already loaded, the result will
     *         contain the <b>ChangeMasterCharc</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeMasterCharc>> getCharacteristicsIfPresent()
    {
        return Option.of(toCharacteristics);
    }

    /**
     * Overwrites the list of associated <b>ChangeMasterCharc</b> entities for the loaded navigation property
     * <b>to_Characteristics</b>.
     * <p>
     * If the navigation property <b>to_Characteristics</b> of a queried <b>ChangeMaster</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeMasterCharc</b> entities.
     */
    public void setCharacteristics( @Nonnull final List<ChangeMasterCharc> value )
    {
        if( toCharacteristics == null ) {
            toCharacteristics = Lists.newArrayList();
        }
        toCharacteristics.clear();
        toCharacteristics.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeMasterCharc</b> entities. This corresponds to the OData
     * navigation property <b>to_Characteristics</b>.
     * <p>
     * If the navigation property <b>to_Characteristics</b> of a queried <b>ChangeMaster</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeMasterCharc</b> entities.
     */
    public void addCharacteristics( ChangeMasterCharc... entity )
    {
        if( toCharacteristics == null ) {
            toCharacteristics = Lists.newArrayList();
        }
        toCharacteristics.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeMasterClass</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Classification</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeMasterClass</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMasterClass> fetchClassification()
    {
        return fetchFieldAsList("to_Classification", ChangeMasterClass.class);
    }

    /**
     * Retrieval of associated <b>ChangeMasterClass</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Classification</b>.
     * <p>
     * If the navigation property <b>to_Classification</b> of a queried <b>ChangeMaster</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeMasterClass</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMasterClass> getClassificationOrFetch()
    {
        if( toClassification == null ) {
            toClassification = fetchClassification();
        }
        return toClassification;
    }

    /**
     * Retrieval of associated <b>ChangeMasterClass</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Classification</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeMaster</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Classification</b> is already loaded, the result will
     *         contain the <b>ChangeMasterClass</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeMasterClass>> getClassificationIfPresent()
    {
        return Option.of(toClassification);
    }

    /**
     * Overwrites the list of associated <b>ChangeMasterClass</b> entities for the loaded navigation property
     * <b>to_Classification</b>.
     * <p>
     * If the navigation property <b>to_Classification</b> of a queried <b>ChangeMaster</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeMasterClass</b> entities.
     */
    public void setClassification( @Nonnull final List<ChangeMasterClass> value )
    {
        if( toClassification == null ) {
            toClassification = Lists.newArrayList();
        }
        toClassification.clear();
        toClassification.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeMasterClass</b> entities. This corresponds to the OData
     * navigation property <b>to_Classification</b>.
     * <p>
     * If the navigation property <b>to_Classification</b> of a queried <b>ChangeMaster</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeMasterClass</b> entities.
     */
    public void addClassification( ChangeMasterClass... entity )
    {
        if( toClassification == null ) {
            toClassification = Lists.newArrayList();
        }
        toClassification.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeMasterObjTypeAssgmt</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ObjTypeAssignment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeMasterObjTypeAssgmt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMasterObjTypeAssgmt> fetchObjTypeAssignment()
    {
        return fetchFieldAsList("to_ObjTypeAssignment", ChangeMasterObjTypeAssgmt.class);
    }

    /**
     * Retrieval of associated <b>ChangeMasterObjTypeAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ObjTypeAssignment</b>.
     * <p>
     * If the navigation property <b>to_ObjTypeAssignment</b> of a queried <b>ChangeMaster</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeMasterObjTypeAssgmt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeMasterObjTypeAssgmt> getObjTypeAssignmentOrFetch()
    {
        if( toObjTypeAssignment == null ) {
            toObjTypeAssignment = fetchObjTypeAssignment();
        }
        return toObjTypeAssignment;
    }

    /**
     * Retrieval of associated <b>ChangeMasterObjTypeAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ObjTypeAssignment</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeMaster</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ObjTypeAssignment</b> is already loaded, the result will
     *         contain the <b>ChangeMasterObjTypeAssgmt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeMasterObjTypeAssgmt>> getObjTypeAssignmentIfPresent()
    {
        return Option.of(toObjTypeAssignment);
    }

    /**
     * Overwrites the list of associated <b>ChangeMasterObjTypeAssgmt</b> entities for the loaded navigation property
     * <b>to_ObjTypeAssignment</b>.
     * <p>
     * If the navigation property <b>to_ObjTypeAssignment</b> of a queried <b>ChangeMaster</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeMasterObjTypeAssgmt</b> entities.
     */
    public void setObjTypeAssignment( @Nonnull final List<ChangeMasterObjTypeAssgmt> value )
    {
        if( toObjTypeAssignment == null ) {
            toObjTypeAssignment = Lists.newArrayList();
        }
        toObjTypeAssignment.clear();
        toObjTypeAssignment.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeMasterObjTypeAssgmt</b> entities. This corresponds to the OData
     * navigation property <b>to_ObjTypeAssignment</b>.
     * <p>
     * If the navigation property <b>to_ObjTypeAssignment</b> of a queried <b>ChangeMaster</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeMasterObjTypeAssgmt</b> entities.
     */
    public void addObjTypeAssignment( ChangeMasterObjTypeAssgmt... entity )
    {
        if( toObjTypeAssignment == null ) {
            toObjTypeAssignment = Lists.newArrayList();
        }
        toObjTypeAssignment.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ChangeMaster instances.
     *
     */
    public final static class ChangeMasterBuilder
    {

        private List<ChangeMasterAltDate> toAlternativeDate = Lists.newArrayList();
        private List<ChangeMstrObjectMgmtRecord> toChangeMstrObjectMgmtRecord = Lists.newArrayList();
        private List<ChangeMstrObMgReDocInfoRecd> toChangeMstrObMgReDocInfoRecd = Lists.newArrayList();
        private List<ChangeMstrObMgReMaterial> toChangeMstrObMgReMaterial = Lists.newArrayList();
        private List<ChangeMstrObMgReMatlBOM> toChangeMstrObMgReMatlBOM = Lists.newArrayList();
        private List<ChangeMasterCharc> toCharacteristics = Lists.newArrayList();
        private List<ChangeMasterClass> toClassification = Lists.newArrayList();
        private List<ChangeMasterObjTypeAssgmt> toObjTypeAssignment = Lists.newArrayList();

        private ChangeMaster.ChangeMasterBuilder toAlternativeDate( final List<ChangeMasterAltDate> value )
        {
            toAlternativeDate.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_AlternativeDate</b> for <b>ChangeMaster</b> to multiple <b>ChangeMasterAltDate</b>.
         *
         * @param value
         *            The ChangeMasterAltDates to build this ChangeMaster with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeMaster.ChangeMasterBuilder alternativeDate( ChangeMasterAltDate... value )
        {
            return toAlternativeDate(Lists.newArrayList(value));
        }

        private ChangeMaster.ChangeMasterBuilder toChangeMstrObjectMgmtRecord(
            final List<ChangeMstrObjectMgmtRecord> value )
        {
            toChangeMstrObjectMgmtRecord.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChangeMstrObjectMgmtRecord</b> for <b>ChangeMaster</b> to multiple
         * <b>ChangeMstrObjectMgmtRecord</b>.
         *
         * @param value
         *            The ChangeMstrObjectMgmtRecords to build this ChangeMaster with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeMaster.ChangeMasterBuilder changeMstrObjectMgmtRecord( ChangeMstrObjectMgmtRecord... value )
        {
            return toChangeMstrObjectMgmtRecord(Lists.newArrayList(value));
        }

        private ChangeMaster.ChangeMasterBuilder toChangeMstrObMgReDocInfoRecd(
            final List<ChangeMstrObMgReDocInfoRecd> value )
        {
            toChangeMstrObMgReDocInfoRecd.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChangeMstrObMgReDocInfoRecd</b> for <b>ChangeMaster</b> to multiple
         * <b>ChangeMstrObMgReDocInfoRecd</b>.
         *
         * @param value
         *            The ChangeMstrObMgReDocInfoRecds to build this ChangeMaster with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeMaster.ChangeMasterBuilder changeMstrObMgReDocInfoRecd( ChangeMstrObMgReDocInfoRecd... value )
        {
            return toChangeMstrObMgReDocInfoRecd(Lists.newArrayList(value));
        }

        private ChangeMaster.ChangeMasterBuilder toChangeMstrObMgReMaterial(
            final List<ChangeMstrObMgReMaterial> value )
        {
            toChangeMstrObMgReMaterial.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChangeMstrObMgReMaterial</b> for <b>ChangeMaster</b> to multiple
         * <b>ChangeMstrObMgReMaterial</b>.
         *
         * @param value
         *            The ChangeMstrObMgReMaterials to build this ChangeMaster with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeMaster.ChangeMasterBuilder changeMstrObMgReMaterial( ChangeMstrObMgReMaterial... value )
        {
            return toChangeMstrObMgReMaterial(Lists.newArrayList(value));
        }

        private ChangeMaster.ChangeMasterBuilder toChangeMstrObMgReMatlBOM( final List<ChangeMstrObMgReMatlBOM> value )
        {
            toChangeMstrObMgReMatlBOM.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChangeMstrObMgReMatlBOM</b> for <b>ChangeMaster</b> to multiple
         * <b>ChangeMstrObMgReMatlBOM</b>.
         *
         * @param value
         *            The ChangeMstrObMgReMatlBOMs to build this ChangeMaster with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeMaster.ChangeMasterBuilder changeMstrObMgReMatlBOM( ChangeMstrObMgReMatlBOM... value )
        {
            return toChangeMstrObMgReMatlBOM(Lists.newArrayList(value));
        }

        private ChangeMaster.ChangeMasterBuilder toCharacteristics( final List<ChangeMasterCharc> value )
        {
            toCharacteristics.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Characteristics</b> for <b>ChangeMaster</b> to multiple <b>ChangeMasterCharc</b>.
         *
         * @param value
         *            The ChangeMasterCharcs to build this ChangeMaster with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeMaster.ChangeMasterBuilder characteristics( ChangeMasterCharc... value )
        {
            return toCharacteristics(Lists.newArrayList(value));
        }

        private ChangeMaster.ChangeMasterBuilder toClassification( final List<ChangeMasterClass> value )
        {
            toClassification.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Classification</b> for <b>ChangeMaster</b> to multiple <b>ChangeMasterClass</b>.
         *
         * @param value
         *            The ChangeMasterClasss to build this ChangeMaster with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeMaster.ChangeMasterBuilder classification( ChangeMasterClass... value )
        {
            return toClassification(Lists.newArrayList(value));
        }

        private ChangeMaster.ChangeMasterBuilder toObjTypeAssignment( final List<ChangeMasterObjTypeAssgmt> value )
        {
            toObjTypeAssignment.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ObjTypeAssignment</b> for <b>ChangeMaster</b> to multiple
         * <b>ChangeMasterObjTypeAssgmt</b>.
         *
         * @param value
         *            The ChangeMasterObjTypeAssgmts to build this ChangeMaster with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeMaster.ChangeMasterBuilder objTypeAssignment( ChangeMasterObjTypeAssgmt... value )
        {
            return toObjTypeAssignment(Lists.newArrayList(value));
        }

    }

}
