/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.field.ChangeMasterAltDateField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.selectable.ChangeMasterAltDateSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Change Number Alternative Date
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ChangeMasterAltDateType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChangeMasterAltDate extends VdmEntity<ChangeMasterAltDate>
{

    /**
     * Selector for all available fields of ChangeMasterAltDate.
     *
     */
    public final static ChangeMasterAltDateSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ChangeMasterAltDateField<Boolean> DELETE_MC =
        new ChangeMasterAltDateField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ChangeMasterAltDateField<Boolean> UPDATE_MC =
        new ChangeMasterAltDateField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @Key
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ChangeMasterAltDateField<String> CHANGE_NUMBER =
        new ChangeMasterAltDateField<String>("ChangeNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ChgNmbrAlternativeDateID</b>
     * </p>
     *
     * @return Alternative date external key
     */
    @Key
    @SerializedName( "ChgNmbrAlternativeDateID" )
    @JsonProperty( "ChgNmbrAlternativeDateID" )
    @Nullable
    @ODataField( odataName = "ChgNmbrAlternativeDateID" )
    private String chgNmbrAlternativeDateID;
    /**
     * Use with available fluent helpers to apply the <b>ChgNmbrAlternativeDateID</b> field to query operations.
     *
     */
    public final static ChangeMasterAltDateField<String> CHG_NMBR_ALTERNATIVE_DATE_ID =
        new ChangeMasterAltDateField<String>("ChgNmbrAlternativeDateID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChgNmbrAlternativeDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ChgNmbrAlternativeDate" )
    @JsonProperty( "ChgNmbrAlternativeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ChgNmbrAlternativeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime chgNmbrAlternativeDate;
    /**
     * Use with available fluent helpers to apply the <b>ChgNmbrAlternativeDate</b> field to query operations.
     *
     */
    public final static ChangeMasterAltDateField<LocalDateTime> CHG_NMBR_ALTERNATIVE_DATE =
        new ChangeMasterAltDateField<LocalDateTime>("ChgNmbrAlternativeDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChgNmbrAltvDateIsAssignedToObj</b>
     * </p>
     *
     * @return Objects Allocated
     */
    @SerializedName( "ChgNmbrAltvDateIsAssignedToObj" )
    @JsonProperty( "ChgNmbrAltvDateIsAssignedToObj" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ChgNmbrAltvDateIsAssignedToObj" )
    private Boolean chgNmbrAltvDateIsAssignedToObj;
    /**
     * Use with available fluent helpers to apply the <b>ChgNmbrAltvDateIsAssignedToObj</b> field to query operations.
     *
     */
    public final static ChangeMasterAltDateField<Boolean> CHG_NMBR_ALTV_DATE_IS_ASSIGNED_TO_OBJ =
        new ChangeMasterAltDateField<Boolean>("ChgNmbrAltvDateIsAssignedToObj");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberLastChgdDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "ChangeNumberLastChgdDateTime" )
    @JsonProperty( "ChangeNumberLastChgdDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangeNumberLastChgdDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changeNumberLastChgdDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumberLastChgdDateTime</b> field to query operations.
     *
     */
    public final static ChangeMasterAltDateField<ZonedDateTime> CHANGE_NUMBER_LAST_CHGD_DATE_TIME =
        new ChangeMasterAltDateField<ZonedDateTime>("ChangeNumberLastChgdDateTime");

    @Nonnull
    @Override
    public Class<ChangeMasterAltDate> getType()
    {
        return ChangeMasterAltDate.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ChgNmbrAlternativeDateID</b>
     * </p>
     *
     * @param chgNmbrAlternativeDateID
     *            Alternative date external key
     */
    public void setChgNmbrAlternativeDateID( @Nullable final String chgNmbrAlternativeDateID )
    {
        rememberChangedField("ChgNmbrAlternativeDateID", this.chgNmbrAlternativeDateID);
        this.chgNmbrAlternativeDateID = chgNmbrAlternativeDateID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChgNmbrAlternativeDate</b>
     * </p>
     *
     * @param chgNmbrAlternativeDate
     *            Valid-From Date
     */
    public void setChgNmbrAlternativeDate( @Nullable final LocalDateTime chgNmbrAlternativeDate )
    {
        rememberChangedField("ChgNmbrAlternativeDate", this.chgNmbrAlternativeDate);
        this.chgNmbrAlternativeDate = chgNmbrAlternativeDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChgNmbrAltvDateIsAssignedToObj</b>
     * </p>
     *
     * @param chgNmbrAltvDateIsAssignedToObj
     *            Objects Allocated
     */
    public void setChgNmbrAltvDateIsAssignedToObj( @Nullable final Boolean chgNmbrAltvDateIsAssignedToObj )
    {
        rememberChangedField("ChgNmbrAltvDateIsAssignedToObj", this.chgNmbrAltvDateIsAssignedToObj);
        this.chgNmbrAltvDateIsAssignedToObj = chgNmbrAltvDateIsAssignedToObj;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberLastChgdDateTime</b>
     * </p>
     *
     * @param changeNumberLastChgdDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setChangeNumberLastChgdDateTime( @Nullable final ZonedDateTime changeNumberLastChgdDateTime )
    {
        rememberChangedField("ChangeNumberLastChgdDateTime", this.changeNumberLastChgdDateTime);
        this.changeNumberLastChgdDateTime = changeNumberLastChgdDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ChangeMasterAltDate";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChangeNumber", getChangeNumber());
        result.put("ChgNmbrAlternativeDateID", getChgNmbrAlternativeDateID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ChgNmbrAlternativeDateID", getChgNmbrAlternativeDateID());
        values.put("ChgNmbrAlternativeDate", getChgNmbrAlternativeDate());
        values.put("ChgNmbrAltvDateIsAssignedToObj", getChgNmbrAltvDateIsAssignedToObj());
        values.put("ChangeNumberLastChgdDateTime", getChangeNumberLastChgdDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ChgNmbrAlternativeDateID") ) {
                final Object value = values.remove("ChgNmbrAlternativeDateID");
                if( (value == null) || (!value.equals(getChgNmbrAlternativeDateID())) ) {
                    setChgNmbrAlternativeDateID(((String) value));
                }
            }
            if( values.containsKey("ChgNmbrAlternativeDate") ) {
                final Object value = values.remove("ChgNmbrAlternativeDate");
                if( (value == null) || (!value.equals(getChgNmbrAlternativeDate())) ) {
                    setChgNmbrAlternativeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChgNmbrAltvDateIsAssignedToObj") ) {
                final Object value = values.remove("ChgNmbrAltvDateIsAssignedToObj");
                if( (value == null) || (!value.equals(getChgNmbrAltvDateIsAssignedToObj())) ) {
                    setChgNmbrAltvDateIsAssignedToObj(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeNumberLastChgdDateTime") ) {
                final Object value = values.remove("ChangeNumberLastChgdDateTime");
                if( (value == null) || (!value.equals(getChangeNumberLastChgdDateTime())) ) {
                    setChangeNumberLastChgdDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ChangeMasterAltDateField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ChangeMasterAltDateField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChangeMasterAltDateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChangeMasterAltDateField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeMasterV2Service.DEFAULT_SERVICE_PATH);
    }

}
