/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.selectable.ChangeMasterCharcSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharc ChangeMasterCharc} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class ChangeMasterCharcByKeyFluentHelper
    extends
    FluentHelperByKey<ChangeMasterCharcByKeyFluentHelper, ChangeMasterCharc, ChangeMasterCharcSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharc ChangeMasterCharc}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ChangeMasterCharc}
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ChangeMasterCharc}
     * @param changeNumber
     *            Key of Object to be Classified
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     */
    public ChangeMasterCharcByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String changeNumber,
        final String charcInternalID,
        final String classType )
    {
        super(servicePath, entityCollection);
        this.key.put("ChangeNumber", changeNumber);
        this.key.put("CharcInternalID", charcInternalID);
        this.key.put("ClassType", classType);
    }

    @Override
    @Nonnull
    protected Class<ChangeMasterCharc> getEntityClass()
    {
        return ChangeMasterCharc.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
