/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.field.ChangeMasterObjTypeAssgmtField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.selectable.ChangeMasterObjTypeAssgmtSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Change Number Object Type Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ChangeMasterObjTypeAssgmtType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChangeMasterObjTypeAssgmt extends VdmEntity<ChangeMasterObjTypeAssgmt>
{

    /**
     * Selector for all available fields of ChangeMasterObjTypeAssgmt.
     *
     */
    public final static ChangeMasterObjTypeAssgmtSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<Boolean> DELETE_MC =
        new ChangeMasterObjTypeAssgmtField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<Boolean> UPDATE_MC =
        new ChangeMasterObjTypeAssgmtField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @Key
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<String> CHANGE_NUMBER =
        new ChangeMasterObjTypeAssgmtField<String>("ChangeNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @return SAP Object Type
     */
    @Key
    @SerializedName( "SAPObjectType" )
    @JsonProperty( "SAPObjectType" )
    @Nullable
    @ODataField( odataName = "SAPObjectType" )
    private String sAPObjectType;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectType</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<String> SAP_OBJECT_TYPE =
        new ChangeMasterObjTypeAssgmtField<String>("SAPObjectType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsActiveForChangeNumber</b>
     * </p>
     *
     * @return Object Type Active for Change Number
     */
    @SerializedName( "IsActiveForChangeNumber" )
    @JsonProperty( "IsActiveForChangeNumber" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsActiveForChangeNumber" )
    private Boolean isActiveForChangeNumber;
    /**
     * Use with available fluent helpers to apply the <b>IsActiveForChangeNumber</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<Boolean> IS_ACTIVE_FOR_CHANGE_NUMBER =
        new ChangeMasterObjTypeAssgmtField<Boolean>("IsActiveForChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsLockedForChanges</b>
     * </p>
     *
     * @return Indicator: Object type locked for changes
     */
    @SerializedName( "IsLockedForChanges" )
    @JsonProperty( "IsLockedForChanges" )
    @Nullable
    @ODataField( odataName = "IsLockedForChanges" )
    private String isLockedForChanges;
    /**
     * Use with available fluent helpers to apply the <b>IsLockedForChanges</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<String> IS_LOCKED_FOR_CHANGES =
        new ChangeMasterObjTypeAssgmtField<String>("IsLockedForChanges");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsPartiallyDisplayed</b>
     * </p>
     *
     * @return Indicator: display partial objects for object
     */
    @SerializedName( "IsPartiallyDisplayed" )
    @JsonProperty( "IsPartiallyDisplayed" )
    @Nullable
    @ODataField( odataName = "IsPartiallyDisplayed" )
    private String isPartiallyDisplayed;
    /**
     * Use with available fluent helpers to apply the <b>IsPartiallyDisplayed</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<String> IS_PARTIALLY_DISPLAYED =
        new ChangeMasterObjTypeAssgmtField<String>("IsPartiallyDisplayed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdIsRequired</b>
     * </p>
     *
     * @return Management Record Is Required for Each Object
     */
    @SerializedName( "ObjMgmtRecdIsRequired" )
    @JsonProperty( "ObjMgmtRecdIsRequired" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ObjMgmtRecdIsRequired" )
    private Boolean objMgmtRecdIsRequired;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdIsRequired</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<Boolean> OBJ_MGMT_RECD_IS_REQUIRED =
        new ChangeMasterObjTypeAssgmtField<Boolean>("ObjMgmtRecdIsRequired");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdIsGenerated</b>
     * </p>
     *
     * @return Object Management Record Was Generated
     */
    @SerializedName( "ObjMgmtRecdIsGenerated" )
    @JsonProperty( "ObjMgmtRecdIsGenerated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ObjMgmtRecdIsGenerated" )
    private Boolean objMgmtRecdIsGenerated;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdIsGenerated</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<Boolean> OBJ_MGMT_RECD_IS_GENERATED =
        new ChangeMasterObjTypeAssgmtField<Boolean>("ObjMgmtRecdIsGenerated");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdIsAutomlyCrted</b>
     * </p>
     *
     * @return Mgmt Record Generated Automatically Only for New Objects
     */
    @SerializedName( "ObjMgmtRecdIsAutomlyCrted" )
    @JsonProperty( "ObjMgmtRecdIsAutomlyCrted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ObjMgmtRecdIsAutomlyCrted" )
    private Boolean objMgmtRecdIsAutomlyCrted;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdIsAutomlyCrted</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<Boolean> OBJ_MGMT_RECD_IS_AUTOMLY_CRTED =
        new ChangeMasterObjTypeAssgmtField<Boolean>("ObjMgmtRecdIsAutomlyCrted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdIsAutomlyCrtedByDlg</b>
     * </p>
     *
     * @return Automatic Generation with Dialog Box
     */
    @SerializedName( "ObjMgmtRecdIsAutomlyCrtedByDlg" )
    @JsonProperty( "ObjMgmtRecdIsAutomlyCrtedByDlg" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ObjMgmtRecdIsAutomlyCrtedByDlg" )
    private Boolean objMgmtRecdIsAutomlyCrtedByDlg;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdIsAutomlyCrtedByDlg</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<Boolean> OBJ_MGMT_RECD_IS_AUTOMLY_CRTED_BY_DLG =
        new ChangeMasterObjTypeAssgmtField<Boolean>("ObjMgmtRecdIsAutomlyCrtedByDlg");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjectTypeCreationDate</b>
     * </p>
     *
     * @return Date record created on
     */
    @SerializedName( "ObjectTypeCreationDate" )
    @JsonProperty( "ObjectTypeCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ObjectTypeCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime objectTypeCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>ObjectTypeCreationDate</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<LocalDateTime> OBJECT_TYPE_CREATION_DATE =
        new ChangeMasterObjTypeAssgmtField<LocalDateTime>("ObjectTypeCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjectTypeCreatedByUser</b>
     * </p>
     *
     * @return User who created record
     */
    @SerializedName( "ObjectTypeCreatedByUser" )
    @JsonProperty( "ObjectTypeCreatedByUser" )
    @Nullable
    @ODataField( odataName = "ObjectTypeCreatedByUser" )
    private String objectTypeCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>ObjectTypeCreatedByUser</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<String> OBJECT_TYPE_CREATED_BY_USER =
        new ChangeMasterObjTypeAssgmtField<String>("ObjectTypeCreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjectTypeLastChangedDate</b>
     * </p>
     *
     * @return Date of Last Change
     */
    @SerializedName( "ObjectTypeLastChangedDate" )
    @JsonProperty( "ObjectTypeLastChangedDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ObjectTypeLastChangedDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime objectTypeLastChangedDate;
    /**
     * Use with available fluent helpers to apply the <b>ObjectTypeLastChangedDate</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<LocalDateTime> OBJECT_TYPE_LAST_CHANGED_DATE =
        new ChangeMasterObjTypeAssgmtField<LocalDateTime>("ObjectTypeLastChangedDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjectTypeLastChangedByUser</b>
     * </p>
     *
     * @return Name of person who changed object
     */
    @SerializedName( "ObjectTypeLastChangedByUser" )
    @JsonProperty( "ObjectTypeLastChangedByUser" )
    @Nullable
    @ODataField( odataName = "ObjectTypeLastChangedByUser" )
    private String objectTypeLastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>ObjectTypeLastChangedByUser</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<String> OBJECT_TYPE_LAST_CHANGED_BY_USER =
        new ChangeMasterObjTypeAssgmtField<String>("ObjectTypeLastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberLastChgdDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "ChangeNumberLastChgdDateTime" )
    @JsonProperty( "ChangeNumberLastChgdDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangeNumberLastChgdDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changeNumberLastChgdDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumberLastChgdDateTime</b> field to query operations.
     *
     */
    public final static ChangeMasterObjTypeAssgmtField<ZonedDateTime> CHANGE_NUMBER_LAST_CHGD_DATE_TIME =
        new ChangeMasterObjTypeAssgmtField<ZonedDateTime>("ChangeNumberLastChgdDateTime");

    @Nonnull
    @Override
    public Class<ChangeMasterObjTypeAssgmt> getType()
    {
        return ChangeMasterObjTypeAssgmt.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @param sAPObjectType
     *            SAP Object Type
     */
    public void setSAPObjectType( @Nullable final String sAPObjectType )
    {
        rememberChangedField("SAPObjectType", this.sAPObjectType);
        this.sAPObjectType = sAPObjectType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsActiveForChangeNumber</b>
     * </p>
     *
     * @param isActiveForChangeNumber
     *            Object Type Active for Change Number
     */
    public void setIsActiveForChangeNumber( @Nullable final Boolean isActiveForChangeNumber )
    {
        rememberChangedField("IsActiveForChangeNumber", this.isActiveForChangeNumber);
        this.isActiveForChangeNumber = isActiveForChangeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsLockedForChanges</b>
     * </p>
     *
     * @param isLockedForChanges
     *            Indicator: Object type locked for changes
     */
    public void setIsLockedForChanges( @Nullable final String isLockedForChanges )
    {
        rememberChangedField("IsLockedForChanges", this.isLockedForChanges);
        this.isLockedForChanges = isLockedForChanges;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsPartiallyDisplayed</b>
     * </p>
     *
     * @param isPartiallyDisplayed
     *            Indicator: display partial objects for object
     */
    public void setIsPartiallyDisplayed( @Nullable final String isPartiallyDisplayed )
    {
        rememberChangedField("IsPartiallyDisplayed", this.isPartiallyDisplayed);
        this.isPartiallyDisplayed = isPartiallyDisplayed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdIsRequired</b>
     * </p>
     *
     * @param objMgmtRecdIsRequired
     *            Management Record Is Required for Each Object
     */
    public void setObjMgmtRecdIsRequired( @Nullable final Boolean objMgmtRecdIsRequired )
    {
        rememberChangedField("ObjMgmtRecdIsRequired", this.objMgmtRecdIsRequired);
        this.objMgmtRecdIsRequired = objMgmtRecdIsRequired;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdIsGenerated</b>
     * </p>
     *
     * @param objMgmtRecdIsGenerated
     *            Object Management Record Was Generated
     */
    public void setObjMgmtRecdIsGenerated( @Nullable final Boolean objMgmtRecdIsGenerated )
    {
        rememberChangedField("ObjMgmtRecdIsGenerated", this.objMgmtRecdIsGenerated);
        this.objMgmtRecdIsGenerated = objMgmtRecdIsGenerated;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdIsAutomlyCrted</b>
     * </p>
     *
     * @param objMgmtRecdIsAutomlyCrted
     *            Mgmt Record Generated Automatically Only for New Objects
     */
    public void setObjMgmtRecdIsAutomlyCrted( @Nullable final Boolean objMgmtRecdIsAutomlyCrted )
    {
        rememberChangedField("ObjMgmtRecdIsAutomlyCrted", this.objMgmtRecdIsAutomlyCrted);
        this.objMgmtRecdIsAutomlyCrted = objMgmtRecdIsAutomlyCrted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdIsAutomlyCrtedByDlg</b>
     * </p>
     *
     * @param objMgmtRecdIsAutomlyCrtedByDlg
     *            Automatic Generation with Dialog Box
     */
    public void setObjMgmtRecdIsAutomlyCrtedByDlg( @Nullable final Boolean objMgmtRecdIsAutomlyCrtedByDlg )
    {
        rememberChangedField("ObjMgmtRecdIsAutomlyCrtedByDlg", this.objMgmtRecdIsAutomlyCrtedByDlg);
        this.objMgmtRecdIsAutomlyCrtedByDlg = objMgmtRecdIsAutomlyCrtedByDlg;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjectTypeCreationDate</b>
     * </p>
     *
     * @param objectTypeCreationDate
     *            Date record created on
     */
    public void setObjectTypeCreationDate( @Nullable final LocalDateTime objectTypeCreationDate )
    {
        rememberChangedField("ObjectTypeCreationDate", this.objectTypeCreationDate);
        this.objectTypeCreationDate = objectTypeCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjectTypeCreatedByUser</b>
     * </p>
     *
     * @param objectTypeCreatedByUser
     *            User who created record
     */
    public void setObjectTypeCreatedByUser( @Nullable final String objectTypeCreatedByUser )
    {
        rememberChangedField("ObjectTypeCreatedByUser", this.objectTypeCreatedByUser);
        this.objectTypeCreatedByUser = objectTypeCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjectTypeLastChangedDate</b>
     * </p>
     *
     * @param objectTypeLastChangedDate
     *            Date of Last Change
     */
    public void setObjectTypeLastChangedDate( @Nullable final LocalDateTime objectTypeLastChangedDate )
    {
        rememberChangedField("ObjectTypeLastChangedDate", this.objectTypeLastChangedDate);
        this.objectTypeLastChangedDate = objectTypeLastChangedDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjectTypeLastChangedByUser</b>
     * </p>
     *
     * @param objectTypeLastChangedByUser
     *            Name of person who changed object
     */
    public void setObjectTypeLastChangedByUser( @Nullable final String objectTypeLastChangedByUser )
    {
        rememberChangedField("ObjectTypeLastChangedByUser", this.objectTypeLastChangedByUser);
        this.objectTypeLastChangedByUser = objectTypeLastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberLastChgdDateTime</b>
     * </p>
     *
     * @param changeNumberLastChgdDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setChangeNumberLastChgdDateTime( @Nullable final ZonedDateTime changeNumberLastChgdDateTime )
    {
        rememberChangedField("ChangeNumberLastChgdDateTime", this.changeNumberLastChgdDateTime);
        this.changeNumberLastChgdDateTime = changeNumberLastChgdDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ChangeMasterObjTypeAssgmt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChangeNumber", getChangeNumber());
        result.put("SAPObjectType", getSAPObjectType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("ChangeNumber", getChangeNumber());
        values.put("SAPObjectType", getSAPObjectType());
        values.put("IsActiveForChangeNumber", getIsActiveForChangeNumber());
        values.put("IsLockedForChanges", getIsLockedForChanges());
        values.put("IsPartiallyDisplayed", getIsPartiallyDisplayed());
        values.put("ObjMgmtRecdIsRequired", getObjMgmtRecdIsRequired());
        values.put("ObjMgmtRecdIsGenerated", getObjMgmtRecdIsGenerated());
        values.put("ObjMgmtRecdIsAutomlyCrted", getObjMgmtRecdIsAutomlyCrted());
        values.put("ObjMgmtRecdIsAutomlyCrtedByDlg", getObjMgmtRecdIsAutomlyCrtedByDlg());
        values.put("ObjectTypeCreationDate", getObjectTypeCreationDate());
        values.put("ObjectTypeCreatedByUser", getObjectTypeCreatedByUser());
        values.put("ObjectTypeLastChangedDate", getObjectTypeLastChangedDate());
        values.put("ObjectTypeLastChangedByUser", getObjectTypeLastChangedByUser());
        values.put("ChangeNumberLastChgdDateTime", getChangeNumberLastChgdDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("SAPObjectType") ) {
                final Object value = values.remove("SAPObjectType");
                if( (value == null) || (!value.equals(getSAPObjectType())) ) {
                    setSAPObjectType(((String) value));
                }
            }
            if( values.containsKey("IsActiveForChangeNumber") ) {
                final Object value = values.remove("IsActiveForChangeNumber");
                if( (value == null) || (!value.equals(getIsActiveForChangeNumber())) ) {
                    setIsActiveForChangeNumber(((Boolean) value));
                }
            }
            if( values.containsKey("IsLockedForChanges") ) {
                final Object value = values.remove("IsLockedForChanges");
                if( (value == null) || (!value.equals(getIsLockedForChanges())) ) {
                    setIsLockedForChanges(((String) value));
                }
            }
            if( values.containsKey("IsPartiallyDisplayed") ) {
                final Object value = values.remove("IsPartiallyDisplayed");
                if( (value == null) || (!value.equals(getIsPartiallyDisplayed())) ) {
                    setIsPartiallyDisplayed(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdIsRequired") ) {
                final Object value = values.remove("ObjMgmtRecdIsRequired");
                if( (value == null) || (!value.equals(getObjMgmtRecdIsRequired())) ) {
                    setObjMgmtRecdIsRequired(((Boolean) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdIsGenerated") ) {
                final Object value = values.remove("ObjMgmtRecdIsGenerated");
                if( (value == null) || (!value.equals(getObjMgmtRecdIsGenerated())) ) {
                    setObjMgmtRecdIsGenerated(((Boolean) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdIsAutomlyCrted") ) {
                final Object value = values.remove("ObjMgmtRecdIsAutomlyCrted");
                if( (value == null) || (!value.equals(getObjMgmtRecdIsAutomlyCrted())) ) {
                    setObjMgmtRecdIsAutomlyCrted(((Boolean) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdIsAutomlyCrtedByDlg") ) {
                final Object value = values.remove("ObjMgmtRecdIsAutomlyCrtedByDlg");
                if( (value == null) || (!value.equals(getObjMgmtRecdIsAutomlyCrtedByDlg())) ) {
                    setObjMgmtRecdIsAutomlyCrtedByDlg(((Boolean) value));
                }
            }
            if( values.containsKey("ObjectTypeCreationDate") ) {
                final Object value = values.remove("ObjectTypeCreationDate");
                if( (value == null) || (!value.equals(getObjectTypeCreationDate())) ) {
                    setObjectTypeCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ObjectTypeCreatedByUser") ) {
                final Object value = values.remove("ObjectTypeCreatedByUser");
                if( (value == null) || (!value.equals(getObjectTypeCreatedByUser())) ) {
                    setObjectTypeCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("ObjectTypeLastChangedDate") ) {
                final Object value = values.remove("ObjectTypeLastChangedDate");
                if( (value == null) || (!value.equals(getObjectTypeLastChangedDate())) ) {
                    setObjectTypeLastChangedDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ObjectTypeLastChangedByUser") ) {
                final Object value = values.remove("ObjectTypeLastChangedByUser");
                if( (value == null) || (!value.equals(getObjectTypeLastChangedByUser())) ) {
                    setObjectTypeLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ChangeNumberLastChgdDateTime") ) {
                final Object value = values.remove("ChangeNumberLastChgdDateTime");
                if( (value == null) || (!value.equals(getChangeNumberLastChgdDateTime())) ) {
                    setChangeNumberLastChgdDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ChangeMasterObjTypeAssgmtField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ChangeMasterObjTypeAssgmtField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChangeMasterObjTypeAssgmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChangeMasterObjTypeAssgmtField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeMasterV2Service.DEFAULT_SERVICE_PATH);
    }

}
