/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.selectable.ChangeMstrObMgReDocInfoRecdSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
 * ChangeMstrObMgReDocInfoRecd} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ChangeMstrObMgReDocInfoRecdByKeyFluentHelper
    extends
    FluentHelperByKey<ChangeMstrObMgReDocInfoRecdByKeyFluentHelper, ChangeMstrObMgReDocInfoRecd, ChangeMstrObMgReDocInfoRecdSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     * ChangeMstrObMgReDocInfoRecd} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param documentInfoRecord
     *            Document number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param documentPart
     *            Document Part
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ChangeMstrObMgReDocInfoRecd}
     * @param documentType
     *            Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ChangeMstrObMgReDocInfoRecd}
     * @param changeNumber
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param documentVersion
     *            Document Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public ChangeMstrObMgReDocInfoRecdByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String changeNumber,
        final String documentType,
        final String documentInfoRecord,
        final String documentPart,
        final String documentVersion )
    {
        super(servicePath, entityCollection);
        this.key.put("ChangeNumber", changeNumber);
        this.key.put("DocumentType", documentType);
        this.key.put("DocumentInfoRecord", documentInfoRecord);
        this.key.put("DocumentPart", documentPart);
        this.key.put("DocumentVersion", documentVersion);
    }

    @Override
    @Nonnull
    protected Class<ChangeMstrObMgReDocInfoRecd> getEntityClass()
    {
        return ChangeMstrObMgReDocInfoRecd.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
