/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.field.ChangeMstrObMgReMaterialField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.selectable.ChangeMstrObMgReMaterialSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Change Number Object Management Records - Material
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ChangeMstrObMgReMaterialType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChangeMstrObMgReMaterial extends VdmEntity<ChangeMstrObMgReMaterial>
{

    /**
     * Selector for all available fields of ChangeMstrObMgReMaterial.
     *
     */
    public final static ChangeMstrObMgReMaterialSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AssignAltDateObjMgmtRecMAT_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "AssignAltDateObjMgmtRecMAT_ac" )
    @JsonProperty( "AssignAltDateObjMgmtRecMAT_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AssignAltDateObjMgmtRecMAT_ac" )
    private Boolean assignAltDateObjMgmtRecMAT_ac;
    /**
     * Use with available fluent helpers to apply the <b>AssignAltDateObjMgmtRecMAT_ac</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<Boolean> ASSIGN_ALT_DATE_OBJ_MGMT_REC_MAT_AC =
        new ChangeMstrObMgReMaterialField<Boolean>("AssignAltDateObjMgmtRecMAT_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnassignAltDateObjMgmtRecMAT_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "UnassignAltDateObjMgmtRecMAT_ac" )
    @JsonProperty( "UnassignAltDateObjMgmtRecMAT_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "UnassignAltDateObjMgmtRecMAT_ac" )
    private Boolean unassignAltDateObjMgmtRecMAT_ac;
    /**
     * Use with available fluent helpers to apply the <b>UnassignAltDateObjMgmtRecMAT_ac</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<Boolean> UNASSIGN_ALT_DATE_OBJ_MGMT_REC_MAT_AC =
        new ChangeMstrObMgReMaterialField<Boolean>("UnassignAltDateObjMgmtRecMAT_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<Boolean> DELETE_MC =
        new ChangeMstrObMgReMaterialField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<Boolean> UPDATE_MC =
        new ChangeMstrObMgReMaterialField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @Key
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<String> CHANGE_NUMBER =
        new ChangeMstrObMgReMaterialField<String>("ChangeNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<String> MATERIAL =
        new ChangeMstrObMgReMaterialField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ChgNmbrAlternativeDateID</b>
     * </p>
     *
     * @return Alternative date external key
     */
    @SerializedName( "ChgNmbrAlternativeDateID" )
    @JsonProperty( "ChgNmbrAlternativeDateID" )
    @Nullable
    @ODataField( odataName = "ChgNmbrAlternativeDateID" )
    private String chgNmbrAlternativeDateID;
    /**
     * Use with available fluent helpers to apply the <b>ChgNmbrAlternativeDateID</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<String> CHG_NMBR_ALTERNATIVE_DATE_ID =
        new ChangeMstrObMgReMaterialField<String>("ChgNmbrAlternativeDateID");
    /**
     * Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTechnicalID</b>
     * </p>
     *
     * @return Identification of object to be changed
     */
    @SerializedName( "SAPObjectTechnicalID" )
    @JsonProperty( "SAPObjectTechnicalID" )
    @Nullable
    @ODataField( odataName = "SAPObjectTechnicalID" )
    private String sAPObjectTechnicalID;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectTechnicalID</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<String> SAP_OBJECT_TECHNICAL_ID =
        new ChangeMstrObMgReMaterialField<String>("SAPObjectTechnicalID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdDescription</b>
     * </p>
     *
     * @return Object management record description
     */
    @SerializedName( "ObjMgmtRecdDescription" )
    @JsonProperty( "ObjMgmtRecdDescription" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdDescription" )
    private String objMgmtRecdDescription;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdDescription</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<String> OBJ_MGMT_RECD_DESCRIPTION =
        new ChangeMstrObMgReMaterialField<String>("ObjMgmtRecdDescription");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdItemUUID</b>
     * </p>
     *
     * @return Object Management Record Item GUID
     */
    @SerializedName( "ObjMgmtRecdItemUUID" )
    @JsonProperty( "ObjMgmtRecdItemUUID" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdItemUUID" )
    private UUID objMgmtRecdItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdItemUUID</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<UUID> OBJ_MGMT_RECD_ITEM_UUID =
        new ChangeMstrObMgReMaterialField<UUID>("ObjMgmtRecdItemUUID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdLastChangedAt</b>
     * </p>
     *
     * @return Date of Last Change
     */
    @SerializedName( "ObjMgmtRecdLastChangedAt" )
    @JsonProperty( "ObjMgmtRecdLastChangedAt" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ObjMgmtRecdLastChangedAt",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime objMgmtRecdLastChangedAt;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdLastChangedAt</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<LocalDateTime> OBJ_MGMT_RECD_LAST_CHANGED_AT =
        new ChangeMstrObMgReMaterialField<LocalDateTime>("ObjMgmtRecdLastChangedAt");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdLastChangedBy</b>
     * </p>
     *
     * @return Name of person who changed object
     */
    @SerializedName( "ObjMgmtRecdLastChangedBy" )
    @JsonProperty( "ObjMgmtRecdLastChangedBy" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdLastChangedBy" )
    private String objMgmtRecdLastChangedBy;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdLastChangedBy</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<String> OBJ_MGMT_RECD_LAST_CHANGED_BY =
        new ChangeMstrObMgReMaterialField<String>("ObjMgmtRecdLastChangedBy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdCreationDate</b>
     * </p>
     *
     * @return Date record created on
     */
    @SerializedName( "ObjMgmtRecdCreationDate" )
    @JsonProperty( "ObjMgmtRecdCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ObjMgmtRecdCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime objMgmtRecdCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdCreationDate</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<LocalDateTime> OBJ_MGMT_RECD_CREATION_DATE =
        new ChangeMstrObMgReMaterialField<LocalDateTime>("ObjMgmtRecdCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdCreatedBy</b>
     * </p>
     *
     * @return User who created record
     */
    @SerializedName( "ObjMgmtRecdCreatedBy" )
    @JsonProperty( "ObjMgmtRecdCreatedBy" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdCreatedBy" )
    private String objMgmtRecdCreatedBy;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdCreatedBy</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<String> OBJ_MGMT_RECD_CREATED_BY =
        new ChangeMstrObMgReMaterialField<String>("ObjMgmtRecdCreatedBy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjLastChangedAt</b>
     * </p>
     *
     * @return Date on Which Object Was Last Changed
     */
    @SerializedName( "ObjMgmtRecdObjLastChangedAt" )
    @JsonProperty( "ObjMgmtRecdObjLastChangedAt" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ObjMgmtRecdObjLastChangedAt",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime objMgmtRecdObjLastChangedAt;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdObjLastChangedAt</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<LocalDateTime> OBJ_MGMT_RECD_OBJ_LAST_CHANGED_AT =
        new ChangeMstrObMgReMaterialField<LocalDateTime>("ObjMgmtRecdObjLastChangedAt");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjLastChangedBy</b>
     * </p>
     *
     * @return User who last changed the object
     */
    @SerializedName( "ObjMgmtRecdObjLastChangedBy" )
    @JsonProperty( "ObjMgmtRecdObjLastChangedBy" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdObjLastChangedBy" )
    private String objMgmtRecdObjLastChangedBy;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdObjLastChangedBy</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<String> OBJ_MGMT_RECD_OBJ_LAST_CHANGED_BY =
        new ChangeMstrObMgReMaterialField<String>("ObjMgmtRecdObjLastChangedBy");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjIsLockedForChg</b>
     * </p>
     *
     * @return Indicator: Object locked for changes
     */
    @SerializedName( "ObjMgmtRecdObjIsLockedForChg" )
    @JsonProperty( "ObjMgmtRecdObjIsLockedForChg" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdObjIsLockedForChg" )
    private String objMgmtRecdObjIsLockedForChg;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdObjIsLockedForChg</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<String> OBJ_MGMT_RECD_OBJ_IS_LOCKED_FOR_CHG =
        new ChangeMstrObMgReMaterialField<String>("ObjMgmtRecdObjIsLockedForChg");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjIsPlanned</b>
     * </p>
     *
     * @return Indicator: planned record
     */
    @SerializedName( "ObjMgmtRecdObjIsPlanned" )
    @JsonProperty( "ObjMgmtRecdObjIsPlanned" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdObjIsPlanned" )
    private String objMgmtRecdObjIsPlanned;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdObjIsPlanned</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<String> OBJ_MGMT_RECD_OBJ_IS_PLANNED =
        new ChangeMstrObMgReMaterialField<String>("ObjMgmtRecdObjIsPlanned");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjRevisionLevel</b>
     * </p>
     *
     * @return Revision Level without Conversion Exit
     */
    @SerializedName( "ObjMgmtRecdObjRevisionLevel" )
    @JsonProperty( "ObjMgmtRecdObjRevisionLevel" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdObjRevisionLevel" )
    private String objMgmtRecdObjRevisionLevel;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdObjRevisionLevel</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<String> OBJ_MGMT_RECD_OBJ_REVISION_LEVEL =
        new ChangeMstrObMgReMaterialField<String>("ObjMgmtRecdObjRevisionLevel");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberLastChgdDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "ChangeNumberLastChgdDateTime" )
    @JsonProperty( "ChangeNumberLastChgdDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangeNumberLastChgdDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changeNumberLastChgdDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumberLastChgdDateTime</b> field to query operations.
     *
     */
    public final static ChangeMstrObMgReMaterialField<ZonedDateTime> CHANGE_NUMBER_LAST_CHGD_DATE_TIME =
        new ChangeMstrObMgReMaterialField<ZonedDateTime>("ChangeNumberLastChgdDateTime");

    @Nonnull
    @Override
    public Class<ChangeMstrObMgReMaterial> getType()
    {
        return ChangeMstrObMgReMaterial.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AssignAltDateObjMgmtRecMAT_ac</b>
     * </p>
     *
     * @param assignAltDateObjMgmtRecMAT_ac
     *            Dyn. Action Control
     */
    public void setAssignAltDateObjMgmtRecMAT_ac( @Nullable final Boolean assignAltDateObjMgmtRecMAT_ac )
    {
        rememberChangedField("AssignAltDateObjMgmtRecMAT_ac", this.assignAltDateObjMgmtRecMAT_ac);
        this.assignAltDateObjMgmtRecMAT_ac = assignAltDateObjMgmtRecMAT_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnassignAltDateObjMgmtRecMAT_ac</b>
     * </p>
     *
     * @param unassignAltDateObjMgmtRecMAT_ac
     *            Dyn. Action Control
     */
    public void setUnassignAltDateObjMgmtRecMAT_ac( @Nullable final Boolean unassignAltDateObjMgmtRecMAT_ac )
    {
        rememberChangedField("UnassignAltDateObjMgmtRecMAT_ac", this.unassignAltDateObjMgmtRecMAT_ac);
        this.unassignAltDateObjMgmtRecMAT_ac = unassignAltDateObjMgmtRecMAT_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ChgNmbrAlternativeDateID</b>
     * </p>
     *
     * @param chgNmbrAlternativeDateID
     *            Alternative date external key
     */
    public void setChgNmbrAlternativeDateID( @Nullable final String chgNmbrAlternativeDateID )
    {
        rememberChangedField("ChgNmbrAlternativeDateID", this.chgNmbrAlternativeDateID);
        this.chgNmbrAlternativeDateID = chgNmbrAlternativeDateID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTechnicalID</b>
     * </p>
     *
     * @param sAPObjectTechnicalID
     *            Identification of object to be changed
     */
    public void setSAPObjectTechnicalID( @Nullable final String sAPObjectTechnicalID )
    {
        rememberChangedField("SAPObjectTechnicalID", this.sAPObjectTechnicalID);
        this.sAPObjectTechnicalID = sAPObjectTechnicalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdDescription</b>
     * </p>
     *
     * @param objMgmtRecdDescription
     *            Object management record description
     */
    public void setObjMgmtRecdDescription( @Nullable final String objMgmtRecdDescription )
    {
        rememberChangedField("ObjMgmtRecdDescription", this.objMgmtRecdDescription);
        this.objMgmtRecdDescription = objMgmtRecdDescription;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdItemUUID</b>
     * </p>
     *
     * @param objMgmtRecdItemUUID
     *            Object Management Record Item GUID
     */
    public void setObjMgmtRecdItemUUID( @Nullable final UUID objMgmtRecdItemUUID )
    {
        rememberChangedField("ObjMgmtRecdItemUUID", this.objMgmtRecdItemUUID);
        this.objMgmtRecdItemUUID = objMgmtRecdItemUUID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdLastChangedAt</b>
     * </p>
     *
     * @param objMgmtRecdLastChangedAt
     *            Date of Last Change
     */
    public void setObjMgmtRecdLastChangedAt( @Nullable final LocalDateTime objMgmtRecdLastChangedAt )
    {
        rememberChangedField("ObjMgmtRecdLastChangedAt", this.objMgmtRecdLastChangedAt);
        this.objMgmtRecdLastChangedAt = objMgmtRecdLastChangedAt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdLastChangedBy</b>
     * </p>
     *
     * @param objMgmtRecdLastChangedBy
     *            Name of person who changed object
     */
    public void setObjMgmtRecdLastChangedBy( @Nullable final String objMgmtRecdLastChangedBy )
    {
        rememberChangedField("ObjMgmtRecdLastChangedBy", this.objMgmtRecdLastChangedBy);
        this.objMgmtRecdLastChangedBy = objMgmtRecdLastChangedBy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdCreationDate</b>
     * </p>
     *
     * @param objMgmtRecdCreationDate
     *            Date record created on
     */
    public void setObjMgmtRecdCreationDate( @Nullable final LocalDateTime objMgmtRecdCreationDate )
    {
        rememberChangedField("ObjMgmtRecdCreationDate", this.objMgmtRecdCreationDate);
        this.objMgmtRecdCreationDate = objMgmtRecdCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdCreatedBy</b>
     * </p>
     *
     * @param objMgmtRecdCreatedBy
     *            User who created record
     */
    public void setObjMgmtRecdCreatedBy( @Nullable final String objMgmtRecdCreatedBy )
    {
        rememberChangedField("ObjMgmtRecdCreatedBy", this.objMgmtRecdCreatedBy);
        this.objMgmtRecdCreatedBy = objMgmtRecdCreatedBy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjLastChangedAt</b>
     * </p>
     *
     * @param objMgmtRecdObjLastChangedAt
     *            Date on Which Object Was Last Changed
     */
    public void setObjMgmtRecdObjLastChangedAt( @Nullable final LocalDateTime objMgmtRecdObjLastChangedAt )
    {
        rememberChangedField("ObjMgmtRecdObjLastChangedAt", this.objMgmtRecdObjLastChangedAt);
        this.objMgmtRecdObjLastChangedAt = objMgmtRecdObjLastChangedAt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjLastChangedBy</b>
     * </p>
     *
     * @param objMgmtRecdObjLastChangedBy
     *            User who last changed the object
     */
    public void setObjMgmtRecdObjLastChangedBy( @Nullable final String objMgmtRecdObjLastChangedBy )
    {
        rememberChangedField("ObjMgmtRecdObjLastChangedBy", this.objMgmtRecdObjLastChangedBy);
        this.objMgmtRecdObjLastChangedBy = objMgmtRecdObjLastChangedBy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjIsLockedForChg</b>
     * </p>
     *
     * @param objMgmtRecdObjIsLockedForChg
     *            Indicator: Object locked for changes
     */
    public void setObjMgmtRecdObjIsLockedForChg( @Nullable final String objMgmtRecdObjIsLockedForChg )
    {
        rememberChangedField("ObjMgmtRecdObjIsLockedForChg", this.objMgmtRecdObjIsLockedForChg);
        this.objMgmtRecdObjIsLockedForChg = objMgmtRecdObjIsLockedForChg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjIsPlanned</b>
     * </p>
     *
     * @param objMgmtRecdObjIsPlanned
     *            Indicator: planned record
     */
    public void setObjMgmtRecdObjIsPlanned( @Nullable final String objMgmtRecdObjIsPlanned )
    {
        rememberChangedField("ObjMgmtRecdObjIsPlanned", this.objMgmtRecdObjIsPlanned);
        this.objMgmtRecdObjIsPlanned = objMgmtRecdObjIsPlanned;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjRevisionLevel</b>
     * </p>
     *
     * @param objMgmtRecdObjRevisionLevel
     *            Revision Level without Conversion Exit
     */
    public void setObjMgmtRecdObjRevisionLevel( @Nullable final String objMgmtRecdObjRevisionLevel )
    {
        rememberChangedField("ObjMgmtRecdObjRevisionLevel", this.objMgmtRecdObjRevisionLevel);
        this.objMgmtRecdObjRevisionLevel = objMgmtRecdObjRevisionLevel;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberLastChgdDateTime</b>
     * </p>
     *
     * @param changeNumberLastChgdDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setChangeNumberLastChgdDateTime( @Nullable final ZonedDateTime changeNumberLastChgdDateTime )
    {
        rememberChangedField("ChangeNumberLastChgdDateTime", this.changeNumberLastChgdDateTime);
        this.changeNumberLastChgdDateTime = changeNumberLastChgdDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ChangeMstrObMgReMaterial";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChangeNumber", getChangeNumber());
        result.put("Material", getMaterial());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AssignAltDateObjMgmtRecMAT_ac", getAssignAltDateObjMgmtRecMAT_ac());
        values.put("UnassignAltDateObjMgmtRecMAT_ac", getUnassignAltDateObjMgmtRecMAT_ac());
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("ChangeNumber", getChangeNumber());
        values.put("Material", getMaterial());
        values.put("ChgNmbrAlternativeDateID", getChgNmbrAlternativeDateID());
        values.put("SAPObjectTechnicalID", getSAPObjectTechnicalID());
        values.put("ObjMgmtRecdDescription", getObjMgmtRecdDescription());
        values.put("ObjMgmtRecdItemUUID", getObjMgmtRecdItemUUID());
        values.put("ObjMgmtRecdLastChangedAt", getObjMgmtRecdLastChangedAt());
        values.put("ObjMgmtRecdLastChangedBy", getObjMgmtRecdLastChangedBy());
        values.put("ObjMgmtRecdCreationDate", getObjMgmtRecdCreationDate());
        values.put("ObjMgmtRecdCreatedBy", getObjMgmtRecdCreatedBy());
        values.put("ObjMgmtRecdObjLastChangedAt", getObjMgmtRecdObjLastChangedAt());
        values.put("ObjMgmtRecdObjLastChangedBy", getObjMgmtRecdObjLastChangedBy());
        values.put("ObjMgmtRecdObjIsLockedForChg", getObjMgmtRecdObjIsLockedForChg());
        values.put("ObjMgmtRecdObjIsPlanned", getObjMgmtRecdObjIsPlanned());
        values.put("ObjMgmtRecdObjRevisionLevel", getObjMgmtRecdObjRevisionLevel());
        values.put("ChangeNumberLastChgdDateTime", getChangeNumberLastChgdDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AssignAltDateObjMgmtRecMAT_ac") ) {
                final Object value = values.remove("AssignAltDateObjMgmtRecMAT_ac");
                if( (value == null) || (!value.equals(getAssignAltDateObjMgmtRecMAT_ac())) ) {
                    setAssignAltDateObjMgmtRecMAT_ac(((Boolean) value));
                }
            }
            if( values.containsKey("UnassignAltDateObjMgmtRecMAT_ac") ) {
                final Object value = values.remove("UnassignAltDateObjMgmtRecMAT_ac");
                if( (value == null) || (!value.equals(getUnassignAltDateObjMgmtRecMAT_ac())) ) {
                    setUnassignAltDateObjMgmtRecMAT_ac(((Boolean) value));
                }
            }
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("ChgNmbrAlternativeDateID") ) {
                final Object value = values.remove("ChgNmbrAlternativeDateID");
                if( (value == null) || (!value.equals(getChgNmbrAlternativeDateID())) ) {
                    setChgNmbrAlternativeDateID(((String) value));
                }
            }
            if( values.containsKey("SAPObjectTechnicalID") ) {
                final Object value = values.remove("SAPObjectTechnicalID");
                if( (value == null) || (!value.equals(getSAPObjectTechnicalID())) ) {
                    setSAPObjectTechnicalID(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdDescription") ) {
                final Object value = values.remove("ObjMgmtRecdDescription");
                if( (value == null) || (!value.equals(getObjMgmtRecdDescription())) ) {
                    setObjMgmtRecdDescription(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdItemUUID") ) {
                final Object value = values.remove("ObjMgmtRecdItemUUID");
                if( (value == null) || (!value.equals(getObjMgmtRecdItemUUID())) ) {
                    setObjMgmtRecdItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdLastChangedAt") ) {
                final Object value = values.remove("ObjMgmtRecdLastChangedAt");
                if( (value == null) || (!value.equals(getObjMgmtRecdLastChangedAt())) ) {
                    setObjMgmtRecdLastChangedAt(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdLastChangedBy") ) {
                final Object value = values.remove("ObjMgmtRecdLastChangedBy");
                if( (value == null) || (!value.equals(getObjMgmtRecdLastChangedBy())) ) {
                    setObjMgmtRecdLastChangedBy(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdCreationDate") ) {
                final Object value = values.remove("ObjMgmtRecdCreationDate");
                if( (value == null) || (!value.equals(getObjMgmtRecdCreationDate())) ) {
                    setObjMgmtRecdCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdCreatedBy") ) {
                final Object value = values.remove("ObjMgmtRecdCreatedBy");
                if( (value == null) || (!value.equals(getObjMgmtRecdCreatedBy())) ) {
                    setObjMgmtRecdCreatedBy(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdObjLastChangedAt") ) {
                final Object value = values.remove("ObjMgmtRecdObjLastChangedAt");
                if( (value == null) || (!value.equals(getObjMgmtRecdObjLastChangedAt())) ) {
                    setObjMgmtRecdObjLastChangedAt(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdObjLastChangedBy") ) {
                final Object value = values.remove("ObjMgmtRecdObjLastChangedBy");
                if( (value == null) || (!value.equals(getObjMgmtRecdObjLastChangedBy())) ) {
                    setObjMgmtRecdObjLastChangedBy(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdObjIsLockedForChg") ) {
                final Object value = values.remove("ObjMgmtRecdObjIsLockedForChg");
                if( (value == null) || (!value.equals(getObjMgmtRecdObjIsLockedForChg())) ) {
                    setObjMgmtRecdObjIsLockedForChg(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdObjIsPlanned") ) {
                final Object value = values.remove("ObjMgmtRecdObjIsPlanned");
                if( (value == null) || (!value.equals(getObjMgmtRecdObjIsPlanned())) ) {
                    setObjMgmtRecdObjIsPlanned(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdObjRevisionLevel") ) {
                final Object value = values.remove("ObjMgmtRecdObjRevisionLevel");
                if( (value == null) || (!value.equals(getObjMgmtRecdObjRevisionLevel())) ) {
                    setObjMgmtRecdObjRevisionLevel(((String) value));
                }
            }
            if( values.containsKey("ChangeNumberLastChgdDateTime") ) {
                final Object value = values.remove("ChangeNumberLastChgdDateTime");
                if( (value == null) || (!value.equals(getChangeNumberLastChgdDateTime())) ) {
                    setChangeNumberLastChgdDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ChangeMstrObMgReMaterialField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ChangeMstrObMgReMaterialField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChangeMstrObMgReMaterialField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChangeMstrObMgReMaterialField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeMasterV2Service.DEFAULT_SERVICE_PATH);
    }

}
