/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.selectable.ChangeMstrObMgReMaterialSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
 * ChangeMstrObMgReMaterial} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ChangeMstrObMgReMaterialByKeyFluentHelper
    extends
    FluentHelperByKey<ChangeMstrObMgReMaterialByKeyFluentHelper, ChangeMstrObMgReMaterial, ChangeMstrObMgReMaterialSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     * ChangeMstrObMgReMaterial} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ChangeMstrObMgReMaterial}
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ChangeMstrObMgReMaterial}
     * @param changeNumber
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     */
    public ChangeMstrObMgReMaterialByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String changeNumber,
        final String material )
    {
        super(servicePath, entityCollection);
        this.key.put("ChangeNumber", changeNumber);
        this.key.put("Material", material);
    }

    @Override
    @Nonnull
    protected Class<ChangeMstrObMgReMaterial> getEntityClass()
    {
        return ChangeMstrObMgReMaterial.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
