/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.field.ChangeMstrObjectMgmtRecordField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.selectable.ChangeMstrObjectMgmtRecordSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Change Number Object Management Records
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ChangeMstrObjectMgmtRecordType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChangeMstrObjectMgmtRecord extends VdmEntity<ChangeMstrObjectMgmtRecord>
{

    /**
     * Selector for all available fields of ChangeMstrObjectMgmtRecord.
     *
     */
    public final static ChangeMstrObjectMgmtRecordSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AssignAltDateObjMgmtRecord_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "AssignAltDateObjMgmtRecord_ac" )
    @JsonProperty( "AssignAltDateObjMgmtRecord_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AssignAltDateObjMgmtRecord_ac" )
    private Boolean assignAltDateObjMgmtRecord_ac;
    /**
     * Use with available fluent helpers to apply the <b>AssignAltDateObjMgmtRecord_ac</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<Boolean> ASSIGN_ALT_DATE_OBJ_MGMT_RECORD_AC =
        new ChangeMstrObjectMgmtRecordField<Boolean>("AssignAltDateObjMgmtRecord_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnassignAltDateObjMgmtRecord_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "UnassignAltDateObjMgmtRecord_ac" )
    @JsonProperty( "UnassignAltDateObjMgmtRecord_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "UnassignAltDateObjMgmtRecord_ac" )
    private Boolean unassignAltDateObjMgmtRecord_ac;
    /**
     * Use with available fluent helpers to apply the <b>UnassignAltDateObjMgmtRecord_ac</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<Boolean> UNASSIGN_ALT_DATE_OBJ_MGMT_RECORD_AC =
        new ChangeMstrObjectMgmtRecordField<Boolean>("UnassignAltDateObjMgmtRecord_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<Boolean> DELETE_MC =
        new ChangeMstrObjectMgmtRecordField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<Boolean> UPDATE_MC =
        new ChangeMstrObjectMgmtRecordField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @Key
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<String> CHANGE_NUMBER =
        new ChangeMstrObjectMgmtRecordField<String>("ChangeNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @return SAP Object Type
     */
    @Key
    @SerializedName( "SAPObjectType" )
    @JsonProperty( "SAPObjectType" )
    @Nullable
    @ODataField( odataName = "SAPObjectType" )
    private String sAPObjectType;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectType</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<String> SAP_OBJECT_TYPE =
        new ChangeMstrObjectMgmtRecordField<String>("SAPObjectType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTechnicalID</b>
     * </p>
     *
     * @return Identification of object to be changed
     */
    @Key
    @SerializedName( "SAPObjectTechnicalID" )
    @JsonProperty( "SAPObjectTechnicalID" )
    @Nullable
    @ODataField( odataName = "SAPObjectTechnicalID" )
    private String sAPObjectTechnicalID;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectTechnicalID</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<String> SAP_OBJECT_TECHNICAL_ID =
        new ChangeMstrObjectMgmtRecordField<String>("SAPObjectTechnicalID");
    /**
     * Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectReadableID</b>
     * </p>
     *
     * @return SAPconnect/phone: Character 90
     */
    @SerializedName( "SAPObjectReadableID" )
    @JsonProperty( "SAPObjectReadableID" )
    @Nullable
    @ODataField( odataName = "SAPObjectReadableID" )
    private String sAPObjectReadableID;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectReadableID</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<String> SAP_OBJECT_READABLE_ID =
        new ChangeMstrObjectMgmtRecordField<String>("SAPObjectReadableID");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ChgNmbrAlternativeDateID</b>
     * </p>
     *
     * @return Alternative date external key
     */
    @SerializedName( "ChgNmbrAlternativeDateID" )
    @JsonProperty( "ChgNmbrAlternativeDateID" )
    @Nullable
    @ODataField( odataName = "ChgNmbrAlternativeDateID" )
    private String chgNmbrAlternativeDateID;
    /**
     * Use with available fluent helpers to apply the <b>ChgNmbrAlternativeDateID</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<String> CHG_NMBR_ALTERNATIVE_DATE_ID =
        new ChangeMstrObjectMgmtRecordField<String>("ChgNmbrAlternativeDateID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdDescription</b>
     * </p>
     *
     * @return Object management record description
     */
    @SerializedName( "ObjMgmtRecdDescription" )
    @JsonProperty( "ObjMgmtRecdDescription" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdDescription" )
    private String objMgmtRecdDescription;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdDescription</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<String> OBJ_MGMT_RECD_DESCRIPTION =
        new ChangeMstrObjectMgmtRecordField<String>("ObjMgmtRecdDescription");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdItemUUID</b>
     * </p>
     *
     * @return Object Management Record Item GUID
     */
    @SerializedName( "ObjMgmtRecdItemUUID" )
    @JsonProperty( "ObjMgmtRecdItemUUID" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdItemUUID" )
    private UUID objMgmtRecdItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdItemUUID</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<UUID> OBJ_MGMT_RECD_ITEM_UUID =
        new ChangeMstrObjectMgmtRecordField<UUID>("ObjMgmtRecdItemUUID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdLastChangedAt</b>
     * </p>
     *
     * @return Date of Last Change
     */
    @SerializedName( "ObjMgmtRecdLastChangedAt" )
    @JsonProperty( "ObjMgmtRecdLastChangedAt" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ObjMgmtRecdLastChangedAt",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime objMgmtRecdLastChangedAt;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdLastChangedAt</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<LocalDateTime> OBJ_MGMT_RECD_LAST_CHANGED_AT =
        new ChangeMstrObjectMgmtRecordField<LocalDateTime>("ObjMgmtRecdLastChangedAt");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdLastChangedBy</b>
     * </p>
     *
     * @return Name of person who changed object
     */
    @SerializedName( "ObjMgmtRecdLastChangedBy" )
    @JsonProperty( "ObjMgmtRecdLastChangedBy" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdLastChangedBy" )
    private String objMgmtRecdLastChangedBy;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdLastChangedBy</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<String> OBJ_MGMT_RECD_LAST_CHANGED_BY =
        new ChangeMstrObjectMgmtRecordField<String>("ObjMgmtRecdLastChangedBy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdCreationDate</b>
     * </p>
     *
     * @return Date record created on
     */
    @SerializedName( "ObjMgmtRecdCreationDate" )
    @JsonProperty( "ObjMgmtRecdCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ObjMgmtRecdCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime objMgmtRecdCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdCreationDate</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<LocalDateTime> OBJ_MGMT_RECD_CREATION_DATE =
        new ChangeMstrObjectMgmtRecordField<LocalDateTime>("ObjMgmtRecdCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdCreatedBy</b>
     * </p>
     *
     * @return User who created record
     */
    @SerializedName( "ObjMgmtRecdCreatedBy" )
    @JsonProperty( "ObjMgmtRecdCreatedBy" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdCreatedBy" )
    private String objMgmtRecdCreatedBy;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdCreatedBy</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<String> OBJ_MGMT_RECD_CREATED_BY =
        new ChangeMstrObjectMgmtRecordField<String>("ObjMgmtRecdCreatedBy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjLastChangedAt</b>
     * </p>
     *
     * @return Date on Which Object Was Last Changed
     */
    @SerializedName( "ObjMgmtRecdObjLastChangedAt" )
    @JsonProperty( "ObjMgmtRecdObjLastChangedAt" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ObjMgmtRecdObjLastChangedAt",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime objMgmtRecdObjLastChangedAt;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdObjLastChangedAt</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<LocalDateTime> OBJ_MGMT_RECD_OBJ_LAST_CHANGED_AT =
        new ChangeMstrObjectMgmtRecordField<LocalDateTime>("ObjMgmtRecdObjLastChangedAt");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjLastChangedBy</b>
     * </p>
     *
     * @return User who last changed the object
     */
    @SerializedName( "ObjMgmtRecdObjLastChangedBy" )
    @JsonProperty( "ObjMgmtRecdObjLastChangedBy" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdObjLastChangedBy" )
    private String objMgmtRecdObjLastChangedBy;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdObjLastChangedBy</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<String> OBJ_MGMT_RECD_OBJ_LAST_CHANGED_BY =
        new ChangeMstrObjectMgmtRecordField<String>("ObjMgmtRecdObjLastChangedBy");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjIsLockedForChg</b>
     * </p>
     *
     * @return Indicator: Object locked for changes
     */
    @SerializedName( "ObjMgmtRecdObjIsLockedForChg" )
    @JsonProperty( "ObjMgmtRecdObjIsLockedForChg" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdObjIsLockedForChg" )
    private String objMgmtRecdObjIsLockedForChg;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdObjIsLockedForChg</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<String> OBJ_MGMT_RECD_OBJ_IS_LOCKED_FOR_CHG =
        new ChangeMstrObjectMgmtRecordField<String>("ObjMgmtRecdObjIsLockedForChg");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjIsBaselined</b>
     * </p>
     *
     * @return Baselining for object was performed
     */
    @SerializedName( "ObjMgmtRecdObjIsBaselined" )
    @JsonProperty( "ObjMgmtRecdObjIsBaselined" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdObjIsBaselined" )
    private String objMgmtRecdObjIsBaselined;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdObjIsBaselined</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<String> OBJ_MGMT_RECD_OBJ_IS_BASELINED =
        new ChangeMstrObjectMgmtRecordField<String>("ObjMgmtRecdObjIsBaselined");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjIsPlanned</b>
     * </p>
     *
     * @return Indicator: planned record
     */
    @SerializedName( "ObjMgmtRecdObjIsPlanned" )
    @JsonProperty( "ObjMgmtRecdObjIsPlanned" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdObjIsPlanned" )
    private String objMgmtRecdObjIsPlanned;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdObjIsPlanned</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<String> OBJ_MGMT_RECD_OBJ_IS_PLANNED =
        new ChangeMstrObjectMgmtRecordField<String>("ObjMgmtRecdObjIsPlanned");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjRevisionLevel</b>
     * </p>
     *
     * @return Revision Level without Conversion Exit
     */
    @SerializedName( "ObjMgmtRecdObjRevisionLevel" )
    @JsonProperty( "ObjMgmtRecdObjRevisionLevel" )
    @Nullable
    @ODataField( odataName = "ObjMgmtRecdObjRevisionLevel" )
    private String objMgmtRecdObjRevisionLevel;
    /**
     * Use with available fluent helpers to apply the <b>ObjMgmtRecdObjRevisionLevel</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<String> OBJ_MGMT_RECD_OBJ_REVISION_LEVEL =
        new ChangeMstrObjectMgmtRecordField<String>("ObjMgmtRecdObjRevisionLevel");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberLastChgdDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "ChangeNumberLastChgdDateTime" )
    @JsonProperty( "ChangeNumberLastChgdDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangeNumberLastChgdDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changeNumberLastChgdDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumberLastChgdDateTime</b> field to query operations.
     *
     */
    public final static ChangeMstrObjectMgmtRecordField<ZonedDateTime> CHANGE_NUMBER_LAST_CHGD_DATE_TIME =
        new ChangeMstrObjectMgmtRecordField<ZonedDateTime>("ChangeNumberLastChgdDateTime");

    @Nonnull
    @Override
    public Class<ChangeMstrObjectMgmtRecord> getType()
    {
        return ChangeMstrObjectMgmtRecord.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AssignAltDateObjMgmtRecord_ac</b>
     * </p>
     *
     * @param assignAltDateObjMgmtRecord_ac
     *            Dyn. Action Control
     */
    public void setAssignAltDateObjMgmtRecord_ac( @Nullable final Boolean assignAltDateObjMgmtRecord_ac )
    {
        rememberChangedField("AssignAltDateObjMgmtRecord_ac", this.assignAltDateObjMgmtRecord_ac);
        this.assignAltDateObjMgmtRecord_ac = assignAltDateObjMgmtRecord_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnassignAltDateObjMgmtRecord_ac</b>
     * </p>
     *
     * @param unassignAltDateObjMgmtRecord_ac
     *            Dyn. Action Control
     */
    public void setUnassignAltDateObjMgmtRecord_ac( @Nullable final Boolean unassignAltDateObjMgmtRecord_ac )
    {
        rememberChangedField("UnassignAltDateObjMgmtRecord_ac", this.unassignAltDateObjMgmtRecord_ac);
        this.unassignAltDateObjMgmtRecord_ac = unassignAltDateObjMgmtRecord_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @param sAPObjectType
     *            SAP Object Type
     */
    public void setSAPObjectType( @Nullable final String sAPObjectType )
    {
        rememberChangedField("SAPObjectType", this.sAPObjectType);
        this.sAPObjectType = sAPObjectType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTechnicalID</b>
     * </p>
     *
     * @param sAPObjectTechnicalID
     *            Identification of object to be changed
     */
    public void setSAPObjectTechnicalID( @Nullable final String sAPObjectTechnicalID )
    {
        rememberChangedField("SAPObjectTechnicalID", this.sAPObjectTechnicalID);
        this.sAPObjectTechnicalID = sAPObjectTechnicalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectReadableID</b>
     * </p>
     *
     * @param sAPObjectReadableID
     *            SAPconnect/phone: Character 90
     */
    public void setSAPObjectReadableID( @Nullable final String sAPObjectReadableID )
    {
        rememberChangedField("SAPObjectReadableID", this.sAPObjectReadableID);
        this.sAPObjectReadableID = sAPObjectReadableID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ChgNmbrAlternativeDateID</b>
     * </p>
     *
     * @param chgNmbrAlternativeDateID
     *            Alternative date external key
     */
    public void setChgNmbrAlternativeDateID( @Nullable final String chgNmbrAlternativeDateID )
    {
        rememberChangedField("ChgNmbrAlternativeDateID", this.chgNmbrAlternativeDateID);
        this.chgNmbrAlternativeDateID = chgNmbrAlternativeDateID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdDescription</b>
     * </p>
     *
     * @param objMgmtRecdDescription
     *            Object management record description
     */
    public void setObjMgmtRecdDescription( @Nullable final String objMgmtRecdDescription )
    {
        rememberChangedField("ObjMgmtRecdDescription", this.objMgmtRecdDescription);
        this.objMgmtRecdDescription = objMgmtRecdDescription;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdItemUUID</b>
     * </p>
     *
     * @param objMgmtRecdItemUUID
     *            Object Management Record Item GUID
     */
    public void setObjMgmtRecdItemUUID( @Nullable final UUID objMgmtRecdItemUUID )
    {
        rememberChangedField("ObjMgmtRecdItemUUID", this.objMgmtRecdItemUUID);
        this.objMgmtRecdItemUUID = objMgmtRecdItemUUID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdLastChangedAt</b>
     * </p>
     *
     * @param objMgmtRecdLastChangedAt
     *            Date of Last Change
     */
    public void setObjMgmtRecdLastChangedAt( @Nullable final LocalDateTime objMgmtRecdLastChangedAt )
    {
        rememberChangedField("ObjMgmtRecdLastChangedAt", this.objMgmtRecdLastChangedAt);
        this.objMgmtRecdLastChangedAt = objMgmtRecdLastChangedAt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdLastChangedBy</b>
     * </p>
     *
     * @param objMgmtRecdLastChangedBy
     *            Name of person who changed object
     */
    public void setObjMgmtRecdLastChangedBy( @Nullable final String objMgmtRecdLastChangedBy )
    {
        rememberChangedField("ObjMgmtRecdLastChangedBy", this.objMgmtRecdLastChangedBy);
        this.objMgmtRecdLastChangedBy = objMgmtRecdLastChangedBy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdCreationDate</b>
     * </p>
     *
     * @param objMgmtRecdCreationDate
     *            Date record created on
     */
    public void setObjMgmtRecdCreationDate( @Nullable final LocalDateTime objMgmtRecdCreationDate )
    {
        rememberChangedField("ObjMgmtRecdCreationDate", this.objMgmtRecdCreationDate);
        this.objMgmtRecdCreationDate = objMgmtRecdCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdCreatedBy</b>
     * </p>
     *
     * @param objMgmtRecdCreatedBy
     *            User who created record
     */
    public void setObjMgmtRecdCreatedBy( @Nullable final String objMgmtRecdCreatedBy )
    {
        rememberChangedField("ObjMgmtRecdCreatedBy", this.objMgmtRecdCreatedBy);
        this.objMgmtRecdCreatedBy = objMgmtRecdCreatedBy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjLastChangedAt</b>
     * </p>
     *
     * @param objMgmtRecdObjLastChangedAt
     *            Date on Which Object Was Last Changed
     */
    public void setObjMgmtRecdObjLastChangedAt( @Nullable final LocalDateTime objMgmtRecdObjLastChangedAt )
    {
        rememberChangedField("ObjMgmtRecdObjLastChangedAt", this.objMgmtRecdObjLastChangedAt);
        this.objMgmtRecdObjLastChangedAt = objMgmtRecdObjLastChangedAt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjLastChangedBy</b>
     * </p>
     *
     * @param objMgmtRecdObjLastChangedBy
     *            User who last changed the object
     */
    public void setObjMgmtRecdObjLastChangedBy( @Nullable final String objMgmtRecdObjLastChangedBy )
    {
        rememberChangedField("ObjMgmtRecdObjLastChangedBy", this.objMgmtRecdObjLastChangedBy);
        this.objMgmtRecdObjLastChangedBy = objMgmtRecdObjLastChangedBy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjIsLockedForChg</b>
     * </p>
     *
     * @param objMgmtRecdObjIsLockedForChg
     *            Indicator: Object locked for changes
     */
    public void setObjMgmtRecdObjIsLockedForChg( @Nullable final String objMgmtRecdObjIsLockedForChg )
    {
        rememberChangedField("ObjMgmtRecdObjIsLockedForChg", this.objMgmtRecdObjIsLockedForChg);
        this.objMgmtRecdObjIsLockedForChg = objMgmtRecdObjIsLockedForChg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjIsBaselined</b>
     * </p>
     *
     * @param objMgmtRecdObjIsBaselined
     *            Baselining for object was performed
     */
    public void setObjMgmtRecdObjIsBaselined( @Nullable final String objMgmtRecdObjIsBaselined )
    {
        rememberChangedField("ObjMgmtRecdObjIsBaselined", this.objMgmtRecdObjIsBaselined);
        this.objMgmtRecdObjIsBaselined = objMgmtRecdObjIsBaselined;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjIsPlanned</b>
     * </p>
     *
     * @param objMgmtRecdObjIsPlanned
     *            Indicator: planned record
     */
    public void setObjMgmtRecdObjIsPlanned( @Nullable final String objMgmtRecdObjIsPlanned )
    {
        rememberChangedField("ObjMgmtRecdObjIsPlanned", this.objMgmtRecdObjIsPlanned);
        this.objMgmtRecdObjIsPlanned = objMgmtRecdObjIsPlanned;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ObjMgmtRecdObjRevisionLevel</b>
     * </p>
     *
     * @param objMgmtRecdObjRevisionLevel
     *            Revision Level without Conversion Exit
     */
    public void setObjMgmtRecdObjRevisionLevel( @Nullable final String objMgmtRecdObjRevisionLevel )
    {
        rememberChangedField("ObjMgmtRecdObjRevisionLevel", this.objMgmtRecdObjRevisionLevel);
        this.objMgmtRecdObjRevisionLevel = objMgmtRecdObjRevisionLevel;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumberLastChgdDateTime</b>
     * </p>
     *
     * @param changeNumberLastChgdDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setChangeNumberLastChgdDateTime( @Nullable final ZonedDateTime changeNumberLastChgdDateTime )
    {
        rememberChangedField("ChangeNumberLastChgdDateTime", this.changeNumberLastChgdDateTime);
        this.changeNumberLastChgdDateTime = changeNumberLastChgdDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ChangeMstrObjectMgmtRecord";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChangeNumber", getChangeNumber());
        result.put("SAPObjectType", getSAPObjectType());
        result.put("SAPObjectTechnicalID", getSAPObjectTechnicalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AssignAltDateObjMgmtRecord_ac", getAssignAltDateObjMgmtRecord_ac());
        values.put("UnassignAltDateObjMgmtRecord_ac", getUnassignAltDateObjMgmtRecord_ac());
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("ChangeNumber", getChangeNumber());
        values.put("SAPObjectType", getSAPObjectType());
        values.put("SAPObjectTechnicalID", getSAPObjectTechnicalID());
        values.put("SAPObjectReadableID", getSAPObjectReadableID());
        values.put("ChgNmbrAlternativeDateID", getChgNmbrAlternativeDateID());
        values.put("ObjMgmtRecdDescription", getObjMgmtRecdDescription());
        values.put("ObjMgmtRecdItemUUID", getObjMgmtRecdItemUUID());
        values.put("ObjMgmtRecdLastChangedAt", getObjMgmtRecdLastChangedAt());
        values.put("ObjMgmtRecdLastChangedBy", getObjMgmtRecdLastChangedBy());
        values.put("ObjMgmtRecdCreationDate", getObjMgmtRecdCreationDate());
        values.put("ObjMgmtRecdCreatedBy", getObjMgmtRecdCreatedBy());
        values.put("ObjMgmtRecdObjLastChangedAt", getObjMgmtRecdObjLastChangedAt());
        values.put("ObjMgmtRecdObjLastChangedBy", getObjMgmtRecdObjLastChangedBy());
        values.put("ObjMgmtRecdObjIsLockedForChg", getObjMgmtRecdObjIsLockedForChg());
        values.put("ObjMgmtRecdObjIsBaselined", getObjMgmtRecdObjIsBaselined());
        values.put("ObjMgmtRecdObjIsPlanned", getObjMgmtRecdObjIsPlanned());
        values.put("ObjMgmtRecdObjRevisionLevel", getObjMgmtRecdObjRevisionLevel());
        values.put("ChangeNumberLastChgdDateTime", getChangeNumberLastChgdDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AssignAltDateObjMgmtRecord_ac") ) {
                final Object value = values.remove("AssignAltDateObjMgmtRecord_ac");
                if( (value == null) || (!value.equals(getAssignAltDateObjMgmtRecord_ac())) ) {
                    setAssignAltDateObjMgmtRecord_ac(((Boolean) value));
                }
            }
            if( values.containsKey("UnassignAltDateObjMgmtRecord_ac") ) {
                final Object value = values.remove("UnassignAltDateObjMgmtRecord_ac");
                if( (value == null) || (!value.equals(getUnassignAltDateObjMgmtRecord_ac())) ) {
                    setUnassignAltDateObjMgmtRecord_ac(((Boolean) value));
                }
            }
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("SAPObjectType") ) {
                final Object value = values.remove("SAPObjectType");
                if( (value == null) || (!value.equals(getSAPObjectType())) ) {
                    setSAPObjectType(((String) value));
                }
            }
            if( values.containsKey("SAPObjectTechnicalID") ) {
                final Object value = values.remove("SAPObjectTechnicalID");
                if( (value == null) || (!value.equals(getSAPObjectTechnicalID())) ) {
                    setSAPObjectTechnicalID(((String) value));
                }
            }
            if( values.containsKey("SAPObjectReadableID") ) {
                final Object value = values.remove("SAPObjectReadableID");
                if( (value == null) || (!value.equals(getSAPObjectReadableID())) ) {
                    setSAPObjectReadableID(((String) value));
                }
            }
            if( values.containsKey("ChgNmbrAlternativeDateID") ) {
                final Object value = values.remove("ChgNmbrAlternativeDateID");
                if( (value == null) || (!value.equals(getChgNmbrAlternativeDateID())) ) {
                    setChgNmbrAlternativeDateID(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdDescription") ) {
                final Object value = values.remove("ObjMgmtRecdDescription");
                if( (value == null) || (!value.equals(getObjMgmtRecdDescription())) ) {
                    setObjMgmtRecdDescription(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdItemUUID") ) {
                final Object value = values.remove("ObjMgmtRecdItemUUID");
                if( (value == null) || (!value.equals(getObjMgmtRecdItemUUID())) ) {
                    setObjMgmtRecdItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdLastChangedAt") ) {
                final Object value = values.remove("ObjMgmtRecdLastChangedAt");
                if( (value == null) || (!value.equals(getObjMgmtRecdLastChangedAt())) ) {
                    setObjMgmtRecdLastChangedAt(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdLastChangedBy") ) {
                final Object value = values.remove("ObjMgmtRecdLastChangedBy");
                if( (value == null) || (!value.equals(getObjMgmtRecdLastChangedBy())) ) {
                    setObjMgmtRecdLastChangedBy(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdCreationDate") ) {
                final Object value = values.remove("ObjMgmtRecdCreationDate");
                if( (value == null) || (!value.equals(getObjMgmtRecdCreationDate())) ) {
                    setObjMgmtRecdCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdCreatedBy") ) {
                final Object value = values.remove("ObjMgmtRecdCreatedBy");
                if( (value == null) || (!value.equals(getObjMgmtRecdCreatedBy())) ) {
                    setObjMgmtRecdCreatedBy(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdObjLastChangedAt") ) {
                final Object value = values.remove("ObjMgmtRecdObjLastChangedAt");
                if( (value == null) || (!value.equals(getObjMgmtRecdObjLastChangedAt())) ) {
                    setObjMgmtRecdObjLastChangedAt(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdObjLastChangedBy") ) {
                final Object value = values.remove("ObjMgmtRecdObjLastChangedBy");
                if( (value == null) || (!value.equals(getObjMgmtRecdObjLastChangedBy())) ) {
                    setObjMgmtRecdObjLastChangedBy(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdObjIsLockedForChg") ) {
                final Object value = values.remove("ObjMgmtRecdObjIsLockedForChg");
                if( (value == null) || (!value.equals(getObjMgmtRecdObjIsLockedForChg())) ) {
                    setObjMgmtRecdObjIsLockedForChg(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdObjIsBaselined") ) {
                final Object value = values.remove("ObjMgmtRecdObjIsBaselined");
                if( (value == null) || (!value.equals(getObjMgmtRecdObjIsBaselined())) ) {
                    setObjMgmtRecdObjIsBaselined(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdObjIsPlanned") ) {
                final Object value = values.remove("ObjMgmtRecdObjIsPlanned");
                if( (value == null) || (!value.equals(getObjMgmtRecdObjIsPlanned())) ) {
                    setObjMgmtRecdObjIsPlanned(((String) value));
                }
            }
            if( values.containsKey("ObjMgmtRecdObjRevisionLevel") ) {
                final Object value = values.remove("ObjMgmtRecdObjRevisionLevel");
                if( (value == null) || (!value.equals(getObjMgmtRecdObjRevisionLevel())) ) {
                    setObjMgmtRecdObjRevisionLevel(((String) value));
                }
            }
            if( values.containsKey("ChangeNumberLastChgdDateTime") ) {
                final Object value = values.remove("ChangeNumberLastChgdDateTime");
                if( (value == null) || (!value.equals(getChangeNumberLastChgdDateTime())) ) {
                    setChangeNumberLastChgdDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ChangeMstrObjectMgmtRecordField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ChangeMstrObjectMgmtRecordField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChangeMstrObjectMgmtRecordField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChangeMstrObjectMgmtRecordField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeMasterV2Service.DEFAULT_SERVICE_PATH);
    }

}
