/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.selectable.ChangeMstrObjectMgmtRecordSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
 * ChangeMstrObjectMgmtRecord} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ChangeMstrObjectMgmtRecordByKeyFluentHelper
    extends
    FluentHelperByKey<ChangeMstrObjectMgmtRecordByKeyFluentHelper, ChangeMstrObjectMgmtRecord, ChangeMstrObjectMgmtRecordSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
     * ChangeMstrObjectMgmtRecord} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ChangeMstrObjectMgmtRecord}
     * @param sAPObjectTechnicalID
     *            Identification of object to be changed
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ChangeMstrObjectMgmtRecord}
     * @param changeNumber
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param sAPObjectType
     *            SAP Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     */
    public ChangeMstrObjectMgmtRecordByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String changeNumber,
        final String sAPObjectType,
        final String sAPObjectTechnicalID )
    {
        super(servicePath, entityCollection);
        this.key.put("ChangeNumber", changeNumber);
        this.key.put("SAPObjectType", sAPObjectType);
        this.key.put("SAPObjectTechnicalID", sAPObjectTechnicalID);
    }

    @Override
    @Nonnull
    protected Class<ChangeMstrObjectMgmtRecord> getEntityClass()
    {
        return ChangeMstrObjectMgmtRecord.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
