/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeMasterV2Service ChangeMasterV2Service}.
 *
 */
public interface ChangeMasterV2ServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ChangeMasterV2ServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ChangeMasterV2ServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     * ChangeMasterAltDate} entity and save it to the S/4HANA system.
     *
     * @param changeMasterAltDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     *            ChangeMasterAltDate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        createChangeMasterAltDate( @Nonnull final ChangeMasterAltDate changeMasterAltDate );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     * ChangeMasterAltDate} entity and save it to the S/4HANA system.
     *
     * @param changeMasterAltDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     *            ChangeMasterAltDate} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        updateChangeMasterAltDate( @Nonnull final ChangeMasterAltDate changeMasterAltDate );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     * ChangeMasterAltDate} entity in the S/4HANA system.
     *
     * @param changeMasterAltDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     *            ChangeMasterAltDate} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        deleteChangeMasterAltDate( @Nonnull final ChangeMasterAltDate changeMasterAltDate );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     * ChangeMasterObjTypeAssgmt} entity and save it to the S/4HANA system.
     *
     * @param changeMasterObjTypeAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     *            ChangeMasterObjTypeAssgmt} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        createChangeMasterObjTypeAssgmt( @Nonnull final ChangeMasterObjTypeAssgmt changeMasterObjTypeAssgmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     * ChangeMasterObjTypeAssgmt} entity and save it to the S/4HANA system.
     *
     * @param changeMasterObjTypeAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     *            ChangeMasterObjTypeAssgmt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        updateChangeMasterObjTypeAssgmt( @Nonnull final ChangeMasterObjTypeAssgmt changeMasterObjTypeAssgmt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     * ChangeMasterObjTypeAssgmt} entity in the S/4HANA system.
     *
     * @param changeMasterObjTypeAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     *            ChangeMasterObjTypeAssgmt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        deleteChangeMasterObjTypeAssgmt( @Nonnull final ChangeMasterObjTypeAssgmt changeMasterObjTypeAssgmt );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster ChangeMaster}
     * entity and save it to the S/4HANA system.
     *
     * @param changeMaster
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster ChangeMaster}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet createChangeMaster( @Nonnull final ChangeMaster changeMaster );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster
     * ChangeMaster} entity and save it to the S/4HANA system.
     *
     * @param changeMaster
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster ChangeMaster}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet updateChangeMaster( @Nonnull final ChangeMaster changeMaster );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster
     * ChangeMaster} entity in the S/4HANA system.
     *
     * @param changeMaster
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster ChangeMaster}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet deleteChangeMaster( @Nonnull final ChangeMaster changeMaster );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
     * ChangeMstrObjectMgmtRecord} entity and save it to the S/4HANA system.
     *
     * @param changeMstrObjectMgmtRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
     *            ChangeMstrObjectMgmtRecord} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        updateChangeMstrObjectMgmtRecord( @Nonnull final ChangeMstrObjectMgmtRecord changeMstrObjectMgmtRecord );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
     * ChangeMstrObjectMgmtRecord} entity in the S/4HANA system.
     *
     * @param changeMstrObjectMgmtRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
     *            ChangeMstrObjectMgmtRecord} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        deleteChangeMstrObjectMgmtRecord( @Nonnull final ChangeMstrObjectMgmtRecord changeMstrObjectMgmtRecord );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     * ChangeMstrObMgReDocInfoRecd} entity and save it to the S/4HANA system.
     *
     * @param changeMstrObMgReDocInfoRecd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     *            ChangeMstrObMgReDocInfoRecd} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        createChangeMstrObMgReDocInfoRecd( @Nonnull final ChangeMstrObMgReDocInfoRecd changeMstrObMgReDocInfoRecd );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     * ChangeMstrObMgReDocInfoRecd} entity and save it to the S/4HANA system.
     *
     * @param changeMstrObMgReDocInfoRecd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     *            ChangeMstrObMgReDocInfoRecd} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        updateChangeMstrObMgReDocInfoRecd( @Nonnull final ChangeMstrObMgReDocInfoRecd changeMstrObMgReDocInfoRecd );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     * ChangeMstrObMgReDocInfoRecd} entity in the S/4HANA system.
     *
     * @param changeMstrObMgReDocInfoRecd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     *            ChangeMstrObMgReDocInfoRecd} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        deleteChangeMstrObMgReDocInfoRecd( @Nonnull final ChangeMstrObMgReDocInfoRecd changeMstrObMgReDocInfoRecd );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     * ChangeMstrObMgReMaterial} entity and save it to the S/4HANA system.
     *
     * @param changeMstrObMgReMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     *            ChangeMstrObMgReMaterial} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        createChangeMstrObMgReMaterial( @Nonnull final ChangeMstrObMgReMaterial changeMstrObMgReMaterial );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     * ChangeMstrObMgReMaterial} entity and save it to the S/4HANA system.
     *
     * @param changeMstrObMgReMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     *            ChangeMstrObMgReMaterial} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        updateChangeMstrObMgReMaterial( @Nonnull final ChangeMstrObMgReMaterial changeMstrObMgReMaterial );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     * ChangeMstrObMgReMaterial} entity in the S/4HANA system.
     *
     * @param changeMstrObMgReMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     *            ChangeMstrObMgReMaterial} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        deleteChangeMstrObMgReMaterial( @Nonnull final ChangeMstrObMgReMaterial changeMstrObMgReMaterial );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     * ChangeMstrObMgReMatlBOM} entity and save it to the S/4HANA system.
     *
     * @param changeMstrObMgReMatlBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     *            ChangeMstrObMgReMatlBOM} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        createChangeMstrObMgReMatlBOM( @Nonnull final ChangeMstrObMgReMatlBOM changeMstrObMgReMatlBOM );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     * ChangeMstrObMgReMatlBOM} entity and save it to the S/4HANA system.
     *
     * @param changeMstrObMgReMatlBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     *            ChangeMstrObMgReMatlBOM} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        updateChangeMstrObMgReMatlBOM( @Nonnull final ChangeMstrObMgReMatlBOM changeMstrObMgReMatlBOM );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     * ChangeMstrObMgReMatlBOM} entity in the S/4HANA system.
     *
     * @param changeMstrObMgReMatlBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     *            ChangeMstrObMgReMatlBOM} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ChangeMasterV2ServiceBatchChangeSet
        deleteChangeMstrObMgReMatlBOM( @Nonnull final ChangeMstrObMgReMatlBOM changeMstrObMgReMatlBOM );

}
