/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord;

/**
 * Implementation of the {@link ChangeMasterV2ServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeMasterV2Service ChangeMasterV2Service}.
 *
 */
public class DefaultChangeMasterV2ServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ChangeMasterV2ServiceBatch, ChangeMasterV2ServiceBatchChangeSet>
    implements
    ChangeMasterV2ServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeMasterV2Service service;

    @SuppressWarnings( "deprecation" )
    DefaultChangeMasterV2ServiceBatchChangeSet(
        @Nonnull final DefaultChangeMasterV2ServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeMasterV2Service service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultChangeMasterV2ServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet createChangeMasterAltDate(
        @Nonnull final ChangeMasterAltDate changeMasterAltDate )
    {
        return addRequestCreate(service::createChangeMasterAltDate, changeMasterAltDate);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet updateChangeMasterAltDate(
        @Nonnull final ChangeMasterAltDate changeMasterAltDate )
    {
        return addRequestUpdate(service::updateChangeMasterAltDate, changeMasterAltDate);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet deleteChangeMasterAltDate(
        @Nonnull final ChangeMasterAltDate changeMasterAltDate )
    {
        return addRequestDelete(service::deleteChangeMasterAltDate, changeMasterAltDate);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet createChangeMasterObjTypeAssgmt(
        @Nonnull final ChangeMasterObjTypeAssgmt changeMasterObjTypeAssgmt )
    {
        return addRequestCreate(service::createChangeMasterObjTypeAssgmt, changeMasterObjTypeAssgmt);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet updateChangeMasterObjTypeAssgmt(
        @Nonnull final ChangeMasterObjTypeAssgmt changeMasterObjTypeAssgmt )
    {
        return addRequestUpdate(service::updateChangeMasterObjTypeAssgmt, changeMasterObjTypeAssgmt);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet deleteChangeMasterObjTypeAssgmt(
        @Nonnull final ChangeMasterObjTypeAssgmt changeMasterObjTypeAssgmt )
    {
        return addRequestDelete(service::deleteChangeMasterObjTypeAssgmt, changeMasterObjTypeAssgmt);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet createChangeMaster( @Nonnull final ChangeMaster changeMaster )
    {
        return addRequestCreate(service::createChangeMaster, changeMaster);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet updateChangeMaster( @Nonnull final ChangeMaster changeMaster )
    {
        return addRequestUpdate(service::updateChangeMaster, changeMaster);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet deleteChangeMaster( @Nonnull final ChangeMaster changeMaster )
    {
        return addRequestDelete(service::deleteChangeMaster, changeMaster);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet updateChangeMstrObjectMgmtRecord(
        @Nonnull final ChangeMstrObjectMgmtRecord changeMstrObjectMgmtRecord )
    {
        return addRequestUpdate(service::updateChangeMstrObjectMgmtRecord, changeMstrObjectMgmtRecord);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet deleteChangeMstrObjectMgmtRecord(
        @Nonnull final ChangeMstrObjectMgmtRecord changeMstrObjectMgmtRecord )
    {
        return addRequestDelete(service::deleteChangeMstrObjectMgmtRecord, changeMstrObjectMgmtRecord);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet createChangeMstrObMgReDocInfoRecd(
        @Nonnull final ChangeMstrObMgReDocInfoRecd changeMstrObMgReDocInfoRecd )
    {
        return addRequestCreate(service::createChangeMstrObMgReDocInfoRecd, changeMstrObMgReDocInfoRecd);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet updateChangeMstrObMgReDocInfoRecd(
        @Nonnull final ChangeMstrObMgReDocInfoRecd changeMstrObMgReDocInfoRecd )
    {
        return addRequestUpdate(service::updateChangeMstrObMgReDocInfoRecd, changeMstrObMgReDocInfoRecd);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet deleteChangeMstrObMgReDocInfoRecd(
        @Nonnull final ChangeMstrObMgReDocInfoRecd changeMstrObMgReDocInfoRecd )
    {
        return addRequestDelete(service::deleteChangeMstrObMgReDocInfoRecd, changeMstrObMgReDocInfoRecd);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet createChangeMstrObMgReMaterial(
        @Nonnull final ChangeMstrObMgReMaterial changeMstrObMgReMaterial )
    {
        return addRequestCreate(service::createChangeMstrObMgReMaterial, changeMstrObMgReMaterial);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet updateChangeMstrObMgReMaterial(
        @Nonnull final ChangeMstrObMgReMaterial changeMstrObMgReMaterial )
    {
        return addRequestUpdate(service::updateChangeMstrObMgReMaterial, changeMstrObMgReMaterial);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet deleteChangeMstrObMgReMaterial(
        @Nonnull final ChangeMstrObMgReMaterial changeMstrObMgReMaterial )
    {
        return addRequestDelete(service::deleteChangeMstrObMgReMaterial, changeMstrObMgReMaterial);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet createChangeMstrObMgReMatlBOM(
        @Nonnull final ChangeMstrObMgReMatlBOM changeMstrObMgReMatlBOM )
    {
        return addRequestCreate(service::createChangeMstrObMgReMatlBOM, changeMstrObMgReMatlBOM);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet updateChangeMstrObMgReMatlBOM(
        @Nonnull final ChangeMstrObMgReMatlBOM changeMstrObMgReMatlBOM )
    {
        return addRequestUpdate(service::updateChangeMstrObMgReMatlBOM, changeMstrObMgReMatlBOM);
    }

    @Nonnull
    @Override
    public ChangeMasterV2ServiceBatchChangeSet deleteChangeMstrObMgReMatlBOM(
        @Nonnull final ChangeMstrObMgReMatlBOM changeMstrObMgReMatlBOM )
    {
        return addRequestDelete(service::deleteChangeMstrObMgReMatlBOM, changeMstrObMgReMatlBOM);
    }

}
