/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.selectable.ChangeMstrObMgReDocInfoRecdSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
 * ChangeMstrObMgReDocInfoRecd} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class ChangeMstrObMgReDocInfoRecdLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<ChangeMstrObMgReDocInfoRecdLink<ObjectT>, ChangeMstrObMgReDocInfoRecd, ObjectT>
    implements
    ChangeMstrObMgReDocInfoRecdSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public ChangeMstrObMgReDocInfoRecdLink( final String fieldName )
    {
        super(fieldName);
    }

    private ChangeMstrObMgReDocInfoRecdLink(
        final EntityLink<ChangeMstrObMgReDocInfoRecdLink<ObjectT>, ChangeMstrObMgReDocInfoRecd, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected ChangeMstrObMgReDocInfoRecdLink<ObjectT> translateLinkType(
        final EntityLink<ChangeMstrObMgReDocInfoRecdLink<ObjectT>, ChangeMstrObMgReDocInfoRecd, ObjectT> link )
    {
        return new ChangeMstrObMgReDocInfoRecdLink<ObjectT>(link);
    }

}
