/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
 * ChangeMasterObjTypeAssgmt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.field.ChangeMasterObjTypeAssgmtField
 * ChangeMasterObjTypeAssgmtField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.link.ChangeMasterObjTypeAssgmtLink
 * ChangeMasterObjTypeAssgmtLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#SAP_OBJECT_TYPE
 * SAP_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#IS_ACTIVE_FOR_CHANGE_NUMBER
 * IS_ACTIVE_FOR_CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#IS_LOCKED_FOR_CHANGES
 * IS_LOCKED_FOR_CHANGES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#IS_PARTIALLY_DISPLAYED
 * IS_PARTIALLY_DISPLAYED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#OBJ_MGMT_RECD_IS_REQUIRED
 * OBJ_MGMT_RECD_IS_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#OBJ_MGMT_RECD_IS_GENERATED
 * OBJ_MGMT_RECD_IS_GENERATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#OBJ_MGMT_RECD_IS_AUTOMLY_CRTED
 * OBJ_MGMT_RECD_IS_AUTOMLY_CRTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#OBJ_MGMT_RECD_IS_AUTOMLY_CRTED_BY_DLG
 * OBJ_MGMT_RECD_IS_AUTOMLY_CRTED_BY_DLG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#OBJECT_TYPE_CREATION_DATE
 * OBJECT_TYPE_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#OBJECT_TYPE_CREATED_BY_USER
 * OBJECT_TYPE_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#OBJECT_TYPE_LAST_CHANGED_DATE
 * OBJECT_TYPE_LAST_CHANGED_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#OBJECT_TYPE_LAST_CHANGED_BY_USER
 * OBJECT_TYPE_LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt#CHANGE_NUMBER_LAST_CHGD_DATE_TIME
 * CHANGE_NUMBER_LAST_CHGD_DATE_TIME}</li>
 * </ul>
 *
 */
public interface ChangeMasterObjTypeAssgmtSelectable extends EntitySelectable<ChangeMasterObjTypeAssgmt>
{

}
