/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster ChangeMaster}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.field.ChangeMasterField
 * ChangeMasterField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.link.ChangeMasterLink ChangeMasterLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#SHIFT_VALIDITY_START_DATE_AC
 * SHIFT_VALIDITY_START_DATE_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#DELETE_MC DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#UPDATE_MC UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#ALTERNATIVE_DATE_OC
 * ALTERNATIVE_DATE_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#CHANGE_MSTR_OB_MG_RE_DOC_INFO_RECD_OC
 * CHANGE_MSTR_OB_MG_RE_DOC_INFO_RECD_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#CHANGE_MSTR_OB_MG_RE_MATERIAL_OC
 * CHANGE_MSTR_OB_MG_RE_MATERIAL_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#CHANGE_MSTR_OB_MG_RE_MATL_BOM_OC
 * CHANGE_MSTR_OB_MG_RE_MATL_BOM_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#OBJ_TYPE_ASSIGNMENT_OC
 * OBJ_TYPE_ASSIGNMENT_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#CHANGE_NUMBER_STATUS
 * CHANGE_NUMBER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#CHANGE_NUMBER_FUNCTION
 * CHANGE_NUMBER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#IS_TECHNICALLY_RELEASED
 * IS_TECHNICALLY_RELEASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#CHANGE_NUMBER_RELEASE_KEY
 * CHANGE_NUMBER_RELEASE_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#REASON_FOR_CHANGE_TEXT
 * REASON_FOR_CHANGE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#CHANGE_NUMBER_DESCRIPTION
 * CHANGE_NUMBER_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#CHANGE_NUMBER_VALID_FROM_DATE
 * CHANGE_NUMBER_VALID_FROM_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#CHANGE_NUMBER_CREATION_DATE
 * CHANGE_NUMBER_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#CHANGE_NUMBER_CREATED_BY_USER
 * CHANGE_NUMBER_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#CHANGE_NUMBER_LAST_CHANGED_DATE
 * CHANGE_NUMBER_LAST_CHANGED_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#CHANGE_NUMBER_LAST_CHANGED_BY_USER
 * CHANGE_NUMBER_LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#IS_USED_FOR_DATA_DEFINITION
 * IS_USED_FOR_DATA_DEFINITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#CHANGE_NUMBER_IS_MRKD_FOR_DELETION
 * CHANGE_NUMBER_IS_MRKD_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#CHANGE_NUMBER_LAST_CHGD_DATE_TIME
 * CHANGE_NUMBER_LAST_CHGD_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#TO_ALTERNATIVE_DATE
 * TO_ALTERNATIVE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#TO_CHANGE_MSTR_OBJECT_MGMT_RECORD
 * TO_CHANGE_MSTR_OBJECT_MGMT_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#TO_CHANGE_MSTR_OB_MG_RE_DOC_INFO_RECD
 * TO_CHANGE_MSTR_OB_MG_RE_DOC_INFO_RECD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#TO_CHANGE_MSTR_OB_MG_RE_MATERIAL
 * TO_CHANGE_MSTR_OB_MG_RE_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#TO_CHANGE_MSTR_OB_MG_RE_MATL_BOM
 * TO_CHANGE_MSTR_OB_MG_RE_MATL_BOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#TO_CHARACTERISTICS
 * TO_CHARACTERISTICS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#TO_CLASSIFICATION
 * TO_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster#TO_OBJ_TYPE_ASSIGNMENT
 * TO_OBJ_TYPE_ASSIGNMENT}</li>
 * </ul>
 *
 */
public interface ChangeMasterSelectable extends EntitySelectable<ChangeMaster>
{

}
