/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
 * ChangeMstrObMgReDocInfoRecd}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.field.ChangeMstrObMgReDocInfoRecdField
 * ChangeMstrObMgReDocInfoRecdField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.link.ChangeMstrObMgReDocInfoRecdLink
 * ChangeMstrObMgReDocInfoRecdLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#ASSIGN_ALT_DATE_OBJ_MGMT_REC_DIR_AC
 * ASSIGN_ALT_DATE_OBJ_MGMT_REC_DIR_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#UNASSIGN_ALT_DATE_OBJ_MGMT_REC_DIR_AC
 * UNASSIGN_ALT_DATE_OBJ_MGMT_REC_DIR_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#DOCUMENT_TYPE
 * DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#DOCUMENT_INFO_RECORD
 * DOCUMENT_INFO_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#DOCUMENT_PART
 * DOCUMENT_PART}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#DOCUMENT_VERSION
 * DOCUMENT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#CHG_NMBR_ALTERNATIVE_DATE_ID
 * CHG_NMBR_ALTERNATIVE_DATE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#SAP_OBJECT_TECHNICAL_ID
 * SAP_OBJECT_TECHNICAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#OBJ_MGMT_RECD_DESCRIPTION
 * OBJ_MGMT_RECD_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#OBJ_MGMT_RECD_ITEM_UUID
 * OBJ_MGMT_RECD_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#OBJ_MGMT_RECD_LAST_CHANGED_AT
 * OBJ_MGMT_RECD_LAST_CHANGED_AT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#OBJ_MGMT_RECD_LAST_CHANGED_BY
 * OBJ_MGMT_RECD_LAST_CHANGED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#OBJ_MGMT_RECD_CREATION_DATE
 * OBJ_MGMT_RECD_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#OBJ_MGMT_RECD_CREATED_BY
 * OBJ_MGMT_RECD_CREATED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#OBJ_MGMT_RECD_OBJ_LAST_CHANGED_AT
 * OBJ_MGMT_RECD_OBJ_LAST_CHANGED_AT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#OBJ_MGMT_RECD_OBJ_LAST_CHANGED_BY
 * OBJ_MGMT_RECD_OBJ_LAST_CHANGED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#OBJ_MGMT_RECD_OBJ_IS_LOCKED_FOR_CHG
 * OBJ_MGMT_RECD_OBJ_IS_LOCKED_FOR_CHG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#OBJ_MGMT_RECD_OBJ_IS_PLANNED
 * OBJ_MGMT_RECD_OBJ_IS_PLANNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#OBJ_MGMT_RECD_OBJ_REVISION_LEVEL
 * OBJ_MGMT_RECD_OBJ_REVISION_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd#CHANGE_NUMBER_LAST_CHGD_DATE_TIME
 * CHANGE_NUMBER_LAST_CHGD_DATE_TIME}</li>
 * </ul>
 *
 */
public interface ChangeMstrObMgReDocInfoRecdSelectable extends EntitySelectable<ChangeMstrObMgReDocInfoRecd>
{

}
