/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
 * ChangeMstrObMgReMaterial}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.field.ChangeMstrObMgReMaterialField
 * ChangeMstrObMgReMaterialField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.link.ChangeMstrObMgReMaterialLink
 * ChangeMstrObMgReMaterialLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#ASSIGN_ALT_DATE_OBJ_MGMT_REC_MAT_AC
 * ASSIGN_ALT_DATE_OBJ_MGMT_REC_MAT_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#UNASSIGN_ALT_DATE_OBJ_MGMT_REC_MAT_AC
 * UNASSIGN_ALT_DATE_OBJ_MGMT_REC_MAT_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#CHG_NMBR_ALTERNATIVE_DATE_ID
 * CHG_NMBR_ALTERNATIVE_DATE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#SAP_OBJECT_TECHNICAL_ID
 * SAP_OBJECT_TECHNICAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#OBJ_MGMT_RECD_DESCRIPTION
 * OBJ_MGMT_RECD_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#OBJ_MGMT_RECD_ITEM_UUID
 * OBJ_MGMT_RECD_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#OBJ_MGMT_RECD_LAST_CHANGED_AT
 * OBJ_MGMT_RECD_LAST_CHANGED_AT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#OBJ_MGMT_RECD_LAST_CHANGED_BY
 * OBJ_MGMT_RECD_LAST_CHANGED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#OBJ_MGMT_RECD_CREATION_DATE
 * OBJ_MGMT_RECD_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#OBJ_MGMT_RECD_CREATED_BY
 * OBJ_MGMT_RECD_CREATED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#OBJ_MGMT_RECD_OBJ_LAST_CHANGED_AT
 * OBJ_MGMT_RECD_OBJ_LAST_CHANGED_AT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#OBJ_MGMT_RECD_OBJ_LAST_CHANGED_BY
 * OBJ_MGMT_RECD_OBJ_LAST_CHANGED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#OBJ_MGMT_RECD_OBJ_IS_LOCKED_FOR_CHG
 * OBJ_MGMT_RECD_OBJ_IS_LOCKED_FOR_CHG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#OBJ_MGMT_RECD_OBJ_IS_PLANNED
 * OBJ_MGMT_RECD_OBJ_IS_PLANNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#OBJ_MGMT_RECD_OBJ_REVISION_LEVEL
 * OBJ_MGMT_RECD_OBJ_REVISION_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial#CHANGE_NUMBER_LAST_CHGD_DATE_TIME
 * CHANGE_NUMBER_LAST_CHGD_DATE_TIME}</li>
 * </ul>
 *
 */
public interface ChangeMstrObMgReMaterialSelectable extends EntitySelectable<ChangeMstrObMgReMaterial>
{

}
