/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
 * ChangeMstrObjectMgmtRecord}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.field.ChangeMstrObjectMgmtRecordField
 * ChangeMstrObjectMgmtRecordField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.link.ChangeMstrObjectMgmtRecordLink
 * ChangeMstrObjectMgmtRecordLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#ASSIGN_ALT_DATE_OBJ_MGMT_RECORD_AC
 * ASSIGN_ALT_DATE_OBJ_MGMT_RECORD_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#UNASSIGN_ALT_DATE_OBJ_MGMT_RECORD_AC
 * UNASSIGN_ALT_DATE_OBJ_MGMT_RECORD_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#SAP_OBJECT_TYPE
 * SAP_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#SAP_OBJECT_TECHNICAL_ID
 * SAP_OBJECT_TECHNICAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#SAP_OBJECT_READABLE_ID
 * SAP_OBJECT_READABLE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#CHG_NMBR_ALTERNATIVE_DATE_ID
 * CHG_NMBR_ALTERNATIVE_DATE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#OBJ_MGMT_RECD_DESCRIPTION
 * OBJ_MGMT_RECD_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#OBJ_MGMT_RECD_ITEM_UUID
 * OBJ_MGMT_RECD_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#OBJ_MGMT_RECD_LAST_CHANGED_AT
 * OBJ_MGMT_RECD_LAST_CHANGED_AT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#OBJ_MGMT_RECD_LAST_CHANGED_BY
 * OBJ_MGMT_RECD_LAST_CHANGED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#OBJ_MGMT_RECD_CREATION_DATE
 * OBJ_MGMT_RECD_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#OBJ_MGMT_RECD_CREATED_BY
 * OBJ_MGMT_RECD_CREATED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#OBJ_MGMT_RECD_OBJ_LAST_CHANGED_AT
 * OBJ_MGMT_RECD_OBJ_LAST_CHANGED_AT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#OBJ_MGMT_RECD_OBJ_LAST_CHANGED_BY
 * OBJ_MGMT_RECD_OBJ_LAST_CHANGED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#OBJ_MGMT_RECD_OBJ_IS_LOCKED_FOR_CHG
 * OBJ_MGMT_RECD_OBJ_IS_LOCKED_FOR_CHG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#OBJ_MGMT_RECD_OBJ_IS_BASELINED
 * OBJ_MGMT_RECD_OBJ_IS_BASELINED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#OBJ_MGMT_RECD_OBJ_IS_PLANNED
 * OBJ_MGMT_RECD_OBJ_IS_PLANNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#OBJ_MGMT_RECD_OBJ_REVISION_LEVEL
 * OBJ_MGMT_RECD_OBJ_REVISION_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord#CHANGE_NUMBER_LAST_CHGD_DATE_TIME
 * CHANGE_NUMBER_LAST_CHGD_DATE_TIME}</li>
 * </ul>
 *
 */
public interface ChangeMstrObjectMgmtRecordSelectable extends EntitySelectable<ChangeMstrObjectMgmtRecord>
{

}
