/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.field.ChangeRecordField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.link.ChangeRecordLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.selectable.ChangeRecordSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Change Record Header Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ChangeRecordType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChangeRecord extends VdmEntity<ChangeRecord>
{

    /**
     * Selector for all available fields of ChangeRecord.
     *
     */
    public final static ChangeRecordSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> UPDATE_MC = new ChangeRecordField<Boolean>("Update_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordFuncLocTskList_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeRecordFuncLocTskList_oc" )
    @JsonProperty( "to_ChangeRecordFuncLocTskList_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeRecordFuncLocTskList_oc" )
    private Boolean changeRecordFuncLocTskList_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordFuncLocTskList_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHANGE_RECORD_FUNC_LOC_TSK_LIST_OC =
        new ChangeRecordField<Boolean>("to_ChangeRecordFuncLocTskList_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRateRtgTskList_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeRecordRateRtgTskList_oc" )
    @JsonProperty( "to_ChangeRecordRateRtgTskList_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeRecordRateRtgTskList_oc" )
    private Boolean changeRecordRateRtgTskList_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRateRtgTskList_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHANGE_RECORD_RATE_RTG_TSK_LIST_OC =
        new ChangeRecordField<Boolean>("to_ChangeRecordRateRtgTskList_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefCharc_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeRecordRefCharc_oc" )
    @JsonProperty( "to_ChangeRecordRefCharc_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeRecordRefCharc_oc" )
    private Boolean changeRecordRefCharc_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefCharc_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHANGE_RECORD_REF_CHARC_OC =
        new ChangeRecordField<Boolean>("to_ChangeRecordRefCharc_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefClass_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeRecordRefClass_oc" )
    @JsonProperty( "to_ChangeRecordRefClass_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeRecordRefClass_oc" )
    private Boolean changeRecordRefClass_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefClass_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHANGE_RECORD_REF_CLASS_OC =
        new ChangeRecordField<Boolean>("to_ChangeRecordRefClass_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefEquipTskList_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeRecordRefEquipTskList_oc" )
    @JsonProperty( "to_ChangeRecordRefEquipTskList_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeRecordRefEquipTskList_oc" )
    private Boolean changeRecordRefEquipTskList_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefEquipTskList_oc</b> field to query
     * operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHANGE_RECORD_REF_EQUIP_TSK_LIST_OC =
        new ChangeRecordField<Boolean>("to_ChangeRecordRefEquipTskList_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefInspPlan_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeRecordRefInspPlan_oc" )
    @JsonProperty( "to_ChangeRecordRefInspPlan_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeRecordRefInspPlan_oc" )
    private Boolean changeRecordRefInspPlan_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefInspPlan_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHANGE_RECORD_REF_INSP_PLAN_OC =
        new ChangeRecordField<Boolean>("to_ChangeRecordRefInspPlan_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefLabelSet_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeRecordRefLabelSet_oc" )
    @JsonProperty( "to_ChangeRecordRefLabelSet_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeRecordRefLabelSet_oc" )
    private Boolean changeRecordRefLabelSet_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefLabelSet_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHANGE_RECORD_REF_LABEL_SET_OC =
        new ChangeRecordField<Boolean>("to_ChangeRecordRefLabelSet_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefMasterRecipe_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeRecordRefMasterRecipe_oc" )
    @JsonProperty( "to_ChangeRecordRefMasterRecipe_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeRecordRefMasterRecipe_oc" )
    private Boolean changeRecordRefMasterRecipe_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefMasterRecipe_oc</b> field to query
     * operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHANGE_RECORD_REF_MASTER_RECIPE_OC =
        new ChangeRecordField<Boolean>("to_ChangeRecordRefMasterRecipe_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefOpSetTskList_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeRecordRefOpSetTskList_oc" )
    @JsonProperty( "to_ChangeRecordRefOpSetTskList_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeRecordRefOpSetTskList_oc" )
    private Boolean changeRecordRefOpSetTskList_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefOpSetTskList_oc</b> field to query
     * operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHANGE_RECORD_REF_OP_SET_TSK_LIST_OC =
        new ChangeRecordField<Boolean>("to_ChangeRecordRefOpSetTskList_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefProdnRouting_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeRecordRefProdnRouting_oc" )
    @JsonProperty( "to_ChangeRecordRefProdnRouting_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeRecordRefProdnRouting_oc" )
    private Boolean changeRecordRefProdnRouting_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefProdnRouting_oc</b> field to query
     * operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHANGE_RECORD_REF_PRODN_ROUTING_OC =
        new ChangeRecordField<Boolean>("to_ChangeRecordRefProdnRouting_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefRecipe_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeRecordRefRecipe_oc" )
    @JsonProperty( "to_ChangeRecordRefRecipe_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeRecordRefRecipe_oc" )
    private Boolean changeRecordRefRecipe_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefRecipe_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHANGE_RECORD_REF_RECIPE_OC =
        new ChangeRecordField<Boolean>("to_ChangeRecordRefRecipe_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefSpecification_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeRecordRefSpecification_oc" )
    @JsonProperty( "to_ChangeRecordRefSpecification_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeRecordRefSpecification_oc" )
    private Boolean changeRecordRefSpecification_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefSpecification_oc</b> field to query
     * operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHANGE_RECORD_REF_SPECIFICATION_OC =
        new ChangeRecordField<Boolean>("to_ChangeRecordRefSpecification_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefStdBOM_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeRecordRefStdBOM_oc" )
    @JsonProperty( "to_ChangeRecordRefStdBOM_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeRecordRefStdBOM_oc" )
    private Boolean changeRecordRefStdBOM_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefStdBOM_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHANGE_RECORD_REF_STD_BOM_OC =
        new ChangeRecordField<Boolean>("to_ChangeRecordRefStdBOM_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefTmplRouting_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeRecordRefTmplRouting_oc" )
    @JsonProperty( "to_ChangeRecordRefTmplRouting_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeRecordRefTmplRouting_oc" )
    private Boolean changeRecordRefTmplRouting_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefTmplRouting_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHANGE_RECORD_REF_TMPL_ROUTING_OC =
        new ChangeRecordField<Boolean>("to_ChangeRecordRefTmplRouting_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefVarBOM_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChangeRecordRefVarBOM_oc" )
    @JsonProperty( "to_ChangeRecordRefVarBOM_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChangeRecordRefVarBOM_oc" )
    private Boolean changeRecordRefVarBOM_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefVarBOM_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHANGE_RECORD_REF_VAR_BOM_OC =
        new ChangeRecordField<Boolean>("to_ChangeRecordRefVarBOM_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdCollaboration_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChgRecdCollaboration_oc" )
    @JsonProperty( "to_ChgRecdCollaboration_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChgRecdCollaboration_oc" )
    private Boolean chgRecdCollaboration_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdCollaboration_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHG_RECD_COLLABORATION_OC =
        new ChangeRecordField<Boolean>("to_ChgRecdCollaboration_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdEquipBOM_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChgRecdEquipBOM_oc" )
    @JsonProperty( "to_ChgRecdEquipBOM_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChgRecdEquipBOM_oc" )
    private Boolean chgRecdEquipBOM_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdEquipBOM_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHG_RECD_EQUIP_BOM_OC =
        new ChangeRecordField<Boolean>("to_ChgRecdEquipBOM_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdFuncLocBOM_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChgRecdFuncLocBOM_oc" )
    @JsonProperty( "to_ChgRecdFuncLocBOM_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChgRecdFuncLocBOM_oc" )
    private Boolean chgRecdFuncLocBOM_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdFuncLocBOM_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHG_RECD_FUNC_LOC_BOM_OC =
        new ChangeRecordField<Boolean>("to_ChgRecdFuncLocBOM_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdRefCutPlngPrflTskList_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChgRecdRefCutPlngPrflTskList_oc" )
    @JsonProperty( "to_ChgRecdRefCutPlngPrflTskList_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChgRecdRefCutPlngPrflTskList_oc" )
    private Boolean chgRecdRefCutPlngPrflTskList_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdRefCutPlngPrflTskList_oc</b> field to query
     * operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHG_RECD_REF_CUT_PLNG_PRFL_TSK_LIST_OC =
        new ChangeRecordField<Boolean>("to_ChgRecdRefCutPlngPrflTskList_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdRefEngBOM_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChgRecdRefEngBOM_oc" )
    @JsonProperty( "to_ChgRecdRefEngBOM_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChgRecdRefEngBOM_oc" )
    private Boolean chgRecdRefEngBOM_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdRefEngBOM_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHG_RECD_REF_ENG_BOM_OC =
        new ChangeRecordField<Boolean>("to_ChgRecdRefEngBOM_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdRefMaintTskList_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChgRecdRefMaintTskList_oc" )
    @JsonProperty( "to_ChgRecdRefMaintTskList_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChgRecdRefMaintTskList_oc" )
    private Boolean chgRecdRefMaintTskList_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdRefMaintTskList_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHG_RECD_REF_MAINT_TSK_LIST_OC =
        new ChangeRecordField<Boolean>("to_ChgRecdRefMaintTskList_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdRefMfgBOM_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChgRecdRefMfgBOM_oc" )
    @JsonProperty( "to_ChgRecdRefMfgBOM_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChgRecdRefMfgBOM_oc" )
    private Boolean chgRecdRefMfgBOM_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdRefMfgBOM_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHG_RECD_REF_MFG_BOM_OC =
        new ChangeRecordField<Boolean>("to_ChgRecdRefMfgBOM_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdRefPlngScp_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChgRecdRefPlngScp_oc" )
    @JsonProperty( "to_ChgRecdRefPlngScp_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChgRecdRefPlngScp_oc" )
    private Boolean chgRecdRefPlngScp_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdRefPlngScp_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHG_RECD_REF_PLNG_SCP_OC =
        new ChangeRecordField<Boolean>("to_ChgRecdRefPlngScp_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdRefRateRtgTskList_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChgRecdRefRateRtgTskList_oc" )
    @JsonProperty( "to_ChgRecdRefRateRtgTskList_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChgRecdRefRateRtgTskList_oc" )
    private Boolean chgRecdRefRateRtgTskList_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdRefRateRtgTskList_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHG_RECD_REF_RATE_RTG_TSK_LIST_OC =
        new ChangeRecordField<Boolean>("to_ChgRecdRefRateRtgTskList_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdWBSElmntBOM_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ChgRecdWBSElmntBOM_oc" )
    @JsonProperty( "to_ChgRecdWBSElmntBOM_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ChgRecdWBSElmntBOM_oc" )
    private Boolean chgRecdWBSElmntBOM_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdWBSElmntBOM_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> CHG_RECD_WBS_ELMNT_BOM_OC =
        new ChangeRecordField<Boolean>("to_ChgRecdWBSElmntBOM_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_RefBit_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_RefBit_oc" )
    @JsonProperty( "to_RefBit_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_RefBit_oc" )
    private Boolean refBit_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_RefBit_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> REF_BIT_OC = new ChangeRecordField<Boolean>("to_RefBit_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_RefBOM_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_RefBOM_oc" )
    @JsonProperty( "to_RefBOM_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_RefBOM_oc" )
    private Boolean refBOM_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_RefBOM_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> REF_BOM_OC = new ChangeRecordField<Boolean>("to_RefBOM_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_RefDoc_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_RefDoc_oc" )
    @JsonProperty( "to_RefDoc_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_RefDoc_oc" )
    private Boolean refDoc_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_RefDoc_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> REF_DOC_OC = new ChangeRecordField<Boolean>("to_RefDoc_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_RefMat_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_RefMat_oc" )
    @JsonProperty( "to_RefMat_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_RefMat_oc" )
    private Boolean refMat_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_RefMat_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> REF_MAT_OC = new ChangeRecordField<Boolean>("to_RefMat_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_RefPSV_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_RefPSV_oc" )
    @JsonProperty( "to_RefPSV_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_RefPSV_oc" )
    private Boolean refPSV_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_RefPSV_oc</b> field to query operations.
     *
     */
    public final static ChangeRecordField<Boolean> REF_PSV_OC = new ChangeRecordField<Boolean>("to_RefPSV_oc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @Key
    @SerializedName( "ChangeRecordUUID" )
    @JsonProperty( "ChangeRecordUUID" )
    @Nullable
    @ODataField( odataName = "ChangeRecordUUID" )
    private UUID changeRecordUUID;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordUUID</b> field to query operations.
     *
     */
    public final static ChangeRecordField<UUID> CHANGE_RECORD_UUID = new ChangeRecordField<UUID>("ChangeRecordUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecord</b>
     * </p>
     *
     * @return Change Record ID
     */
    @SerializedName( "ChangeRecord" )
    @JsonProperty( "ChangeRecord" )
    @Nullable
    @ODataField( odataName = "ChangeRecord" )
    private String changeRecord;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecord</b> field to query operations.
     *
     */
    public final static ChangeRecordField<String> CHANGE_RECORD = new ChangeRecordField<String>("ChangeRecord");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordType</b>
     * </p>
     *
     * @return Change Record Type
     */
    @SerializedName( "ChangeRecordType" )
    @JsonProperty( "ChangeRecordType" )
    @Nullable
    @ODataField( odataName = "ChangeRecordType" )
    private String changeRecordType;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordType</b> field to query operations.
     *
     */
    public final static ChangeRecordField<String> CHANGE_RECORD_TYPE =
        new ChangeRecordField<String>("ChangeRecordType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordStatus</b>
     * </p>
     *
     * @return Change Record Header Status
     */
    @SerializedName( "ChangeRecordStatus" )
    @JsonProperty( "ChangeRecordStatus" )
    @Nullable
    @ODataField( odataName = "ChangeRecordStatus" )
    private String changeRecordStatus;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordStatus</b> field to query operations.
     *
     */
    public final static ChangeRecordField<String> CHANGE_RECORD_STATUS =
        new ChangeRecordField<String>("ChangeRecordStatus");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ChangeRecordField<String> CHANGE_NUMBER = new ChangeRecordField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ChangeRecordField<String> CREATED_BY_USER = new ChangeRecordField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ChangeRecordField<ZonedDateTime> CREATION_DATE_TIME =
        new ChangeRecordField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Changed By
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ChangeRecordField<String> LAST_CHANGED_BY_USER =
        new ChangeRecordField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 22, Scale: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return The lastChangeDateTime contained in this entity.
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @ODataField( odataName = "LastChangeDateTime" )
    private BigDecimal lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ChangeRecordField<BigDecimal> LAST_CHANGE_DATE_TIME =
        new ChangeRecordField<BigDecimal>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordLifecycleStatus</b>
     * </p>
     *
     * @return Issue Lifecycle Status Code
     */
    @SerializedName( "ChangeRecordLifecycleStatus" )
    @JsonProperty( "ChangeRecordLifecycleStatus" )
    @Nullable
    @ODataField( odataName = "ChangeRecordLifecycleStatus" )
    private String changeRecordLifecycleStatus;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordLifecycleStatus</b> field to query operations.
     *
     */
    public final static ChangeRecordField<String> CHANGE_RECORD_LIFECYCLE_STATUS =
        new ChangeRecordField<String>("ChangeRecordLifecycleStatus");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Partner</b>
     * </p>
     *
     * @return Change Record Change Responsible (Person)
     */
    @SerializedName( "Partner" )
    @JsonProperty( "Partner" )
    @Nullable
    @ODataField( odataName = "Partner" )
    private String partner;
    /**
     * Use with available fluent helpers to apply the <b>Partner</b> field to query operations.
     *
     */
    public final static ChangeRecordField<String> PARTNER = new ChangeRecordField<String>("Partner");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ChgRecordDescriptionText</b>
     * </p>
     *
     * @return Issue Text
     */
    @SerializedName( "ChgRecordDescriptionText" )
    @JsonProperty( "ChgRecordDescriptionText" )
    @Nullable
    @ODataField( odataName = "ChgRecordDescriptionText" )
    private String chgRecordDescriptionText;
    /**
     * Use with available fluent helpers to apply the <b>ChgRecordDescriptionText</b> field to query operations.
     *
     */
    public final static ChangeRecordField<String> CHG_RECORD_DESCRIPTION_TEXT =
        new ChangeRecordField<String>("ChgRecordDescriptionText");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordDetailDescription</b>
     * </p>
     *
     * @return Change Record General Info
     */
    @SerializedName( "ChangeRecordDetailDescription" )
    @JsonProperty( "ChangeRecordDetailDescription" )
    @Nullable
    @ODataField( odataName = "ChangeRecordDetailDescription" )
    private String changeRecordDetailDescription;
    /**
     * Use with available fluent helpers to apply the <b>ChangeRecordDetailDescription</b> field to query operations.
     *
     */
    public final static ChangeRecordField<String> CHANGE_RECORD_DETAIL_DESCRIPTION =
        new ChangeRecordField<String>("ChangeRecordDetailDescription");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChgRecdExpectedCompletionDate</b>
     * </p>
     *
     * @return Expected Completion Date
     */
    @SerializedName( "ChgRecdExpectedCompletionDate" )
    @JsonProperty( "ChgRecdExpectedCompletionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ChgRecdExpectedCompletionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime chgRecdExpectedCompletionDate;
    /**
     * Use with available fluent helpers to apply the <b>ChgRecdExpectedCompletionDate</b> field to query operations.
     *
     */
    public final static ChangeRecordField<LocalDateTime> CHG_RECD_EXPECTED_COMPLETION_DATE =
        new ChangeRecordField<LocalDateTime>("ChgRecdExpectedCompletionDate");
    /**
     * Navigation property <b>to_ChangeRecordFuncLocTskList</b> for <b>ChangeRecord</b> to multiple
     * <b>ChgRecdFuncLocTskList</b>.
     *
     */
    @SerializedName( "to_ChangeRecordFuncLocTskList" )
    @JsonProperty( "to_ChangeRecordFuncLocTskList" )
    @ODataField( odataName = "to_ChangeRecordFuncLocTskList" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChgRecdFuncLocTskList> toChangeRecordFuncLocTskList;
    /**
     * Navigation property <b>to_ChangeRecordRefCharc</b> for <b>ChangeRecord</b> to multiple
     * <b>ChangeRecordRefCharc</b>.
     *
     */
    @SerializedName( "to_ChangeRecordRefCharc" )
    @JsonProperty( "to_ChangeRecordRefCharc" )
    @ODataField( odataName = "to_ChangeRecordRefCharc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeRecordRefCharc> toChangeRecordRefCharc;
    /**
     * Navigation property <b>to_ChangeRecordRefClass</b> for <b>ChangeRecord</b> to multiple
     * <b>ChangeRecordRefClass</b>.
     *
     */
    @SerializedName( "to_ChangeRecordRefClass" )
    @JsonProperty( "to_ChangeRecordRefClass" )
    @ODataField( odataName = "to_ChangeRecordRefClass" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeRecordRefClass> toChangeRecordRefClass;
    /**
     * Navigation property <b>to_ChangeRecordRefEquipTskList</b> for <b>ChangeRecord</b> to multiple
     * <b>ChgRecdRefEquipTskList</b>.
     *
     */
    @SerializedName( "to_ChangeRecordRefEquipTskList" )
    @JsonProperty( "to_ChangeRecordRefEquipTskList" )
    @ODataField( odataName = "to_ChangeRecordRefEquipTskList" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChgRecdRefEquipTskList> toChangeRecordRefEquipTskList;
    /**
     * Navigation property <b>to_ChangeRecordRefMasterRecipe</b> for <b>ChangeRecord</b> to multiple
     * <b>ChangeRecordRefMasterRecipe</b>.
     *
     */
    @SerializedName( "to_ChangeRecordRefMasterRecipe" )
    @JsonProperty( "to_ChangeRecordRefMasterRecipe" )
    @ODataField( odataName = "to_ChangeRecordRefMasterRecipe" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeRecordRefMasterRecipe> toChangeRecordRefMasterRecipe;
    /**
     * Navigation property <b>to_ChangeRecordRefProdnRouting</b> for <b>ChangeRecord</b> to multiple
     * <b>ChangeRecordRefProdnRouting</b>.
     *
     */
    @SerializedName( "to_ChangeRecordRefProdnRouting" )
    @JsonProperty( "to_ChangeRecordRefProdnRouting" )
    @ODataField( odataName = "to_ChangeRecordRefProdnRouting" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeRecordRefProdnRouting> toChangeRecordRefProdnRouting;
    /**
     * Navigation property <b>to_ChangeRecordRefStdBOM</b> for <b>ChangeRecord</b> to multiple <b>ChgRecdRefStdBOM</b>.
     *
     */
    @SerializedName( "to_ChangeRecordRefStdBOM" )
    @JsonProperty( "to_ChangeRecordRefStdBOM" )
    @ODataField( odataName = "to_ChangeRecordRefStdBOM" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChgRecdRefStdBOM> toChangeRecordRefStdBOM;
    /**
     * Navigation property <b>to_ChangeRecordRefVarBOM</b> for <b>ChangeRecord</b> to multiple <b>ChgRecdRefVarBOM</b>.
     *
     */
    @SerializedName( "to_ChangeRecordRefVarBOM" )
    @JsonProperty( "to_ChangeRecordRefVarBOM" )
    @ODataField( odataName = "to_ChangeRecordRefVarBOM" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChgRecdRefVarBOM> toChangeRecordRefVarBOM;
    /**
     * Navigation property <b>to_ChgRecdCollaboration</b> for <b>ChangeRecord</b> to multiple
     * <b>ChgRecdPLMEPDCollabn</b>.
     *
     */
    @SerializedName( "to_ChgRecdCollaboration" )
    @JsonProperty( "to_ChgRecdCollaboration" )
    @ODataField( odataName = "to_ChgRecdCollaboration" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChgRecdPLMEPDCollabn> toChgRecdCollaboration;
    /**
     * Navigation property <b>to_ChgRecdEquipBOM</b> for <b>ChangeRecord</b> to multiple <b>ChgRecdEquipBOM</b>.
     *
     */
    @SerializedName( "to_ChgRecdEquipBOM" )
    @JsonProperty( "to_ChgRecdEquipBOM" )
    @ODataField( odataName = "to_ChgRecdEquipBOM" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChgRecdEquipBOM> toChgRecdEquipBOM;
    /**
     * Navigation property <b>to_ChgRecdFuncLocBOM</b> for <b>ChangeRecord</b> to multiple <b>ChgRecdFuncLocBOM</b>.
     *
     */
    @SerializedName( "to_ChgRecdFuncLocBOM" )
    @JsonProperty( "to_ChgRecdFuncLocBOM" )
    @ODataField( odataName = "to_ChgRecdFuncLocBOM" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChgRecdFuncLocBOM> toChgRecdFuncLocBOM;
    /**
     * Navigation property <b>to_ChgRecdRefEngBOM</b> for <b>ChangeRecord</b> to multiple <b>ChgRecdRefEngBOM</b>.
     *
     */
    @SerializedName( "to_ChgRecdRefEngBOM" )
    @JsonProperty( "to_ChgRecdRefEngBOM" )
    @ODataField( odataName = "to_ChgRecdRefEngBOM" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChgRecdRefEngBOM> toChgRecdRefEngBOM;
    /**
     * Navigation property <b>to_ChgRecdRefMaintTskList</b> for <b>ChangeRecord</b> to multiple
     * <b>ChgRecdObjPgMaintTskList</b>.
     *
     */
    @SerializedName( "to_ChgRecdRefMaintTskList" )
    @JsonProperty( "to_ChgRecdRefMaintTskList" )
    @ODataField( odataName = "to_ChgRecdRefMaintTskList" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChgRecdObjPgMaintTskList> toChgRecdRefMaintTskList;
    /**
     * Navigation property <b>to_ChgRecdRefMfgBOM</b> for <b>ChangeRecord</b> to multiple <b>ChgRecdRefMfgBOM</b>.
     *
     */
    @SerializedName( "to_ChgRecdRefMfgBOM" )
    @JsonProperty( "to_ChgRecdRefMfgBOM" )
    @ODataField( odataName = "to_ChgRecdRefMfgBOM" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChgRecdRefMfgBOM> toChgRecdRefMfgBOM;
    /**
     * Navigation property <b>to_RefBit</b> for <b>ChangeRecord</b> to multiple <b>ChangeRecordReferenceBit</b>.
     *
     */
    @SerializedName( "to_RefBit" )
    @JsonProperty( "to_RefBit" )
    @ODataField( odataName = "to_RefBit" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeRecordReferenceBit> toRefBit;
    /**
     * Navigation property <b>to_RefBOM</b> for <b>ChangeRecord</b> to multiple <b>ChangeRecordReferenceBOM</b>.
     *
     */
    @SerializedName( "to_RefBOM" )
    @JsonProperty( "to_RefBOM" )
    @ODataField( odataName = "to_RefBOM" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeRecordReferenceBOM> toRefBOM;
    /**
     * Navigation property <b>to_RefDoc</b> for <b>ChangeRecord</b> to multiple <b>ChangeRecordReferenceDoc</b>.
     *
     */
    @SerializedName( "to_RefDoc" )
    @JsonProperty( "to_RefDoc" )
    @ODataField( odataName = "to_RefDoc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeRecordReferenceDoc> toRefDoc;
    /**
     * Navigation property <b>to_RefMat</b> for <b>ChangeRecord</b> to multiple <b>ChangeRecordReferenceMat</b>.
     *
     */
    @SerializedName( "to_RefMat" )
    @JsonProperty( "to_RefMat" )
    @ODataField( odataName = "to_RefMat" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeRecordReferenceMat> toRefMat;
    /**
     * Navigation property <b>to_RefPSV</b> for <b>ChangeRecord</b> to multiple <b>ChangeRecordReferencePSV</b>.
     *
     */
    @SerializedName( "to_RefPSV" )
    @JsonProperty( "to_RefPSV" )
    @ODataField( odataName = "to_RefPSV" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ChangeRecordReferencePSV> toRefPSV;
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordFuncLocTskList</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeRecordLink<ChgRecdFuncLocTskList> TO_CHANGE_RECORD_FUNC_LOC_TSK_LIST =
        new ChangeRecordLink<ChgRecdFuncLocTskList>("to_ChangeRecordFuncLocTskList");
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefCharc</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeRecordLink<ChangeRecordRefCharc> TO_CHANGE_RECORD_REF_CHARC =
        new ChangeRecordLink<ChangeRecordRefCharc>("to_ChangeRecordRefCharc");
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefClass</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeRecordLink<ChangeRecordRefClass> TO_CHANGE_RECORD_REF_CLASS =
        new ChangeRecordLink<ChangeRecordRefClass>("to_ChangeRecordRefClass");
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefEquipTskList</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeRecordLink<ChgRecdRefEquipTskList> TO_CHANGE_RECORD_REF_EQUIP_TSK_LIST =
        new ChangeRecordLink<ChgRecdRefEquipTskList>("to_ChangeRecordRefEquipTskList");
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefMasterRecipe</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeRecordLink<ChangeRecordRefMasterRecipe> TO_CHANGE_RECORD_REF_MASTER_RECIPE =
        new ChangeRecordLink<ChangeRecordRefMasterRecipe>("to_ChangeRecordRefMasterRecipe");
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefProdnRouting</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeRecordLink<ChangeRecordRefProdnRouting> TO_CHANGE_RECORD_REF_PRODN_ROUTING =
        new ChangeRecordLink<ChangeRecordRefProdnRouting>("to_ChangeRecordRefProdnRouting");
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefStdBOM</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeRecordLink<ChgRecdRefStdBOM> TO_CHANGE_RECORD_REF_STD_BOM =
        new ChangeRecordLink<ChgRecdRefStdBOM>("to_ChangeRecordRefStdBOM");
    /**
     * Use with available fluent helpers to apply the <b>to_ChangeRecordRefVarBOM</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeRecordLink<ChgRecdRefVarBOM> TO_CHANGE_RECORD_REF_VAR_BOM =
        new ChangeRecordLink<ChgRecdRefVarBOM>("to_ChangeRecordRefVarBOM");
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdCollaboration</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeRecordLink<ChgRecdPLMEPDCollabn> TO_CHG_RECD_COLLABORATION =
        new ChangeRecordLink<ChgRecdPLMEPDCollabn>("to_ChgRecdCollaboration");
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdEquipBOM</b> navigation property to query operations.
     *
     */
    public final static ChangeRecordLink<ChgRecdEquipBOM> TO_CHG_RECD_EQUIP_BOM =
        new ChangeRecordLink<ChgRecdEquipBOM>("to_ChgRecdEquipBOM");
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdFuncLocBOM</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeRecordLink<ChgRecdFuncLocBOM> TO_CHG_RECD_FUNC_LOC_BOM =
        new ChangeRecordLink<ChgRecdFuncLocBOM>("to_ChgRecdFuncLocBOM");
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdRefEngBOM</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeRecordLink<ChgRecdRefEngBOM> TO_CHG_RECD_REF_ENG_BOM =
        new ChangeRecordLink<ChgRecdRefEngBOM>("to_ChgRecdRefEngBOM");
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdRefMaintTskList</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeRecordLink<ChgRecdObjPgMaintTskList> TO_CHG_RECD_REF_MAINT_TSK_LIST =
        new ChangeRecordLink<ChgRecdObjPgMaintTskList>("to_ChgRecdRefMaintTskList");
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdRefMfgBOM</b> navigation property to query
     * operations.
     *
     */
    public final static ChangeRecordLink<ChgRecdRefMfgBOM> TO_CHG_RECD_REF_MFG_BOM =
        new ChangeRecordLink<ChgRecdRefMfgBOM>("to_ChgRecdRefMfgBOM");
    /**
     * Use with available fluent helpers to apply the <b>to_RefBit</b> navigation property to query operations.
     *
     */
    public final static ChangeRecordLink<ChangeRecordReferenceBit> TO_REF_BIT =
        new ChangeRecordLink<ChangeRecordReferenceBit>("to_RefBit");
    /**
     * Use with available fluent helpers to apply the <b>to_RefBOM</b> navigation property to query operations.
     *
     */
    public final static ChangeRecordLink<ChangeRecordReferenceBOM> TO_REF_BOM =
        new ChangeRecordLink<ChangeRecordReferenceBOM>("to_RefBOM");
    /**
     * Use with available fluent helpers to apply the <b>to_RefDoc</b> navigation property to query operations.
     *
     */
    public final static ChangeRecordLink<ChangeRecordReferenceDoc> TO_REF_DOC =
        new ChangeRecordLink<ChangeRecordReferenceDoc>("to_RefDoc");
    /**
     * Use with available fluent helpers to apply the <b>to_RefMat</b> navigation property to query operations.
     *
     */
    public final static ChangeRecordLink<ChangeRecordReferenceMat> TO_REF_MAT =
        new ChangeRecordLink<ChangeRecordReferenceMat>("to_RefMat");
    /**
     * Use with available fluent helpers to apply the <b>to_RefPSV</b> navigation property to query operations.
     *
     */
    public final static ChangeRecordLink<ChangeRecordReferencePSV> TO_REF_PSV =
        new ChangeRecordLink<ChangeRecordReferencePSV>("to_RefPSV");

    @Nonnull
    @Override
    public Class<ChangeRecord> getType()
    {
        return ChangeRecord.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordFuncLocTskList_oc</b>
     * </p>
     *
     * @param changeRecordFuncLocTskList_oc
     *            Dynamic CbA-Control
     */
    public void setChangeRecordFuncLocTskList_oc( @Nullable final Boolean changeRecordFuncLocTskList_oc )
    {
        rememberChangedField("to_ChangeRecordFuncLocTskList_oc", this.changeRecordFuncLocTskList_oc);
        this.changeRecordFuncLocTskList_oc = changeRecordFuncLocTskList_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRateRtgTskList_oc</b>
     * </p>
     *
     * @param changeRecordRateRtgTskList_oc
     *            Dynamic CbA-Control
     */
    public void setChangeRecordRateRtgTskList_oc( @Nullable final Boolean changeRecordRateRtgTskList_oc )
    {
        rememberChangedField("to_ChangeRecordRateRtgTskList_oc", this.changeRecordRateRtgTskList_oc);
        this.changeRecordRateRtgTskList_oc = changeRecordRateRtgTskList_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefCharc_oc</b>
     * </p>
     *
     * @param changeRecordRefCharc_oc
     *            Dynamic CbA-Control
     */
    public void setChangeRecordRefCharc_oc( @Nullable final Boolean changeRecordRefCharc_oc )
    {
        rememberChangedField("to_ChangeRecordRefCharc_oc", this.changeRecordRefCharc_oc);
        this.changeRecordRefCharc_oc = changeRecordRefCharc_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefClass_oc</b>
     * </p>
     *
     * @param changeRecordRefClass_oc
     *            Dynamic CbA-Control
     */
    public void setChangeRecordRefClass_oc( @Nullable final Boolean changeRecordRefClass_oc )
    {
        rememberChangedField("to_ChangeRecordRefClass_oc", this.changeRecordRefClass_oc);
        this.changeRecordRefClass_oc = changeRecordRefClass_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefEquipTskList_oc</b>
     * </p>
     *
     * @param changeRecordRefEquipTskList_oc
     *            Dynamic CbA-Control
     */
    public void setChangeRecordRefEquipTskList_oc( @Nullable final Boolean changeRecordRefEquipTskList_oc )
    {
        rememberChangedField("to_ChangeRecordRefEquipTskList_oc", this.changeRecordRefEquipTskList_oc);
        this.changeRecordRefEquipTskList_oc = changeRecordRefEquipTskList_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefInspPlan_oc</b>
     * </p>
     *
     * @param changeRecordRefInspPlan_oc
     *            Dynamic CbA-Control
     */
    public void setChangeRecordRefInspPlan_oc( @Nullable final Boolean changeRecordRefInspPlan_oc )
    {
        rememberChangedField("to_ChangeRecordRefInspPlan_oc", this.changeRecordRefInspPlan_oc);
        this.changeRecordRefInspPlan_oc = changeRecordRefInspPlan_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefLabelSet_oc</b>
     * </p>
     *
     * @param changeRecordRefLabelSet_oc
     *            Dynamic CbA-Control
     */
    public void setChangeRecordRefLabelSet_oc( @Nullable final Boolean changeRecordRefLabelSet_oc )
    {
        rememberChangedField("to_ChangeRecordRefLabelSet_oc", this.changeRecordRefLabelSet_oc);
        this.changeRecordRefLabelSet_oc = changeRecordRefLabelSet_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefMasterRecipe_oc</b>
     * </p>
     *
     * @param changeRecordRefMasterRecipe_oc
     *            Dynamic CbA-Control
     */
    public void setChangeRecordRefMasterRecipe_oc( @Nullable final Boolean changeRecordRefMasterRecipe_oc )
    {
        rememberChangedField("to_ChangeRecordRefMasterRecipe_oc", this.changeRecordRefMasterRecipe_oc);
        this.changeRecordRefMasterRecipe_oc = changeRecordRefMasterRecipe_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefOpSetTskList_oc</b>
     * </p>
     *
     * @param changeRecordRefOpSetTskList_oc
     *            Dynamic CbA-Control
     */
    public void setChangeRecordRefOpSetTskList_oc( @Nullable final Boolean changeRecordRefOpSetTskList_oc )
    {
        rememberChangedField("to_ChangeRecordRefOpSetTskList_oc", this.changeRecordRefOpSetTskList_oc);
        this.changeRecordRefOpSetTskList_oc = changeRecordRefOpSetTskList_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefProdnRouting_oc</b>
     * </p>
     *
     * @param changeRecordRefProdnRouting_oc
     *            Dynamic CbA-Control
     */
    public void setChangeRecordRefProdnRouting_oc( @Nullable final Boolean changeRecordRefProdnRouting_oc )
    {
        rememberChangedField("to_ChangeRecordRefProdnRouting_oc", this.changeRecordRefProdnRouting_oc);
        this.changeRecordRefProdnRouting_oc = changeRecordRefProdnRouting_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefRecipe_oc</b>
     * </p>
     *
     * @param changeRecordRefRecipe_oc
     *            Dynamic CbA-Control
     */
    public void setChangeRecordRefRecipe_oc( @Nullable final Boolean changeRecordRefRecipe_oc )
    {
        rememberChangedField("to_ChangeRecordRefRecipe_oc", this.changeRecordRefRecipe_oc);
        this.changeRecordRefRecipe_oc = changeRecordRefRecipe_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefSpecification_oc</b>
     * </p>
     *
     * @param changeRecordRefSpecification_oc
     *            Dynamic CbA-Control
     */
    public void setChangeRecordRefSpecification_oc( @Nullable final Boolean changeRecordRefSpecification_oc )
    {
        rememberChangedField("to_ChangeRecordRefSpecification_oc", this.changeRecordRefSpecification_oc);
        this.changeRecordRefSpecification_oc = changeRecordRefSpecification_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefStdBOM_oc</b>
     * </p>
     *
     * @param changeRecordRefStdBOM_oc
     *            Dynamic CbA-Control
     */
    public void setChangeRecordRefStdBOM_oc( @Nullable final Boolean changeRecordRefStdBOM_oc )
    {
        rememberChangedField("to_ChangeRecordRefStdBOM_oc", this.changeRecordRefStdBOM_oc);
        this.changeRecordRefStdBOM_oc = changeRecordRefStdBOM_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefTmplRouting_oc</b>
     * </p>
     *
     * @param changeRecordRefTmplRouting_oc
     *            Dynamic CbA-Control
     */
    public void setChangeRecordRefTmplRouting_oc( @Nullable final Boolean changeRecordRefTmplRouting_oc )
    {
        rememberChangedField("to_ChangeRecordRefTmplRouting_oc", this.changeRecordRefTmplRouting_oc);
        this.changeRecordRefTmplRouting_oc = changeRecordRefTmplRouting_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChangeRecordRefVarBOM_oc</b>
     * </p>
     *
     * @param changeRecordRefVarBOM_oc
     *            Dynamic CbA-Control
     */
    public void setChangeRecordRefVarBOM_oc( @Nullable final Boolean changeRecordRefVarBOM_oc )
    {
        rememberChangedField("to_ChangeRecordRefVarBOM_oc", this.changeRecordRefVarBOM_oc);
        this.changeRecordRefVarBOM_oc = changeRecordRefVarBOM_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdCollaboration_oc</b>
     * </p>
     *
     * @param chgRecdCollaboration_oc
     *            Dynamic CbA-Control
     */
    public void setChgRecdCollaboration_oc( @Nullable final Boolean chgRecdCollaboration_oc )
    {
        rememberChangedField("to_ChgRecdCollaboration_oc", this.chgRecdCollaboration_oc);
        this.chgRecdCollaboration_oc = chgRecdCollaboration_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdEquipBOM_oc</b>
     * </p>
     *
     * @param chgRecdEquipBOM_oc
     *            Dynamic CbA-Control
     */
    public void setChgRecdEquipBOM_oc( @Nullable final Boolean chgRecdEquipBOM_oc )
    {
        rememberChangedField("to_ChgRecdEquipBOM_oc", this.chgRecdEquipBOM_oc);
        this.chgRecdEquipBOM_oc = chgRecdEquipBOM_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdFuncLocBOM_oc</b>
     * </p>
     *
     * @param chgRecdFuncLocBOM_oc
     *            Dynamic CbA-Control
     */
    public void setChgRecdFuncLocBOM_oc( @Nullable final Boolean chgRecdFuncLocBOM_oc )
    {
        rememberChangedField("to_ChgRecdFuncLocBOM_oc", this.chgRecdFuncLocBOM_oc);
        this.chgRecdFuncLocBOM_oc = chgRecdFuncLocBOM_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdRefCutPlngPrflTskList_oc</b>
     * </p>
     *
     * @param chgRecdRefCutPlngPrflTskList_oc
     *            Dynamic CbA-Control
     */
    public void setChgRecdRefCutPlngPrflTskList_oc( @Nullable final Boolean chgRecdRefCutPlngPrflTskList_oc )
    {
        rememberChangedField("to_ChgRecdRefCutPlngPrflTskList_oc", this.chgRecdRefCutPlngPrflTskList_oc);
        this.chgRecdRefCutPlngPrflTskList_oc = chgRecdRefCutPlngPrflTskList_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdRefEngBOM_oc</b>
     * </p>
     *
     * @param chgRecdRefEngBOM_oc
     *            Dynamic CbA-Control
     */
    public void setChgRecdRefEngBOM_oc( @Nullable final Boolean chgRecdRefEngBOM_oc )
    {
        rememberChangedField("to_ChgRecdRefEngBOM_oc", this.chgRecdRefEngBOM_oc);
        this.chgRecdRefEngBOM_oc = chgRecdRefEngBOM_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdRefMaintTskList_oc</b>
     * </p>
     *
     * @param chgRecdRefMaintTskList_oc
     *            Dynamic CbA-Control
     */
    public void setChgRecdRefMaintTskList_oc( @Nullable final Boolean chgRecdRefMaintTskList_oc )
    {
        rememberChangedField("to_ChgRecdRefMaintTskList_oc", this.chgRecdRefMaintTskList_oc);
        this.chgRecdRefMaintTskList_oc = chgRecdRefMaintTskList_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdRefMfgBOM_oc</b>
     * </p>
     *
     * @param chgRecdRefMfgBOM_oc
     *            Dynamic CbA-Control
     */
    public void setChgRecdRefMfgBOM_oc( @Nullable final Boolean chgRecdRefMfgBOM_oc )
    {
        rememberChangedField("to_ChgRecdRefMfgBOM_oc", this.chgRecdRefMfgBOM_oc);
        this.chgRecdRefMfgBOM_oc = chgRecdRefMfgBOM_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdRefPlngScp_oc</b>
     * </p>
     *
     * @param chgRecdRefPlngScp_oc
     *            Dynamic CbA-Control
     */
    public void setChgRecdRefPlngScp_oc( @Nullable final Boolean chgRecdRefPlngScp_oc )
    {
        rememberChangedField("to_ChgRecdRefPlngScp_oc", this.chgRecdRefPlngScp_oc);
        this.chgRecdRefPlngScp_oc = chgRecdRefPlngScp_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdRefRateRtgTskList_oc</b>
     * </p>
     *
     * @param chgRecdRefRateRtgTskList_oc
     *            Dynamic CbA-Control
     */
    public void setChgRecdRefRateRtgTskList_oc( @Nullable final Boolean chgRecdRefRateRtgTskList_oc )
    {
        rememberChangedField("to_ChgRecdRefRateRtgTskList_oc", this.chgRecdRefRateRtgTskList_oc);
        this.chgRecdRefRateRtgTskList_oc = chgRecdRefRateRtgTskList_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ChgRecdWBSElmntBOM_oc</b>
     * </p>
     *
     * @param chgRecdWBSElmntBOM_oc
     *            Dynamic CbA-Control
     */
    public void setChgRecdWBSElmntBOM_oc( @Nullable final Boolean chgRecdWBSElmntBOM_oc )
    {
        rememberChangedField("to_ChgRecdWBSElmntBOM_oc", this.chgRecdWBSElmntBOM_oc);
        this.chgRecdWBSElmntBOM_oc = chgRecdWBSElmntBOM_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_RefBit_oc</b>
     * </p>
     *
     * @param refBit_oc
     *            Dynamic CbA-Control
     */
    public void setRefBit_oc( @Nullable final Boolean refBit_oc )
    {
        rememberChangedField("to_RefBit_oc", this.refBit_oc);
        this.refBit_oc = refBit_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_RefBOM_oc</b>
     * </p>
     *
     * @param refBOM_oc
     *            Dynamic CbA-Control
     */
    public void setRefBOM_oc( @Nullable final Boolean refBOM_oc )
    {
        rememberChangedField("to_RefBOM_oc", this.refBOM_oc);
        this.refBOM_oc = refBOM_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_RefDoc_oc</b>
     * </p>
     *
     * @param refDoc_oc
     *            Dynamic CbA-Control
     */
    public void setRefDoc_oc( @Nullable final Boolean refDoc_oc )
    {
        rememberChangedField("to_RefDoc_oc", this.refDoc_oc);
        this.refDoc_oc = refDoc_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_RefMat_oc</b>
     * </p>
     *
     * @param refMat_oc
     *            Dynamic CbA-Control
     */
    public void setRefMat_oc( @Nullable final Boolean refMat_oc )
    {
        rememberChangedField("to_RefMat_oc", this.refMat_oc);
        this.refMat_oc = refMat_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_RefPSV_oc</b>
     * </p>
     *
     * @param refPSV_oc
     *            Dynamic CbA-Control
     */
    public void setRefPSV_oc( @Nullable final Boolean refPSV_oc )
    {
        rememberChangedField("to_RefPSV_oc", this.refPSV_oc);
        this.refPSV_oc = refPSV_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordUUID</b>
     * </p>
     *
     * @param changeRecordUUID
     *            NodeID
     */
    public void setChangeRecordUUID( @Nullable final UUID changeRecordUUID )
    {
        rememberChangedField("ChangeRecordUUID", this.changeRecordUUID);
        this.changeRecordUUID = changeRecordUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecord</b>
     * </p>
     *
     * @param changeRecord
     *            Change Record ID
     */
    public void setChangeRecord( @Nullable final String changeRecord )
    {
        rememberChangedField("ChangeRecord", this.changeRecord);
        this.changeRecord = changeRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordType</b>
     * </p>
     *
     * @param changeRecordType
     *            Change Record Type
     */
    public void setChangeRecordType( @Nullable final String changeRecordType )
    {
        rememberChangedField("ChangeRecordType", this.changeRecordType);
        this.changeRecordType = changeRecordType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordStatus</b>
     * </p>
     *
     * @param changeRecordStatus
     *            Change Record Header Status
     */
    public void setChangeRecordStatus( @Nullable final String changeRecordStatus )
    {
        rememberChangedField("ChangeRecordStatus", this.changeRecordStatus);
        this.changeRecordStatus = changeRecordStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Changed By
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 22, Scale: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            The lastChangeDateTime to set.
     */
    public void setLastChangeDateTime( @Nullable final BigDecimal lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordLifecycleStatus</b>
     * </p>
     *
     * @param changeRecordLifecycleStatus
     *            Issue Lifecycle Status Code
     */
    public void setChangeRecordLifecycleStatus( @Nullable final String changeRecordLifecycleStatus )
    {
        rememberChangedField("ChangeRecordLifecycleStatus", this.changeRecordLifecycleStatus);
        this.changeRecordLifecycleStatus = changeRecordLifecycleStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Partner</b>
     * </p>
     *
     * @param partner
     *            Change Record Change Responsible (Person)
     */
    public void setPartner( @Nullable final String partner )
    {
        rememberChangedField("Partner", this.partner);
        this.partner = partner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ChgRecordDescriptionText</b>
     * </p>
     *
     * @param chgRecordDescriptionText
     *            Issue Text
     */
    public void setChgRecordDescriptionText( @Nullable final String chgRecordDescriptionText )
    {
        rememberChangedField("ChgRecordDescriptionText", this.chgRecordDescriptionText);
        this.chgRecordDescriptionText = chgRecordDescriptionText;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeRecordDetailDescription</b>
     * </p>
     *
     * @param changeRecordDetailDescription
     *            Change Record General Info
     */
    public void setChangeRecordDetailDescription( @Nullable final String changeRecordDetailDescription )
    {
        rememberChangedField("ChangeRecordDetailDescription", this.changeRecordDetailDescription);
        this.changeRecordDetailDescription = changeRecordDetailDescription;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChgRecdExpectedCompletionDate</b>
     * </p>
     *
     * @param chgRecdExpectedCompletionDate
     *            Expected Completion Date
     */
    public void setChgRecdExpectedCompletionDate( @Nullable final LocalDateTime chgRecdExpectedCompletionDate )
    {
        rememberChangedField("ChgRecdExpectedCompletionDate", this.chgRecdExpectedCompletionDate);
        this.chgRecdExpectedCompletionDate = chgRecdExpectedCompletionDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ChangeRecord";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ChangeRecordUUID", getChangeRecordUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Update_mc", getUpdate_mc());
        values.put("to_ChangeRecordFuncLocTskList_oc", getChangeRecordFuncLocTskList_oc());
        values.put("to_ChangeRecordRateRtgTskList_oc", getChangeRecordRateRtgTskList_oc());
        values.put("to_ChangeRecordRefCharc_oc", getChangeRecordRefCharc_oc());
        values.put("to_ChangeRecordRefClass_oc", getChangeRecordRefClass_oc());
        values.put("to_ChangeRecordRefEquipTskList_oc", getChangeRecordRefEquipTskList_oc());
        values.put("to_ChangeRecordRefInspPlan_oc", getChangeRecordRefInspPlan_oc());
        values.put("to_ChangeRecordRefLabelSet_oc", getChangeRecordRefLabelSet_oc());
        values.put("to_ChangeRecordRefMasterRecipe_oc", getChangeRecordRefMasterRecipe_oc());
        values.put("to_ChangeRecordRefOpSetTskList_oc", getChangeRecordRefOpSetTskList_oc());
        values.put("to_ChangeRecordRefProdnRouting_oc", getChangeRecordRefProdnRouting_oc());
        values.put("to_ChangeRecordRefRecipe_oc", getChangeRecordRefRecipe_oc());
        values.put("to_ChangeRecordRefSpecification_oc", getChangeRecordRefSpecification_oc());
        values.put("to_ChangeRecordRefStdBOM_oc", getChangeRecordRefStdBOM_oc());
        values.put("to_ChangeRecordRefTmplRouting_oc", getChangeRecordRefTmplRouting_oc());
        values.put("to_ChangeRecordRefVarBOM_oc", getChangeRecordRefVarBOM_oc());
        values.put("to_ChgRecdCollaboration_oc", getChgRecdCollaboration_oc());
        values.put("to_ChgRecdEquipBOM_oc", getChgRecdEquipBOM_oc());
        values.put("to_ChgRecdFuncLocBOM_oc", getChgRecdFuncLocBOM_oc());
        values.put("to_ChgRecdRefCutPlngPrflTskList_oc", getChgRecdRefCutPlngPrflTskList_oc());
        values.put("to_ChgRecdRefEngBOM_oc", getChgRecdRefEngBOM_oc());
        values.put("to_ChgRecdRefMaintTskList_oc", getChgRecdRefMaintTskList_oc());
        values.put("to_ChgRecdRefMfgBOM_oc", getChgRecdRefMfgBOM_oc());
        values.put("to_ChgRecdRefPlngScp_oc", getChgRecdRefPlngScp_oc());
        values.put("to_ChgRecdRefRateRtgTskList_oc", getChgRecdRefRateRtgTskList_oc());
        values.put("to_ChgRecdWBSElmntBOM_oc", getChgRecdWBSElmntBOM_oc());
        values.put("to_RefBit_oc", getRefBit_oc());
        values.put("to_RefBOM_oc", getRefBOM_oc());
        values.put("to_RefDoc_oc", getRefDoc_oc());
        values.put("to_RefMat_oc", getRefMat_oc());
        values.put("to_RefPSV_oc", getRefPSV_oc());
        values.put("ChangeRecordUUID", getChangeRecordUUID());
        values.put("ChangeRecord", getChangeRecord());
        values.put("ChangeRecordType", getChangeRecordType());
        values.put("ChangeRecordStatus", getChangeRecordStatus());
        values.put("ChangeNumber", getChangeNumber());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("ChangeRecordLifecycleStatus", getChangeRecordLifecycleStatus());
        values.put("Partner", getPartner());
        values.put("ChgRecordDescriptionText", getChgRecordDescriptionText());
        values.put("ChangeRecordDetailDescription", getChangeRecordDetailDescription());
        values.put("ChgRecdExpectedCompletionDate", getChgRecdExpectedCompletionDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeRecordFuncLocTskList_oc") ) {
                final Object value = values.remove("to_ChangeRecordFuncLocTskList_oc");
                if( (value == null) || (!value.equals(getChangeRecordFuncLocTskList_oc())) ) {
                    setChangeRecordFuncLocTskList_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeRecordRateRtgTskList_oc") ) {
                final Object value = values.remove("to_ChangeRecordRateRtgTskList_oc");
                if( (value == null) || (!value.equals(getChangeRecordRateRtgTskList_oc())) ) {
                    setChangeRecordRateRtgTskList_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeRecordRefCharc_oc") ) {
                final Object value = values.remove("to_ChangeRecordRefCharc_oc");
                if( (value == null) || (!value.equals(getChangeRecordRefCharc_oc())) ) {
                    setChangeRecordRefCharc_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeRecordRefClass_oc") ) {
                final Object value = values.remove("to_ChangeRecordRefClass_oc");
                if( (value == null) || (!value.equals(getChangeRecordRefClass_oc())) ) {
                    setChangeRecordRefClass_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeRecordRefEquipTskList_oc") ) {
                final Object value = values.remove("to_ChangeRecordRefEquipTskList_oc");
                if( (value == null) || (!value.equals(getChangeRecordRefEquipTskList_oc())) ) {
                    setChangeRecordRefEquipTskList_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeRecordRefInspPlan_oc") ) {
                final Object value = values.remove("to_ChangeRecordRefInspPlan_oc");
                if( (value == null) || (!value.equals(getChangeRecordRefInspPlan_oc())) ) {
                    setChangeRecordRefInspPlan_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeRecordRefLabelSet_oc") ) {
                final Object value = values.remove("to_ChangeRecordRefLabelSet_oc");
                if( (value == null) || (!value.equals(getChangeRecordRefLabelSet_oc())) ) {
                    setChangeRecordRefLabelSet_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeRecordRefMasterRecipe_oc") ) {
                final Object value = values.remove("to_ChangeRecordRefMasterRecipe_oc");
                if( (value == null) || (!value.equals(getChangeRecordRefMasterRecipe_oc())) ) {
                    setChangeRecordRefMasterRecipe_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeRecordRefOpSetTskList_oc") ) {
                final Object value = values.remove("to_ChangeRecordRefOpSetTskList_oc");
                if( (value == null) || (!value.equals(getChangeRecordRefOpSetTskList_oc())) ) {
                    setChangeRecordRefOpSetTskList_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeRecordRefProdnRouting_oc") ) {
                final Object value = values.remove("to_ChangeRecordRefProdnRouting_oc");
                if( (value == null) || (!value.equals(getChangeRecordRefProdnRouting_oc())) ) {
                    setChangeRecordRefProdnRouting_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeRecordRefRecipe_oc") ) {
                final Object value = values.remove("to_ChangeRecordRefRecipe_oc");
                if( (value == null) || (!value.equals(getChangeRecordRefRecipe_oc())) ) {
                    setChangeRecordRefRecipe_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeRecordRefSpecification_oc") ) {
                final Object value = values.remove("to_ChangeRecordRefSpecification_oc");
                if( (value == null) || (!value.equals(getChangeRecordRefSpecification_oc())) ) {
                    setChangeRecordRefSpecification_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeRecordRefStdBOM_oc") ) {
                final Object value = values.remove("to_ChangeRecordRefStdBOM_oc");
                if( (value == null) || (!value.equals(getChangeRecordRefStdBOM_oc())) ) {
                    setChangeRecordRefStdBOM_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeRecordRefTmplRouting_oc") ) {
                final Object value = values.remove("to_ChangeRecordRefTmplRouting_oc");
                if( (value == null) || (!value.equals(getChangeRecordRefTmplRouting_oc())) ) {
                    setChangeRecordRefTmplRouting_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChangeRecordRefVarBOM_oc") ) {
                final Object value = values.remove("to_ChangeRecordRefVarBOM_oc");
                if( (value == null) || (!value.equals(getChangeRecordRefVarBOM_oc())) ) {
                    setChangeRecordRefVarBOM_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChgRecdCollaboration_oc") ) {
                final Object value = values.remove("to_ChgRecdCollaboration_oc");
                if( (value == null) || (!value.equals(getChgRecdCollaboration_oc())) ) {
                    setChgRecdCollaboration_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChgRecdEquipBOM_oc") ) {
                final Object value = values.remove("to_ChgRecdEquipBOM_oc");
                if( (value == null) || (!value.equals(getChgRecdEquipBOM_oc())) ) {
                    setChgRecdEquipBOM_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChgRecdFuncLocBOM_oc") ) {
                final Object value = values.remove("to_ChgRecdFuncLocBOM_oc");
                if( (value == null) || (!value.equals(getChgRecdFuncLocBOM_oc())) ) {
                    setChgRecdFuncLocBOM_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChgRecdRefCutPlngPrflTskList_oc") ) {
                final Object value = values.remove("to_ChgRecdRefCutPlngPrflTskList_oc");
                if( (value == null) || (!value.equals(getChgRecdRefCutPlngPrflTskList_oc())) ) {
                    setChgRecdRefCutPlngPrflTskList_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChgRecdRefEngBOM_oc") ) {
                final Object value = values.remove("to_ChgRecdRefEngBOM_oc");
                if( (value == null) || (!value.equals(getChgRecdRefEngBOM_oc())) ) {
                    setChgRecdRefEngBOM_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChgRecdRefMaintTskList_oc") ) {
                final Object value = values.remove("to_ChgRecdRefMaintTskList_oc");
                if( (value == null) || (!value.equals(getChgRecdRefMaintTskList_oc())) ) {
                    setChgRecdRefMaintTskList_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChgRecdRefMfgBOM_oc") ) {
                final Object value = values.remove("to_ChgRecdRefMfgBOM_oc");
                if( (value == null) || (!value.equals(getChgRecdRefMfgBOM_oc())) ) {
                    setChgRecdRefMfgBOM_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChgRecdRefPlngScp_oc") ) {
                final Object value = values.remove("to_ChgRecdRefPlngScp_oc");
                if( (value == null) || (!value.equals(getChgRecdRefPlngScp_oc())) ) {
                    setChgRecdRefPlngScp_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChgRecdRefRateRtgTskList_oc") ) {
                final Object value = values.remove("to_ChgRecdRefRateRtgTskList_oc");
                if( (value == null) || (!value.equals(getChgRecdRefRateRtgTskList_oc())) ) {
                    setChgRecdRefRateRtgTskList_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ChgRecdWBSElmntBOM_oc") ) {
                final Object value = values.remove("to_ChgRecdWBSElmntBOM_oc");
                if( (value == null) || (!value.equals(getChgRecdWBSElmntBOM_oc())) ) {
                    setChgRecdWBSElmntBOM_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_RefBit_oc") ) {
                final Object value = values.remove("to_RefBit_oc");
                if( (value == null) || (!value.equals(getRefBit_oc())) ) {
                    setRefBit_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_RefBOM_oc") ) {
                final Object value = values.remove("to_RefBOM_oc");
                if( (value == null) || (!value.equals(getRefBOM_oc())) ) {
                    setRefBOM_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_RefDoc_oc") ) {
                final Object value = values.remove("to_RefDoc_oc");
                if( (value == null) || (!value.equals(getRefDoc_oc())) ) {
                    setRefDoc_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_RefMat_oc") ) {
                final Object value = values.remove("to_RefMat_oc");
                if( (value == null) || (!value.equals(getRefMat_oc())) ) {
                    setRefMat_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_RefPSV_oc") ) {
                final Object value = values.remove("to_RefPSV_oc");
                if( (value == null) || (!value.equals(getRefPSV_oc())) ) {
                    setRefPSV_oc(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeRecordUUID") ) {
                final Object value = values.remove("ChangeRecordUUID");
                if( (value == null) || (!value.equals(getChangeRecordUUID())) ) {
                    setChangeRecordUUID(((UUID) value));
                }
            }
            if( values.containsKey("ChangeRecord") ) {
                final Object value = values.remove("ChangeRecord");
                if( (value == null) || (!value.equals(getChangeRecord())) ) {
                    setChangeRecord(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordType") ) {
                final Object value = values.remove("ChangeRecordType");
                if( (value == null) || (!value.equals(getChangeRecordType())) ) {
                    setChangeRecordType(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordStatus") ) {
                final Object value = values.remove("ChangeRecordStatus");
                if( (value == null) || (!value.equals(getChangeRecordStatus())) ) {
                    setChangeRecordStatus(((String) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("ChangeRecordLifecycleStatus") ) {
                final Object value = values.remove("ChangeRecordLifecycleStatus");
                if( (value == null) || (!value.equals(getChangeRecordLifecycleStatus())) ) {
                    setChangeRecordLifecycleStatus(((String) value));
                }
            }
            if( values.containsKey("Partner") ) {
                final Object value = values.remove("Partner");
                if( (value == null) || (!value.equals(getPartner())) ) {
                    setPartner(((String) value));
                }
            }
            if( values.containsKey("ChgRecordDescriptionText") ) {
                final Object value = values.remove("ChgRecordDescriptionText");
                if( (value == null) || (!value.equals(getChgRecordDescriptionText())) ) {
                    setChgRecordDescriptionText(((String) value));
                }
            }
            if( values.containsKey("ChangeRecordDetailDescription") ) {
                final Object value = values.remove("ChangeRecordDetailDescription");
                if( (value == null) || (!value.equals(getChangeRecordDetailDescription())) ) {
                    setChangeRecordDetailDescription(((String) value));
                }
            }
            if( values.containsKey("ChgRecdExpectedCompletionDate") ) {
                final Object value = values.remove("ChgRecdExpectedCompletionDate");
                if( (value == null) || (!value.equals(getChgRecdExpectedCompletionDate())) ) {
                    setChgRecdExpectedCompletionDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ChangeRecordFuncLocTskList") ) {
                final Object value = (values).remove("to_ChangeRecordFuncLocTskList");
                if( value instanceof Iterable ) {
                    if( toChangeRecordFuncLocTskList == null ) {
                        toChangeRecordFuncLocTskList = Lists.newArrayList();
                    } else {
                        toChangeRecordFuncLocTskList = Lists.newArrayList(toChangeRecordFuncLocTskList);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChgRecdFuncLocTskList entity;
                        if( toChangeRecordFuncLocTskList.size() > i ) {
                            entity = toChangeRecordFuncLocTskList.get(i);
                        } else {
                            entity = new ChgRecdFuncLocTskList();
                            toChangeRecordFuncLocTskList.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChangeRecordRefCharc") ) {
                final Object value = (values).remove("to_ChangeRecordRefCharc");
                if( value instanceof Iterable ) {
                    if( toChangeRecordRefCharc == null ) {
                        toChangeRecordRefCharc = Lists.newArrayList();
                    } else {
                        toChangeRecordRefCharc = Lists.newArrayList(toChangeRecordRefCharc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeRecordRefCharc entity;
                        if( toChangeRecordRefCharc.size() > i ) {
                            entity = toChangeRecordRefCharc.get(i);
                        } else {
                            entity = new ChangeRecordRefCharc();
                            toChangeRecordRefCharc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChangeRecordRefClass") ) {
                final Object value = (values).remove("to_ChangeRecordRefClass");
                if( value instanceof Iterable ) {
                    if( toChangeRecordRefClass == null ) {
                        toChangeRecordRefClass = Lists.newArrayList();
                    } else {
                        toChangeRecordRefClass = Lists.newArrayList(toChangeRecordRefClass);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeRecordRefClass entity;
                        if( toChangeRecordRefClass.size() > i ) {
                            entity = toChangeRecordRefClass.get(i);
                        } else {
                            entity = new ChangeRecordRefClass();
                            toChangeRecordRefClass.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChangeRecordRefEquipTskList") ) {
                final Object value = (values).remove("to_ChangeRecordRefEquipTskList");
                if( value instanceof Iterable ) {
                    if( toChangeRecordRefEquipTskList == null ) {
                        toChangeRecordRefEquipTskList = Lists.newArrayList();
                    } else {
                        toChangeRecordRefEquipTskList = Lists.newArrayList(toChangeRecordRefEquipTskList);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChgRecdRefEquipTskList entity;
                        if( toChangeRecordRefEquipTskList.size() > i ) {
                            entity = toChangeRecordRefEquipTskList.get(i);
                        } else {
                            entity = new ChgRecdRefEquipTskList();
                            toChangeRecordRefEquipTskList.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChangeRecordRefMasterRecipe") ) {
                final Object value = (values).remove("to_ChangeRecordRefMasterRecipe");
                if( value instanceof Iterable ) {
                    if( toChangeRecordRefMasterRecipe == null ) {
                        toChangeRecordRefMasterRecipe = Lists.newArrayList();
                    } else {
                        toChangeRecordRefMasterRecipe = Lists.newArrayList(toChangeRecordRefMasterRecipe);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeRecordRefMasterRecipe entity;
                        if( toChangeRecordRefMasterRecipe.size() > i ) {
                            entity = toChangeRecordRefMasterRecipe.get(i);
                        } else {
                            entity = new ChangeRecordRefMasterRecipe();
                            toChangeRecordRefMasterRecipe.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChangeRecordRefProdnRouting") ) {
                final Object value = (values).remove("to_ChangeRecordRefProdnRouting");
                if( value instanceof Iterable ) {
                    if( toChangeRecordRefProdnRouting == null ) {
                        toChangeRecordRefProdnRouting = Lists.newArrayList();
                    } else {
                        toChangeRecordRefProdnRouting = Lists.newArrayList(toChangeRecordRefProdnRouting);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeRecordRefProdnRouting entity;
                        if( toChangeRecordRefProdnRouting.size() > i ) {
                            entity = toChangeRecordRefProdnRouting.get(i);
                        } else {
                            entity = new ChangeRecordRefProdnRouting();
                            toChangeRecordRefProdnRouting.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChangeRecordRefStdBOM") ) {
                final Object value = (values).remove("to_ChangeRecordRefStdBOM");
                if( value instanceof Iterable ) {
                    if( toChangeRecordRefStdBOM == null ) {
                        toChangeRecordRefStdBOM = Lists.newArrayList();
                    } else {
                        toChangeRecordRefStdBOM = Lists.newArrayList(toChangeRecordRefStdBOM);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChgRecdRefStdBOM entity;
                        if( toChangeRecordRefStdBOM.size() > i ) {
                            entity = toChangeRecordRefStdBOM.get(i);
                        } else {
                            entity = new ChgRecdRefStdBOM();
                            toChangeRecordRefStdBOM.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChangeRecordRefVarBOM") ) {
                final Object value = (values).remove("to_ChangeRecordRefVarBOM");
                if( value instanceof Iterable ) {
                    if( toChangeRecordRefVarBOM == null ) {
                        toChangeRecordRefVarBOM = Lists.newArrayList();
                    } else {
                        toChangeRecordRefVarBOM = Lists.newArrayList(toChangeRecordRefVarBOM);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChgRecdRefVarBOM entity;
                        if( toChangeRecordRefVarBOM.size() > i ) {
                            entity = toChangeRecordRefVarBOM.get(i);
                        } else {
                            entity = new ChgRecdRefVarBOM();
                            toChangeRecordRefVarBOM.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChgRecdCollaboration") ) {
                final Object value = (values).remove("to_ChgRecdCollaboration");
                if( value instanceof Iterable ) {
                    if( toChgRecdCollaboration == null ) {
                        toChgRecdCollaboration = Lists.newArrayList();
                    } else {
                        toChgRecdCollaboration = Lists.newArrayList(toChgRecdCollaboration);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChgRecdPLMEPDCollabn entity;
                        if( toChgRecdCollaboration.size() > i ) {
                            entity = toChgRecdCollaboration.get(i);
                        } else {
                            entity = new ChgRecdPLMEPDCollabn();
                            toChgRecdCollaboration.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChgRecdEquipBOM") ) {
                final Object value = (values).remove("to_ChgRecdEquipBOM");
                if( value instanceof Iterable ) {
                    if( toChgRecdEquipBOM == null ) {
                        toChgRecdEquipBOM = Lists.newArrayList();
                    } else {
                        toChgRecdEquipBOM = Lists.newArrayList(toChgRecdEquipBOM);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChgRecdEquipBOM entity;
                        if( toChgRecdEquipBOM.size() > i ) {
                            entity = toChgRecdEquipBOM.get(i);
                        } else {
                            entity = new ChgRecdEquipBOM();
                            toChgRecdEquipBOM.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChgRecdFuncLocBOM") ) {
                final Object value = (values).remove("to_ChgRecdFuncLocBOM");
                if( value instanceof Iterable ) {
                    if( toChgRecdFuncLocBOM == null ) {
                        toChgRecdFuncLocBOM = Lists.newArrayList();
                    } else {
                        toChgRecdFuncLocBOM = Lists.newArrayList(toChgRecdFuncLocBOM);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChgRecdFuncLocBOM entity;
                        if( toChgRecdFuncLocBOM.size() > i ) {
                            entity = toChgRecdFuncLocBOM.get(i);
                        } else {
                            entity = new ChgRecdFuncLocBOM();
                            toChgRecdFuncLocBOM.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChgRecdRefEngBOM") ) {
                final Object value = (values).remove("to_ChgRecdRefEngBOM");
                if( value instanceof Iterable ) {
                    if( toChgRecdRefEngBOM == null ) {
                        toChgRecdRefEngBOM = Lists.newArrayList();
                    } else {
                        toChgRecdRefEngBOM = Lists.newArrayList(toChgRecdRefEngBOM);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChgRecdRefEngBOM entity;
                        if( toChgRecdRefEngBOM.size() > i ) {
                            entity = toChgRecdRefEngBOM.get(i);
                        } else {
                            entity = new ChgRecdRefEngBOM();
                            toChgRecdRefEngBOM.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChgRecdRefMaintTskList") ) {
                final Object value = (values).remove("to_ChgRecdRefMaintTskList");
                if( value instanceof Iterable ) {
                    if( toChgRecdRefMaintTskList == null ) {
                        toChgRecdRefMaintTskList = Lists.newArrayList();
                    } else {
                        toChgRecdRefMaintTskList = Lists.newArrayList(toChgRecdRefMaintTskList);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChgRecdObjPgMaintTskList entity;
                        if( toChgRecdRefMaintTskList.size() > i ) {
                            entity = toChgRecdRefMaintTskList.get(i);
                        } else {
                            entity = new ChgRecdObjPgMaintTskList();
                            toChgRecdRefMaintTskList.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChgRecdRefMfgBOM") ) {
                final Object value = (values).remove("to_ChgRecdRefMfgBOM");
                if( value instanceof Iterable ) {
                    if( toChgRecdRefMfgBOM == null ) {
                        toChgRecdRefMfgBOM = Lists.newArrayList();
                    } else {
                        toChgRecdRefMfgBOM = Lists.newArrayList(toChgRecdRefMfgBOM);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChgRecdRefMfgBOM entity;
                        if( toChgRecdRefMfgBOM.size() > i ) {
                            entity = toChgRecdRefMfgBOM.get(i);
                        } else {
                            entity = new ChgRecdRefMfgBOM();
                            toChgRecdRefMfgBOM.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RefBit") ) {
                final Object value = (values).remove("to_RefBit");
                if( value instanceof Iterable ) {
                    if( toRefBit == null ) {
                        toRefBit = Lists.newArrayList();
                    } else {
                        toRefBit = Lists.newArrayList(toRefBit);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeRecordReferenceBit entity;
                        if( toRefBit.size() > i ) {
                            entity = toRefBit.get(i);
                        } else {
                            entity = new ChangeRecordReferenceBit();
                            toRefBit.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RefBOM") ) {
                final Object value = (values).remove("to_RefBOM");
                if( value instanceof Iterable ) {
                    if( toRefBOM == null ) {
                        toRefBOM = Lists.newArrayList();
                    } else {
                        toRefBOM = Lists.newArrayList(toRefBOM);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeRecordReferenceBOM entity;
                        if( toRefBOM.size() > i ) {
                            entity = toRefBOM.get(i);
                        } else {
                            entity = new ChangeRecordReferenceBOM();
                            toRefBOM.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RefDoc") ) {
                final Object value = (values).remove("to_RefDoc");
                if( value instanceof Iterable ) {
                    if( toRefDoc == null ) {
                        toRefDoc = Lists.newArrayList();
                    } else {
                        toRefDoc = Lists.newArrayList(toRefDoc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeRecordReferenceDoc entity;
                        if( toRefDoc.size() > i ) {
                            entity = toRefDoc.get(i);
                        } else {
                            entity = new ChangeRecordReferenceDoc();
                            toRefDoc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RefMat") ) {
                final Object value = (values).remove("to_RefMat");
                if( value instanceof Iterable ) {
                    if( toRefMat == null ) {
                        toRefMat = Lists.newArrayList();
                    } else {
                        toRefMat = Lists.newArrayList(toRefMat);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeRecordReferenceMat entity;
                        if( toRefMat.size() > i ) {
                            entity = toRefMat.get(i);
                        } else {
                            entity = new ChangeRecordReferenceMat();
                            toRefMat.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RefPSV") ) {
                final Object value = (values).remove("to_RefPSV");
                if( value instanceof Iterable ) {
                    if( toRefPSV == null ) {
                        toRefPSV = Lists.newArrayList();
                    } else {
                        toRefPSV = Lists.newArrayList(toRefPSV);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ChangeRecordReferencePSV entity;
                        if( toRefPSV.size() > i ) {
                            entity = toRefPSV.get(i);
                        } else {
                            entity = new ChangeRecordReferencePSV();
                            toRefPSV.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ChangeRecordField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ChangeRecordField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ChangeRecordField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ChangeRecordField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ChangeRecordService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toChangeRecordFuncLocTskList != null ) {
            (values).put("to_ChangeRecordFuncLocTskList", toChangeRecordFuncLocTskList);
        }
        if( toChangeRecordRefCharc != null ) {
            (values).put("to_ChangeRecordRefCharc", toChangeRecordRefCharc);
        }
        if( toChangeRecordRefClass != null ) {
            (values).put("to_ChangeRecordRefClass", toChangeRecordRefClass);
        }
        if( toChangeRecordRefEquipTskList != null ) {
            (values).put("to_ChangeRecordRefEquipTskList", toChangeRecordRefEquipTskList);
        }
        if( toChangeRecordRefMasterRecipe != null ) {
            (values).put("to_ChangeRecordRefMasterRecipe", toChangeRecordRefMasterRecipe);
        }
        if( toChangeRecordRefProdnRouting != null ) {
            (values).put("to_ChangeRecordRefProdnRouting", toChangeRecordRefProdnRouting);
        }
        if( toChangeRecordRefStdBOM != null ) {
            (values).put("to_ChangeRecordRefStdBOM", toChangeRecordRefStdBOM);
        }
        if( toChangeRecordRefVarBOM != null ) {
            (values).put("to_ChangeRecordRefVarBOM", toChangeRecordRefVarBOM);
        }
        if( toChgRecdCollaboration != null ) {
            (values).put("to_ChgRecdCollaboration", toChgRecdCollaboration);
        }
        if( toChgRecdEquipBOM != null ) {
            (values).put("to_ChgRecdEquipBOM", toChgRecdEquipBOM);
        }
        if( toChgRecdFuncLocBOM != null ) {
            (values).put("to_ChgRecdFuncLocBOM", toChgRecdFuncLocBOM);
        }
        if( toChgRecdRefEngBOM != null ) {
            (values).put("to_ChgRecdRefEngBOM", toChgRecdRefEngBOM);
        }
        if( toChgRecdRefMaintTskList != null ) {
            (values).put("to_ChgRecdRefMaintTskList", toChgRecdRefMaintTskList);
        }
        if( toChgRecdRefMfgBOM != null ) {
            (values).put("to_ChgRecdRefMfgBOM", toChgRecdRefMfgBOM);
        }
        if( toRefBit != null ) {
            (values).put("to_RefBit", toRefBit);
        }
        if( toRefBOM != null ) {
            (values).put("to_RefBOM", toRefBOM);
        }
        if( toRefDoc != null ) {
            (values).put("to_RefDoc", toRefDoc);
        }
        if( toRefMat != null ) {
            (values).put("to_RefMat", toRefMat);
        }
        if( toRefPSV != null ) {
            (values).put("to_RefPSV", toRefPSV);
        }
        return values;
    }

    /**
     * Fetches the <b>ChgRecdFuncLocTskList</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ChangeRecordFuncLocTskList</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChgRecdFuncLocTskList</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdFuncLocTskList> fetchChangeRecordFuncLocTskList()
    {
        return fetchFieldAsList("to_ChangeRecordFuncLocTskList", ChgRecdFuncLocTskList.class);
    }

    /**
     * Retrieval of associated <b>ChgRecdFuncLocTskList</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeRecordFuncLocTskList</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordFuncLocTskList</b> of a queried <b>ChangeRecord</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChgRecdFuncLocTskList</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdFuncLocTskList> getChangeRecordFuncLocTskListOrFetch()
    {
        if( toChangeRecordFuncLocTskList == null ) {
            toChangeRecordFuncLocTskList = fetchChangeRecordFuncLocTskList();
        }
        return toChangeRecordFuncLocTskList;
    }

    /**
     * Retrieval of associated <b>ChgRecdFuncLocTskList</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeRecordFuncLocTskList</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChangeRecordFuncLocTskList</b> is already loaded, the
     *         result will contain the <b>ChgRecdFuncLocTskList</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChgRecdFuncLocTskList>> getChangeRecordFuncLocTskListIfPresent()
    {
        return Option.of(toChangeRecordFuncLocTskList);
    }

    /**
     * Overwrites the list of associated <b>ChgRecdFuncLocTskList</b> entities for the loaded navigation property
     * <b>to_ChangeRecordFuncLocTskList</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordFuncLocTskList</b> of a queried <b>ChangeRecord</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChgRecdFuncLocTskList</b> entities.
     */
    public void setChangeRecordFuncLocTskList( @Nonnull final List<ChgRecdFuncLocTskList> value )
    {
        if( toChangeRecordFuncLocTskList == null ) {
            toChangeRecordFuncLocTskList = Lists.newArrayList();
        }
        toChangeRecordFuncLocTskList.clear();
        toChangeRecordFuncLocTskList.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChgRecdFuncLocTskList</b> entities. This corresponds to the OData
     * navigation property <b>to_ChangeRecordFuncLocTskList</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordFuncLocTskList</b> of a queried <b>ChangeRecord</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChgRecdFuncLocTskList</b> entities.
     */
    public void addChangeRecordFuncLocTskList( ChgRecdFuncLocTskList... entity )
    {
        if( toChangeRecordFuncLocTskList == null ) {
            toChangeRecordFuncLocTskList = Lists.newArrayList();
        }
        toChangeRecordFuncLocTskList.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeRecordRefCharc</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ChangeRecordRefCharc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeRecordRefCharc</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordRefCharc> fetchChangeRecordRefCharc()
    {
        return fetchFieldAsList("to_ChangeRecordRefCharc", ChangeRecordRefCharc.class);
    }

    /**
     * Retrieval of associated <b>ChangeRecordRefCharc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeRecordRefCharc</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefCharc</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeRecordRefCharc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordRefCharc> getChangeRecordRefCharcOrFetch()
    {
        if( toChangeRecordRefCharc == null ) {
            toChangeRecordRefCharc = fetchChangeRecordRefCharc();
        }
        return toChangeRecordRefCharc;
    }

    /**
     * Retrieval of associated <b>ChangeRecordRefCharc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeRecordRefCharc</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChangeRecordRefCharc</b> is already loaded, the result
     *         will contain the <b>ChangeRecordRefCharc</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeRecordRefCharc>> getChangeRecordRefCharcIfPresent()
    {
        return Option.of(toChangeRecordRefCharc);
    }

    /**
     * Overwrites the list of associated <b>ChangeRecordRefCharc</b> entities for the loaded navigation property
     * <b>to_ChangeRecordRefCharc</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefCharc</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeRecordRefCharc</b> entities.
     */
    public void setChangeRecordRefCharc( @Nonnull final List<ChangeRecordRefCharc> value )
    {
        if( toChangeRecordRefCharc == null ) {
            toChangeRecordRefCharc = Lists.newArrayList();
        }
        toChangeRecordRefCharc.clear();
        toChangeRecordRefCharc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeRecordRefCharc</b> entities. This corresponds to the OData
     * navigation property <b>to_ChangeRecordRefCharc</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefCharc</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeRecordRefCharc</b> entities.
     */
    public void addChangeRecordRefCharc( ChangeRecordRefCharc... entity )
    {
        if( toChangeRecordRefCharc == null ) {
            toChangeRecordRefCharc = Lists.newArrayList();
        }
        toChangeRecordRefCharc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeRecordRefClass</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ChangeRecordRefClass</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeRecordRefClass</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordRefClass> fetchChangeRecordRefClass()
    {
        return fetchFieldAsList("to_ChangeRecordRefClass", ChangeRecordRefClass.class);
    }

    /**
     * Retrieval of associated <b>ChangeRecordRefClass</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeRecordRefClass</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefClass</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeRecordRefClass</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordRefClass> getChangeRecordRefClassOrFetch()
    {
        if( toChangeRecordRefClass == null ) {
            toChangeRecordRefClass = fetchChangeRecordRefClass();
        }
        return toChangeRecordRefClass;
    }

    /**
     * Retrieval of associated <b>ChangeRecordRefClass</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeRecordRefClass</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChangeRecordRefClass</b> is already loaded, the result
     *         will contain the <b>ChangeRecordRefClass</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeRecordRefClass>> getChangeRecordRefClassIfPresent()
    {
        return Option.of(toChangeRecordRefClass);
    }

    /**
     * Overwrites the list of associated <b>ChangeRecordRefClass</b> entities for the loaded navigation property
     * <b>to_ChangeRecordRefClass</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefClass</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeRecordRefClass</b> entities.
     */
    public void setChangeRecordRefClass( @Nonnull final List<ChangeRecordRefClass> value )
    {
        if( toChangeRecordRefClass == null ) {
            toChangeRecordRefClass = Lists.newArrayList();
        }
        toChangeRecordRefClass.clear();
        toChangeRecordRefClass.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeRecordRefClass</b> entities. This corresponds to the OData
     * navigation property <b>to_ChangeRecordRefClass</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefClass</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeRecordRefClass</b> entities.
     */
    public void addChangeRecordRefClass( ChangeRecordRefClass... entity )
    {
        if( toChangeRecordRefClass == null ) {
            toChangeRecordRefClass = Lists.newArrayList();
        }
        toChangeRecordRefClass.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChgRecdRefEquipTskList</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ChangeRecordRefEquipTskList</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChgRecdRefEquipTskList</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdRefEquipTskList> fetchChangeRecordRefEquipTskList()
    {
        return fetchFieldAsList("to_ChangeRecordRefEquipTskList", ChgRecdRefEquipTskList.class);
    }

    /**
     * Retrieval of associated <b>ChgRecdRefEquipTskList</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeRecordRefEquipTskList</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefEquipTskList</b> of a queried <b>ChangeRecord</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChgRecdRefEquipTskList</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdRefEquipTskList> getChangeRecordRefEquipTskListOrFetch()
    {
        if( toChangeRecordRefEquipTskList == null ) {
            toChangeRecordRefEquipTskList = fetchChangeRecordRefEquipTskList();
        }
        return toChangeRecordRefEquipTskList;
    }

    /**
     * Retrieval of associated <b>ChgRecdRefEquipTskList</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeRecordRefEquipTskList</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChangeRecordRefEquipTskList</b> is already loaded, the
     *         result will contain the <b>ChgRecdRefEquipTskList</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChgRecdRefEquipTskList>> getChangeRecordRefEquipTskListIfPresent()
    {
        return Option.of(toChangeRecordRefEquipTskList);
    }

    /**
     * Overwrites the list of associated <b>ChgRecdRefEquipTskList</b> entities for the loaded navigation property
     * <b>to_ChangeRecordRefEquipTskList</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefEquipTskList</b> of a queried <b>ChangeRecord</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChgRecdRefEquipTskList</b> entities.
     */
    public void setChangeRecordRefEquipTskList( @Nonnull final List<ChgRecdRefEquipTskList> value )
    {
        if( toChangeRecordRefEquipTskList == null ) {
            toChangeRecordRefEquipTskList = Lists.newArrayList();
        }
        toChangeRecordRefEquipTskList.clear();
        toChangeRecordRefEquipTskList.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChgRecdRefEquipTskList</b> entities. This corresponds to the OData
     * navigation property <b>to_ChangeRecordRefEquipTskList</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefEquipTskList</b> of a queried <b>ChangeRecord</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChgRecdRefEquipTskList</b> entities.
     */
    public void addChangeRecordRefEquipTskList( ChgRecdRefEquipTskList... entity )
    {
        if( toChangeRecordRefEquipTskList == null ) {
            toChangeRecordRefEquipTskList = Lists.newArrayList();
        }
        toChangeRecordRefEquipTskList.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeRecordRefMasterRecipe</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ChangeRecordRefMasterRecipe</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeRecordRefMasterRecipe</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordRefMasterRecipe> fetchChangeRecordRefMasterRecipe()
    {
        return fetchFieldAsList("to_ChangeRecordRefMasterRecipe", ChangeRecordRefMasterRecipe.class);
    }

    /**
     * Retrieval of associated <b>ChangeRecordRefMasterRecipe</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeRecordRefMasterRecipe</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefMasterRecipe</b> of a queried <b>ChangeRecord</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeRecordRefMasterRecipe</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordRefMasterRecipe> getChangeRecordRefMasterRecipeOrFetch()
    {
        if( toChangeRecordRefMasterRecipe == null ) {
            toChangeRecordRefMasterRecipe = fetchChangeRecordRefMasterRecipe();
        }
        return toChangeRecordRefMasterRecipe;
    }

    /**
     * Retrieval of associated <b>ChangeRecordRefMasterRecipe</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeRecordRefMasterRecipe</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChangeRecordRefMasterRecipe</b> is already loaded, the
     *         result will contain the <b>ChangeRecordRefMasterRecipe</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeRecordRefMasterRecipe>> getChangeRecordRefMasterRecipeIfPresent()
    {
        return Option.of(toChangeRecordRefMasterRecipe);
    }

    /**
     * Overwrites the list of associated <b>ChangeRecordRefMasterRecipe</b> entities for the loaded navigation property
     * <b>to_ChangeRecordRefMasterRecipe</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefMasterRecipe</b> of a queried <b>ChangeRecord</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeRecordRefMasterRecipe</b> entities.
     */
    public void setChangeRecordRefMasterRecipe( @Nonnull final List<ChangeRecordRefMasterRecipe> value )
    {
        if( toChangeRecordRefMasterRecipe == null ) {
            toChangeRecordRefMasterRecipe = Lists.newArrayList();
        }
        toChangeRecordRefMasterRecipe.clear();
        toChangeRecordRefMasterRecipe.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeRecordRefMasterRecipe</b> entities. This corresponds to the
     * OData navigation property <b>to_ChangeRecordRefMasterRecipe</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefMasterRecipe</b> of a queried <b>ChangeRecord</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeRecordRefMasterRecipe</b> entities.
     */
    public void addChangeRecordRefMasterRecipe( ChangeRecordRefMasterRecipe... entity )
    {
        if( toChangeRecordRefMasterRecipe == null ) {
            toChangeRecordRefMasterRecipe = Lists.newArrayList();
        }
        toChangeRecordRefMasterRecipe.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeRecordRefProdnRouting</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ChangeRecordRefProdnRouting</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeRecordRefProdnRouting</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordRefProdnRouting> fetchChangeRecordRefProdnRouting()
    {
        return fetchFieldAsList("to_ChangeRecordRefProdnRouting", ChangeRecordRefProdnRouting.class);
    }

    /**
     * Retrieval of associated <b>ChangeRecordRefProdnRouting</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeRecordRefProdnRouting</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefProdnRouting</b> of a queried <b>ChangeRecord</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeRecordRefProdnRouting</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordRefProdnRouting> getChangeRecordRefProdnRoutingOrFetch()
    {
        if( toChangeRecordRefProdnRouting == null ) {
            toChangeRecordRefProdnRouting = fetchChangeRecordRefProdnRouting();
        }
        return toChangeRecordRefProdnRouting;
    }

    /**
     * Retrieval of associated <b>ChangeRecordRefProdnRouting</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChangeRecordRefProdnRouting</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChangeRecordRefProdnRouting</b> is already loaded, the
     *         result will contain the <b>ChangeRecordRefProdnRouting</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeRecordRefProdnRouting>> getChangeRecordRefProdnRoutingIfPresent()
    {
        return Option.of(toChangeRecordRefProdnRouting);
    }

    /**
     * Overwrites the list of associated <b>ChangeRecordRefProdnRouting</b> entities for the loaded navigation property
     * <b>to_ChangeRecordRefProdnRouting</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefProdnRouting</b> of a queried <b>ChangeRecord</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeRecordRefProdnRouting</b> entities.
     */
    public void setChangeRecordRefProdnRouting( @Nonnull final List<ChangeRecordRefProdnRouting> value )
    {
        if( toChangeRecordRefProdnRouting == null ) {
            toChangeRecordRefProdnRouting = Lists.newArrayList();
        }
        toChangeRecordRefProdnRouting.clear();
        toChangeRecordRefProdnRouting.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeRecordRefProdnRouting</b> entities. This corresponds to the
     * OData navigation property <b>to_ChangeRecordRefProdnRouting</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefProdnRouting</b> of a queried <b>ChangeRecord</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeRecordRefProdnRouting</b> entities.
     */
    public void addChangeRecordRefProdnRouting( ChangeRecordRefProdnRouting... entity )
    {
        if( toChangeRecordRefProdnRouting == null ) {
            toChangeRecordRefProdnRouting = Lists.newArrayList();
        }
        toChangeRecordRefProdnRouting.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChgRecdRefStdBOM</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ChangeRecordRefStdBOM</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChgRecdRefStdBOM</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdRefStdBOM> fetchChangeRecordRefStdBOM()
    {
        return fetchFieldAsList("to_ChangeRecordRefStdBOM", ChgRecdRefStdBOM.class);
    }

    /**
     * Retrieval of associated <b>ChgRecdRefStdBOM</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ChangeRecordRefStdBOM</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefStdBOM</b> of a queried <b>ChangeRecord</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChgRecdRefStdBOM</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdRefStdBOM> getChangeRecordRefStdBOMOrFetch()
    {
        if( toChangeRecordRefStdBOM == null ) {
            toChangeRecordRefStdBOM = fetchChangeRecordRefStdBOM();
        }
        return toChangeRecordRefStdBOM;
    }

    /**
     * Retrieval of associated <b>ChgRecdRefStdBOM</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ChangeRecordRefStdBOM</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChangeRecordRefStdBOM</b> is already loaded, the result
     *         will contain the <b>ChgRecdRefStdBOM</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChgRecdRefStdBOM>> getChangeRecordRefStdBOMIfPresent()
    {
        return Option.of(toChangeRecordRefStdBOM);
    }

    /**
     * Overwrites the list of associated <b>ChgRecdRefStdBOM</b> entities for the loaded navigation property
     * <b>to_ChangeRecordRefStdBOM</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefStdBOM</b> of a queried <b>ChangeRecord</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChgRecdRefStdBOM</b> entities.
     */
    public void setChangeRecordRefStdBOM( @Nonnull final List<ChgRecdRefStdBOM> value )
    {
        if( toChangeRecordRefStdBOM == null ) {
            toChangeRecordRefStdBOM = Lists.newArrayList();
        }
        toChangeRecordRefStdBOM.clear();
        toChangeRecordRefStdBOM.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChgRecdRefStdBOM</b> entities. This corresponds to the OData
     * navigation property <b>to_ChangeRecordRefStdBOM</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefStdBOM</b> of a queried <b>ChangeRecord</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChgRecdRefStdBOM</b> entities.
     */
    public void addChangeRecordRefStdBOM( ChgRecdRefStdBOM... entity )
    {
        if( toChangeRecordRefStdBOM == null ) {
            toChangeRecordRefStdBOM = Lists.newArrayList();
        }
        toChangeRecordRefStdBOM.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChgRecdRefVarBOM</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ChangeRecordRefVarBOM</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChgRecdRefVarBOM</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdRefVarBOM> fetchChangeRecordRefVarBOM()
    {
        return fetchFieldAsList("to_ChangeRecordRefVarBOM", ChgRecdRefVarBOM.class);
    }

    /**
     * Retrieval of associated <b>ChgRecdRefVarBOM</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ChangeRecordRefVarBOM</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefVarBOM</b> of a queried <b>ChangeRecord</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChgRecdRefVarBOM</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdRefVarBOM> getChangeRecordRefVarBOMOrFetch()
    {
        if( toChangeRecordRefVarBOM == null ) {
            toChangeRecordRefVarBOM = fetchChangeRecordRefVarBOM();
        }
        return toChangeRecordRefVarBOM;
    }

    /**
     * Retrieval of associated <b>ChgRecdRefVarBOM</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ChangeRecordRefVarBOM</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChangeRecordRefVarBOM</b> is already loaded, the result
     *         will contain the <b>ChgRecdRefVarBOM</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChgRecdRefVarBOM>> getChangeRecordRefVarBOMIfPresent()
    {
        return Option.of(toChangeRecordRefVarBOM);
    }

    /**
     * Overwrites the list of associated <b>ChgRecdRefVarBOM</b> entities for the loaded navigation property
     * <b>to_ChangeRecordRefVarBOM</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefVarBOM</b> of a queried <b>ChangeRecord</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChgRecdRefVarBOM</b> entities.
     */
    public void setChangeRecordRefVarBOM( @Nonnull final List<ChgRecdRefVarBOM> value )
    {
        if( toChangeRecordRefVarBOM == null ) {
            toChangeRecordRefVarBOM = Lists.newArrayList();
        }
        toChangeRecordRefVarBOM.clear();
        toChangeRecordRefVarBOM.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChgRecdRefVarBOM</b> entities. This corresponds to the OData
     * navigation property <b>to_ChangeRecordRefVarBOM</b>.
     * <p>
     * If the navigation property <b>to_ChangeRecordRefVarBOM</b> of a queried <b>ChangeRecord</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChgRecdRefVarBOM</b> entities.
     */
    public void addChangeRecordRefVarBOM( ChgRecdRefVarBOM... entity )
    {
        if( toChangeRecordRefVarBOM == null ) {
            toChangeRecordRefVarBOM = Lists.newArrayList();
        }
        toChangeRecordRefVarBOM.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChgRecdPLMEPDCollabn</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ChgRecdCollaboration</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChgRecdPLMEPDCollabn</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdPLMEPDCollabn> fetchChgRecdCollaboration()
    {
        return fetchFieldAsList("to_ChgRecdCollaboration", ChgRecdPLMEPDCollabn.class);
    }

    /**
     * Retrieval of associated <b>ChgRecdPLMEPDCollabn</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChgRecdCollaboration</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdCollaboration</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChgRecdPLMEPDCollabn</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdPLMEPDCollabn> getChgRecdCollaborationOrFetch()
    {
        if( toChgRecdCollaboration == null ) {
            toChgRecdCollaboration = fetchChgRecdCollaboration();
        }
        return toChgRecdCollaboration;
    }

    /**
     * Retrieval of associated <b>ChgRecdPLMEPDCollabn</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChgRecdCollaboration</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChgRecdCollaboration</b> is already loaded, the result
     *         will contain the <b>ChgRecdPLMEPDCollabn</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChgRecdPLMEPDCollabn>> getChgRecdCollaborationIfPresent()
    {
        return Option.of(toChgRecdCollaboration);
    }

    /**
     * Overwrites the list of associated <b>ChgRecdPLMEPDCollabn</b> entities for the loaded navigation property
     * <b>to_ChgRecdCollaboration</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdCollaboration</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChgRecdPLMEPDCollabn</b> entities.
     */
    public void setChgRecdCollaboration( @Nonnull final List<ChgRecdPLMEPDCollabn> value )
    {
        if( toChgRecdCollaboration == null ) {
            toChgRecdCollaboration = Lists.newArrayList();
        }
        toChgRecdCollaboration.clear();
        toChgRecdCollaboration.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChgRecdPLMEPDCollabn</b> entities. This corresponds to the OData
     * navigation property <b>to_ChgRecdCollaboration</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdCollaboration</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChgRecdPLMEPDCollabn</b> entities.
     */
    public void addChgRecdCollaboration( ChgRecdPLMEPDCollabn... entity )
    {
        if( toChgRecdCollaboration == null ) {
            toChgRecdCollaboration = Lists.newArrayList();
        }
        toChgRecdCollaboration.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChgRecdEquipBOM</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ChgRecdEquipBOM</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChgRecdEquipBOM</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdEquipBOM> fetchChgRecdEquipBOM()
    {
        return fetchFieldAsList("to_ChgRecdEquipBOM", ChgRecdEquipBOM.class);
    }

    /**
     * Retrieval of associated <b>ChgRecdEquipBOM</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ChgRecdEquipBOM</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdEquipBOM</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChgRecdEquipBOM</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdEquipBOM> getChgRecdEquipBOMOrFetch()
    {
        if( toChgRecdEquipBOM == null ) {
            toChgRecdEquipBOM = fetchChgRecdEquipBOM();
        }
        return toChgRecdEquipBOM;
    }

    /**
     * Retrieval of associated <b>ChgRecdEquipBOM</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ChgRecdEquipBOM</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChgRecdEquipBOM</b> is already loaded, the result will
     *         contain the <b>ChgRecdEquipBOM</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChgRecdEquipBOM>> getChgRecdEquipBOMIfPresent()
    {
        return Option.of(toChgRecdEquipBOM);
    }

    /**
     * Overwrites the list of associated <b>ChgRecdEquipBOM</b> entities for the loaded navigation property
     * <b>to_ChgRecdEquipBOM</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdEquipBOM</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChgRecdEquipBOM</b> entities.
     */
    public void setChgRecdEquipBOM( @Nonnull final List<ChgRecdEquipBOM> value )
    {
        if( toChgRecdEquipBOM == null ) {
            toChgRecdEquipBOM = Lists.newArrayList();
        }
        toChgRecdEquipBOM.clear();
        toChgRecdEquipBOM.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChgRecdEquipBOM</b> entities. This corresponds to the OData navigation
     * property <b>to_ChgRecdEquipBOM</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdEquipBOM</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChgRecdEquipBOM</b> entities.
     */
    public void addChgRecdEquipBOM( ChgRecdEquipBOM... entity )
    {
        if( toChgRecdEquipBOM == null ) {
            toChgRecdEquipBOM = Lists.newArrayList();
        }
        toChgRecdEquipBOM.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChgRecdFuncLocBOM</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ChgRecdFuncLocBOM</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChgRecdFuncLocBOM</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdFuncLocBOM> fetchChgRecdFuncLocBOM()
    {
        return fetchFieldAsList("to_ChgRecdFuncLocBOM", ChgRecdFuncLocBOM.class);
    }

    /**
     * Retrieval of associated <b>ChgRecdFuncLocBOM</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ChgRecdFuncLocBOM</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdFuncLocBOM</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChgRecdFuncLocBOM</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdFuncLocBOM> getChgRecdFuncLocBOMOrFetch()
    {
        if( toChgRecdFuncLocBOM == null ) {
            toChgRecdFuncLocBOM = fetchChgRecdFuncLocBOM();
        }
        return toChgRecdFuncLocBOM;
    }

    /**
     * Retrieval of associated <b>ChgRecdFuncLocBOM</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ChgRecdFuncLocBOM</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChgRecdFuncLocBOM</b> is already loaded, the result will
     *         contain the <b>ChgRecdFuncLocBOM</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChgRecdFuncLocBOM>> getChgRecdFuncLocBOMIfPresent()
    {
        return Option.of(toChgRecdFuncLocBOM);
    }

    /**
     * Overwrites the list of associated <b>ChgRecdFuncLocBOM</b> entities for the loaded navigation property
     * <b>to_ChgRecdFuncLocBOM</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdFuncLocBOM</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChgRecdFuncLocBOM</b> entities.
     */
    public void setChgRecdFuncLocBOM( @Nonnull final List<ChgRecdFuncLocBOM> value )
    {
        if( toChgRecdFuncLocBOM == null ) {
            toChgRecdFuncLocBOM = Lists.newArrayList();
        }
        toChgRecdFuncLocBOM.clear();
        toChgRecdFuncLocBOM.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChgRecdFuncLocBOM</b> entities. This corresponds to the OData
     * navigation property <b>to_ChgRecdFuncLocBOM</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdFuncLocBOM</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChgRecdFuncLocBOM</b> entities.
     */
    public void addChgRecdFuncLocBOM( ChgRecdFuncLocBOM... entity )
    {
        if( toChgRecdFuncLocBOM == null ) {
            toChgRecdFuncLocBOM = Lists.newArrayList();
        }
        toChgRecdFuncLocBOM.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChgRecdRefEngBOM</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ChgRecdRefEngBOM</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChgRecdRefEngBOM</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdRefEngBOM> fetchChgRecdRefEngBOM()
    {
        return fetchFieldAsList("to_ChgRecdRefEngBOM", ChgRecdRefEngBOM.class);
    }

    /**
     * Retrieval of associated <b>ChgRecdRefEngBOM</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ChgRecdRefEngBOM</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdRefEngBOM</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChgRecdRefEngBOM</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdRefEngBOM> getChgRecdRefEngBOMOrFetch()
    {
        if( toChgRecdRefEngBOM == null ) {
            toChgRecdRefEngBOM = fetchChgRecdRefEngBOM();
        }
        return toChgRecdRefEngBOM;
    }

    /**
     * Retrieval of associated <b>ChgRecdRefEngBOM</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ChgRecdRefEngBOM</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChgRecdRefEngBOM</b> is already loaded, the result will
     *         contain the <b>ChgRecdRefEngBOM</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChgRecdRefEngBOM>> getChgRecdRefEngBOMIfPresent()
    {
        return Option.of(toChgRecdRefEngBOM);
    }

    /**
     * Overwrites the list of associated <b>ChgRecdRefEngBOM</b> entities for the loaded navigation property
     * <b>to_ChgRecdRefEngBOM</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdRefEngBOM</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChgRecdRefEngBOM</b> entities.
     */
    public void setChgRecdRefEngBOM( @Nonnull final List<ChgRecdRefEngBOM> value )
    {
        if( toChgRecdRefEngBOM == null ) {
            toChgRecdRefEngBOM = Lists.newArrayList();
        }
        toChgRecdRefEngBOM.clear();
        toChgRecdRefEngBOM.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChgRecdRefEngBOM</b> entities. This corresponds to the OData
     * navigation property <b>to_ChgRecdRefEngBOM</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdRefEngBOM</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChgRecdRefEngBOM</b> entities.
     */
    public void addChgRecdRefEngBOM( ChgRecdRefEngBOM... entity )
    {
        if( toChgRecdRefEngBOM == null ) {
            toChgRecdRefEngBOM = Lists.newArrayList();
        }
        toChgRecdRefEngBOM.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChgRecdObjPgMaintTskList</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ChgRecdRefMaintTskList</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChgRecdObjPgMaintTskList</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdObjPgMaintTskList> fetchChgRecdRefMaintTskList()
    {
        return fetchFieldAsList("to_ChgRecdRefMaintTskList", ChgRecdObjPgMaintTskList.class);
    }

    /**
     * Retrieval of associated <b>ChgRecdObjPgMaintTskList</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChgRecdRefMaintTskList</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdRefMaintTskList</b> of a queried <b>ChangeRecord</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChgRecdObjPgMaintTskList</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdObjPgMaintTskList> getChgRecdRefMaintTskListOrFetch()
    {
        if( toChgRecdRefMaintTskList == null ) {
            toChgRecdRefMaintTskList = fetchChgRecdRefMaintTskList();
        }
        return toChgRecdRefMaintTskList;
    }

    /**
     * Retrieval of associated <b>ChgRecdObjPgMaintTskList</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChgRecdRefMaintTskList</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChgRecdRefMaintTskList</b> is already loaded, the result
     *         will contain the <b>ChgRecdObjPgMaintTskList</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChgRecdObjPgMaintTskList>> getChgRecdRefMaintTskListIfPresent()
    {
        return Option.of(toChgRecdRefMaintTskList);
    }

    /**
     * Overwrites the list of associated <b>ChgRecdObjPgMaintTskList</b> entities for the loaded navigation property
     * <b>to_ChgRecdRefMaintTskList</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdRefMaintTskList</b> of a queried <b>ChangeRecord</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChgRecdObjPgMaintTskList</b> entities.
     */
    public void setChgRecdRefMaintTskList( @Nonnull final List<ChgRecdObjPgMaintTskList> value )
    {
        if( toChgRecdRefMaintTskList == null ) {
            toChgRecdRefMaintTskList = Lists.newArrayList();
        }
        toChgRecdRefMaintTskList.clear();
        toChgRecdRefMaintTskList.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChgRecdObjPgMaintTskList</b> entities. This corresponds to the OData
     * navigation property <b>to_ChgRecdRefMaintTskList</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdRefMaintTskList</b> of a queried <b>ChangeRecord</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChgRecdObjPgMaintTskList</b> entities.
     */
    public void addChgRecdRefMaintTskList( ChgRecdObjPgMaintTskList... entity )
    {
        if( toChgRecdRefMaintTskList == null ) {
            toChgRecdRefMaintTskList = Lists.newArrayList();
        }
        toChgRecdRefMaintTskList.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChgRecdRefMfgBOM</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ChgRecdRefMfgBOM</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChgRecdRefMfgBOM</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdRefMfgBOM> fetchChgRecdRefMfgBOM()
    {
        return fetchFieldAsList("to_ChgRecdRefMfgBOM", ChgRecdRefMfgBOM.class);
    }

    /**
     * Retrieval of associated <b>ChgRecdRefMfgBOM</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ChgRecdRefMfgBOM</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdRefMfgBOM</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChgRecdRefMfgBOM</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChgRecdRefMfgBOM> getChgRecdRefMfgBOMOrFetch()
    {
        if( toChgRecdRefMfgBOM == null ) {
            toChgRecdRefMfgBOM = fetchChgRecdRefMfgBOM();
        }
        return toChgRecdRefMfgBOM;
    }

    /**
     * Retrieval of associated <b>ChgRecdRefMfgBOM</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ChgRecdRefMfgBOM</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChgRecdRefMfgBOM</b> is already loaded, the result will
     *         contain the <b>ChgRecdRefMfgBOM</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChgRecdRefMfgBOM>> getChgRecdRefMfgBOMIfPresent()
    {
        return Option.of(toChgRecdRefMfgBOM);
    }

    /**
     * Overwrites the list of associated <b>ChgRecdRefMfgBOM</b> entities for the loaded navigation property
     * <b>to_ChgRecdRefMfgBOM</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdRefMfgBOM</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChgRecdRefMfgBOM</b> entities.
     */
    public void setChgRecdRefMfgBOM( @Nonnull final List<ChgRecdRefMfgBOM> value )
    {
        if( toChgRecdRefMfgBOM == null ) {
            toChgRecdRefMfgBOM = Lists.newArrayList();
        }
        toChgRecdRefMfgBOM.clear();
        toChgRecdRefMfgBOM.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChgRecdRefMfgBOM</b> entities. This corresponds to the OData
     * navigation property <b>to_ChgRecdRefMfgBOM</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdRefMfgBOM</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChgRecdRefMfgBOM</b> entities.
     */
    public void addChgRecdRefMfgBOM( ChgRecdRefMfgBOM... entity )
    {
        if( toChgRecdRefMfgBOM == null ) {
            toChgRecdRefMfgBOM = Lists.newArrayList();
        }
        toChgRecdRefMfgBOM.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeRecordReferenceBit</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RefBit</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeRecordReferenceBit</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordReferenceBit> fetchRefBit()
    {
        return fetchFieldAsList("to_RefBit", ChangeRecordReferenceBit.class);
    }

    /**
     * Retrieval of associated <b>ChangeRecordReferenceBit</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RefBit</b>.
     * <p>
     * If the navigation property <b>to_RefBit</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeRecordReferenceBit</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordReferenceBit> getRefBitOrFetch()
    {
        if( toRefBit == null ) {
            toRefBit = fetchRefBit();
        }
        return toRefBit;
    }

    /**
     * Retrieval of associated <b>ChangeRecordReferenceBit</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RefBit</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RefBit</b> is already loaded, the result will contain
     *         the <b>ChangeRecordReferenceBit</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeRecordReferenceBit>> getRefBitIfPresent()
    {
        return Option.of(toRefBit);
    }

    /**
     * Overwrites the list of associated <b>ChangeRecordReferenceBit</b> entities for the loaded navigation property
     * <b>to_RefBit</b>.
     * <p>
     * If the navigation property <b>to_RefBit</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeRecordReferenceBit</b> entities.
     */
    public void setRefBit( @Nonnull final List<ChangeRecordReferenceBit> value )
    {
        if( toRefBit == null ) {
            toRefBit = Lists.newArrayList();
        }
        toRefBit.clear();
        toRefBit.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeRecordReferenceBit</b> entities. This corresponds to the OData
     * navigation property <b>to_RefBit</b>.
     * <p>
     * If the navigation property <b>to_RefBit</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeRecordReferenceBit</b> entities.
     */
    public void addRefBit( ChangeRecordReferenceBit... entity )
    {
        if( toRefBit == null ) {
            toRefBit = Lists.newArrayList();
        }
        toRefBit.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeRecordReferenceBOM</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RefBOM</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeRecordReferenceBOM</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordReferenceBOM> fetchRefBOM()
    {
        return fetchFieldAsList("to_RefBOM", ChangeRecordReferenceBOM.class);
    }

    /**
     * Retrieval of associated <b>ChangeRecordReferenceBOM</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RefBOM</b>.
     * <p>
     * If the navigation property <b>to_RefBOM</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeRecordReferenceBOM</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordReferenceBOM> getRefBOMOrFetch()
    {
        if( toRefBOM == null ) {
            toRefBOM = fetchRefBOM();
        }
        return toRefBOM;
    }

    /**
     * Retrieval of associated <b>ChangeRecordReferenceBOM</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RefBOM</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RefBOM</b> is already loaded, the result will contain
     *         the <b>ChangeRecordReferenceBOM</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeRecordReferenceBOM>> getRefBOMIfPresent()
    {
        return Option.of(toRefBOM);
    }

    /**
     * Overwrites the list of associated <b>ChangeRecordReferenceBOM</b> entities for the loaded navigation property
     * <b>to_RefBOM</b>.
     * <p>
     * If the navigation property <b>to_RefBOM</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeRecordReferenceBOM</b> entities.
     */
    public void setRefBOM( @Nonnull final List<ChangeRecordReferenceBOM> value )
    {
        if( toRefBOM == null ) {
            toRefBOM = Lists.newArrayList();
        }
        toRefBOM.clear();
        toRefBOM.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeRecordReferenceBOM</b> entities. This corresponds to the OData
     * navigation property <b>to_RefBOM</b>.
     * <p>
     * If the navigation property <b>to_RefBOM</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeRecordReferenceBOM</b> entities.
     */
    public void addRefBOM( ChangeRecordReferenceBOM... entity )
    {
        if( toRefBOM == null ) {
            toRefBOM = Lists.newArrayList();
        }
        toRefBOM.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeRecordReferenceDoc</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RefDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeRecordReferenceDoc</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordReferenceDoc> fetchRefDoc()
    {
        return fetchFieldAsList("to_RefDoc", ChangeRecordReferenceDoc.class);
    }

    /**
     * Retrieval of associated <b>ChangeRecordReferenceDoc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RefDoc</b>.
     * <p>
     * If the navigation property <b>to_RefDoc</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeRecordReferenceDoc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordReferenceDoc> getRefDocOrFetch()
    {
        if( toRefDoc == null ) {
            toRefDoc = fetchRefDoc();
        }
        return toRefDoc;
    }

    /**
     * Retrieval of associated <b>ChangeRecordReferenceDoc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RefDoc</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RefDoc</b> is already loaded, the result will contain
     *         the <b>ChangeRecordReferenceDoc</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeRecordReferenceDoc>> getRefDocIfPresent()
    {
        return Option.of(toRefDoc);
    }

    /**
     * Overwrites the list of associated <b>ChangeRecordReferenceDoc</b> entities for the loaded navigation property
     * <b>to_RefDoc</b>.
     * <p>
     * If the navigation property <b>to_RefDoc</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeRecordReferenceDoc</b> entities.
     */
    public void setRefDoc( @Nonnull final List<ChangeRecordReferenceDoc> value )
    {
        if( toRefDoc == null ) {
            toRefDoc = Lists.newArrayList();
        }
        toRefDoc.clear();
        toRefDoc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeRecordReferenceDoc</b> entities. This corresponds to the OData
     * navigation property <b>to_RefDoc</b>.
     * <p>
     * If the navigation property <b>to_RefDoc</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeRecordReferenceDoc</b> entities.
     */
    public void addRefDoc( ChangeRecordReferenceDoc... entity )
    {
        if( toRefDoc == null ) {
            toRefDoc = Lists.newArrayList();
        }
        toRefDoc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeRecordReferenceMat</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RefMat</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeRecordReferenceMat</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordReferenceMat> fetchRefMat()
    {
        return fetchFieldAsList("to_RefMat", ChangeRecordReferenceMat.class);
    }

    /**
     * Retrieval of associated <b>ChangeRecordReferenceMat</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RefMat</b>.
     * <p>
     * If the navigation property <b>to_RefMat</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeRecordReferenceMat</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordReferenceMat> getRefMatOrFetch()
    {
        if( toRefMat == null ) {
            toRefMat = fetchRefMat();
        }
        return toRefMat;
    }

    /**
     * Retrieval of associated <b>ChangeRecordReferenceMat</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RefMat</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RefMat</b> is already loaded, the result will contain
     *         the <b>ChangeRecordReferenceMat</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeRecordReferenceMat>> getRefMatIfPresent()
    {
        return Option.of(toRefMat);
    }

    /**
     * Overwrites the list of associated <b>ChangeRecordReferenceMat</b> entities for the loaded navigation property
     * <b>to_RefMat</b>.
     * <p>
     * If the navigation property <b>to_RefMat</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeRecordReferenceMat</b> entities.
     */
    public void setRefMat( @Nonnull final List<ChangeRecordReferenceMat> value )
    {
        if( toRefMat == null ) {
            toRefMat = Lists.newArrayList();
        }
        toRefMat.clear();
        toRefMat.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeRecordReferenceMat</b> entities. This corresponds to the OData
     * navigation property <b>to_RefMat</b>.
     * <p>
     * If the navigation property <b>to_RefMat</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeRecordReferenceMat</b> entities.
     */
    public void addRefMat( ChangeRecordReferenceMat... entity )
    {
        if( toRefMat == null ) {
            toRefMat = Lists.newArrayList();
        }
        toRefMat.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ChangeRecordReferencePSV</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RefPSV</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ChangeRecordReferencePSV</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordReferencePSV> fetchRefPSV()
    {
        return fetchFieldAsList("to_RefPSV", ChangeRecordReferencePSV.class);
    }

    /**
     * Retrieval of associated <b>ChangeRecordReferencePSV</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RefPSV</b>.
     * <p>
     * If the navigation property <b>to_RefPSV</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ChangeRecordReferencePSV</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ChangeRecordReferencePSV> getRefPSVOrFetch()
    {
        if( toRefPSV == null ) {
            toRefPSV = fetchRefPSV();
        }
        return toRefPSV;
    }

    /**
     * Retrieval of associated <b>ChangeRecordReferencePSV</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RefPSV</b>.
     * <p>
     * If the navigation property for an entity <b>ChangeRecord</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RefPSV</b> is already loaded, the result will contain
     *         the <b>ChangeRecordReferencePSV</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ChangeRecordReferencePSV>> getRefPSVIfPresent()
    {
        return Option.of(toRefPSV);
    }

    /**
     * Overwrites the list of associated <b>ChangeRecordReferencePSV</b> entities for the loaded navigation property
     * <b>to_RefPSV</b>.
     * <p>
     * If the navigation property <b>to_RefPSV</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ChangeRecordReferencePSV</b> entities.
     */
    public void setRefPSV( @Nonnull final List<ChangeRecordReferencePSV> value )
    {
        if( toRefPSV == null ) {
            toRefPSV = Lists.newArrayList();
        }
        toRefPSV.clear();
        toRefPSV.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ChangeRecordReferencePSV</b> entities. This corresponds to the OData
     * navigation property <b>to_RefPSV</b>.
     * <p>
     * If the navigation property <b>to_RefPSV</b> of a queried <b>ChangeRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ChangeRecordReferencePSV</b> entities.
     */
    public void addRefPSV( ChangeRecordReferencePSV... entity )
    {
        if( toRefPSV == null ) {
            toRefPSV = Lists.newArrayList();
        }
        toRefPSV.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ChangeRecord instances.
     *
     */
    public final static class ChangeRecordBuilder
    {

        private List<ChgRecdFuncLocTskList> toChangeRecordFuncLocTskList = Lists.newArrayList();
        private List<ChangeRecordRefCharc> toChangeRecordRefCharc = Lists.newArrayList();
        private List<ChangeRecordRefClass> toChangeRecordRefClass = Lists.newArrayList();
        private List<ChgRecdRefEquipTskList> toChangeRecordRefEquipTskList = Lists.newArrayList();
        private List<ChangeRecordRefMasterRecipe> toChangeRecordRefMasterRecipe = Lists.newArrayList();
        private List<ChangeRecordRefProdnRouting> toChangeRecordRefProdnRouting = Lists.newArrayList();
        private List<ChgRecdRefStdBOM> toChangeRecordRefStdBOM = Lists.newArrayList();
        private List<ChgRecdRefVarBOM> toChangeRecordRefVarBOM = Lists.newArrayList();
        private List<ChgRecdPLMEPDCollabn> toChgRecdCollaboration = Lists.newArrayList();
        private List<ChgRecdEquipBOM> toChgRecdEquipBOM = Lists.newArrayList();
        private List<ChgRecdFuncLocBOM> toChgRecdFuncLocBOM = Lists.newArrayList();
        private List<ChgRecdRefEngBOM> toChgRecdRefEngBOM = Lists.newArrayList();
        private List<ChgRecdObjPgMaintTskList> toChgRecdRefMaintTskList = Lists.newArrayList();
        private List<ChgRecdRefMfgBOM> toChgRecdRefMfgBOM = Lists.newArrayList();
        private List<ChangeRecordReferenceBit> toRefBit = Lists.newArrayList();
        private List<ChangeRecordReferenceBOM> toRefBOM = Lists.newArrayList();
        private List<ChangeRecordReferenceDoc> toRefDoc = Lists.newArrayList();
        private List<ChangeRecordReferenceMat> toRefMat = Lists.newArrayList();
        private List<ChangeRecordReferencePSV> toRefPSV = Lists.newArrayList();

        private ChangeRecord.ChangeRecordBuilder toChangeRecordFuncLocTskList( final List<ChgRecdFuncLocTskList> value )
        {
            toChangeRecordFuncLocTskList.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChangeRecordFuncLocTskList</b> for <b>ChangeRecord</b> to multiple
         * <b>ChgRecdFuncLocTskList</b>.
         *
         * @param value
         *            The ChgRecdFuncLocTskLists to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder changeRecordFuncLocTskList( ChgRecdFuncLocTskList... value )
        {
            return toChangeRecordFuncLocTskList(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toChangeRecordRefCharc( final List<ChangeRecordRefCharc> value )
        {
            toChangeRecordRefCharc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChangeRecordRefCharc</b> for <b>ChangeRecord</b> to multiple
         * <b>ChangeRecordRefCharc</b>.
         *
         * @param value
         *            The ChangeRecordRefCharcs to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder changeRecordRefCharc( ChangeRecordRefCharc... value )
        {
            return toChangeRecordRefCharc(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toChangeRecordRefClass( final List<ChangeRecordRefClass> value )
        {
            toChangeRecordRefClass.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChangeRecordRefClass</b> for <b>ChangeRecord</b> to multiple
         * <b>ChangeRecordRefClass</b>.
         *
         * @param value
         *            The ChangeRecordRefClasss to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder changeRecordRefClass( ChangeRecordRefClass... value )
        {
            return toChangeRecordRefClass(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toChangeRecordRefEquipTskList(
            final List<ChgRecdRefEquipTskList> value )
        {
            toChangeRecordRefEquipTskList.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChangeRecordRefEquipTskList</b> for <b>ChangeRecord</b> to multiple
         * <b>ChgRecdRefEquipTskList</b>.
         *
         * @param value
         *            The ChgRecdRefEquipTskLists to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder changeRecordRefEquipTskList( ChgRecdRefEquipTskList... value )
        {
            return toChangeRecordRefEquipTskList(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toChangeRecordRefMasterRecipe(
            final List<ChangeRecordRefMasterRecipe> value )
        {
            toChangeRecordRefMasterRecipe.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChangeRecordRefMasterRecipe</b> for <b>ChangeRecord</b> to multiple
         * <b>ChangeRecordRefMasterRecipe</b>.
         *
         * @param value
         *            The ChangeRecordRefMasterRecipes to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder changeRecordRefMasterRecipe( ChangeRecordRefMasterRecipe... value )
        {
            return toChangeRecordRefMasterRecipe(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toChangeRecordRefProdnRouting(
            final List<ChangeRecordRefProdnRouting> value )
        {
            toChangeRecordRefProdnRouting.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChangeRecordRefProdnRouting</b> for <b>ChangeRecord</b> to multiple
         * <b>ChangeRecordRefProdnRouting</b>.
         *
         * @param value
         *            The ChangeRecordRefProdnRoutings to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder changeRecordRefProdnRouting( ChangeRecordRefProdnRouting... value )
        {
            return toChangeRecordRefProdnRouting(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toChangeRecordRefStdBOM( final List<ChgRecdRefStdBOM> value )
        {
            toChangeRecordRefStdBOM.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChangeRecordRefStdBOM</b> for <b>ChangeRecord</b> to multiple
         * <b>ChgRecdRefStdBOM</b>.
         *
         * @param value
         *            The ChgRecdRefStdBOMs to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder changeRecordRefStdBOM( ChgRecdRefStdBOM... value )
        {
            return toChangeRecordRefStdBOM(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toChangeRecordRefVarBOM( final List<ChgRecdRefVarBOM> value )
        {
            toChangeRecordRefVarBOM.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChangeRecordRefVarBOM</b> for <b>ChangeRecord</b> to multiple
         * <b>ChgRecdRefVarBOM</b>.
         *
         * @param value
         *            The ChgRecdRefVarBOMs to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder changeRecordRefVarBOM( ChgRecdRefVarBOM... value )
        {
            return toChangeRecordRefVarBOM(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toChgRecdCollaboration( final List<ChgRecdPLMEPDCollabn> value )
        {
            toChgRecdCollaboration.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChgRecdCollaboration</b> for <b>ChangeRecord</b> to multiple
         * <b>ChgRecdPLMEPDCollabn</b>.
         *
         * @param value
         *            The ChgRecdPLMEPDCollabns to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder chgRecdCollaboration( ChgRecdPLMEPDCollabn... value )
        {
            return toChgRecdCollaboration(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toChgRecdEquipBOM( final List<ChgRecdEquipBOM> value )
        {
            toChgRecdEquipBOM.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChgRecdEquipBOM</b> for <b>ChangeRecord</b> to multiple <b>ChgRecdEquipBOM</b>.
         *
         * @param value
         *            The ChgRecdEquipBOMs to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder chgRecdEquipBOM( ChgRecdEquipBOM... value )
        {
            return toChgRecdEquipBOM(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toChgRecdFuncLocBOM( final List<ChgRecdFuncLocBOM> value )
        {
            toChgRecdFuncLocBOM.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChgRecdFuncLocBOM</b> for <b>ChangeRecord</b> to multiple <b>ChgRecdFuncLocBOM</b>.
         *
         * @param value
         *            The ChgRecdFuncLocBOMs to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder chgRecdFuncLocBOM( ChgRecdFuncLocBOM... value )
        {
            return toChgRecdFuncLocBOM(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toChgRecdRefEngBOM( final List<ChgRecdRefEngBOM> value )
        {
            toChgRecdRefEngBOM.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChgRecdRefEngBOM</b> for <b>ChangeRecord</b> to multiple <b>ChgRecdRefEngBOM</b>.
         *
         * @param value
         *            The ChgRecdRefEngBOMs to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder chgRecdRefEngBOM( ChgRecdRefEngBOM... value )
        {
            return toChgRecdRefEngBOM(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toChgRecdRefMaintTskList( final List<ChgRecdObjPgMaintTskList> value )
        {
            toChgRecdRefMaintTskList.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChgRecdRefMaintTskList</b> for <b>ChangeRecord</b> to multiple
         * <b>ChgRecdObjPgMaintTskList</b>.
         *
         * @param value
         *            The ChgRecdObjPgMaintTskLists to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder chgRecdRefMaintTskList( ChgRecdObjPgMaintTskList... value )
        {
            return toChgRecdRefMaintTskList(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toChgRecdRefMfgBOM( final List<ChgRecdRefMfgBOM> value )
        {
            toChgRecdRefMfgBOM.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChgRecdRefMfgBOM</b> for <b>ChangeRecord</b> to multiple <b>ChgRecdRefMfgBOM</b>.
         *
         * @param value
         *            The ChgRecdRefMfgBOMs to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder chgRecdRefMfgBOM( ChgRecdRefMfgBOM... value )
        {
            return toChgRecdRefMfgBOM(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toRefBit( final List<ChangeRecordReferenceBit> value )
        {
            toRefBit.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RefBit</b> for <b>ChangeRecord</b> to multiple <b>ChangeRecordReferenceBit</b>.
         *
         * @param value
         *            The ChangeRecordReferenceBits to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder refBit( ChangeRecordReferenceBit... value )
        {
            return toRefBit(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toRefBOM( final List<ChangeRecordReferenceBOM> value )
        {
            toRefBOM.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RefBOM</b> for <b>ChangeRecord</b> to multiple <b>ChangeRecordReferenceBOM</b>.
         *
         * @param value
         *            The ChangeRecordReferenceBOMs to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder refBOM( ChangeRecordReferenceBOM... value )
        {
            return toRefBOM(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toRefDoc( final List<ChangeRecordReferenceDoc> value )
        {
            toRefDoc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RefDoc</b> for <b>ChangeRecord</b> to multiple <b>ChangeRecordReferenceDoc</b>.
         *
         * @param value
         *            The ChangeRecordReferenceDocs to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder refDoc( ChangeRecordReferenceDoc... value )
        {
            return toRefDoc(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toRefMat( final List<ChangeRecordReferenceMat> value )
        {
            toRefMat.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RefMat</b> for <b>ChangeRecord</b> to multiple <b>ChangeRecordReferenceMat</b>.
         *
         * @param value
         *            The ChangeRecordReferenceMats to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder refMat( ChangeRecordReferenceMat... value )
        {
            return toRefMat(Lists.newArrayList(value));
        }

        private ChangeRecord.ChangeRecordBuilder toRefPSV( final List<ChangeRecordReferencePSV> value )
        {
            toRefPSV.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RefPSV</b> for <b>ChangeRecord</b> to multiple <b>ChangeRecordReferencePSV</b>.
         *
         * @param value
         *            The ChangeRecordReferencePSVs to build this ChangeRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ChangeRecord.ChangeRecordBuilder refPSV( ChangeRecordReferencePSV... value )
        {
            return toRefPSV(Lists.newArrayList(value));
        }

    }

}
